/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportopen.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.taxc.bdtaxr.business.multidideclare.MultiDeclareBizBusiness;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportopen.service.DeclareReportOpenService;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareCustomParamsHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.taxdeclare.enums.TaxDeclareMetaRouteEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DefaultDeclareReportOpenService
implements DeclareReportOpenService {
    @Override
    public DynamicObject loadDecalre(String type, Long id, String number, Map<String, Object> params, boolean isHistory) {
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        String version = this.getVersion(type);
        Long modelId = null;
        if (DeclareConstant.MODEL_VERSION_THREE.equalsIgnoreCase(version)) {
            modelId = templateEnum.isDeclare() ? MultiDeclareBizBusiness.getModelIdByNumber(MultiTableEnum.TSCOO1.getModel()) : MultiDeclareBizBusiness.getModelIdByNumber(MultiTableEnum.TSD001.getModel());
        }
        return this.queryDeclare(modelId, id, number, params, isHistory);
    }

    protected String getVersion(String type) {
        return MultiDeclareBizBusiness.getModelVersion(type);
    }

    protected DynamicObject queryDeclare(Long modelId, Long id, String number, Map<String, Object> params, boolean isHistory) {
        if (isHistory) {
            return MultiDeclareBizBusiness.queryHisDeclareByIdAndModelId(modelId, id);
        }
        return MultiDeclareBizBusiness.queryDeclareByIDOrNumber(modelId, id, number);
    }

    @Override
    public Map<String, Object> getExtendParams(String type, DynamicObject object, boolean isHistory) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(10);
        customParams.put("sbbid", object.getString("id"));
        customParams.put("billno", object.getString("billno"));
        customParams.put("orgid", object.getDynamicObject("org").getString("id"));
        customParams.put("orgname", object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("readonly", Boolean.TRUE);
        customParams.put("modifytime", object.getDate("modifytime"));
        String dataType = object.getString("datatype");
        customParams.put("datatype", dataType);
        customParams.put("templatetype", type);
        String version = this.getVersion(type);
        this.setExtendParamByVersion(type, object, customParams, version);
        return customParams;
    }

    private void setExtendParamByVersion(String type, DynamicObject object, Map<String, Object> customParams, String version) {
        if (DeclareConstant.MODEL_VERSION_THREE.equals(version)) {
            if ("declared".equals(object.getString("declarestatus"))) {
                DeclareRequestModel requestModel = new DeclareRequestModel();
                requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get("orgid"))));
                requestModel.setTemplateType(type);
                requestModel.setId(Long.valueOf(object.getLong("id")));
                requestModel.setSkssqq(DateUtils.format((Date)object.getDate("skssqq")));
                requestModel.setSkssqz(DateUtils.format((Date)object.getDate("skssqz")));
                requestModel.setOperation("read");
                requestModel.setRefresh(Boolean.FALSE);
                requestModel.setModelId(this.getModelId(type));
                customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
            }
        } else {
            String declarestatus = object.getString("declarestatus");
            if ("declared".equals(declarestatus)) {
                DeclareCustomParamsHelper.setDeclareRequestData((DynamicObject)object, customParams);
            } else {
                Map params = DeclareCustomParamsHelper.buildCustomParams((DynamicObject)object);
                if (params != null && !params.isEmpty()) {
                    customParams.putAll(params);
                }
            }
        }
    }

    protected Long getModelId(String type) {
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        String version = this.getVersion(type);
        Long modelId = null;
        if (DeclareConstant.MODEL_VERSION_THREE.equalsIgnoreCase(version)) {
            modelId = templateEnum.isDeclare() ? MultiDeclareBizBusiness.getModelIdByNumber(MultiTableEnum.TSCOO1.getModel()) : MultiDeclareBizBusiness.getModelIdByNumber(MultiTableEnum.TSD001.getModel());
        }
        return modelId;
    }

    @Override
    public String getDeclareFormId(String type, DynamicObject object, boolean isHistory) {
        boolean isUpdated = MultiDeclareBizBusiness.isModelUpdated(type);
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        boolean isDeclare = templateEnum.isDeclare();
        String editPage = templateEnum.getEditPage();
        if (isUpdated) {
            if (isHistory && isDeclare) {
                editPage = "multi_declare_show";
            } else {
                TaxDeclareMetaRouteEnum metaRouteEnum = TaxDeclareMetaRouteEnum.getEnumByDeclarePage((String)editPage);
                if (metaRouteEnum != null) {
                    editPage = metaRouteEnum.getThreeMetaEntity();
                }
            }
        } else if (isHistory && isDeclare) {
            editPage = templateEnum.getDeclareShowPage();
        }
        String declarestatus = object.getString("declarestatus");
        if (isDeclare && "declared".equals(declarestatus)) {
            editPage = "multi_declare_show";
        }
        return editPage;
    }

    @Override
    public String getDecalreListFormId(String type, Map<String, Object> customParams, boolean isHistory) {
        TaxDeclareMetaRouteEnum metaRouteEnum;
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        String editPage = templateEnum.getEditPage();
        String listPage = templateEnum.getListPage();
        boolean isUpdated = MultiDeclareBizBusiness.isModelUpdated(type);
        if (isUpdated && (metaRouteEnum = TaxDeclareMetaRouteEnum.getEnumByDeclarePage((String)editPage)) != null) {
            listPage = metaRouteEnum.getThreeListMetaEntity();
        }
        return listPage;
    }
}

