/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.impl;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.business.taxcode.TaxCodeResultBussiness;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractOverSeasDeclareReportSaveImpl
implements DeclareReportSaveService {
    private static Log logger = LogFactory.getLog(AbstractOverSeasDeclareReportSaveImpl.class);

    @Override
    public BaseResult saveTeeData(DeclareRequestModel requestModel, Map<String, String> treeData) {
        return null;
    }

    @Override
    public BaseResult saveBusinessData(Map<String, Object> requestParams, Map<String, Object> resultData) {
        BaseResult baseResult;
        if (this.enableSaveTaxCodeResult() && ObjectUtils.isNotEmpty((Object)(baseResult = this.saveTaxCodeResult(requestParams))) && 200 != baseResult.getCode()) {
            return baseResult;
        }
        return BaseResult.ok();
    }

    public boolean enableSaveTaxCodeResult() {
        return false;
    }

    public BaseResult saveTaxCodeResult(Map<String, Object> requestParams) {
        Long id = requestParams.containsKey("Id") ? Long.parseLong(requestParams.get("Id").toString()) : 0L;
        boolean b = TaxCodeResultBussiness.saveTaxcodeResult(id);
        if (!b) {
            return BaseResult.fail((String)"save fail\u3002");
        }
        return BaseResult.ok();
    }

    protected BaseResult buildBqybtseAndSaveData(Map<String, Object> requestParams, Map<String, Object> resultData) {
        String taxationsys;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)(requestParams.get("templateid") instanceof String ? Long.parseLong((String)requestParams.get("templateid")) : 0L), (String)"tpo_template");
        String templateType = dynamicObject.getString("type.id");
        GtcpDeclarePayRefundEnum gtcpDeclarePayRefundEnum = GtcpDeclarePayRefundEnum.getGtcpDeclarePayEnumByMultiCondition((String)templateType, (String)(taxationsys = requestParams.get("taxationsys") != null ? (String)requestParams.get("taxationsys") : (String)requestParams.get("taxsystem")), (String)((String)requestParams.get("taxtype")));
        if (ObjectUtils.isEmpty((Object)gtcpDeclarePayRefundEnum)) {
            return BaseResult.fail((String)"AbstractOverSeasDeclareReportSaveImpl save error");
        }
        Long id = Long.parseLong(String.valueOf(requestParams.get("Id")));
        BigDecimal bqybtseAmount = BigDecimal.ZERO;
        for (String column : gtcpDeclarePayRefundEnum.getRowColumn()) {
            logger.info(String.format("\u5e94\u8865\u9000\u7a0e\u989d\u6bcf\u4e2a\u5355\u5143\u683c\u83b7\u53d6\u503c\uff1atemplateType:%s,column: %s , amount: %s", templateType, column, (String)resultData.get(column)));
            bqybtseAmount = bqybtseAmount.add(ObjectUtils.isNotEmpty((Object)resultData.get(column)) ? new BigDecimal(resultData.get(column).toString()) : BigDecimal.ZERO);
        }
        logger.info("bqybtseAmount", (Object)bqybtseAmount);
        boolean doSaveData = this.doSaveData(id, bqybtseAmount);
        if (doSaveData) {
            logger.info(this.getClass().getName() + id + "AbstractOverSeasDeclareReportSaveImpl save success");
            return BaseResult.ok();
        }
        logger.info(this.getClass().getName() + id + "AbstractOverSeasDeclareReportSaveImpl save error");
        return BaseResult.fail((String)"AbstractOverSeasDeclareReportSaveImpl save error");
    }

    protected boolean doSaveData(Long id, BigDecimal bqybtseAmount) {
        DynamicObject saveObject = BusinessDataServiceHelper.loadSingle((String)"gtcp_declare_payrefund", (String)"id,draftid,sseq,bqybtse,declarestatus,payrefundstatus", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)id)});
        DynamicObject dynObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_declare_payrefund");
        if (ObjectUtils.isEmpty((Object)saveObject)) {
            saveObject = dynObject;
            saveObject.set("sseq", (Object)1);
            saveObject.set("declarestatus", (Object)"editing");
            saveObject.set("payrefundstatus", (Object)"unpayrefund");
        }
        saveObject.set("draftid", (Object)id);
        saveObject.set("bqybtse", (Object)bqybtseAmount);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"gtcp_declare_payrefund", (DynamicObject[])new DynamicObject[]{saveObject}, (OperateOption)OperateOption.create());
        return result.isSuccess();
    }
}

