/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.impl.AbstractOverSeasDeclareReportSaveImpl;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OverSeasUsaCitDeclareReportSaveImpl
extends AbstractOverSeasDeclareReportSaveImpl
implements DeclareReportSaveService {
    private static Log logger = LogFactory.getLog(OverSeasUsaCitDeclareReportSaveImpl.class);

    @Override
    public BaseResult saveTeeData(DeclareRequestModel requestModel, Map<String, String> treeData) {
        return null;
    }

    @Override
    public BaseResult saveBusinessData(Map<String, Object> requestParams, Map<String, Object> resultData) {
        BaseResult baseResult = super.saveBusinessData(requestParams, resultData);
        if (ObjectUtils.isNotEmpty((Object)baseResult) && 200 != baseResult.getCode()) {
            return baseResult;
        }
        return this.buildBqybtseAndSaveData(requestParams, resultData);
    }

    @Override
    protected BaseResult buildBqybtseAndSaveData(Map<String, Object> requestParams, Map<String, Object> resultData) {
        String taxationsys;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)(requestParams.get("templateid") instanceof String ? Long.parseLong((String)requestParams.get("templateid")) : 0L), (String)"tpo_template");
        String templateType = dynamicObject.getString("type.id");
        GtcpDeclarePayRefundEnum gtcpDeclarePayRefundEnum = GtcpDeclarePayRefundEnum.getGtcpDeclarePayEnumByMultiCondition((String)templateType, (String)(taxationsys = requestParams.get("taxationsys") != null ? (String)requestParams.get("taxationsys") : (String)requestParams.get("taxsystem")), (String)((String)requestParams.get("taxtype")));
        if (ObjectUtils.isEmpty((Object)gtcpDeclarePayRefundEnum)) {
            return BaseResult.fail((String)"OverSeasUsaCitDeclareReportSaveImpl save error");
        }
        Long id = Long.parseLong(String.valueOf(requestParams.get("Id")));
        BigDecimal bqybtseAmount = BigDecimal.ZERO;
        String areaJsonStr = (String)requestParams.get("USA_CIT_TAX_AREA_LIST");
        ArrayList showAreaList = new ArrayList(64);
        if (StringUtils.isNotEmpty((CharSequence)areaJsonStr)) {
            List listFromJsonStr = (List)SerializationUtils.fromJsonString((String)areaJsonStr, List.class);
            showAreaList.addAll(listFromJsonStr);
        }
        ArrayList tabList = new ArrayList(64);
        Map tabTaxAreaGroupMap = GtcpDeclarePayRefundEnum.getUsaTabTaxAreaGroupMap();
        tabTaxAreaGroupMap.entrySet().stream().filter(row -> showAreaList.contains(Long.valueOf((String)row.getValue()))).forEach(row -> tabList.add(row.getKey()));
        logger.info(String.format("\u7f8e\u56fd\u6240\u5f97\u7a0e\u5e94\u8865\u9000\u7a0e\u989d\u8981\u5408\u8ba1\u7684\u6240\u6709\u9875\u7b7e\uff1a%s", ((Object)tabList).toString()));
        for (String tab : tabList) {
            String column = (String)GtcpDeclarePayRefundEnum.getUsaTaxAmountRowColumnMap().get(tab);
            logger.info(String.format("\u5e94\u8865\u9000\u7a0e\u989d\u6bcf\u4e2a\u5355\u5143\u683c\u83b7\u53d6\u503c\uff1atemplateType:%s,column: %s , amount: %s", templateType, column, resultData.get(column)));
            bqybtseAmount = bqybtseAmount.add(ObjectUtils.isNotEmpty((Object)resultData.get(column)) ? new BigDecimal(resultData.get(column).toString()) : BigDecimal.ZERO);
        }
        logger.info("OverSeasUsaCitDeclareReportSaveImpl bqybtseAmount", (Object)bqybtseAmount);
        boolean doSaveData = this.doSaveData(id, bqybtseAmount);
        if (doSaveData) {
            logger.info(this.getClass().getName() + id + "OverSeasUsaCitDeclareReportSaveImpl save success");
            return BaseResult.ok();
        }
        logger.info(this.getClass().getName() + id + "OverSeasUsaCitDeclareReportSaveImpl save error");
        return BaseResult.fail((String)"OverSeasUsaCitDeclareReportSaveImpl save error");
    }

    @Override
    public boolean enableSaveTaxCodeResult() {
        return true;
    }
}

