/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SdsjtDeclareReportSaveImpl
implements DeclareReportSaveService {
    private static Log logger = LogFactory.getLog(SdsjtDeclareReportSaveImpl.class);

    @Override
    public BaseResult saveTeeData(DeclareRequestModel requestModel, Map<String, String> treeData) {
        logger.info("begin saveTeeData");
        if (treeData != null) {
            JSONArray jsonArrays = (JSONArray)((Map)JSONObject.parseObject((String)SerializationUtils.toJsonString(treeData), Map.class)).get("treeData");
            ArrayList<Long> treeIds = new ArrayList<Long>(12);
            String taxsystem = (String)requestModel.getBusinessMap().get("taxsystem");
            Long id = requestModel.getId();
            this.getAllTreeNodeIds(jsonArrays, treeIds);
            if (treeIds.size() > 0) {
                DynamicObject[] tabObjs = BusinessDataServiceHelper.load((String)"itp_draft_tab", (String)"id,tab", (QFilter[])new QFilter[]{new QFilter("taxationsys", "=", (Object)Long.valueOf(taxsystem)).and("draftid", "=", (Object)id)});
                if (tabObjs != null && tabObjs.length > 0) {
                    List<Long> tabIds = Arrays.stream(tabObjs).map(o -> o.getLong("tab.id")).collect(Collectors.toList());
                    if (tabIds.size() == treeIds.size() && tabIds.containsAll(treeIds)) {
                        return BaseResult.ok();
                    }
                    List<Long> dealSaveNodeId = this.getDealSaveNodeId(treeIds, tabIds);
                    List<Long> dealDeleteNodeIds = this.getDealDeleteNodeId(treeIds, tabIds);
                    if (dealDeleteNodeIds.size() > 0) {
                        tabIds.removeAll(dealSaveNodeId);
                        int delete = DeleteServiceHelper.delete((String)"itp_draft_tab", (QFilter[])new QFilter[]{new QFilter("tab", "in", dealDeleteNodeIds).and("draftid", "=", (Object)id)});
                        if (delete < 1) {
                            return BaseResult.fail((String)"fali");
                        }
                    }
                    boolean b = Boolean.FALSE;
                    if (dealSaveNodeId.size() > 0) {
                        b = this.saveTabMapByTaxsystem(Long.valueOf(taxsystem), dealSaveNodeId, id);
                    }
                    if (b) {
                        return BaseResult.ok();
                    }
                    return BaseResult.fail((String)"fali");
                }
                boolean b = this.saveTabMapByTaxsystem(Long.valueOf(taxsystem), treeIds, id);
                if (b) {
                    return BaseResult.ok();
                }
                return BaseResult.fail((String)"fail");
            }
        }
        logger.info("finish saveTeeData");
        return BaseResult.ok();
    }

    @Override
    public BaseResult saveBusinessData(Map<String, Object> requestParams, Map<String, Object> resultData) {
        BigDecimal jsndysdsfy;
        BigDecimal dysdsfy;
        BigDecimal jsndqsdsfy;
        BigDecimal dqsdsfy;
        BigDecimal jsnyxsfl;
        BigDecimal yxsfl;
        boolean b;
        logger.info("start saveBusinessData");
        if (CollectionUtils.isEmpty(requestParams) || CollectionUtils.isEmpty(resultData)) {
            logger.info("Illigal paeams!");
            return BaseResult.fail((String)"Illigal paeams!");
        }
        Long orgId = Long.parseLong(requestParams.get("orgId").toString());
        Date skssqq = DateUtils.stringToDate((String)requestParams.get("skssqq").toString());
        Date skssqz = DateUtils.stringToDate((String)requestParams.get("skssqz").toString());
        Long taxsystem = Long.valueOf(requestParams.get("taxsystem").toString());
        String accountsettype = requestParams.get("accountsettype").toString();
        Long id = Long.parseLong(requestParams.get("Id").toString());
        boolean isadjustperiod = !ObjectUtils.isEmpty((Object)requestParams.get("isadjustperiod")) && !"0".equals(requestParams.get("isadjustperiod"));
        String adjustperiod = ObjectUtils.isEmpty((Object)requestParams.get("adjustperiod")) ? null : requestParams.get("adjustperiod").toString();
        DynamicObject etrInfo = this.getEtrInfo(orgId, skssqq, skssqz, taxsystem, accountsettype, isadjustperiod, adjustperiod);
        BigDecimal jsnyxsfl_tb = new BigDecimal("0.00");
        BigDecimal jsndqsdsfy_tb = new BigDecimal("0.00");
        BigDecimal jsndysdsfy_tb = new BigDecimal("0.00");
        if (etrInfo != null) {
            jsnyxsfl_tb = etrInfo.getBigDecimal("jsnyxsfl");
            jsndqsdsfy_tb = etrInfo.getBigDecimal("jsndqsdsfy");
            jsndysdsfy_tb = etrInfo.getBigDecimal("jsndysdsfy");
        }
        if (!(b = this.updateTaxEtrMain(orgId, skssqq, skssqz, taxsystem, accountsettype, isadjustperiod, adjustperiod, yxsfl = this.getYxsfl(resultData, accountsettype), jsnyxsfl = this.getJsnyxsfl(yxsfl, jsnyxsfl_tb), dqsdsfy = this.getDqsdsfy(resultData, accountsettype), jsndqsdsfy = this.getJsndqsdsfy(dqsdsfy, jsndqsdsfy_tb), dysdsfy = this.getDysdsfy(resultData, accountsettype), jsndysdsfy = this.getJsndysdsfy(dysdsfy, jsndysdsfy_tb), id))) {
            return BaseResult.fail((String)"fali");
        }
        String remarks = requestParams.get("remarks") != null ? requestParams.get("remarks").toString() : "";
        String billno = requestParams.get("billno") != null ? requestParams.get("billno").toString() : "";
        this.updateNxx(billno, remarks);
        logger.info("finish saveBusinessData");
        return BaseResult.ok();
    }

    private void updateNxx(String billno, String reamrks) {
        QFilter qfilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"itp_draft_query_list", (String)"id,billno,org,taxsystem,templatetype,skssqq,skssqz,remarks,modifytime", (QFilter[])new QFilter[]{qfilter});
        if (dynamicObject != null) {
            dynamicObject.set("remarks", (Object)reamrks);
            dynamicObject.set("modifytime", (Object)new Date());
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }

    public List<Long> getAllTreeNodeIds(JSONArray jsonArrays, List<Long> treeIds) {
        if (jsonArrays == null || jsonArrays.size() == 0) {
            return treeIds;
        }
        List jsonObjects = jsonArrays.toJavaList(JSONObject.class);
        for (JSONObject jsonObject : jsonObjects) {
            treeIds.add(jsonObject.getLong("id"));
            if (jsonObject.get((Object)"children") == null) continue;
            JSONArray childrenArray = jsonObject.getJSONArray("children");
            this.getAllTreeNodeIds(childrenArray, treeIds);
        }
        return treeIds;
    }

    public boolean saveTabMapByTaxsystem(Long taxsystemId, List<Long> treeIds, Long draftid) {
        ArrayList<DynamicObject> tabObis = new ArrayList<DynamicObject>(12);
        for (Long treeId : treeIds) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"itp_draft_tab");
            dynamicObject.set("tab", (Object)treeId);
            dynamicObject.set("taxationsys", (Object)taxsystemId);
            dynamicObject.set("draftid", (Object)draftid);
            tabObis.add(dynamicObject);
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])tabObis.toArray(new DynamicObject[tabObis.size()]));
        return save != null && save.length > 0;
    }

    public List<Long> getDealSaveNodeId(List<Long> treeIds, List<Long> tabIds) {
        ArrayList<Long> saveIds = new ArrayList<Long>(12);
        for (Long treeId : treeIds) {
            if (tabIds.contains(treeId)) continue;
            saveIds.add(treeId);
        }
        return saveIds;
    }

    public List<Long> getDealDeleteNodeId(List<Long> treeIds, List<Long> tabIds) {
        ArrayList<Long> deleteIds = new ArrayList<Long>(12);
        for (Long tabId : tabIds) {
            if (treeIds.contains(tabId)) continue;
            deleteIds.add(tabId);
        }
        return deleteIds;
    }

    private boolean updateTaxEtrMain(Long orgId, Date skssqq, Date skssqz, Long taxationsysId, String zt, boolean isadjustperiod, String adjustperiod, BigDecimal yxsfl, BigDecimal jsnyxsfl, BigDecimal dqsdsfy, BigDecimal jsndqsdsfy, BigDecimal dysdsfy, BigDecimal jsndysdsfy, Long draftid) {
        DynamicObject object;
        if (orgId == null || skssqq == null || skssqz == null || taxationsysId == null || zt == null) {
            return false;
        }
        QFilter orgQfilter = new QFilter("org", "=", (Object)orgId);
        QFilter taxqFilter = new QFilter("taxsystem", "=", (Object)taxationsysId);
        QFilter ztqFilter = new QFilter("accountsettype", "=", (Object)zt);
        QFilter sksqFilter = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
        QFilter isadjustperiodFilter = new QFilter("isadjustperiod", "=", (Object)isadjustperiod);
        if (isadjustperiod) {
            isadjustperiodFilter.and("adjustperiod", "=", (Object)adjustperiod);
        }
        if ((object = BusinessDataServiceHelper.loadSingle((String)"itp_draft_etr", (String)"yxsfl,jsnyxsfl,dqsdsfy,jsndqsdsfy,dysdsfy,jsndysdsfy", (QFilter[])new QFilter[]{orgQfilter, taxqFilter, taxqFilter, ztqFilter, sksqFilter, isadjustperiodFilter})) == null) {
            object = BusinessDataServiceHelper.newDynamicObject((String)"itp_draft_etr");
            object.set("draftid", (Object)draftid);
            object.set("org", (Object)orgId);
            object.set("skssqq", (Object)skssqq);
            object.set("skssqz", (Object)skssqz);
            object.set("taxsystem", (Object)taxationsysId);
            object.set("accountsettype", (Object)zt);
            object.set("isadjustperiod", (Object)isadjustperiod);
            object.set("adjustperiod", (Object)adjustperiod);
        }
        object.set("yxsfl", (Object)yxsfl);
        object.set("jsnyxsfl", (Object)jsnyxsfl);
        object.set("dqsdsfy", (Object)dqsdsfy);
        object.set("jsndqsdsfy", (Object)jsndqsdsfy);
        object.set("dysdsfy", (Object)dysdsfy);
        object.set("jsndysdsfy", (Object)jsndysdsfy);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        if (save == null || save.length == 0) {
            return Boolean.FALSE;
        }
        return true;
    }

    private DynamicObject getEtrInfo(Long orgId, Date skssqq, Date skssqz, Long taxationsysId, String zt, boolean isadjustperiod, String adjustperiod) {
        QFilter orgQfilter = new QFilter("org", "=", (Object)orgId);
        QFilter taxqFilter = new QFilter("taxsystem", "=", (Object)taxationsysId);
        QFilter ztqFilter = new QFilter("accountsettype", "=", (Object)zt);
        QFilter sksqFilter = new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)skssqq, (int)-12)).and("skssqz", "=", (Object)DateUtils.addMonth((Date)skssqz, (int)-12));
        QFilter isadjustperiodFilter = new QFilter("isadjustperiod", "=", (Object)isadjustperiod);
        if (isadjustperiod) {
            isadjustperiodFilter.and("adjustperiod", "=", (Object)adjustperiod);
        }
        return BusinessDataServiceHelper.loadSingle((String)"itp_draft_etr", (String)"id,yxsfl,jsnyxsfl,dqsdsfy,jsndqsdsfy,dysdsfy,jsndysdsfy", (QFilter[])new QFilter[]{orgQfilter, taxqFilter, taxqFilter, ztqFilter, sksqFilter, isadjustperiodFilter});
    }

    private BigDecimal getYxsfl(Map<String, Object> resultData, String zt) {
        BigDecimal dqsdsfy = new BigDecimal(resultData.get("sjjs_dqsdsfy_bnyjfy#sjjs_je") == null || "".equalsIgnoreCase(resultData.get("sjjs_dqsdsfy_bnyjfy#sjjs_je").toString()) ? "0" : resultData.get("sjjs_dqsdsfy_bnyjfy#sjjs_je").toString());
        BigDecimal dysdsfy = new BigDecimal(resultData.get("sjjs_dysdsfy_bnyjfy#sjjs_je") == null || "".equalsIgnoreCase(resultData.get("sjjs_dysdsfy_bnyjfy#sjjs_je").toString()) ? "0" : resultData.get("sjjs_dysdsfy_bnyjfy#sjjs_je").toString());
        BigDecimal ztValue = BigDecimal.ZERO;
        if ("jtzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(resultData.get("dqsds_sqlr_jt#dqsds_hj") == null || "".equalsIgnoreCase(resultData.get("dqsds_sqlr_jt#dqsds_hj").toString()) ? "0" : resultData.get("dqsds_sqlr_jt#dqsds_hj").toString());
        } else if ("bdzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(resultData.get("dqsds_sqlr_bd#dqsds_hj") == null || "".equalsIgnoreCase(resultData.get("dqsds_sqlr_bd#dqsds_hj").toString()) ? "0" : resultData.get("dqsds_sqlr_bd#dqsds_hj").toString());
        }
        if (0L == ztValue.longValue()) {
            return BigDecimal.ZERO;
        }
        return dqsdsfy.add(dysdsfy).divide(ztValue, 4, 4);
    }

    private BigDecimal getJsnyxsfl(BigDecimal getYxsfl, BigDecimal getYxsfl_tb) {
        return getYxsfl.subtract(getYxsfl_tb);
    }

    private BigDecimal getDqsdsfy(Map<String, Object> resultData, String zt) {
        BigDecimal dqsdsfy = new BigDecimal(resultData.get("sjjs_dqsdsfy_bnyjfy#sjjs_je") == null || "".equalsIgnoreCase(resultData.get("sjjs_dqsdsfy_bnyjfy#sjjs_je").toString()) ? "0" : resultData.get("sjjs_dqsdsfy_bnyjfy#sjjs_je").toString());
        BigDecimal ztValue = BigDecimal.ZERO;
        if ("jtzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(resultData.get("dqsds_sqlr_jt#dqsds_hj") == null || "".equalsIgnoreCase(resultData.get("dqsds_sqlr_jt#dqsds_hj").toString()) ? "0" : resultData.get("dqsds_sqlr_jt#dqsds_hj").toString());
        } else if ("bdzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(resultData.get("dqsds_sqlr_bd#dqsds_hj") == null || "".equalsIgnoreCase(resultData.get("dqsds_sqlr_bd#dqsds_hj").toString()) ? "0" : resultData.get("dqsds_sqlr_bd#dqsds_hj").toString());
        }
        if (0L == ztValue.longValue()) {
            return BigDecimal.ZERO;
        }
        return dqsdsfy.divide(ztValue, 4, 4);
    }

    private BigDecimal getJsndqsdsfy(BigDecimal dqsdsfy, BigDecimal dqsdsfy_tb) {
        return dqsdsfy.subtract(dqsdsfy_tb);
    }

    private BigDecimal getDysdsfy(Map<String, Object> resultData, String zt) {
        BigDecimal dysdsfy = new BigDecimal(resultData.get("sjjs_dysdsfy_bnyjfy#sjjs_je") == null || "".equalsIgnoreCase(resultData.get("sjjs_dysdsfy_bnyjfy#sjjs_je").toString()) ? "0" : resultData.get("sjjs_dysdsfy_bnyjfy#sjjs_je").toString());
        BigDecimal ztValue = BigDecimal.ZERO;
        if ("jtzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(resultData.get("dqsds_sqlr_jt#dqsds_hj") == null || "".equalsIgnoreCase(resultData.get("dqsds_sqlr_jt#dqsds_hj").toString()) ? "0" : resultData.get("dqsds_sqlr_jt#dqsds_hj").toString());
        } else if ("bdzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(resultData.get("dqsds_sqlr_bd#dqsds_hj") == null || "".equalsIgnoreCase(resultData.get("dqsds_sqlr_bd#dqsds_hj").toString()) ? "0" : resultData.get("dqsds_sqlr_bd#dqsds_hj").toString());
        }
        if (0L == ztValue.longValue()) {
            return BigDecimal.ZERO;
        }
        return dysdsfy.divide(ztValue, 4, 4);
    }

    private BigDecimal getJsndysdsfy(BigDecimal dysdsfy, BigDecimal dysdsfy_tb) {
        return dysdsfy.subtract(dysdsfy_tb);
    }
}

