/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import org.apache.commons.collections4.CollectionUtils;

public class TssqbDeclareReportSaveImpl
implements DeclareReportSaveService {
    private static final Log logger = LogFactory.getLog(TssqbDeclareReportSaveImpl.class);

    @Override
    public BaseResult saveTeeData(DeclareRequestModel requestModel, Map<String, String> treeData) {
        return BaseResult.ok();
    }

    @Override
    public BaseResult saveBusinessData(Map<String, Object> requestParams, Map<String, Object> resultData) {
        DynamicObjectCollection entryentity;
        DynamicObject entry;
        logger.info("start saveBusinessData");
        if (requestParams == null || requestParams.isEmpty() || resultData == null || resultData.isEmpty()) {
            logger.info("Illegal params!");
            return BaseResult.fail((String)"Illegal params!");
        }
        Long orgId = Long.parseLong(requestParams.get("orgId").toString());
        Long id = Long.parseLong(requestParams.get("Id").toString());
        DynamicObject tssqb = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcvat_tssqb_query");
        DynamicObjectCollection jzjtdrafts = tssqb.getDynamicObjectCollection("jzjtdraft");
        List hisDraftIds = jzjtdrafts.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList());
        jzjtdrafts.clear();
        Object draftIds = requestParams.get("draftIds");
        DynamicObject[] drafts = null;
        if (draftIds != null) {
            Object[] draftIdArr = Stream.of(draftIds.toString().split(",")).map(Long::new).toArray();
            for (DynamicObject draft2 : drafts = BusinessDataServiceHelper.load((Object[])draftIdArr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_tsjs_draft_query"))) {
                DynamicObject object = jzjtdrafts.addNew();
                object.set("fbasedataid", (Object)draft2);
                hisDraftIds.remove(draft2.getLong("id"));
                this.updateDraftSqb(draft2, id);
            }
        }
        DynamicObject[] hisDrafts = null;
        if (CollectionUtils.isNotEmpty(hisDraftIds)) {
            hisDrafts = BusinessDataServiceHelper.load((Object[])hisDraftIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_tsjs_draft_query"));
            Stream.of(hisDrafts).forEach(draft -> this.updateDraftSqb((DynamicObject)draft, 0L));
        }
        if ((entry = CollectionUtils.isEmpty((Collection)(entryentity = (DynamicObjectCollection)tssqb.get("entryentity"))) ? entryentity.addNew() : (DynamicObject)entryentity.get(0)) == null) {
            return BaseResult.fail((String)"");
        }
        entry.set("sqtsje", (Object)new BigDecimal(resultData.get("tssqb_sqtsjexx#tssqb_tdssqspbsqtsje").toString()));
        entry.set("bljd", (Object)"wsq");
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tssqb});
                if (drafts != null && drafts.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])drafts);
                }
                if (hisDrafts != null && hisDrafts.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])hisDrafts);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        logger.info("finish saveBusinessData");
        return BaseResult.ok();
    }

    private void updateDraftSqb(DynamicObject draft, Long tssqbId) {
        DynamicObjectCollection entryentity = draft.getDynamicObjectCollection("entryentity");
        DynamicObject entry = CollectionUtils.isEmpty((Collection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
        entry.set("tssqb", (Object)tssqbId);
    }
}

