/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.dynamicrowcheck.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.dynamicrowcheck.service.DynamicRowCheckService;
import kd.taxc.bdtaxr.common.refactor.formula.context.SimpleFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.DynamicRowCheckResultVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowCheckVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowDataVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowFormulaVo;

public abstract class AbstractDynamicRowCheckService
implements DynamicRowCheckService {
    protected SimpleFormulaContext formulaContext = null;
    protected DynamicRowCheckResultVo resultVo = null;

    @Override
    public Map<String, String> check(DynamicRowCheckVo checkVo, DynamicRowFormulaVo formulaVo, SimpleFormulaContext formulaContext) {
        this.init(checkVo, formulaVo, formulaContext);
        DynamicRowCheckResultVo resultVo = this.doCheck(checkVo, formulaVo, formulaContext);
        return this.getCheckResult(checkVo, formulaVo, resultVo);
    }

    private void init(DynamicRowCheckVo checkVo, DynamicRowFormulaVo formulaVo, SimpleFormulaContext formulaContext) {
        this.formulaContext = formulaContext;
        this.resultVo = new DynamicRowCheckResultVo();
    }

    public abstract DynamicRowCheckResultVo doCheck(DynamicRowCheckVo var1, DynamicRowFormulaVo var2, SimpleFormulaContext var3);

    protected abstract Map<String, String> getCheckResult(DynamicRowCheckVo var1, DynamicRowFormulaVo var2, DynamicRowCheckResultVo var3);

    protected List<DynamicRowModel> matchFitDyn(List<DynamicRowModel> dynRowList, DynamicRowFormulaVo formulaVo) {
        List<String> columnRangeList = Arrays.asList(formulaVo.getColumnRange().split(","));
        ArrayList<DynamicRowModel> fitDynRowList = new ArrayList<DynamicRowModel>(10);
        for (DynamicRowModel rowModel : dynRowList) {
            if (rowModel.getRowList() == null || rowModel.getRowList().size() == 0 || !this.isFitDynRow(formulaVo, rowModel)) continue;
            Map rowData = (Map)rowModel.getRowList().get(0);
            ArrayList<String> colMembers = new ArrayList<String>(10);
            for (Map.Entry entry : rowData.entrySet()) {
                String[] ary = ((String)entry.getKey()).split("#");
                colMembers.add(ary[ary.length - 1]);
            }
            colMembers.retainAll(columnRangeList);
            if (colMembers.size() != colMembers.size()) continue;
            fitDynRowList.add(rowModel);
        }
        return fitDynRowList;
    }

    protected boolean isFitDynRow(DynamicRowFormulaVo formulaVo, DynamicRowModel rowModel) {
        List<String> dynrowRangeList;
        if (formulaVo.getDynrowNo().equals(rowModel.getDynRowNo())) {
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)formulaVo.getDynrowRange()) && (dynrowRangeList = Arrays.asList(formulaVo.getDynrowRange().split(","))).contains(rowModel.getDynRowNo());
    }

    protected List<DynamicRowDataVo> buildRowDataList(DynamicRowModel rowModel, DynamicRowFormulaVo formulaVo, DynamicRowCheckVo checkVo) {
        Map sheetNameMap = checkVo.getSheetNameMap();
        ArrayList<DynamicRowDataVo> rowDataVoList = new ArrayList<DynamicRowDataVo>(10);
        int size = rowModel.getRowList().size();
        for (int i = 0; i < size; ++i) {
            Map rowData = (Map)rowModel.getRowList().get(i);
            DynamicRowDataVo rowDataVo = new DynamicRowDataVo();
            rowDataVo.setSheetName((String)sheetNameMap.get(rowModel.getDynRowNo().split("#")[0]));
            rowDataVo.setDynrowNo(rowModel.getDynRowNo());
            rowDataVo.setRowModel(rowModel);
            rowDataVo.setRowIndex(i + 1);
            rowDataVo.setRowData(rowData);
            rowDataVoList.add(rowDataVo);
        }
        return rowDataVoList;
    }

    protected boolean filterByCondition(DynamicRowDataVo rowData, DynamicRowFormulaVo formulaVo, DynamicRowCheckVo checkVo) {
        if (StringUtil.isEmpty((CharSequence)formulaVo.getCondition())) {
            return true;
        }
        FormulaVo formula = this.parseConditionFormulaVo(rowData, formulaVo, checkVo);
        String result = this.formulaContext.calculate(formula);
        return result.equals("1");
    }

    protected FormulaVo parseConditionFormulaVo(DynamicRowDataVo rowData, DynamicRowFormulaVo formulaVo, DynamicRowCheckVo checkVo) {
        String condition = formulaVo.getCondition();
        String rowMember = rowData.getDynrowNo().split("#")[0];
        String formualKey = rowMember + "#" + UUID.randomUUID();
        FormulaVo vo = new FormulaVo();
        vo.setFormulaType("1");
        vo.setFormulaKey(formualKey);
        String newFormula = DynamicRowService.handleCopyFormula((String)condition, (String)formualKey, (DynamicRowModel)rowData.getRowModel(), (long)rowData.getRowIndex(), (List)checkVo.getDynRowList());
        vo.setFormula(newFormula);
        return vo;
    }

    protected String getJoinKey(String joinStr, Object ... split) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                stringBuilder.append(split[i]);
                continue;
            }
            stringBuilder.append(split[i]);
            stringBuilder.append(joinStr);
        }
        return stringBuilder.toString();
    }
}

