/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.dynamicrowcheck.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.dynamicrowcheck.service.impl.AbstractDynamicRowCheckService;
import kd.taxc.bdtaxr.common.refactor.formula.context.SimpleFormulaContext;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.utils.velocity.VelocityUtils;
import kd.taxc.bdtaxr.common.vo.DynamicRowCheckErrorInfo;
import kd.taxc.bdtaxr.common.vo.DynamicRowCheckResultVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowCheckVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowDataVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowFormulaVo;

public class DynamicRowUniqueCheckService
extends AbstractDynamicRowCheckService {
    @Override
    public DynamicRowCheckResultVo doCheck(DynamicRowCheckVo checkVo, DynamicRowFormulaVo formulaVo, SimpleFormulaContext formulaContext) {
        List<DynamicRowModel> dynrowList = this.matchFitDyn(checkVo.getDynRowList(), formulaVo);
        ArrayList<DynamicRowDataVo> rowDataList = new ArrayList<DynamicRowDataVo>(10);
        for (DynamicRowModel rowModel : dynrowList) {
            rowDataList.addAll(this.buildRowDataList(rowModel, formulaVo, checkVo));
        }
        Map<String, List<DynamicRowDataVo>> groupMap = rowDataList.stream().filter(rowData -> this.filterByCondition((DynamicRowDataVo)rowData, formulaVo, checkVo)).collect(Collectors.groupingBy(rowData -> this.getBuildKey((DynamicRowDataVo)rowData, formulaVo, checkVo)));
        for (Map.Entry<String, List<DynamicRowDataVo>> entry : groupMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            this.addErrorMessage(entry.getKey(), entry.getValue(), formulaVo);
        }
        return this.resultVo;
    }

    @Override
    public Map<String, String> getCheckResult(DynamicRowCheckVo checkVo, DynamicRowFormulaVo formulaVo, DynamicRowCheckResultVo resultVo) {
        if (resultVo.isSuccess()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("jump", "");
        map.put("rowitems", resultVo.getErrorRowItems().stream().collect(Collectors.joining(",")));
        map.put("title", formulaVo.getTitle());
        String content = DynamicRowUniqueCheckService.calculateContent(formulaVo.getContent(), resultVo, checkVo);
        if (StringUtils.isNotEmpty((CharSequence)content) && !content.equals(formulaVo.getContent())) {
            content = content.replaceAll("\n", "").replaceAll("\t", "");
        }
        map.put("content", content);
        map.put("items", "");
        map.put("level", formulaVo.getCheckType());
        return map;
    }

    protected void addErrorMessage(String key, List<DynamicRowDataVo> rowDataList, DynamicRowFormulaVo formulaVo) {
        Map<String, List<DynamicRowDataVo>> groupMap = rowDataList.stream().collect(Collectors.groupingBy(v -> v.getDynrowNo()));
        DynamicRowCheckErrorInfo errorInfo = null;
        for (Map.Entry<String, List<DynamicRowDataVo>> entry : groupMap.entrySet()) {
            errorInfo = new DynamicRowCheckErrorInfo();
            String sheetName = entry.getValue().get(0).getSheetName();
            String rowIndex = entry.getValue().stream().map(v -> v.getRowIndex() + "").collect(Collectors.joining(","));
            errorInfo.setDynrowno(entry.getKey());
            errorInfo.setSheetName(sheetName);
            errorInfo.setRowIndex(rowIndex);
            errorInfo.setColrange(formulaVo.getColumnRange());
            this.resultVo.getErrorInfos().computeIfAbsent(key, v -> new ArrayList(10)).add(errorInfo);
        }
    }

    protected String getBuildKey(DynamicRowDataVo rowData, DynamicRowFormulaVo formulaVo, DynamicRowCheckVo checkVo) {
        List<String> columnRanges = Arrays.asList(formulaVo.getColumnRange().split(","));
        String rowMember = rowData.getDynrowNo().split("#")[0];
        StringBuilder uniquekey = new StringBuilder();
        for (String columnMember : columnRanges) {
            String key = this.getJoinKey("#", rowMember, rowData.getRowIndex(), columnMember);
            String value = (String)checkVo.getData().get(key);
            uniquekey.append(value);
        }
        return uniquekey.toString();
    }

    private static String calculateContent(String content, DynamicRowCheckResultVo resultVo, DynamicRowCheckVo checkVo) {
        HashMap<String, Map> contentMap = new HashMap<String, Map>(10);
        contentMap.putAll(checkVo.getData());
        if (checkVo.getParam() != null) {
            contentMap.putAll(checkVo.getParam());
        }
        contentMap.put("errorInfos", resultVo.getErrorInfos());
        return VelocityUtils.evaluate((String)content, contentMap);
    }
}

