/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.unifieddeclarereportedit.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.unifieddeclarereportedit.service.impl.DefaultUnifiedDeclareReportEditService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class ItpDeclareReportEditServiceImpl
extends DefaultUnifiedDeclareReportEditService {
    protected static final String RECALC_KEY = "recalc";

    @Override
    public void initPeriod(String orgId, Map<String, Object> customParams) {
        Date endDate;
        Date startDate;
        Long taxtionsysId = 1L;
        String zt_type = "bdzt";
        String papers_status = "A";
        this.getView().getModel().setValue("zt_type", (Object)zt_type);
        List<Long> validTaxationsys = ItpDeclareReportEditServiceImpl.queryValidTaxationsys();
        if (validTaxationsys.size() > 0) {
            if (!validTaxationsys.contains(taxtionsysId)) {
                taxtionsysId = validTaxationsys.get(0);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7a0e\u6536\u5236\u5ea6\u3002", (String)"ItpDeclareReportEditServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.getView().getModel().setValue("taxationsys", (Object)taxtionsysId);
        String comment = "";
        if (Boolean.TRUE.equals(customParams.get("readonly"))) {
            startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            papers_status = (String)customParams.get("papers_status");
            comment = (String)customParams.get("comment");
        } else {
            String provisionPeriod = this.getProvisionPeriod(org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)orgId) ? Long.parseLong(orgId) : 0L, taxtionsysId, 3L, zt_type, this.getView().getModel().getDataEntity().getDate("skssqq"), this.getView().getModel().getDataEntity().getDate("skssqz"));
            Map<String, Date> map = ItpDeclareReportEditServiceImpl.preTaxPeriod(provisionPeriod, new Date());
            startDate = map.get("startDate");
            endDate = map.get("endDate");
        }
        this.getView().getModel().setValue("papers_status", (Object)papers_status);
        this.getView().getModel().setValue("comment", (Object)comment);
        this.getView().getModel().setValue("skssqq", (Object)startDate);
        this.getView().getModel().setValue("skssqz", (Object)endDate);
    }

    @Override
    public String getTemplateType() {
        String ztType = this.getView().getModel().getDataEntity().getString("zt_type");
        return "jtzt".equalsIgnoreCase(ztType) ? "sdsjt_jt" : "sdsjt_bd";
    }

    @Override
    public String[] getTaxLimits() {
        Long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
        Long taxationsysId = this.getView().getModel().getDataEntity().getLong("taxationsys.id");
        String zt = this.getView().getModel().getDataEntity().getString("zt_type");
        String provisionPeriod = this.getProvisionPeriod(orgId, taxationsysId, 3L, zt, this.getView().getModel().getDataEntity().getDate("skssqq"), this.getView().getModel().getDataEntity().getDate("skssqz"));
        ArrayList<String> taxLimits = new ArrayList<String>(8);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)provisionPeriod)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"ItpDeclareReportEditServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        taxLimits.add(provisionPeriod);
        return taxLimits.toArray(new String[0]);
    }

    @Override
    public Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        if (this.getView().getModel().getDataEntity().getBoolean("isadjustperiod")) {
            return true;
        }
        return null;
    }

    @Override
    public Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String number = customParams.containsKey("billno") ? customParams.get("billno").toString() : "";
        String zt_type = customParams.containsKey("zt_type") ? customParams.get("zt_type").toString() : null;
        String papers_status = customParams.containsKey("papers_status") ? customParams.get("papers_status").toString() : null;
        String comment = customParams.containsKey("comment") ? customParams.get("comment").toString() : null;
        String taxtionsysId = customParams.containsKey("taxationsys") ? customParams.get("taxationsys").toString() : null;
        boolean isadjustperiod = customParams.containsKey("isadjustperiod") ? (Boolean)customParams.get("isadjustperiod") : false;
        String adjustperiod = customParams.containsKey("adjustperiod") ? customParams.get("adjustperiod").toString() : "";
        this.getView().getModel().setValue("number", (Object)number);
        this.getView().getModel().setValue("zt_type", (Object)zt_type);
        this.getView().getModel().setValue("papers_status", (Object)(papers_status == null ? "A" : papers_status));
        this.getView().getModel().setValue("comment", (Object)comment);
        this.getView().getModel().setValue("taxationsys", (Object)taxtionsysId);
        this.getView().getModel().setValue("isadjustperiod", (Object)isadjustperiod);
        this.getView().getModel().setValue("adjustperiod", (Object)adjustperiod);
        return customParams;
    }

    @Override
    public Map<String, String> getMainTableExtendParams() {
        HashMap<String, String> mainTableParams = new HashMap<String, String>(4);
        mainTableParams.put("billno", this.getView().getModel().getDataEntity().getString("number"));
        mainTableParams.put("taxsystem", this.getView().getModel().getDataEntity().getString("taxationsys.id"));
        mainTableParams.put("accountsettype", this.getView().getModel().getDataEntity().getString("zt_type"));
        mainTableParams.put("draftstatus", this.getView().getModel().getDataEntity().getString("papers_status"));
        mainTableParams.put("remarks", this.getView().getModel().getDataEntity().getString("comment"));
        mainTableParams.put("createtime", new Date().toString());
        mainTableParams.put("taxtype", "3");
        mainTableParams.put("taxareagroup", this.getProvisionTaxareagroup(this.getView().getModel().getDataEntity().getLong("org.id"), this.getView().getModel().getDataEntity().getLong("taxationsys.id"), 3L, this.getView().getModel().getDataEntity().getString("zt_type"), this.getView().getModel().getDataEntity().getDate("skssqq"), this.getView().getModel().getDataEntity().getDate("skssqz")));
        mainTableParams.put("draftpurpose", "sjjt");
        mainTableParams.put("isadjustperiod", this.getView().getModel().getDataEntity().getBoolean("isadjustperiod") ? "1" : "0");
        mainTableParams.put("adjustperiod", this.getView().getModel().getDataEntity().getString("adjustperiod"));
        return mainTableParams;
    }

    @Override
    public DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getMainTableExtendParams());
        requestModel.setExtendParams(extendParams);
        Long taxationsysId = this.getView().getModel().getDataEntity().getLong("taxationsys.id");
        requestModel.setTaxationsys(taxationsysId);
        return requestModel;
    }

    @Override
    public boolean beforeClickCheckStatus(String operateKey) {
        long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
        Long taxationsysId = this.getView().getModel().getDataEntity().getLong("taxationsys.id");
        Date skssqq = this.getView().getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getView().getModel().getDataEntity().getDate("skssqz");
        String ztType = this.getView().getModel().getDataEntity().getString("zt_type");
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)orgId) || org.apache.commons.lang3.ObjectUtils.isEmpty((Object)taxationsysId) || org.apache.commons.lang3.ObjectUtils.isEmpty((Object)skssqq) || org.apache.commons.lang3.ObjectUtils.isEmpty((Object)skssqz) || org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ztType)) {
            return false;
        }
        List<Long> isTaxpayerOrg = ItpDeclareReportEditServiceImpl.queryTaxcMainOrgIdByIsTaxpayerWithPerm();
        if (!isTaxpayerOrg.contains(orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u8be5\u7a0e\u5236\u7684\u7eb3\u7a0e\u4e3b\u4f53\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ItpDeclareReportEditServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        return !RECALC_KEY.equals(operateKey) || this.getView().getModel().getDataEntity().getBoolean("isadjustperiod") || this.isBaseJtPlanSetJtDate(orgId, taxationsysId, 3L, ztType, skssqq, skssqz);
    }

    @Override
    public boolean checkArgsBeforeOpenInnerPage() {
        long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
        Long taxationsysId = this.getView().getModel().getDataEntity().getLong("taxationsys.id");
        Date skssqq = this.getView().getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getView().getModel().getDataEntity().getDate("skssqz");
        String ztType = this.getView().getModel().getDataEntity().getString("zt_type");
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)orgId) || org.apache.commons.lang3.ObjectUtils.isEmpty((Object)taxationsysId) || org.apache.commons.lang3.ObjectUtils.isEmpty((Object)skssqq) || org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)skssqz)) {
            return false;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!Boolean.TRUE.equals(customParams.get("readonly"))) {
            String provisionPeriod = this.getProvisionPeriod(orgId, taxationsysId, 3L, ztType, skssqq, skssqz);
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)provisionPeriod)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"ItpDeclareReportEditServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return false;
            }
            Integer taxlossyear = this.getItpTaxLossDraft(orgId, taxationsysId, skssqz);
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)taxlossyear)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u7ef4\u62a4\u7a0e\u4e8f\u8bbe\u7f6e\u6216\u4e0d\u5728\u6709\u6548\u671f\u5185\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u7f16\u5236\u3002", (String)"ItpDeclareReportEditServiceImpl_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    @Override
    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
        long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
        Long taxationsysId = this.getView().getModel().getDataEntity().getLong("taxationsys.id");
        Date skssqq = this.getView().getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getView().getModel().getDataEntity().getDate("skssqz");
        String ztType = this.getView().getModel().getDataEntity().getString("zt_type");
        String cacheKey = orgId + DateUtils.format((Date)skssqq) + DateUtils.format((Date)skssqz) + taxationsysId + ztType + "_declareRequest";
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.getView().getPageCache(), (String)cacheKey, DeclareRequestModel.class);
        if (requestModel != null && (RECALC_KEY.equals(requestModel.getCustomEvent()) || "edit".equals(requestModel.getCustomEvent()))) {
            HashMap map = new HashMap(3);
            List<String> list = Arrays.asList("ggxcfjs_jyqndljjzkce#je", "gyxjzzcxekcjs_yqndjzkkcdjze#gyxjzzcxekcjs_je", "zgjyjfjs_yqndjzkce#zgjyjfjs_je");
            list.stream().forEach(o -> {
                if (dataMap.containsKey(o)) {
                    String value = "".equals(dataMap.get(o)) ? "0.00" : (String)dataMap.get(o);
                    map.put(o, value);
                } else {
                    map.put(o, "0.00");
                }
            });
            this.getView().getPageCache().put("fixValuecache", JSONObject.toJSONString(map));
        }
        if ("A".equals(this.getView().getModel().getDataEntity().getString("billstatus")) && "edit".equals(this.getView().getModel().getDataEntity().getString("operationstatus"))) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"adjustncs"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"canceladjust"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"adjustncs"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"canceladjust"});
        }
    }

    public String getProvisionPeriod(Long orgId, Long taxationsysId, Long taxtype, String ztType, Date skssqq, Date skssqz) {
        return (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"itp", (String)"itpJtPlanServiceImpl", (String)"getProvisionPeriod", (Object[])new Object[]{orgId, taxationsysId, taxtype, ztType, skssqq, skssqz});
    }

    public String getProvisionTaxareagroup(Long orgId, Long taxationsysId, Long taxtype, String ztType, Date skssqq, Date skssqz) {
        return (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"itp", (String)"itpJtPlanServiceImpl", (String)"getProvisionTaxareagroup", (Object[])new Object[]{orgId, taxationsysId, taxtype, ztType, skssqq, skssqz});
    }

    public Integer getItpTaxLossDraft(Long orgId, Long taxationsysId, Date skssqz) {
        return (Integer)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"itp", (String)"itpTaxLossDraftImpl", (String)"calculate", (Object[])new Object[]{orgId, taxationsysId, skssqz});
    }

    public static List<Long> queryTaxcMainOrgIdByIsTaxpayerWithPerm() {
        TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), null);
        if (listTaxResult.isSuccess() && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public boolean isBaseJtPlanSetJtDate(Long orgId, Long taxationsysId, Long taxtype, String ztType, Date skssqq, Date skssqz) {
        String provisionPeriod = this.getProvisionPeriod(orgId, taxationsysId, taxtype, ztType, skssqq, skssqz);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)provisionPeriod)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"ItpDeclareReportEditServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static List<Long> queryValidTaxationsys() {
        TaxResult taxResult = TaxAtionsysDataServiceHelper.queryValidTaxationsys();
        if (taxResult.isSuccess() && !ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static Map<String, Date> preTaxPeriod(String provisionPeriod, Date now) {
        Date endDate;
        Date startDate;
        HashMap<String, Date> result = new HashMap<String, Date>();
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)provisionPeriod)) {
            return result;
        }
        Date xtqDate = DateUtils.addMonth((Date)now, (int)-1);
        if ("season".equals(provisionPeriod)) {
            Date date = DateUtils.addMonth((Date)now, (int)-3);
            startDate = DateUtils.getFirstDateOfSeason((Date)date);
            endDate = DateUtils.getLastDateOfSeason((Date)date);
        } else if ("year".equals(provisionPeriod)) {
            startDate = DateUtils.getFirstDateOfYear((Date)now);
            endDate = DateUtils.getLastDateOfYear((Date)now);
        } else {
            startDate = DateUtils.getFirstDateOfMonth((Date)xtqDate);
            endDate = kd.taxc.bdtaxr.common.utils.date.DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)xtqDate));
        }
        result.put("startDate", startDate);
        result.put("endDate", endDate);
        return result;
    }
}

