/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.update;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.taxc.bdtaxr.business.taxdeclare.update.AbstractDeclareDataUpdService;
import kd.taxc.bdtaxr.common.upgrade.UpdConstant;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class StandardDeclareDataUpdService
extends AbstractDeclareDataUpdService {
    private static final Log LOGGER = LogFactory.getLog(StandardDeclareDataUpdService.class);
    private List<String> templateTypes;
    private String appid;

    public StandardDeclareDataUpdService(String appid) {
        this.appid = appid;
        this.templateTypes = UpdConstant.getTemplateTypeByApp((String)appid);
    }

    public String update() {
        if (StringUtil.isEmpty((CharSequence)this.appid)) {
            return "The appid is not exist";
        }
        long l = System.currentTimeMillis();
        this.addLog(INFO, "DATA UPGRADE START");
        try {
            this.update(this.templateTypes, this.getRefresh(), this.appid);
        }
        catch (Throwable t) {
            this.logs.append(ERROR_INFO);
            this.logs.append('\n');
            this.logs.append(StringUtil.getStackTraceMessage((Throwable)t));
            this.getLogger().error(ERROR_INFO, t);
        }
        this.logs.append('\n');
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%s ms", System.currentTimeMillis() - l));
        return this.logs.toString();
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public List<String> getTemplateTypes() {
        return this.templateTypes;
    }

    public void setTemplateTypes(List<String> templateTypes) {
        this.templateTypes = templateTypes;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    @Override
    public String getAppid() {
        return this.appid;
    }
}

