/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.dynamicrowcheck.DynamicRowCheckFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.dynamicrowcheck.service.DynamicRowCheckService;
import kd.taxc.bdtaxr.business.template.DynamicRowBizDao;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.refactor.formula.context.SimpleFormulaContext;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.bdtaxr.common.vo.DynamicRowCheckVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowFormulaVo;
import kd.taxc.bdtaxr.common.vo.TemplateVo;

public class DynamicRowBizBusiness {
    public static DynamicObject getDynRowData(Long templateId, String dynRowNo, String modeltype) {
        return DynamicRowBizDao.getDynRowData(templateId, dynRowNo, modeltype);
    }

    public static EntityType getCheckEntryEntityType() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bdtaxr_template_dynrow");
        EntryProp property = (EntryProp)type.getProperty("checkentry");
        EntityType entityType = (EntityType)property.getItemType();
        return entityType;
    }

    public static Map<String, List<DynamicObject>> getDynRowReportItems(Long templateId) {
        Map<String, DynamicObject> reportItems = DynamicRowBizDao.getReportItemsByTemplate(templateId.toString());
        List dynRowNoList = DynamicRowService.getDynRowNoList((Long)templateId);
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(reportItems.size());
        for (String dynRowNo : dynRowNoList) {
            String rowMember = dynRowNo.split("#")[0];
            for (Map.Entry<String, DynamicObject> entry : reportItems.entrySet()) {
                String cellRowMember;
                String cellKey = entry.getKey();
                if (!cellKey.contains("#") || !(cellRowMember = cellKey.split("#")[0]).equals(rowMember)) continue;
                DynamicObject reportItem = reportItems.get(cellKey);
                result.computeIfAbsent(dynRowNo, v -> new ArrayList(10)).add(reportItem);
            }
        }
        return result;
    }

    public static Map<String, List<DynamicRowFormulaVo>> getCheckFormulas(Long templateId, String checkType) {
        DynamicObject[] dynRowList = DynamicRowBizDao.getDynRowListByTemplateId(templateId, "3");
        if (dynRowList == null || dynRowList.length == 0) {
            return Collections.emptyMap();
        }
        List fitList = Arrays.stream(dynRowList).filter(v -> v.getDynamicObjectCollection("checkentry") != null && v.getDynamicObjectCollection("checkentry").size() > 0).collect(Collectors.toList());
        HashMap<String, List<DynamicRowFormulaVo>> result = new HashMap<String, List<DynamicRowFormulaVo>>(10);
        for (DynamicObject object : fitList) {
            DynamicObjectCollection entries;
            Object fitEntries = entries = object.getDynamicObjectCollection("checkentry");
            if (StringUtils.isNotEmpty((CharSequence)checkType)) {
                fitEntries = entries.stream().filter(v -> checkType.equals(v.getString("checklevel")) && v.getBoolean("entryenable")).collect(Collectors.toList());
            }
            ArrayList<DynamicRowFormulaVo> formulaList = new ArrayList<DynamicRowFormulaVo>(10);
            for (DynamicObject entry : fitEntries) {
                formulaList.add(DynamicRowBizBusiness.dynamicObjectToFormulaVo(entry, object.getString("dynrow_no")));
            }
            if (formulaList.size() <= 0) continue;
            result.put(object.getString("dynrow_no"), formulaList);
        }
        return result;
    }

    private static DynamicRowFormulaVo dynamicObjectToFormulaVo(DynamicObject entry, String dynrowno) {
        DynamicRowFormulaVo formulaVo = new DynamicRowFormulaVo();
        formulaVo.setDynrowNo(dynrowno);
        formulaVo.setCheckType(entry.getString("checktype"));
        formulaVo.setCheckLevel(entry.getString("checklevel"));
        formulaVo.setColumnRange(entry.getString("colrange"));
        formulaVo.setDynrowRange(entry.getString("dynrowrange"));
        formulaVo.setCondition(entry.getString("condition"));
        formulaVo.setTitle(entry.getString("title"));
        formulaVo.setContent(entry.getString("content"));
        formulaVo.setCustomservice(entry.getString("customservice"));
        formulaVo.setDecription(entry.getString("description"));
        return formulaVo;
    }

    public static List<Map<String, String>> calCheckFormulas(DynamicRowCheckVo checkVo) {
        if (checkVo.getDynRowList() == null || checkVo.getDynRowList().size() == 0) {
            return Collections.emptyList();
        }
        SimpleFormulaContext formulaContext = new SimpleFormulaContext(checkVo.getData(), checkVo.getParam(), checkVo.getTypeMap());
        Map formulas = checkVo.getFormulas();
        DynamicRowBizBusiness.batchFetchDataBeforeCheck(checkVo);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(10);
        for (List listValue : formulas.values()) {
            for (DynamicRowFormulaVo formula : listValue) {
                DynamicRowCheckService checkService = DynamicRowCheckFactory.createHandler(checkVo.getRequestModel().getTemplateType(), formula.getCheckType());
                Map<String, String> result = checkService.check(checkVo, formula, formulaContext);
                if (!ObjectUtils.isNotEmpty(result)) continue;
                resultList.add(result);
            }
        }
        return resultList;
    }

    private static void batchFetchDataBeforeCheck(DynamicRowCheckVo checkVo) {
        DeclareRequestModel requestModel = checkVo.getRequestModel();
        List baseTemplate = requestModel.getBaseTemplate();
        if (baseTemplate == null) {
            TemplateVo TemplateVo2 = (TemplateVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_BASE_TEMPLATE, (Object[])new Object[]{requestModel.getModelId(), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), DateUtils.stringToDate((String)requestModel.getSkssqq(), (String)"yyyy-MM-dd"), DateUtils.stringToDate((String)requestModel.getSkssqz(), (String)"yyyy-MM-dd")});
            requestModel.setBaseTemplate(TemplateVo2.getTemplate());
        }
        List dynRowNumbers = checkVo.getDynRowList().stream().map(v -> v.getDynRowNo().split("#")[0]).collect(Collectors.toList());
        if (baseTemplate != null) {
            HashMap sheetNameMap = new HashMap(10);
            baseTemplate.stream().forEach(v -> {
                if (v.getRowList() != null && v.getRowList().size() > 0) {
                    v.getRowList().stream().flatMap(Collection::stream).forEach(cell -> {
                        String key = cell.getCellKey();
                        if (StringUtil.isNotEmpty((CharSequence)key) && key.indexOf("#") >= 0) {
                            String[] objects = key.split("#");
                            if (objects == null || objects.length == 0) {
                                return;
                            }
                            String rowNumber = key.split("#")[0];
                            if (dynRowNumbers.contains(rowNumber)) {
                                sheetNameMap.put(rowNumber, v.getName());
                            }
                        }
                    });
                }
            });
            checkVo.setSheetNameMap(sheetNameMap);
        }
    }
}

