/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.template.impl;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.template.TemplateService;
import kd.taxc.bdtaxr.common.constant.RequestResult;
import kd.taxc.bdtaxr.common.refactor.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TemplateServiceImpl
implements TemplateService {
    private Log logger = LogFactory.getLog(TemplateServiceImpl.class);

    @Override
    public String showTemplate(Long templateId, List<String> sheetNames, String pageId, Map<String, Object> customParams, String listStr) {
        if (StringUtils.isBlank((Object)templateId)) {
            return "";
        }
        DynamicObject templateContent = TemplateUtils.getTemplateDynamicObjectById((Long)templateId);
        List list = JSONArray.parseArray((String)listStr, DynamicRowModel.class);
        return this.extractTemplateJson(templateContent.getString("content_tag"), templateId, sheetNames, pageId, customParams, list);
    }

    public String extractTemplateJson(String templateContent, Long templateId, List<String> sheetNames, String pageId, Map<String, Object> customParams, List<DynamicRowModel> dynamicRowModelList) {
        if (StringUtils.isBlank((CharSequence)templateContent)) {
            return "";
        }
        ArrayList floatBasePointList = new ArrayList();
        ArrayList sheets = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty(sheetNames)) {
            sheetNames.stream().forEach(v -> sheets.addAll(SpreadUtils.getSheets((String)templateContent, (String)v)));
        } else {
            sheets.addAll(SpreadUtils.getSheets((String)templateContent, null));
        }
        Map metadataNumberMap = SpreadUtils.getMetadataNumberMap(sheets);
        Map fieldMap = TemplateUtils.getAllEntityShow((Map)metadataNumberMap);
        boolean needWarn = true;
        boolean needRemark = true;
        String editFlag = "read";
        if (EmptyCheckUtils.isNotEmpty(customParams)) {
            needWarn = StringUtils.equals((CharSequence)String.valueOf(needWarn), (CharSequence)((String)customParams.get("needwarn")));
            needRemark = StringUtils.equals((CharSequence)String.valueOf(needRemark), (CharSequence)((String)customParams.get("needremark")));
            editFlag = (String)customParams.get("operation");
        }
        Map cellTypeMap = CacheFormulaService.getCellFormulas((Long)templateId);
        String templateHtml = TemplateShowUtils.buildSbbHtml(sheets, (Map)fieldMap, (Map)cellTypeMap, (String)editFlag, (String)"{PAGE_ID}", (!needWarn ? 1 : 0) != 0, (!needRemark ? 1 : 0) != 0, floatBasePointList, dynamicRowModelList);
        templateHtml = templateHtml.replace("{PAGE_ID}", pageId);
        return templateHtml;
    }

    @Override
    public String extractMuldiJson(String templateContent, String formulaContent, List<String> sheetNames, String pageId, Map<String, Object> customParams) {
        if (StringUtils.isBlank((CharSequence)templateContent)) {
            return "";
        }
        ArrayList floatBasePointList = new ArrayList();
        ArrayList sheets = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty(sheetNames)) {
            sheetNames.stream().forEach(v -> sheets.addAll(SpreadUtils.getSheets((String)templateContent, (String)v)));
        } else {
            sheets.addAll(SpreadUtils.getSheets((String)templateContent, null));
        }
        HashMap fieldMap = new HashMap(16);
        boolean needWarn = true;
        boolean needRemark = false;
        String editFlag = "read";
        if (EmptyCheckUtils.isNotEmpty(customParams)) {
            needWarn = StringUtils.equals((CharSequence)String.valueOf(needWarn), (CharSequence)((String)customParams.get("needwarn")));
            needRemark = StringUtils.equals((CharSequence)String.valueOf(needRemark), (CharSequence)((String)customParams.get("needremark")));
            editFlag = (String)customParams.get("operation");
        }
        HashMap cellTypeMap = new HashMap();
        String templateHtml = TemplateShowUtils.buildSbbHtml(sheets, fieldMap, cellTypeMap, (String)editFlag, (String)"{PAGE_ID}", (!needWarn ? 1 : 0) != 0, (!needRemark ? 1 : 0) != 0, floatBasePointList, null);
        templateHtml = templateHtml.replace("{PAGE_ID}", pageId);
        return templateHtml;
    }

    @Override
    public String extractTemplateJson(String templateContent, String formulaContent, List<String> sheetNames, String pageId, Map<String, Object> customParams) {
        if (StringUtils.isBlank((CharSequence)templateContent)) {
            return "";
        }
        ArrayList floatBasePointList = new ArrayList();
        ArrayList sheets = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty(sheetNames)) {
            sheetNames.stream().forEach(v -> sheets.addAll(SpreadUtils.getSheets((String)templateContent, (String)v)));
        } else {
            sheets.addAll(SpreadUtils.getSheets((String)templateContent, null));
        }
        Map metadataNumberMap = SpreadUtils.getMetadataNumberMap(sheets);
        Map fieldMap = TemplateUtils.getAllEntityShow((Map)metadataNumberMap);
        boolean needWarn = true;
        boolean needRemark = false;
        String editFlag = "read";
        if (EmptyCheckUtils.isNotEmpty(customParams)) {
            needWarn = StringUtils.equals((CharSequence)String.valueOf(needWarn), (CharSequence)((String)customParams.get("needwarn")));
            needRemark = StringUtils.equals((CharSequence)String.valueOf(needRemark), (CharSequence)((String)customParams.get("needremark")));
            editFlag = (String)customParams.get("operation");
        }
        Map cellTypeMap = CacheFormulaService.getCellFormulas(null);
        String templateHtml = TemplateShowUtils.buildSbbHtml(sheets, (Map)fieldMap, (Map)cellTypeMap, (String)editFlag, (String)"{PAGE_ID}", (!needWarn ? 1 : 0) != 0, (!needRemark ? 1 : 0) != 0, floatBasePointList, null);
        templateHtml = templateHtml.replace("{PAGE_ID}", pageId);
        return templateHtml;
    }

    @Override
    public String exportData(Long pkId, Long templateId, String pageId) {
        if (StringUtils.isBlank((Object)pkId) || StringUtils.isBlank((Object)templateId)) {
            return "";
        }
        String templateContent = TemplateUtils.getTemplateContentById((Long)templateId);
        if (StringUtils.isBlank((CharSequence)templateContent)) {
            return "";
        }
        Map metadataNumberMap = SpreadUtils.getMetadataNumberMap((List)SpreadUtils.getSheets((String)templateContent, null));
        HashMap dataMap = new HashMap();
        metadataNumberMap.entrySet().forEach(v -> {
            QFilter idFilter = ((String)v.getKey()).equals("gtcp_declare_main") ? new QFilter("id", "=", (Object)pkId) : new QFilter("sbbid", "=", (Object)pkId);
            Map mainMap = TemplateUtils.dataToMapForExport((String)((String)v.getKey()), (String)"_", (QFilter[])new QFilter[]{idFilter});
            dataMap.putAll(mainMap);
        });
        String fileName = templateId.toString() + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSS");
        try (InputStream in = TemplateShowUtils.getDownResultExcelFile((Long)templateId, dataMap);){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", in, 5000);
            IFormView view = SessionManager.getCurrent().getView(pageId);
            view.openUrl(urls);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        return fileName;
    }

    @Override
    public RequestResult importData(Long templateId, List<FileItem> fileItemList) {
        return null;
    }

    @Override
    public RequestResult showDataInTemplate(Long templateId, List<String> sheetNames, String pageId, Map<String, Object> customParams, Map<String, Object> queryParams) {
        return null;
    }

    @Override
    public Long getTemplateId(String templateType, String orgId, Date startDate, Date endDate) {
        Long templateId = null;
        try {
            DynamicObject template = TemplateUtils.getTemplateObjectByConfig((String)templateType, (String)orgId, (Date)startDate, (Date)endDate);
            if (template != null) {
                templateId = template.getLong("id");
            }
        }
        catch (Throwable e) {
            this.logger.error("TemplateServiceImpl-getTemplateId-error", e);
        }
        return templateId;
    }

    @Override
    public Long getZeroDeclareTemplateId(String templateType, String orgId, Date startDate, Date endDate) {
        Long templateId = null;
        try {
            DynamicObject template = TemplateUtils.getZeroDeclareTemplate((String)templateType, (String)orgId, (Date)startDate, (Date)endDate);
            if (template != null) {
                templateId = template.getLong("id");
            }
        }
        catch (Throwable e) {
            this.logger.error("TemplateServiceImpl-getTemplateId-error", e);
            return templateId;
        }
        return templateId;
    }

    @Override
    public Map<String, String> getMetadata(Long templateId) {
        Map<String, String> metadataNumberMap = new HashMap<String, String>();
        if (templateId == null) {
            return metadataNumberMap;
        }
        DynamicObject template = TemplateUtils.getTemplateDynamicObjectById((Long)templateId);
        if (template != null && StringUtils.isNotEmpty((CharSequence)template.getString("content_tag"))) {
            metadataNumberMap = SpreadUtils.getMetadataNumberMap((List)SpreadUtils.getSheets((String)template.getString("content_tag"), null));
            Map result = CacheFormulaService.getFormulaMate((Long)templateId);
            if (metadataNumberMap != null) {
                metadataNumberMap.putAll(result);
            }
            Optional<String> optional = Optional.ofNullable(template.getDynamicObject("type")).map(s -> s.getString("maintable"));
            if (metadataNumberMap != null && optional.isPresent()) {
                metadataNumberMap.put(optional.get(), optional.get());
            }
        }
        return metadataNumberMap;
    }

    @Override
    public Map<String, String> getTemplateKeys(Long templateId) {
        Map<String, String> templateKeys = new HashMap<String, String>();
        if (templateId == null) {
            return templateKeys;
        }
        DynamicObject template = TemplateUtils.getTemplateDynamicObjectById((Long)templateId);
        if (template != null && StringUtils.isNotEmpty((CharSequence)template.getString("content_tag"))) {
            templateKeys = SpreadUtils.getTemplateKeys((List)SpreadUtils.getSheets((String)template.getString("content_tag"), null));
        }
        return templateKeys;
    }

    @Override
    public Map<String, Set<String>> getMetadataRowList(Long templateId) {
        Map allFormulas = CacheFormulaService.getAllFormulas((Long)templateId, null);
        Map formulaVoMap = (Map)allFormulas.get("all");
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        for (String key : formulaVoMap.keySet()) {
            String[] split = key.split("#");
            if (split.length != 3) continue;
            Set orDefault = map.getOrDefault(split[0], new HashSet(4));
            orDefault.add(split[0] + "#" + split[1] + "#");
            map.put(split[0], orDefault);
        }
        return map;
    }
}

