/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.template.update;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ValueMapItem;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.util.crypto.MD5;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.formula.update.twotothree.ToThreeUpdFormPlugin;

public class UpdateToThreeService {
    private static final Log LOGGER = LogFactory.getLog(ToThreeUpdFormPlugin.class);
    private static final String STATUS = "C";
    private static final String FORMAT1 = "%s_%s";
    private List<String> runLogs = new ArrayList<String>(32);
    private static final Long DEFAULT_MODEL = 1472330177106149376L;
    private static final Long ROWID = 1477594605435224064L;
    private static final Long COLID = 1477594945425507328L;
    private static final String UPDROWCOL = "updrowcol";
    private static final String UPDTEMP = "updtemp";
    private static final String UPDFORMULA = "updformula";
    private static final String TPO_FORMULA_EDIT = "tpo_formula_edit";
    private static final String TPO_COL_MEMBER = "tpo_col_member";
    private static final String TPO_ROW_MEMBER = "tpo_row_member";
    private static final String T_TPO_ROW_MEMBER = "t_tpo_row_member";
    private static final String T_TPO_COL_MEMBER = "t_tpo_col_member";
    private static final String TPO_REPORT_ITEM = "tpo_report_item";
    private static final Set<String> JUMP_FIELD = Sets.newHashSet((Object[])new String[]{"id", "ewblxh", "ewblname", "sbbid"});
    private static final HashSet<String> textTypes = Sets.newHashSet((Object[])new String[]{"Combo", "Text", "BillStatus", "Privacy", "MuliLangText", "I18nName", "LargeText", "TextArea", "BtneditText", "SubEntryText", "NameSegText", "BillStatus", "MulCombo", "ItemClassType", "NameSegCombo", "Boolean", "Varchar", "Basedata"});
    private static final HashSet<String> intTypes = Sets.newHashSet((Object[])new String[]{"Integer", "BigInt", "Long", "CreatedById", "ModifierId"});
    private static final HashSet<String> dateTypes = Sets.newHashSet((Object[])new String[]{"Date", "DateTime", "ModifyDate", "Bookdate", "Time"});
    private static final HashSet<String> decimalTypes = Sets.newHashSet((Object[])new String[]{"Decimal", "Amount", "Price", "Qty"});
    private static LinkedHashMap<String, String> grandfatherNumberAppMap = new LinkedHashMap(8);
    private Boolean isPreset = Boolean.TRUE;
    private static final String bbx_Exp = "\\$\\{(.*?)\\}";

    public void setPreset(Boolean preset) {
        this.isPreset = preset;
    }

    public List<String> getRunLogs() {
        return this.runLogs;
    }

    public void update(String templatenum, String operateKey) {
        this.runLogs.clear();
        if (StringUtil.isEmpty((CharSequence)templatenum)) {
            this.runLogs.add("Please enter the Template Number");
            return;
        }
        long l = System.currentTimeMillis();
        this.runLogs.add(String.format("Start %s", operateKey));
        String[] templatenums = templatenum.split(",");
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"bdtaxr_template_main", (QFilter[])new QFilter("number", "in", Arrays.asList(templatenums)).toArray(), (String)"number asc", (int)100);
        DynamicObject[] templObjs = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bdtaxr_template_main"));
        Map<String, DynamicObject> numberMap = Arrays.stream(templObjs).collect(Collectors.toMap(a -> a.getString("number"), b -> b));
        for (String temNum : templatenums) {
            this.runLogs.add(String.format("Start %s templatenumber:%s", operateKey, temNum));
            DynamicObject tempObj = numberMap.get(temNum);
            if (Objects.equals(UPDROWCOL, operateKey)) {
                this.updateRowCol(tempObj);
                continue;
            }
            if (Objects.equals(UPDTEMP, operateKey)) {
                this.updateTemplate(tempObj);
                continue;
            }
            if (!Objects.equals(UPDFORMULA, operateKey)) continue;
            this.updateFormula(tempObj, null);
        }
        this.runLogs.add(String.format("End %s, cost:%s ms", operateKey, System.currentTimeMillis() - l));
    }

    public void clearData(String templatenum) {
        this.runLogs.clear();
        if (StringUtil.isEmpty((CharSequence)templatenum)) {
            this.runLogs.add("Please enter the Template Number");
            return;
        }
        long l = System.currentTimeMillis();
        String operateKey = "clearData";
        this.runLogs.add(String.format("Start %s", "clearData"));
        String[] templatenums = templatenum.split(",");
        DynamicObjectCollection templObjs = QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"id,number,content_tag", (QFilter[])new QFilter("number", "in", Arrays.asList(templatenums)).toArray());
        Map<String, DynamicObject> numberMap = templObjs.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b));
        long currUserId = RequestContext.get().getCurrUserId();
        Date dayFirst = DateUtils.stringToDate((String)"2023-06-13");
        QFilter filter = new QFilter("creator", "=", (Object)currUserId).and("createtime", ">", (Object)dayFirst);
        QFilter modelFilter = new QFilter("model", "=", (Object)DEFAULT_MODEL);
        DynamicObjectCollection threeTemps = QueryServiceHelper.query((String)"tpo_template", (String)"id,number,content_tag", (QFilter[])new QFilter("number", "in", Arrays.asList(templatenums)).and(filter).toArray());
        Map<String, DynamicObject> threeTempsMap = threeTemps.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b));
        for (String temNum : templatenums) {
            this.runLogs.add(String.format("Start %s templatenumber:%s", operateKey, temNum));
            DynamicObject tempObj = numberMap.get(temNum);
            DynamicObject threeTempObj = threeTempsMap.get(temNum);
            Set<String> tempMetadata = this.getTempMetadata(tempObj.getLong("id"));
            try (TXHandle h = TX.required();){
                try {
                    this.doClearData(filter, modelFilter, tempObj, threeTempObj, tempMetadata);
                }
                catch (Throwable t) {
                    h.markRollback();
                    this.runLogs.add(String.format("Operate Error: %s \n", this.getStackTraceMessage(t)));
                    LOGGER.info("OPERATE FAILURE:", (Object)t);
                }
            }
        }
        this.runLogs.add(String.format("The %s operation end, cost:%s ms", "clearData", System.currentTimeMillis() - l));
    }

    private void doClearData(QFilter filter, QFilter modelFilter, DynamicObject tempObj, DynamicObject threeTempObj, Set<String> tempMetadata) {
        DynamicObjectCollection mappings;
        if (threeTempObj != null) {
            List formula;
            Object newTempId = threeTempObj.get("id");
            DynamicObjectCollection checkRel = QueryServiceHelper.query((String)"tpo_template_rule_check", (String)"reportitem,formula", (QFilter[])new QFilter[]{modelFilter, new QFilter("template", "=", newTempId)});
            DynamicObjectCollection fetchRel = QueryServiceHelper.query((String)"tpo_template_rule_fetch", (String)"reportitem,formula", (QFilter[])new QFilter[]{modelFilter, new QFilter("template", "=", newTempId)});
            DynamicObjectCollection styleRel = QueryServiceHelper.query((String)"tpo_template_rule_style", (String)"reportitem,formula", (QFilter[])new QFilter[]{modelFilter, new QFilter("template", "=", newTempId)});
            DeleteServiceHelper.delete((String)"tpo_template_rule_check", (QFilter[])new QFilter[]{filter, modelFilter, new QFilter("template", "=", newTempId)});
            DeleteServiceHelper.delete((String)"tpo_template_rule_fetch", (QFilter[])new QFilter[]{filter, modelFilter, new QFilter("template", "=", newTempId)});
            DeleteServiceHelper.delete((String)"tpo_template_rule_style", (QFilter[])new QFilter[]{filter, modelFilter, new QFilter("template", "=", newTempId)});
            if (!checkRel.isEmpty()) {
                formula = checkRel.stream().map(a -> a.get("formula")).collect(Collectors.toList());
                DeleteServiceHelper.delete((String)"tpo_rule_check", (QFilter[])new QFilter[]{filter, modelFilter, new QFilter("id", "in", formula)});
            }
            if (!fetchRel.isEmpty()) {
                formula = fetchRel.stream().map(a -> a.get("formula")).collect(Collectors.toList());
                DeleteServiceHelper.delete((String)"tpo_rule_fetch", (QFilter[])new QFilter[]{filter, modelFilter, new QFilter("id", "in", formula)});
            }
            if (!styleRel.isEmpty()) {
                formula = styleRel.stream().map(a -> a.get("formula")).collect(Collectors.toList());
                DeleteServiceHelper.delete((String)"tpo_rule_style", (QFilter[])new QFilter[]{filter, modelFilter, new QFilter("id", "in", formula)});
            }
            DeleteServiceHelper.delete((String)"bdtaxr_template_dynrow", (QFilter[])new QFilter[]{filter, new QFilter("template_id", "=", newTempId).and("modeltype", "=", (Object)"3")});
            DeleteServiceHelper.delete((String)"tpo_template", (QFilter[])new QFilter[]{new QFilter("id", "=", newTempId)});
        }
        if ((mappings = QueryServiceHelper.query((String)"tpo_rowcol_mapping", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", tempMetadata)})).size() > 0) {
            List mappingIds = mappings.stream().map(a -> a.get("id")).collect(Collectors.toList());
            DynamicObject[] mappingArr = BusinessDataServiceHelper.load((Object[])mappingIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_rowcol_mapping"));
            HashMap<String, String> bbxMap = new HashMap<String, String>();
            HashSet rowIds = new HashSet(32);
            HashSet colIds = new HashSet(32);
            for (DynamicObject mapping : mappingArr) {
                mapping.getDynamicObjectCollection("rowentity").forEach(a -> rowIds.add(a.get("rowmember.id")));
                mapping.getDynamicObjectCollection("columnentity").forEach(a -> colIds.add(a.get("columnmember.id")));
                for (DynamicObject rowentity : mapping.getDynamicObjectCollection("rowentity")) {
                    String rowNumber = rowentity.getString("rowmember.number");
                    for (DynamicObject columnentity : mapping.getDynamicObjectCollection("columnentity")) {
                        String colNumber = columnentity.getString("columnmember.number");
                        String format = String.format("%s#%s", rowNumber, colNumber);
                        bbxMap.put(format, format);
                    }
                }
            }
            if (bbxMap.size() > 0) {
                DeleteServiceHelper.delete((String)TPO_REPORT_ITEM, (QFilter[])new QFilter[]{new QFilter("number", "in", bbxMap.values()), filter, modelFilter});
            }
            if (!rowIds.isEmpty()) {
                DeleteServiceHelper.delete((String)TPO_ROW_MEMBER, (QFilter[])new QFilter[]{new QFilter("id", "in", rowIds), filter, modelFilter});
            }
            if (!colIds.isEmpty()) {
                DeleteServiceHelper.delete((String)TPO_COL_MEMBER, (QFilter[])new QFilter[]{new QFilter("id", "in", colIds), filter, modelFilter});
            }
            DeleteServiceHelper.delete((String)TPO_ROW_MEMBER, (QFilter[])new QFilter[]{new QFilter("number", "in", tempMetadata), filter, modelFilter});
            DeleteServiceHelper.delete((String)TPO_COL_MEMBER, (QFilter[])new QFilter[]{new QFilter("number", "in", tempMetadata), filter, modelFilter});
            for (DynamicObject mapping : mappingArr = BusinessDataServiceHelper.load((Object[])mappingIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_rowcol_mapping"))) {
                Iterator rowentity = mapping.getDynamicObjectCollection("rowentity").iterator();
                while (rowentity.hasNext()) {
                    DynamicObject next = (DynamicObject)rowentity.next();
                    if (next.get("rowmember") != null) continue;
                    rowentity.remove();
                }
                Iterator columnentity = mapping.getDynamicObjectCollection("columnentity").iterator();
                while (columnentity.hasNext()) {
                    DynamicObject next = (DynamicObject)columnentity.next();
                    if (next.get("columnmember") != null) continue;
                    columnentity.remove();
                }
                mapping.set("modifier", (Object)RequestContext.get().getCurrUserId());
                mapping.set("modifytime", (Object)new Date());
            }
            this.doSave(mappingArr);
        }
    }

    private void doSave(DynamicObject[] objArr) {
        if (objArr.length > 0) {
            SaveServiceHelper.save((DynamicObject[])objArr);
        }
    }

    private void updateFormula(DynamicObject oldTemp, QFilter extendFilter) {
        DynamicObject threeTemp = QueryServiceHelper.queryOne((String)"tpo_template", (String)"id", (QFilter[])new QFilter("number", "=", (Object)oldTemp.getString("number")).toArray());
        Set<String> oldBbxbs = this.paseCellBbx(oldTemp.getString("content_tag"));
        HashMap<String, Map<String, DynamicObject>> mappingMap = new HashMap<String, Map<String, DynamicObject>>();
        Map<String, String> bbxOldNewMap = this.getBbxOldNewMap(oldBbxbs, mappingMap);
        DynamicObjectCollection newCells = QueryServiceHelper.query((String)TPO_REPORT_ITEM, (String)"id,number,col.datatype", (QFilter[])new QFilter("number", "in", bbxOldNewMap.values()).toArray());
        Map<String, DynamicObject> cellMap = newCells.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b));
        this.runLogs.add("\t Start query old formulas ");
        QFilter filter = new QFilter("templateid", "=", (Object)oldTemp.getString("id")).or("templatenum", "=", (Object)oldTemp.getString("number"));
        if (extendFilter != null) {
            filter.and(extendFilter);
        }
        DynamicObjectCollection oldFormulas = QueryServiceHelper.query((String)TPO_FORMULA_EDIT, (String)" * ", (QFilter[])filter.toArray());
        Map<String, List<DynamicObject>> formulatypeMap = oldFormulas.stream().filter(a -> bbxOldNewMap.containsKey(a.getString("formulakey"))).collect(Collectors.groupingBy(a -> a.getString("formulatype")));
        QFilter qFilter = new QFilter("template", "=", threeTemp.get("id")).and("model", "=", (Object)DEFAULT_MODEL);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_template_rule_fetch", (String)"reportitem,formula,template", (QFilter[])new QFilter[]{qFilter});
        Map<String, DynamicObject> fetchDbMap = query.stream().collect(Collectors.toMap(a -> String.format(FORMAT1, a.getString("template"), a.getString("reportitem")), b -> b));
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)"tpo_template_rule_style", (String)"reportitem,formula,template", (QFilter[])new QFilter[]{qFilter});
        Map<String, DynamicObject> styleDbMap = query2.stream().collect(Collectors.toMap(a -> String.format(FORMAT1, a.getString("template"), a.getString("reportitem")), b -> b));
        HashMap<String, DynamicObject> fetchRule = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> styleRule = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> checkRule = new HashMap<String, DynamicObject>();
        HashMap<String, Object> dbRule = new HashMap<String, Object>();
        HashMap<String, DynamicObject> fittype = new HashMap<String, DynamicObject>();
        ArrayList<DynamicObject> fetchRuleTempRel = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> styleRuleTempRel = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> checkRuleTempRel = new ArrayList<DynamicObject>(16);
        if (oldFormulas.size() > 0) {
            this.fillDbMap(dbRule, fittype);
        }
        this.runLogs.add("\t Start create new formulas ");
        for (Map.Entry<String, List<DynamicObject>> entry : formulatypeMap.entrySet()) {
            String formulaType = entry.getKey();
            for (DynamicObject oldFormula : entry.getValue()) {
                String formulakey;
                String newCellKey;
                DynamicObject newCell;
                DynamicObject newRule = this.createRule(formulaType, oldFormula, newCell = cellMap.get(newCellKey = bbxOldNewMap.get(formulakey = oldFormula.getString("formulakey"))), bbxOldNewMap, dbRule, fittype);
                if (newRule == null) continue;
                switch (formulaType) {
                    case "2": {
                        checkRule.put(newCellKey, newRule);
                        break;
                    }
                    case "3": {
                        styleRule.putIfAbsent(newCellKey, newRule);
                        break;
                    }
                    case "1": 
                    case "4": {
                        fetchRule.putIfAbsent(newCellKey, newRule);
                    }
                }
                DynamicObject ruleCellTempRel = this.createRuleCellTempRel(formulaType, newRule, newCell, threeTemp.get("id"), fetchDbMap, styleDbMap);
                if (ruleCellTempRel == null) continue;
                switch (formulaType) {
                    case "2": {
                        checkRuleTempRel.add(ruleCellTempRel);
                        break;
                    }
                    case "3": {
                        styleRuleTempRel.add(ruleCellTempRel);
                        break;
                    }
                    case "1": 
                    case "4": {
                        fetchRuleTempRel.add(ruleCellTempRel);
                    }
                }
            }
        }
        this.runLogs.add("\t Start save data");
        try (TXHandle h = TX.required();){
            try {
                this.doSave(fetchRule.values().toArray(new DynamicObject[fetchRule.size()]));
                this.doSave(styleRule.values().toArray(new DynamicObject[styleRule.size()]));
                this.doSave(checkRule.values().toArray(new DynamicObject[checkRule.size()]));
                this.doSave(fetchRuleTempRel.toArray(new DynamicObject[fetchRuleTempRel.size()]));
                this.doSave(styleRuleTempRel.toArray(new DynamicObject[styleRuleTempRel.size()]));
                this.doSave(checkRuleTempRel.toArray(new DynamicObject[checkRuleTempRel.size()]));
            }
            catch (Throwable t) {
                h.markRollback();
                this.runLogs.add(String.format("Operate Error: %s \n", this.getStackTraceMessage(t)));
                LOGGER.info("OPERATE FAILURE:", (Object)t);
            }
        }
        this.runLogs.add("\t End save data");
    }

    public void updateFormulaByTempKey(String templatenum, Set<String> formulaKeySet) {
        long l = System.currentTimeMillis();
        this.runLogs.clear();
        String operateKey = "update formula";
        this.runLogs.add(String.format("Start %s templatenumber:%s", operateKey, templatenum));
        DynamicObject tempObj = QueryServiceHelper.queryOne((String)"bdtaxr_template_main", (String)"content_tag,id,number", (QFilter[])new QFilter("number", "=", (Object)templatenum).toArray());
        if (tempObj != null) {
            this.updateFormula(tempObj, new QFilter("formulakey", "in", formulaKeySet));
        }
        this.runLogs.add(String.format("End %s, cost:%s ms", operateKey, System.currentTimeMillis() - l));
    }

    private void fillDbMap(HashMap<String, Object> dbRule, HashMap<String, DynamicObject> fittype) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_rule_fetch", (String)"formula,id,fittype", (QFilter[])QFilter.isNotNull((String)"id").toArray());
        for (Object object : query) {
            String key = this.calcMd5(object.getString("formula"), "tpo_rule_fetch");
            dbRule.put(key, object.get("id"));
            fittype.put(object.getString("id"), (DynamicObject)object);
        }
        DynamicObjectCollection query1 = QueryServiceHelper.query((String)"tpo_rule_check", (String)"formula,id,fittype", (QFilter[])QFilter.isNotNull((String)"id").toArray());
        for (DynamicObject object : query1) {
            String key = this.calcMd5(object.getString("formula"), "tpo_rule_check");
            dbRule.put(key, object.get("id"));
            fittype.put(object.getString("id"), object);
        }
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)"tpo_rule_style", (String)"formula,id,fittype,celltype", (QFilter[])QFilter.isNotNull((String)"id").toArray());
        for (DynamicObject object : query2) {
            String key = this.calcMd5(object.getString("formula") + object.getString("celltype"), "tpo_rule_style");
            dbRule.put(key, object.get("id"));
            fittype.put(object.getString("id"), object);
        }
    }

    private String calcMd5(String formula, String formulaEntityId) {
        formula = formulaEntityId + formula;
        formula = formula.replace("\n", "").replace("\t", "").replace("\r", "").replace(" ", "").toLowerCase().trim();
        return MD5.md5((String)formula);
    }

    private DynamicObject createRuleCellTempRel(String formulaType, DynamicObject newRule, DynamicObject newCell, Object templateId, Map<String, DynamicObject> fetchDbMap, Map<String, DynamicObject> styleDbMap) {
        DynamicObject ruleCellTempRel = null;
        String cellid = newCell.getString("id");
        String key = String.format(FORMAT1, templateId, cellid);
        switch (formulaType) {
            case "2": {
                ruleCellTempRel = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_template_rule_check"));
                break;
            }
            case "3": {
                if (styleDbMap.containsKey(key)) {
                    return null;
                }
                ruleCellTempRel = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_template_rule_style"));
                styleDbMap.put(key, ruleCellTempRel);
                break;
            }
            case "1": 
            case "4": {
                if (fetchDbMap.containsKey(key)) {
                    return null;
                }
                ruleCellTempRel = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_template_rule_fetch"));
                fetchDbMap.put(key, ruleCellTempRel);
            }
        }
        if (ruleCellTempRel != null) {
            ruleCellTempRel.set("model", (Object)DEFAULT_MODEL);
            ruleCellTempRel.set("formula", newRule.get("id"));
            ruleCellTempRel.set("reportitem", (Object)cellid);
            ruleCellTempRel.set("template", templateId);
            ruleCellTempRel.set("creator", (Object)RequestContext.get().getCurrUserId());
            ruleCellTempRel.set("createtime", (Object)new Date());
        }
        return ruleCellTempRel;
    }

    private DynamicObject createRule(String formulaType, DynamicObject oldFormula, DynamicObject newCell, Map<String, String> bbxOldNewMap, HashMap<String, Object> dbRule, HashMap<String, DynamicObject> fittype) {
        String key;
        DynamicObject newRule = null;
        boolean isDb = false;
        String formula = "4".equals(formulaType) || "1".equals(formulaType) || "2".equals(formulaType) ? this.dealQFormula(bbxOldNewMap, oldFormula.getString("formula")) : oldFormula.getString("formulaname");
        if ("2".equals(formulaType)) {
            key = this.calcMd5(formula, "tpo_rule_check");
            isDb = dbRule.containsKey(key);
            if (isDb) {
                newRule = BusinessDataServiceHelper.loadSingle((Object)dbRule.get(key), (String)"tpo_rule_check");
            } else {
                newRule = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_rule_check"));
                newRule.set("id", (Object)DBUtils.getLongId((String)"t_tpo_rule_check"));
                newRule.set("title", oldFormula.get("title"));
                newRule.set("content", oldFormula.get("content"));
            }
        } else if ("3".equals(formulaType)) {
            key = this.calcMd5(formula + oldFormula.getString("celltype"), "tpo_rule_style");
            isDb = dbRule.containsKey(key);
            if (isDb) {
                newRule = BusinessDataServiceHelper.loadSingle((Object)dbRule.get(key), (String)"tpo_rule_style");
            } else {
                newRule = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_rule_style"));
                newRule.set("id", (Object)DBUtils.getLongId((String)"t_tpo_rule_style"));
                newRule.set("celltype", (Object)oldFormula.getString("celltype"));
            }
        } else if ("4".equals(formulaType) || "1".equals(formulaType)) {
            key = this.calcMd5(formula, "tpo_rule_fetch");
            isDb = dbRule.containsKey(key);
            if (isDb) {
                newRule = BusinessDataServiceHelper.loadSingle((Object)dbRule.get(key), (String)"tpo_rule_fetch");
            } else {
                newRule = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_rule_fetch"));
                newRule.set("id", (Object)DBUtils.getLongId((String)"t_tpo_rule_fetch"));
                newRule.set("datatype", (Object)("4".equals(formulaType) ? "text" : "number"));
            }
        }
        if (newRule != null) {
            if (!isDb) {
                newRule.set("formula", (Object)formula);
                newRule.set("description", oldFormula.get("describe"));
                newRule.set("model", (Object)DEFAULT_MODEL);
                newRule.set("fittype", (Object)"BBXGZ");
                String number = CodeRuleServiceHelper.getNumber((String)newRule.getDataEntityType().getName(), (DynamicObject)newRule, null);
                newRule.set("number", (Object)number);
                newRule.set("createtime", (Object)new Date());
                newRule.set("creator", (Object)RequestContext.get().getCurrUserId());
                newRule.set("status", (Object)"A");
                newRule.set("enable", (Object)"1");
            }
            if (!isDb || isDb && "BBXGZ".equals(fittype.get(newRule.getString("id")))) {
                DynamicObjectCollection cellEntity = newRule.getDynamicObjectCollection("entryentity");
                DynamicObject item = cellEntity.addNew();
                item.set("reportitem", newCell.get("id"));
            }
            newRule.set("modifytime", (Object)new Date());
            newRule.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        return newRule;
    }

    private String dealQFormula(Map<String, String> bbxOldNewMap, String formula) {
        if (StringUtil.isNotEmpty((CharSequence)formula) && formula.contains("{Q[")) {
            List list = ParseUtils.parseformula((String)formula);
            for (String cellformula : list) {
                Map map = ParseUtils.parseFormulaZKH((String)cellformula);
                if (!"Q".equals(ParseUtils.getType((Map)map))) continue;
                String value = ParseUtils.getValue((Map)map);
                String newValue = bbxOldNewMap.get(value);
                formula = formula.replace("{Q[" + value + "]}", "{Q[" + newValue + "]}");
            }
        }
        return formula;
    }

    public void updateTemplate(DynamicObject oldTemp) {
        DynamicObject threeTemp = QueryServiceHelper.queryOne((String)"tpo_template", (String)"id,number", (QFilter[])new QFilter("id", "=", oldTemp.getPkValue()).toArray());
        if (threeTemp != null && Objects.equals(oldTemp.getString("number"), threeTemp.getString("number"))) {
            this.runLogs.add(String.format("The %s template is existed!", oldTemp.getString("number")));
            return;
        }
        this.runLogs.add("\t Start create new template");
        threeTemp = this.createThreeTemplate(oldTemp, threeTemp);
        this.runLogs.add("\t Start replace report item");
        Map<String, DynamicObject> bbxBasedata = this.dealBbx(threeTemp, oldTemp.getString("content_tag"));
        this.runLogs.add(String.format("\t End create report item, data size: %s", bbxBasedata.size()));
        this.runLogs.add("\t Start create dynamic row");
        HashMap<String, DynamicObject> dyrow = this.dealDyrow(oldTemp, threeTemp);
        this.runLogs.add(String.format("\t End create dynamic row, data size: %s", dyrow.size()));
        this.runLogs.add("\t Start save data");
        try (TXHandle h = TX.required();){
            try {
                this.doSave(bbxBasedata.values().toArray(new DynamicObject[bbxBasedata.size()]));
                this.doSave(new DynamicObject[]{threeTemp});
                this.doSave(dyrow.values().toArray(new DynamicObject[dyrow.size()]));
            }
            catch (Throwable t) {
                h.markRollback();
                this.runLogs.add(String.format("Operate Error: %s \n", this.getStackTraceMessage(t)));
                LOGGER.info("OPERATE FAILURE:", (Object)t);
            }
        }
        this.runLogs.add("\t End save data");
    }

    private DynamicObject createThreeTemplate(DynamicObject oldTemp, DynamicObject threeTemp) {
        Object id = threeTemp == null ? oldTemp.get("id") : Long.valueOf(DBUtils.getLongId((String)"t_tpo_template"));
        threeTemp = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_template"));
        threeTemp.set("id", id);
        threeTemp.set("masterid", id);
        threeTemp.set("number", oldTemp.get("number"));
        threeTemp.set("name", oldTemp.get("name"));
        threeTemp.set("type", oldTemp.get("type"));
        threeTemp.set("startdate", oldTemp.get("startdate"));
        threeTemp.set("enddate", oldTemp.get("enddate"));
        threeTemp.set("createtime", (Object)new Date());
        threeTemp.set("modifytime", (Object)new Date());
        threeTemp.set("creator", (Object)RequestContext.get().getCurrUserId());
        threeTemp.set("modifier", (Object)RequestContext.get().getCurrUserId());
        threeTemp.set("status", (Object)STATUS);
        threeTemp.set("enable", (Object)"1");
        threeTemp.set("general", oldTemp.get("general"));
        threeTemp.set("filtercondition", oldTemp.get("filtercondition"));
        threeTemp.set("conditionjson", oldTemp.get("conditionjson"));
        threeTemp.set("model", (Object)DEFAULT_MODEL);
        return threeTemp;
    }

    private Map<String, DynamicObject> dealBbx(DynamicObject threeTemp, String oldContent) {
        Set<String> oldBbxbs = this.paseCellBbx(oldContent);
        HashMap<String, Map<String, DynamicObject>> mappingMap = new HashMap<String, Map<String, DynamicObject>>();
        Map<String, String> bbxMap = this.getBbxOldNewMap(oldBbxbs, mappingMap);
        DynamicObjectCollection dbCells = QueryServiceHelper.query((String)TPO_REPORT_ITEM, (String)"id,number", (QFilter[])new QFilter("number", "in", bbxMap.values()).toArray());
        Map<String, DynamicObject> dbCellMap = dbCells.stream().collect(Collectors.toMap(a -> a.getString("number"), b -> b, (m, n) -> m));
        DynamicObjectCollection entryentity = threeTemp.getDynamicObjectCollection("entryentity");
        HashMap<String, DynamicObject> newReportItemBase = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<String, String> entry : bbxMap.entrySet()) {
            String newBbs = entry.getValue();
            DynamicObject item = entryentity.addNew();
            item.set("rowcol", (Object)newBbs);
            if (dbCellMap.containsKey(newBbs)) {
                item.set("reportitem", dbCellMap.get(newBbs).get("id"));
            } else {
                String[] split = newBbs.split("#");
                DynamicObject reportItemBase = this.createOneReportItem(split[0], split[1]);
                newReportItemBase.put(newBbs, reportItemBase);
                item.set("reportitem", reportItemBase.get("id"));
            }
            oldContent = oldContent.replace("${" + entry.getKey() + "}", "${" + newBbs + "}");
        }
        threeTemp.set("content_tag", (Object)oldContent);
        return newReportItemBase;
    }

    private Map<String, String> getBbxOldNewMap(Set<String> oldBbxbs, Map<String, Map<String, DynamicObject>> mappingMap) {
        HashMap<String, String> bbxMap = new HashMap<String, String>();
        for (String oldBbxb : oldBbxbs) {
            Map<String, DynamicObject> columnMap;
            Map<String, DynamicObject> rowMap;
            String[] split = oldBbxb.split("#");
            if (split.length != 3) continue;
            String table = split[0];
            String xh = split[1];
            String field = split[2];
            if (!mappingMap.containsKey(table + "_col")) {
                DynamicObject mapping = this.loadMember(table, "tpo_rowcol_mapping");
                if (mapping == null) {
                    throw new KDBizException(String.format("Error, No table [%s] mapping", table));
                }
                DynamicObjectCollection rowentity = mapping.getDynamicObjectCollection("rowentity");
                rowMap = rowentity.stream().collect(Collectors.toMap(a -> a.getString("row"), b -> b.getDynamicObject("rowmember"), (m, n) -> m));
                DynamicObjectCollection columnentity = mapping.getDynamicObjectCollection("columnentity");
                columnMap = columnentity.stream().collect(Collectors.toMap(a -> a.getString("column"), b -> b.getDynamicObject("columnmember"), (m, n) -> m));
                mappingMap.put(table + "_row", rowMap);
                mappingMap.put(table + "_col", columnMap);
            } else {
                rowMap = mappingMap.get(table + "_row");
                columnMap = mappingMap.get(table + "_col");
            }
            if (rowMap.containsKey(xh) && columnMap.containsKey(field)) {
                String newBbx = String.format("%s#%s", rowMap.get(xh).getString("number"), columnMap.get(field).getString("number"));
                bbxMap.put(oldBbxb, newBbx);
                continue;
            }
            throw new KDBizException(String.format("Table [%s] not contains row [%s] or column [%s] in mapping", table, xh, field));
        }
        return bbxMap;
    }

    private HashMap<String, DynamicObject> dealDyrow(DynamicObject oldTemp, DynamicObject threeTemp) {
        QFilter qf = new QFilter("template_id", "=", oldTemp.get("id")).and("enable", "=", (Object)"1");
        DynamicObjectCollection dyRows = QueryServiceHelper.query((String)"bdtaxr_template_dynrow", (String)" * ", (QFilter[])qf.toArray());
        Map<String, List<DynamicObject>> collect = dyRows.stream().collect(Collectors.groupingBy(a -> a.getString("template_id") + a.getString("dynrow_no")));
        QFilter qf1 = new QFilter("template_id", "=", oldTemp.get("id")).and("enable", "=", (Object)"1").and("modeltype", "=", (Object)"3");
        DynamicObjectCollection dyRows1 = QueryServiceHelper.query((String)"bdtaxr_template_dynrow", (String)" * ", (QFilter[])qf1.toArray());
        Map<String, List<DynamicObject>> exist = dyRows1.stream().collect(Collectors.groupingBy(a -> a.getString("template_id") + a.getString("dynrow_no")));
        HashMap<String, DynamicObject> dyRowMap = new HashMap<String, DynamicObject>(4);
        for (Map.Entry<String, List<DynamicObject>> entry : collect.entrySet()) {
            if (exist.containsKey(entry.getKey())) continue;
            DynamicObject dyRow = entry.getValue().get(0);
            DynamicObject newDyRow = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bdtaxr_template_dynrow"));
            newDyRow.set("template_id", threeTemp.get("id"));
            String[] split = dyRow.getString("dynrow_no").split("#");
            String dynrowNo = String.format("%s-%s#1", split[0], split[1]);
            newDyRow.set("dynrow_no", (Object)dynrowNo);
            newDyRow.set("enable", dyRow.get("enable"));
            newDyRow.set("rule_id", dyRow.get("rule_id"));
            newDyRow.set("modifier", (Object)RequestContext.get().getCurrUserId());
            newDyRow.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDyRow.set("createtime", (Object)new Date());
            newDyRow.set("modifytime", (Object)new Date());
            newDyRow.set("type", dyRow.get("type"));
            newDyRow.set("group_no", dyRow.get("group_no"));
            newDyRow.set("rule_name", dyRow.get("rule_name"));
            newDyRow.set("pluginpath", dyRow.get("pluginpath"));
            newDyRow.set("start_row", dyRow.get("start_row"));
            newDyRow.set("seq_no", dyRow.get("seq_no"));
            newDyRow.set("disablefrontop", dyRow.get("disablefrontop"));
            newDyRow.set("modeltype", (Object)"3");
            dyRowMap.put(dynrowNo, newDyRow);
        }
        return dyRowMap;
    }

    private DynamicObject createOneReportItem(String rowN, String colN) {
        DynamicObject row = this.loadMember(rowN, TPO_ROW_MEMBER);
        HashMap<String, DynamicObject> rowMap = new HashMap<String, DynamicObject>(4);
        rowMap.put(rowN, row);
        DynamicObject col = this.loadMember(colN, TPO_COL_MEMBER);
        HashMap<String, DynamicObject> colMap = new HashMap<String, DynamicObject>(4);
        colMap.put(colN, col);
        Map<String, DynamicObject> reportItemBase = this.createReportItemBase(rowMap, colMap);
        return reportItemBase.values().stream().findFirst().get();
    }

    private Set<String> paseCellBbx(String json) {
        Pattern r = Pattern.compile(bbx_Exp);
        Matcher m = r.matcher(json);
        HashSet<String> sets = new HashSet<String>(128);
        while (m.find()) {
            sets.add(m.group(1));
        }
        return sets;
    }

    protected String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    private Map<String, DynamicObject> createReportItemBase(Map<String, DynamicObject> row, Map<String, DynamicObject> col) {
        HashMap<String, DynamicObject> cellMap = new HashMap<String, DynamicObject>();
        for (DynamicObject rowMember : row.values()) {
            for (DynamicObject colMember : col.values()) {
                String number = String.format("%s#%s", rowMember.getString("number"), colMember.getString("number"));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TPO_REPORT_ITEM, (String)"id", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
                if (dynamicObject != null) {
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)TPO_REPORT_ITEM);
                } else {
                    dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TPO_REPORT_ITEM));
                    long id = DBUtils.getLongId((String)"t_tpo_report_item");
                    String name = String.format("%s#%s", rowMember.getString("name"), colMember.getString("name"));
                    String fullname = String.format("%s#%s", rowMember.getString("fullname"), colMember.getString("fullname"));
                    dynamicObject.set("id", (Object)id);
                    dynamicObject.set("masterid", (Object)id);
                    dynamicObject.set("model", (Object)DEFAULT_MODEL);
                    dynamicObject.set("number", (Object)number);
                    dynamicObject.set("name", (Object)name);
                    dynamicObject.set("status", (Object)STATUS);
                    dynamicObject.set("enable", (Object)"1");
                    dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                    dynamicObject.set("createtime", (Object)new Date());
                    dynamicObject.set("modifytime", (Object)new Date());
                    dynamicObject.set("row", rowMember.get("id"));
                    dynamicObject.set("col", colMember.get("id"));
                    dynamicObject.set("longname", (Object)fullname);
                }
                cellMap.put(number, dynamicObject);
            }
        }
        return cellMap;
    }

    public void updateRowCol(DynamicObject tempObj) {
        Set<String> tempMetadata = this.getTempMetadata(tempObj.getLong("id"));
        this.updateRowColByMeta(tempMetadata);
    }

    public void updateRowColByMeta(Set<String> tempMetadata) {
        for (String number : tempMetadata) {
            Boolean isExist = MetadataUtil.metaIsExist((String)number);
            if (isExist.booleanValue()) continue;
            this.runLogs.add(String.format("ERROR, The metadata %s is not exist!", number));
            return;
        }
        long l = System.currentTimeMillis();
        this.runLogs.clear();
        this.runLogs.add(String.format("Start update metadata number: %s", String.join((CharSequence)",", tempMetadata)));
        Map<String, Map<String, DynamicObject>> rowColNumberBase = this.createRowColUpdData(tempMetadata);
        this.saveAll(rowColNumberBase.get("row"), rowColNumberBase.get("col"), rowColNumberBase.get("mapping"), rowColNumberBase.get("reportItem"));
        this.runLogs.add(String.format("End update, cost:%s ms", System.currentTimeMillis() - l));
    }

    private void saveAll(Map<String, DynamicObject> row, Map<String, DynamicObject> col, Map<String, DynamicObject> mapping, Map<String, DynamicObject> reportItemBase) {
        try (TXHandle h = TX.required();){
            try {
                this.doSave(row.values().toArray(new DynamicObject[row.size()]));
                this.doSave(col.values().toArray(new DynamicObject[col.size()]));
                this.doSave(mapping.values().toArray(new DynamicObject[mapping.size()]));
                this.doSave(reportItemBase.values().toArray(new DynamicObject[reportItemBase.size()]));
            }
            catch (Throwable t) {
                h.markRollback();
                this.runLogs.add(String.format("Operate Error: %s \n", this.getStackTraceMessage(t)));
                LOGGER.info("OPERATE FAILURE:", (Object)t);
            }
        }
    }

    private Map<String, Map<String, DynamicObject>> createRowColUpdData(Set<String> tempMetadata) {
        HashMap<String, Map<String, DynamicObject>> resultMap = new HashMap<String, Map<String, DynamicObject>>();
        HashMap<String, DynamicObject> rowNumberMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> colNumberMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> mappingMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> reportItemMap = new HashMap<String, DynamicObject>();
        for (String metadataNum : tempMetadata) {
            DynamicObject mapping = QueryServiceHelper.queryOne((String)"tpo_rowcol_mapping", (String)"id", (QFilter[])new QFilter("number", "=", (Object)metadataNum).toArray());
            if (mapping != null) {
                mapping = BusinessDataServiceHelper.loadSingle((Object)mapping.get("id"), (String)"tpo_rowcol_mapping");
            } else {
                mapping = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_rowcol_mapping"));
                mapping.set("number", (Object)metadataNum);
                mapping.set("ispresit", (Object)this.isPreset);
                mapping.set("status", (Object)STATUS);
                mapping.set("enable", (Object)"1");
                mapping.set("creator", (Object)RequestContext.get().getCurrUserId());
                mapping.set("createtime", (Object)new Date());
                mapping.set("modifier", (Object)RequestContext.get().getCurrUserId());
                mapping.set("modifytime", (Object)new Date());
            }
            DynamicObjectCollection rowentity = mapping.getDynamicObjectCollection("rowentity");
            Set rowSet = rowentity.stream().map(a -> a.getString("row")).collect(Collectors.toSet());
            DynamicObjectCollection columnentity = mapping.getDynamicObjectCollection("columnentity");
            Set columnSet = columnentity.stream().map(a -> a.getString("column")).collect(Collectors.toSet());
            EntityInfo entityInfo = MetadataUtil.getEntityAllById2((String)metadataNum);
            String entityName = entityInfo.getEntityName();
            mapping.set("name", (Object)entityName);
            HashMap<String, DynamicObject> rowMap = new HashMap<String, DynamicObject>();
            HashMap<String, DynamicObject> colMap = new HashMap<String, DynamicObject>();
            if ("tcvat_nsrxx".equals(metadataNum)) {
                DynamicObject rowMember = this.loadMember("tpo_declare_main_tsc", TPO_ROW_MEMBER);
                DynamicObject parentCol = this.loadMember("gglw", TPO_COL_MEMBER);
                if (rowMember == null || parentCol == null) {
                    throw new KDBizException("no match row or col member:" + rowMember + "/" + parentCol + ",metadata number:" + metadataNum);
                }
                if (!rowSet.contains("1")) {
                    DynamicObject rowentityItem = rowentity.addNew();
                    rowentityItem.set("row", (Object)"1");
                    rowentityItem.set("rowname", (Object)rowMember.getString("name"));
                    rowentityItem.set("rowmember", rowMember.get("id"));
                    rowentityItem.set("isrpresit", (Object)this.isPreset);
                }
                rowMap.put("tpo_declare_main_tsc", rowMember);
                List fieldList = entityInfo.getFieldList();
                for (EntityField entityField : fieldList) {
                    if (JUMP_FIELD.contains(entityField.getFieldId()) || entityField.getFieldId().contains(".")) continue;
                    String number = entityField.getFieldId();
                    DynamicObject colMember = this.createColMember(number, entityField.getFieldName(), true, parentCol, entityField);
                    colNumberMap.putIfAbsent(number, colMember);
                    colMap.putIfAbsent(number, colMember);
                    if (columnSet.contains(entityField.getFieldId())) continue;
                    DynamicObject columnentityItem = columnentity.addNew();
                    columnentityItem.set("column", (Object)entityField.getFieldId());
                    columnentityItem.set("columnname", (Object)entityField.getFieldName());
                    columnentityItem.set("columnmember", colMember.get("id"));
                    columnentityItem.set("iscpresit", (Object)this.isPreset);
                }
            } else {
                String[] split = metadataNum.split("_");
                String parentNumber = this.getParentNumber(split[0], metadataNum);
                if (StringUtil.isEmpty((CharSequence)parentNumber)) {
                    throw new KDBizException("no match row or col member:" + split[0] + ",metadata number:" + metadataNum);
                }
                DynamicObject grandfatherRow = QueryServiceHelper.queryOne((String)TPO_ROW_MEMBER, (String)" * ", (QFilter[])new QFilter("number", "=", (Object)parentNumber).toArray());
                DynamicObject grandfatherCol = QueryServiceHelper.queryOne((String)TPO_COL_MEMBER, (String)" * ", (QFilter[])new QFilter("number", "=", (Object)parentNumber).toArray());
                if (grandfatherCol == null || grandfatherRow == null) {
                    throw new KDBizException("no match row or col member:" + parentNumber + ",metadata number:" + metadataNum);
                }
                DynamicObject parentRow = this.createRowMember(metadataNum, entityName, false, grandfatherRow, null);
                DynamicObject parentCol = this.createColMember(metadataNum, entityName, false, grandfatherCol, null);
                rowNumberMap.putIfAbsent(metadataNum, parentRow);
                colNumberMap.putIfAbsent(metadataNum, parentCol);
                List fieldList = entityInfo.getFieldList();
                for (EntityField entityField : fieldList) {
                    if ("ewblxh".equals(entityField.getFieldId())) {
                        List comboItems = entityField.getComboItems();
                        for (ValueMapItem comboItem : comboItems) {
                            String number = String.format(FORMAT1, metadataNum, comboItem.getValue());
                            DynamicObject rowMember = this.createRowMember(number, comboItem.getName().getLocaleValue(), true, parentRow, entityField);
                            rowNumberMap.putIfAbsent(number, rowMember);
                            rowMap.putIfAbsent(number, rowMember);
                            if (rowSet.contains(comboItem.getValue())) continue;
                            DynamicObject rowentityItem = rowentity.addNew();
                            rowentityItem.set("row", (Object)comboItem.getValue());
                            rowentityItem.set("rowname", (Object)comboItem.getName().toString());
                            rowentityItem.set("rowmember", rowMember.get("id"));
                            rowentityItem.set("isrpresit", (Object)this.isPreset);
                        }
                        continue;
                    }
                    if (JUMP_FIELD.contains(entityField.getFieldId()) || entityField.getFieldId().contains(".")) continue;
                    String number = String.format(FORMAT1, metadataNum, entityField.getFieldId());
                    DynamicObject colMember = this.createColMember(number, entityField.getFieldName(), true, parentCol, entityField);
                    colNumberMap.putIfAbsent(number, colMember);
                    colMap.putIfAbsent(number, colMember);
                    if (columnSet.contains(entityField.getFieldId())) continue;
                    DynamicObject columnentityItem = columnentity.addNew();
                    columnentityItem.set("column", (Object)entityField.getFieldId());
                    columnentityItem.set("columnname", (Object)entityField.getFieldName());
                    columnentityItem.set("columnmember", colMember.get("id"));
                    columnentityItem.set("iscpresit", (Object)this.isPreset);
                }
            }
            Map<String, DynamicObject> reportItemBase = this.createReportItemBase(rowMap, colMap);
            reportItemMap.putAll(reportItemBase);
            mappingMap.putIfAbsent(metadataNum, mapping);
        }
        resultMap.put("row", rowNumberMap);
        resultMap.put("col", colNumberMap);
        resultMap.put("mapping", mappingMap);
        resultMap.put("reportItem", reportItemMap);
        return resultMap;
    }

    private String getParentNumber(String key, String metadataNum) {
        if ("tcvat_nsrxx".equals(metadataNum)) {
            return "pubmem";
        }
        return grandfatherNumberAppMap.get(key);
    }

    private DynamicObject createColMember(String number, String name, boolean isLeaf, DynamicObject parent, EntityField entityField) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TPO_COL_MEMBER, (String)"id", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (dynamicObject != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)TPO_COL_MEMBER);
        } else {
            dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TPO_COL_MEMBER));
            long id = DBUtils.getLongId((String)T_TPO_COL_MEMBER);
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("masterid", (Object)id);
            dynamicObject.set("model", (Object)DEFAULT_MODEL);
            dynamicObject.set("dimension", (Object)COLID);
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("name", (Object)name);
            dynamicObject.set("status", (Object)STATUS);
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("syspreset", (Object)this.isPreset);
            dynamicObject.set("parent", parent.get("id"));
            dynamicObject.set("level", (Object)(parent.getInt("level") + 1));
            dynamicObject.set("longnumber", (Object)(parent.getString("longnumber") + "." + number));
            dynamicObject.set("fullname", (Object)(parent.getString("name") + "." + name));
            dynamicObject.set("isleaf", (Object)isLeaf);
            dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)new Date());
            if (isLeaf) {
                dynamicObject.set("name", (Object)(entityField.getEntityName() + "-" + name));
                String datatype = "decimal";
                String fieldType = entityField.getFieldType();
                if (dateTypes.contains(fieldType)) {
                    datatype = "date";
                } else if (intTypes.contains(fieldType)) {
                    datatype = "integer";
                } else if (textTypes.contains(fieldType)) {
                    datatype = "string";
                } else if (decimalTypes.contains(fieldType)) {
                    datatype = "decimal";
                }
                dynamicObject.set("datatype", (Object)datatype);
                if (datatype.equals("date")) {
                    if (StringUtil.isBlank((CharSequence)entityField.getFormatStr())) {
                        dynamicObject.set("format", (Object)"yyyy-MM-dd");
                    } else {
                        dynamicObject.set("format", (Object)entityField.getFormatStr());
                    }
                } else if (datatype.equals("decimal") && entityField.getScale() > 0) {
                    int scale = entityField.getScale();
                    StringBuilder formatStr = new StringBuilder("#0.");
                    for (int i = 0; i < scale; ++i) {
                        formatStr.append("0");
                    }
                    dynamicObject.set("format", (Object)formatStr.toString());
                }
                dynamicObject.set("minlength", (Object)entityField.getMinLength());
                dynamicObject.set("maxlength", (Object)entityField.getMaxLength());
            }
        }
        return dynamicObject;
    }

    private DynamicObject loadMember(String number, String entity) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (dynamicObject != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)entity);
            return dynamicObject;
        }
        return null;
    }

    private DynamicObject createRowMember(String number, String name, boolean isLeaf, DynamicObject parent, EntityField entityField) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TPO_ROW_MEMBER, (String)"id", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (dynamicObject != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)TPO_ROW_MEMBER);
        } else {
            dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TPO_ROW_MEMBER));
            long id = DBUtils.getLongId((String)T_TPO_ROW_MEMBER);
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("masterid", (Object)id);
            dynamicObject.set("model", (Object)DEFAULT_MODEL);
            dynamicObject.set("dimension", (Object)ROWID);
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("name", (Object)(isLeaf ? entityField.getEntityName() + "-" + name : name));
            dynamicObject.set("status", (Object)STATUS);
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("syspreset", (Object)this.isPreset);
            dynamicObject.set("parent", parent.get("id"));
            dynamicObject.set("level", (Object)(parent.getInt("level") + 1));
            dynamicObject.set("longnumber", (Object)(parent.getString("longnumber") + "." + number));
            dynamicObject.set("fullname", (Object)(parent.getString("name") + "." + name));
            dynamicObject.set("isleaf", (Object)isLeaf);
            dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)new Date());
        }
        return dynamicObject;
    }

    private Set<String> getTempMetadata(long templateId) {
        Map metadata = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)templateId);
        return new HashSet<String>(metadata.values());
    }

    static {
        grandfatherNumberAppMap.put("tcvat", "zzs");
        grandfatherNumberAppMap.put("tccit", "qysds");
        grandfatherNumberAppMap.put("totf", "totf");
        grandfatherNumberAppMap.put("tcret", "ccxws");
        grandfatherNumberAppMap.put("tcvvt", "tcvvt");
        grandfatherNumberAppMap.put("tcetr", "tcetr");
        grandfatherNumberAppMap.put("tcnfep", "tcnfep");
        grandfatherNumberAppMap.put("tctb", "pubmem");
        grandfatherNumberAppMap.put("bdtaxr", "pubmem");
        grandfatherNumberAppMap.put("tpo", "pubmem");
    }
}

