/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.billconfigs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.vo.BillTaxFilterVo;

public class BillConfigsEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String BILL_ENTITY = "billentity";
    private static final String BILL_FIELD = "billfield";
    private static final String BILL_FIELD_NUMBER = "billfieldnumber";
    private static final String WHERE_FIELD = "wherefield";
    private static final String OLD_FIELDS = "oldFields";
    private static final String BDTAXR_BILLTAX_CONFIGS = "bdtaxr_billtax_configs";

    public void registerListener(EventObject e) {
        MulBasedataEdit basedataEdit = (MulBasedataEdit)this.getControl(WHERE_FIELD);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit bill = (BasedataEdit)this.getControl(BILL_ENTITY);
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (WHERE_FIELD.equals(evt.getProperty().getName())) {
            DynamicObject billObject = (DynamicObject)this.getModel().getValue(BILL_ENTITY);
            if (billObject != null) {
                String billNumber = billObject.getString("number");
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5", (String)"BillConfigsEditPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                formShowParameter.setCustomParam("billNumber", (Object)billNumber);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u7528\u5355\u636e\u3002", (String)"BillConfigsEditPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (BILL_ENTITY.equals(evt.getProperty().getName())) {
            ListShowParameter collection = BusinessDataServiceHelper.load((String)"bastax_bill_interface", (String)"bill", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            ArrayList<String> billNumbers = new ArrayList<String>(16);
            for (DynamicObject dyo : collection) {
                billNumbers.add(String.valueOf(dyo.getDynamicObject("bill").get("number")));
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", billNumbers));
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ListSelectedRowCollection listSelectedRows = evt.getListSelectedRowCollection();
        if (!CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            ArrayList numberList = new ArrayList(listSelectedRows.size());
            ArrayList nameList = new ArrayList(listSelectedRows.size());
            listSelectedRows.forEach(row -> {
                numberList.add(row.getNumber());
                nameList.add(row.getName());
            });
            this.getModel().setValue(BILL_FIELD_NUMBER, (Object)StringUtils.join((Object[])numberList.toArray(), (String)","));
            this.getModel().setValue(BILL_FIELD, (Object)StringUtils.join((Object[])nameList.toArray(), (String)","));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save && OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            Map oldFieldMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(OLD_FIELDS), Map.class);
            Map<String, String> newFieldMap = this.getFieldMap();
            DynamicObject billObject = (DynamicObject)this.getModel().getValue(BILL_ENTITY);
            ArrayList names = new ArrayList();
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BDTAXR_BILLTAX_CONFIGS, (String)"id,callconditionjson", (QFilter[])new QFilter[]{new QFilter("callbill", "=", (Object)billObject.getString("number"))});
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                String conditionjson = ((DynamicObject)dynamicObjects.get(i)).getString("callconditionjson");
                if (conditionjson == null || !conditionjson.contains("fieldNumber")) continue;
                List dtos = JsonUtil.fromJsonList((String)conditionjson, BillTaxFilterVo.class);
                dtos.forEach(row -> {
                    String fieldName = row.getFieldNumber();
                    String field = (String)oldFieldMap.get(fieldName);
                    if (StringUtils.isNotBlank((CharSequence)field) && !newFieldMap.containsKey(fieldName)) {
                        names.add(field);
                    }
                });
            }
            if (names.size() > 0) {
                String msg = names.stream().distinct().collect(Collectors.joining("\u3001"));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"BillConfigsEditPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), msg));
                args.setCancel(true);
                return;
            }
        }
    }

    private Map<String, String> getFieldMap() {
        DynamicObjectCollection fieldObjects = (DynamicObjectCollection)this.getModel().getValue(WHERE_FIELD);
        if (((DynamicObject)fieldObjects.get(0)).get("fbasedataid") != null) {
            return fieldObjects.stream().collect(Collectors.toMap(k -> k.getDynamicObject("fbasedataid").getString("number"), v -> v.getDynamicObject("fbasedataid").getString("name")));
        }
        return new HashMap<String, String>();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection newValue;
        if (WHERE_FIELD.equals(e.getProperty().getName()) && (newValue = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue()).size() == 0) {
            this.getModel().setValue(BILL_FIELD_NUMBER, null);
            this.getModel().setValue(BILL_FIELD, null);
        }
    }

    public void afterBindData(EventObject e) {
        BaseView baseView = (BaseView)e.getSource();
        if (OperationStatus.EDIT.equals((Object)baseView.getFormShowParameter().getStatus())) {
            DynamicObject billObject = (DynamicObject)this.getModel().getValue(BILL_ENTITY);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)BDTAXR_BILLTAX_CONFIGS, (String)"id", (QFilter[])new QFilter[]{new QFilter("callbill", "=", (Object)billObject.getString("number"))});
            if (dynamicObject != null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BILL_ENTITY});
            }
            this.getPageCache().put(OLD_FIELDS, SerializationUtils.toJsonString(this.getFieldMap()));
        } else {
            this.getPageCache().remove(OLD_FIELDS);
        }
    }
}

