/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.billconfigs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class BillConfigsListPlugin
extends AbstractListPlugin {
    private static final String BDTAXR_BILLTAX_CONFIGS = "bdtaxr_billtax_configs";
    private static final String BDTAXR_BILL_CONFIGS = "bdtaxr_bill_configs";
    private static final String BILL_LISTAP = "billlistap";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete && (selectedRows = ((Delete)args.getSource()).getListSelectedData()).size() > 0) {
            this.doSelectedRows(selectedRows);
            args.setCancel(true);
            return;
        }
    }

    private void doSelectedRows(ListSelectedRowCollection selectedRows) {
        ArrayList names = new ArrayList();
        Map<String, Object> rowMap = selectedRows.stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v.getPrimaryKeyValue()));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BDTAXR_BILLTAX_CONFIGS, (String)"id,callbill.name,callbill", (QFilter[])new QFilter[]{new QFilter("callbill", "in", rowMap.keySet())});
        dynamicObjects.forEach(dynamicObject -> {
            if (rowMap.containsKey(String.valueOf(dynamicObject.get("callbill")))) {
                names.add(String.valueOf(dynamicObject.get("callbill.name")));
                rowMap.remove(String.valueOf(dynamicObject.get("callbill")));
            }
        });
        this.deleteSelectedRows(new ArrayList<Object>(rowMap.values()));
        if (names.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"BillConfigsListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), String.join((CharSequence)"\u3001", names)));
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BillConfigsListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }

    private void deleteSelectedRows(List<Object> ids) {
        if (ids.size() > 0) {
            QFilter filter = new QFilter("id", "in", ids);
            DeleteServiceHelper.delete((String)BDTAXR_BILL_CONFIGS, (QFilter[])new QFilter[]{filter});
            BillList billlist = (BillList)this.getControl(BILL_LISTAP);
            billlist.clearSelection();
            billlist.refreshData();
        }
    }
}

