/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.billtaxconfigs;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;

public class BillTaxConfigsDataUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(BillTaxConfigsDataUpgradePlugin.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        Boolean isExist = this.metaIsExist("bdtaxr_billtax_configs");
        if (!isExist.booleanValue()) {
            this.addLog(ERROR, String.format("The %s is not exist!", "bdtaxr_billtax_configs"));
            return;
        }
        DynamicObject[] billtaxs = BusinessDataServiceHelper.load((String)"bdtaxr_billtax_configs", (String)"id,country,taxtation", (QFilter[])new QFilter[]{new QFilter("taxtation", "=", (Object)0).and("taxtype", "=", (Object)0)});
        this.addLog(INFO, ResManager.loadKDString((String)"\u5171\u5347\u7ea7\u6570\u636e\uff1a%s", (String)"BillTaxConfigsDataUpgradePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[]{billtaxs.length}));
        int i = 0;
        for (DynamicObject billtax : billtaxs) {
            long cid = ((DynamicObject)billtax.get("country")).getLong("id");
            DynamicObject[] taxs = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("countryid", "=", (Object)cid)});
            if (taxs == null || taxs.length != 1) continue;
            billtax.set("taxtation", (Object)taxs[0].getLong("id"));
            this.addLog(INFO, ResManager.loadKDString((String)"\u7b2c%s\u6761", (String)"BillTaxConfigsDataUpgradePlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[]{++i}));
            this.addLog(INFO, ResManager.loadKDString((String)"\u7f16\u7801:%s", (String)"BillTaxConfigsDataUpgradePlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[]{billtax.getString("number")}));
        }
        SaveServiceHelper.save((DynamicObject[])billtaxs);
    }
}

