/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.billtaxconfigs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BillTaxFilterVo;
import org.apache.commons.lang3.ObjectUtils;

public class BillTaxConfigsOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (StringUtil.equalsIgnoreCase((CharSequence)e.getOperationKey(), (CharSequence)"save")) {
            List list;
            DynamicObject object = e.getDataEntities()[0];
            String callBillNumber = object.getString("callbill.number");
            String callconditionJson = object.getString("callconditionjson");
            HashSet currentFields = new HashSet();
            QFilter idQ = new QFilter("id", "!=", object.get("id"));
            QFilter billQ = new QFilter("callbill", "=", (Object)callBillNumber);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_billtax_configs", (String)"callbill,callconditionjson", (QFilter[])new QFilter[]{idQ, billQ});
            Map<String, Set<String>> allFieldsMap = this.getCallBillConfigFields(collection);
            if (StringUtil.isNotEmpty((CharSequence)callconditionJson) && null != (list = JsonUtil.fromJsonList((String)callconditionJson, BillTaxFilterVo.class))) {
                currentFields.addAll(list.stream().map(o -> o.getFieldNumber()).collect(Collectors.toSet()));
            }
            currentFields.addAll(null == allFieldsMap.get(callBillNumber) ? new HashSet() : (Collection)allFieldsMap.get(callBillNumber));
            allFieldsMap.put(callBillNumber, currentFields);
            this.updateCallBill(allFieldsMap);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)e.getOperationKey(), (CharSequence)"delete")) {
            DynamicObject[] dataEntities = e.getDataEntities();
            List ids = Arrays.stream(dataEntities).map(o -> o.get("id")).collect(Collectors.toList());
            QFilter idInQ = new QFilter("id", "in", ids);
            QFilter idNotInQ = new QFilter("id", "not in", ids);
            DynamicObjectCollection selectCollection = QueryServiceHelper.query((String)"bdtaxr_billtax_configs", (String)"callbill,callconditionjson", (QFilter[])new QFilter[]{idInQ});
            Set callBills = selectCollection.stream().map(o -> o.get("callbill")).collect(Collectors.toSet());
            Map<String, Set<String>> selectMap = this.getCallBillConfigFields(selectCollection);
            QFilter callBillQ = new QFilter("callbill", "in", callBills);
            DynamicObjectCollection noSelectCollection = QueryServiceHelper.query((String)"bdtaxr_billtax_configs", (String)"callbill,callconditionjson", (QFilter[])new QFilter[]{idNotInQ, callBillQ});
            Map<String, Set<String>> noSelectMap = this.getCallBillConfigFields(noSelectCollection);
            HashMap<String, Set<String>> lastFieldMap = new HashMap<String, Set<String>>(16);
            for (Map.Entry<String, Set<String>> entry : noSelectMap.entrySet()) {
                Set<String> noSelField = entry.getValue();
                Set<String> selSelField = selectMap.get(entry.getKey());
                HashSet set = new HashSet(entry.getValue());
                if (null != selSelField && noSelField.containsAll(selSelField)) {
                    set.removeAll(selSelField);
                }
                lastFieldMap.put(entry.getKey(), set);
            }
            this.updateCallBill(lastFieldMap);
            Set<String> selectKey = selectMap.keySet();
            Set<String> noSelectKey = noSelectMap.keySet();
            selectKey.removeAll(noSelectKey);
            if (!selectKey.isEmpty()) {
                HashSet<String> set = new HashSet<String>(selectKey);
                QFilter idQ = new QFilter("billentity", "in", set);
                DeleteServiceHelper.delete((String)"bdtaxr_bill_configs", (QFilter[])new QFilter[]{idQ});
            }
        }
    }

    private void updateCallBill(Map<String, Set<String>> map) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String callBillId = entry.getKey();
            Set<String> currentFields = entry.getValue();
            QFilter billEntityQ = new QFilter("billentity", "=", (Object)callBillId);
            QFilter[] qFilters = new QFilter[]{billEntityQ};
            DynamicObject callBillObject = BusinessDataServiceHelper.loadSingle((String)"bdtaxr_bill_configs", (String)"id,number,name,status,enable,billfield,billfieldnumber,billentity,wherefield,creator,createtime,modifier,modifytime,", (QFilter[])qFilters);
            QFilter numberQ = new QFilter("number", "in", currentFields);
            QFilter billQ = new QFilter("billnumber", "=", (Object)callBillId);
            DynamicObject[] fieldObjects = BusinessDataServiceHelper.load((String)"bdtaxr_where_fields", (String)"id,name,number", (QFilter[])new QFilter[]{numberQ, billQ});
            String billfield = Arrays.stream(fieldObjects).map(o -> o.getString("name")).collect(Collectors.joining(","));
            String billfieldnumber = Arrays.stream(fieldObjects).map(o -> o.getString("number")).collect(Collectors.joining(","));
            List<Object> whereIds = Arrays.stream(fieldObjects).map(o -> o.get("id")).collect(Collectors.toList());
            if (ObjectUtils.isEmpty(currentFields)) {
                if (null == callBillObject) continue;
                DeleteServiceHelper.delete((String)"bdtaxr_bill_configs", (QFilter[])qFilters);
                continue;
            }
            if (null == callBillObject) {
                callBillObject = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_bill_configs");
                callBillObject.set("number", (Object)callBillId);
                callBillObject.set("status", (Object)"C");
                callBillObject.set("enable", (Object)"1");
                callBillObject.set("billfield", (Object)billfield);
                callBillObject.set("billfieldnumber", (Object)billfieldnumber);
                callBillObject.set("billentity", (Object)callBillId);
                this.setMulBasedatafieldValue(callBillObject, whereIds);
                callBillObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                callBillObject.set("createtime", (Object)new Date());
                callBillObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                callBillObject.set("modifytime", (Object)new Date());
            } else {
                callBillObject.set("billfield", (Object)billfield);
                callBillObject.set("billfieldnumber", (Object)billfieldnumber);
                this.setMulBasedatafieldValue(callBillObject, whereIds);
                callBillObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                callBillObject.set("modifytime", (Object)new Date());
            }
            list.add(callBillObject);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
    }

    private Map<String, Set<String>> getCallBillConfigFields(DynamicObjectCollection collection) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        collection.stream().forEach(object -> {
            HashSet set = new HashSet();
            String callbill = object.getString("callbill");
            String callconditionJson = object.getString("callconditionjson");
            List list = JsonUtil.fromJsonList((String)callconditionJson, BillTaxFilterVo.class);
            if (null != list) {
                set.addAll(list.stream().map(o -> o.getFieldNumber()).collect(Collectors.toSet()));
            }
            if (null != map.get(callbill)) {
                set.addAll((Collection)map.get(callbill));
            }
            map.put(callbill, set);
        });
        return map;
    }

    private void setMulBasedatafieldValue(DynamicObject callBillObject, List<Object> whereIds) {
        DynamicObjectCollection rows = callBillObject.getDynamicObjectCollection("wherefield");
        rows.removeAll((Collection)rows);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"bdtaxr_bill_configs");
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty("wherefield");
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        whereIds.stream().forEach(o -> {
            DynamicObject newBasedataObj = BusinessDataServiceHelper.loadSingleFromCache((Object)o, (DynamicObjectType)basedataProp.getDynamicComplexPropertyType());
            DynamicObject newRow = new DynamicObject(subEntityType);
            rows.add((Object)newRow);
            basedataProp.setValue((Object)newRow, (Object)newBasedataObj);
        });
    }
}

