/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.pay.DeclarePayHelper;
import kd.taxc.bdtaxr.common.enums.CalendarTaxType;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;
import kd.taxc.bdtaxr.common.util.calender.CalenderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeferPayDialogPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(DeferPayDialogPlugin.class);
    private static List<String> singleItem = Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg", "fjsf", "qysdsjb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_jb", "qysds_hdzs_nb", "yhs", "fcs", "cztdsys", "fcscztdsys", "fcsprice", "fcshire", "tvpt", "tcvvt", "tcept", "yys", "tcrt", "zzsyjskb");
    public static final List<String> TCRET_TAXTYPE = Arrays.asList(CalendarTaxType.YHS.getType(), CalendarTaxType.FCS.getType(), CalendarTaxType.CZTDSYS.getType(), CalendarTaxType.HBS.getType(), CalendarTaxType.ZYS.getType(), CalendarTaxType.CCS.getType(), CalendarTaxType.QS.getType(), CalendarTaxType.GDZYS.getType(), CalendarTaxType.TDZZS.getType(), CalendarTaxType.YYS.getType());

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setShowTitle(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection query;
        List filterIds;
        FormShowParameter param = this.getView().getFormShowParameter();
        this.getModel().clearNoDataRow();
        String appId = param.getAppId();
        List sbbIds = (List)param.getCustomParam("sbbIds");
        List sbbEntryIds = (List)param.getCustomParam("sbbEntryIds");
        List<Object> jsonList = null;
        if (sbbEntryIds != null && "tcvat".equals(appId)) {
            filterIds = sbbEntryIds.stream().filter(id -> {
                QFilter applyFilter = new QFilter("entryentity.deferpayapply1", "=", (Object)Boolean.FALSE);
                return QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", id), applyFilter});
            }).collect(Collectors.toList());
            query = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,org,skssqq,skssqz,type,taxlimit,bqybtse,entryentity.id as entryid,entryentity.taxtypes as taxtypes,entryentity.bqdybtse as bqdybtse,entryentity.deferpayapply1 as deferpayapply", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", filterIds)}, (String)"org,skssqq,entryentity.taxtypes");
            jsonList = new ArrayList(query.size());
            for (DynamicObject d2 : query) {
                String string = d2.getString("type");
                String taxtypes = d2.getString("taxtypes");
                String taxType = TaxTypeUtils.getTaxType((String)string, (String)taxtypes);
                if (CalendarTaxType.FJSF.getType().equals(taxType)) {
                    boolean deferpayapply = d2.getBoolean("deferpayapply");
                    for (String taxtype : TaxTypeUtils.FJSF_SPLIT) {
                        BigDecimal ybtse;
                        boolean exists;
                        long entryid = d2.getLong("entryid");
                        if (deferpayapply && (exists = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{new QFilter("sbbentryid", "=", (Object)entryid), new QFilter("taxtype", "=", (Object)taxtype), new QFilter("hjsqid", ">", (Object)0)})) || BigDecimal.ZERO.compareTo(ybtse = DeclarePayHelper.queryFjsfSubAmt(d2.getString("id"), taxtype, string)) >= 0) continue;
                        jsonList.add(DeclarePayHelper.packDeferApplyShowData(d2, ybtse, entryid, taxtype));
                    }
                    continue;
                }
                BigDecimal bqdybtse = d2.getBigDecimal("bqdybtse");
                if (BigDecimal.ZERO.compareTo(bqdybtse) >= 0) continue;
                jsonList.add(DeclarePayHelper.packDeferApplyShowData(d2, bqdybtse, d2.getLong("entryid"), taxType));
            }
        } else if (sbbIds != null) {
            filterIds = sbbIds.stream().filter(id -> QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{new QFilter("id", "=", id), new QFilter("deferpayapply", "=", (Object)Boolean.FALSE)})).collect(Collectors.toList());
            query = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,org,skssqq,skssqz,type,taxlimit,bqybtse", (QFilter[])new QFilter[]{new QFilter("id", "in", filterIds)}, (String)"skssqq");
            jsonList = query.stream().map(d -> DeclarePayHelper.packDeferApplyShowData(d, d.getBigDecimal("bqybtse"), 0L, TaxTypeUtils.getTaxType((String)d.getString("type"), null))).collect(Collectors.toList());
        }
        if (jsonList != null && jsonList.size() > 0) {
            ArrayList<DynamicObject> data = new ArrayList<DynamicObject>(jsonList.size());
            DynamicObjectType dot = this.getModel().getEntryEntity("entryentity").getDynamicObjectType();
            for (JSONObject jSONObject : jsonList) {
                DynamicObject d3 = new DynamicObject(dot);
                d3.set("sbbid", jSONObject.get((Object)"sbbid"));
                d3.set("sbbentryid", jSONObject.get((Object)"sbbentryid"));
                d3.set("org", jSONObject.get((Object)"org"));
                d3.set("taxperiod", jSONObject.get((Object)"taxperiod"));
                d3.set("taxtype", jSONObject.get((Object)"taxtype"));
                d3.set("type", jSONObject.get((Object)"type"));
                d3.set("taxlimit", jSONObject.get((Object)"taxlimit"));
                d3.set("ybtse", jSONObject.get((Object)"ybtse"));
                data.add(d3);
            }
            this.updateEntryEntity(data, "org");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject[] updateDatas;
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount("entryentity");
            if (count == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u62a5\u8868", (String)"DeferPayDialogPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
            String syhjzc = (String)model.getValue("syhjzc");
            BigDecimal yhjkbl = (BigDecimal)model.getValue("yhjkbl");
            Date yhjkqx = (Date)model.getValue("yhjkqx");
            BigDecimal dqjkbl = (BigDecimal)model.getValue("dqjkbl");
            Date dqjkqx = (Date)model.getValue("dqjkqx");
            if (dqjkqx.compareTo(yhjkqx) >= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ef6\u7f13\u7f34\u6b3e\u671f\u9650\u9700\u665a\u4e8e\u5f53\u671f\u7f34\u6b3e\u671f\u9650\uff0c\u8bf7\u4fee\u6539", (String)"DeferPayDialogPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            CopyOnWriteArrayList locks = new CopyOnWriteArrayList();
            String appId = this.getView().getFormShowParameter().getAppId();
            if ("tcvat".equals(appId)) {
                Object[] sbbentryid = entryentity.stream().filter(s -> this.tryLock(locks, s.get("sbbentryid"))).map(e -> e.get("sbbentryid")).toArray();
                updateDatas = BusinessDataServiceHelper.load((Object[])sbbentryid, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_declare_entry"));
            } else {
                Object[] sbbids = entryentity.stream().filter(s -> this.tryLock(locks, s.get("sbbid"))).map(e -> e.get("sbbid")).toArray();
                updateDatas = BusinessDataServiceHelper.load((Object[])sbbids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
            }
            try {
                Boolean exists = this.isExistsData(entryentity);
                if (exists.booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", (String)"DeferPayDialogPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject updateData : updateDatas) {
                    updateData.set("deferpayapply", (Object)Boolean.TRUE);
                    updateData.set("sjje", (Object)BigDecimal.ZERO);
                    if ("tcvat".equals(appId)) {
                        updateData.set("qjje", updateData.get("bqdybtse"));
                        continue;
                    }
                    updateData.set("qjje", updateData.get("bqybtse"));
                }
                try (TXHandle h = TX.requiresNew();){
                    try {
                        this.save(entryentity, syhjzc, yhjkbl, yhjkqx, dqjkbl, dqjkqx);
                        SaveServiceHelper.update((DynamicObject[])updateDatas);
                        this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DeferPayDialogPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        this.getView().close();
                    }
                    catch (Exception e2) {
                        h.markRollback();
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"DeferPayDialogPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        logger.error("taxc-DeferPayRptPlugin save fail:", (Object)e2.getMessage());
                    }
                }
            }
            finally {
                locks.forEach(lock -> Optional.ofNullable(lock).ifPresent(r -> r.unlock()));
            }
        }
    }

    private Boolean isExistsData(DynamicObjectCollection entryentity) {
        return entryentity.stream().anyMatch(object -> {
            Date skssqz;
            Date skssqq;
            Long orgId = object.getDynamicObject("org").getLong("id");
            String taxtype = object.getString("taxtype");
            Object sbbid = object.get("sbbid");
            Object sbbentryid = object.get("sbbentryid");
            DynamicObject nsrxx = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
            if (TCRET_TAXTYPE.contains(taxtype) && Long.parseLong(sbbentryid.toString()) != 0L) {
                DynamicObject tcretZbObj = BusinessDataServiceHelper.loadSingle((Object)sbbentryid, (String)"tcret_ccxws_zb_hb");
                skssqq = tcretZbObj.getDate("startdate");
                skssqz = tcretZbObj.getDate("enddate");
            } else {
                skssqq = nsrxx.getDate("skssqq");
                skssqz = nsrxx.getDate("skssqz");
            }
            QFilter q1 = new QFilter("org", "=", (Object)orgId);
            QFilter q2 = new QFilter("skssqq", "=", (Object)skssqq);
            QFilter q3 = new QFilter("skssqz", "=", (Object)skssqz);
            QFilter q4 = new QFilter("taxtype", "=", (Object)taxtype);
            QFilter q5 = new QFilter("sbbno", "=", (Object)nsrxx.getString("billno"));
            QFilter q6 = new QFilter("operatetime", "is not null", null);
            return QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6});
        });
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("choose".equals(itemKey)) {
            FormShowParameter parameter = new FormShowParameter();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            FormShowParameter param = this.getView().getFormShowParameter();
            String appId = param.getAppId();
            parameter.setCustomParam("sbbIds", param.getCustomParam("sbbIds"));
            parameter.setCustomParam("sbbEntryIds", param.getCustomParam("sbbEntryIds"));
            parameter.setCustomParam("allSbbIds", param.getCustomParam("sbbIds"));
            parameter.setCustomParam("allSbbEntryIds", param.getCustomParam("sbbEntryIds"));
            if ("tcvat".equals(appId)) {
                parameter.setCustomParam("sbbEntryIds", entryentity.stream().map(e -> e.getLong("sbbentryid")).collect(Collectors.toList()));
            } else {
                parameter.setCustomParam("sbbIds", entryentity.stream().map(e -> e.getLong("sbbid")).collect(Collectors.toList()));
            }
            parameter.setFormId("bdtaxr_select_sbb_dialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectSbb");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        List data;
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if ("selectSbb".equals(actionId) && (data = (List)returnData) != null) {
            this.updateEntryEntity(data, "org.id");
        }
    }

    private void save(DynamicObjectCollection entryentity, String syhjzc, BigDecimal yhjkbl, Date yhjkqx, BigDecimal dqjkbl, Date dqjkqx) {
        for (DynamicObject data : entryentity) {
            Date skssqz;
            Date skssqq;
            DynamicObject org = data.getDynamicObject("org");
            BigDecimal ybtse = data.getBigDecimal("ybtse");
            String taxtype = data.getString("taxtype");
            Object sbbid = data.get("sbbid");
            Object sbbentryid = data.get("sbbentryid");
            DynamicObject nsrxx = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
            if (TCRET_TAXTYPE.contains(taxtype) && Long.parseLong(sbbentryid.toString()) != 0L) {
                DynamicObject tcretZbObj = BusinessDataServiceHelper.loadSingle((Object)sbbentryid, (String)"tcret_ccxws_zb_hb");
                skssqq = tcretZbObj.getDate("startdate");
                skssqz = tcretZbObj.getDate("enddate");
            } else {
                skssqq = nsrxx.getDate("skssqq");
                skssqz = nsrxx.getDate("skssqz");
            }
            Long accountOrg = this.doSetAccountOrg(org.getLong("id"), skssqq, skssqz);
            String taxperiodStr = DateUtils.getStartToEndDate((Date)skssqq, (Date)skssqz, (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            DynamicObject dobj = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByUnifiedsocialCode((String)nsrxx.getString("nsrsbh")).getData();
            String appId = this.getView().getFormShowParameter().getAppId();
            if ("tcvat".equals(appId)) {
                QFilter sbbentryidFilter = new QFilter("sbbentryid", "=", sbbentryid);
                QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)taxtype);
                if (TaxTypeUtils.FJSF_SPLIT.contains(taxtype)) {
                    taxtypeFilter = taxtypeFilter.or("taxtype", "=", (Object)"fjsf");
                }
                DynamicObjectCollection query = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"hjsqid", (QFilter[])new QFilter[]{sbbentryidFilter, taxtypeFilter});
                DeleteServiceHelper.delete((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbentryidFilter, taxtypeFilter});
                DeleteServiceHelper.delete((String)"bdtaxr_deferpay_apply", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)query.stream().map(e -> e.get("hjsqid")).toArray())});
            } else {
                QFilter sbbidFilter = new QFilter("sbbid", "=", sbbid);
                DeleteServiceHelper.delete((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid.toString())});
                DeleteServiceHelper.delete((String)"bdtaxr_deferpay_apply", (QFilter[])new QFilter[]{sbbidFilter});
            }
            if ("2".equals(syhjzc)) {
                DynamicObject row1 = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_pay_record");
                String number1 = CodeRuleServiceHelper.getNumber((String)"bdtaxr_pay_record", (DynamicObject)row1, (String)org.getString("id"));
                row1.set("billno", (Object)number1);
                row1.set("sbbno", (Object)nsrxx.getString("billno"));
                BigDecimal dqhjje = ybtse.multiply(dqjkbl).setScale(2, RoundingMode.HALF_UP);
                row1.set("yjje", (Object)dqhjje);
                row1.set("jkbl", (Object)dqjkbl);
                row1.set("paystatus", (Object)"2");
                row1.set("deadline", (Object)dqjkqx);
                row1.set("sjje", (Object)BigDecimal.ZERO);
                row1.set("syqjje", (Object)dqhjje);
                row1.set("taxtype", (Object)taxtype);
                row1.set("sbbid", sbbid);
                row1.set("sbbentryid", sbbentryid);
                row1.set("org", nsrxx.get("org"));
                row1.set("skssqq", (Object)skssqq);
                row1.set("skssqz", (Object)skssqz);
                row1.set("sssq", (Object)taxperiodStr);
                row1.set("nsrtype", nsrxx.get("type"));
                row1.set("billstatus", (Object)"C");
                row1.set("taxauthority", dobj != null ? dobj.get("taxoffice.id") : Long.valueOf(0L));
                row1.set("operator", (Object)RequestContext.get().getCurrUserId());
                row1.set("operatetime", (Object)new Date());
                row1.set("accountorg", (Object)accountOrg);
                this.updateFormEntity(row1.getDynamicObjectCollection("entryentity"), nsrxx.getString("type"), taxtype, dqhjje, BigDecimal.ZERO, dqhjje, String.valueOf(sbbid), skssqq, skssqz);
                DynamicObject row2 = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_pay_record");
                String number2 = CodeRuleServiceHelper.getNumber((String)"bdtaxr_pay_record", (DynamicObject)row2, (String)org.getString("id"));
                row2.set("billno", (Object)number2);
                row2.set("sbbno", (Object)nsrxx.getString("billno"));
                BigDecimal yhjkje = ybtse.subtract(dqhjje).setScale(2, RoundingMode.HALF_UP);
                row2.set("yjje", (Object)yhjkje);
                row2.set("jkbl", (Object)yhjkbl);
                row2.set("paystatus", (Object)"2");
                row2.set("deadline", (Object)yhjkqx);
                row2.set("sjje", (Object)BigDecimal.ZERO);
                row2.set("syqjje", (Object)yhjkje);
                row2.set("taxtype", (Object)taxtype);
                row2.set("sbbid", sbbid);
                row2.set("sbbentryid", sbbentryid);
                row2.set("org", nsrxx.get("org"));
                row2.set("skssqq", (Object)skssqq);
                row2.set("skssqz", (Object)skssqz);
                row2.set("sssq", (Object)taxperiodStr);
                row2.set("nsrtype", nsrxx.get("type"));
                row2.set("billstatus", (Object)"C");
                row2.set("taxauthority", dobj != null ? dobj.get("taxoffice.id") : Long.valueOf(0L));
                row2.set("operator", (Object)RequestContext.get().getCurrUserId());
                row2.set("operatetime", (Object)new Date());
                row2.set("accountorg", (Object)accountOrg);
                this.updateFormEntity(row2.getDynamicObjectCollection("entryentity"), nsrxx.getString("type"), taxtype, yhjkje, BigDecimal.ZERO, yhjkje, String.valueOf(sbbid), skssqq, skssqz);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{row1, row2});
                continue;
            }
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_pay_record");
            String number = CodeRuleServiceHelper.getNumber((String)"bdtaxr_pay_record", (DynamicObject)obj, (String)org.getString("id"));
            obj.set("billno", (Object)number);
            obj.set("sbbno", (Object)nsrxx.getString("billno"));
            BigDecimal yjje = ybtse.multiply(yhjkbl).setScale(2, RoundingMode.HALF_UP);
            obj.set("yjje", (Object)yjje);
            obj.set("jkbl", (Object)yhjkbl);
            obj.set("paystatus", (Object)"2");
            obj.set("deadline", (Object)yhjkqx);
            obj.set("sjje", (Object)BigDecimal.ZERO);
            obj.set("syqjje", (Object)yjje);
            obj.set("taxtype", (Object)taxtype);
            obj.set("sbbid", sbbid);
            obj.set("sbbentryid", sbbentryid);
            obj.set("org", nsrxx.get("org"));
            obj.set("skssqq", (Object)skssqq);
            obj.set("skssqz", (Object)skssqz);
            obj.set("sssq", (Object)taxperiodStr);
            obj.set("nsrtype", nsrxx.get("type"));
            obj.set("billstatus", (Object)"C");
            obj.set("taxauthority", dobj != null ? dobj.get("taxoffice.id") : Long.valueOf(0L));
            obj.set("operator", (Object)RequestContext.get().getCurrUserId());
            obj.set("operatetime", (Object)new Date());
            obj.set("accountorg", (Object)accountOrg);
            this.updateFormEntity(obj.getDynamicObjectCollection("entryentity"), nsrxx.getString("type"), taxtype, yjje, BigDecimal.ZERO, yjje, String.valueOf(sbbid), skssqq, skssqz);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    private void updateFormEntity(DynamicObjectCollection entryentity, String nsrtype, String taxtype, Object yjje, Object sjje, Object syqjje, String sbbid, Date startDate, Date endDate) {
        if (singleItem.contains(nsrtype)) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("taxitem", (Object)taxtype);
            dynamicObject.set("yjjemx", yjje);
            dynamicObject.set("sjjemx", sjje);
            dynamicObject.set("syqjjemx", syqjje);
            dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
        } else if ("szys_a".equals(nsrtype)) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("taxitem", (Object)nsrtype);
            dynamicObject.set("yjjemx", yjje);
            dynamicObject.set("sjjemx", sjje);
            dynamicObject.set("syqjjemx", syqjje);
            dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
        } else if ("ccxws".equals(nsrtype)) {
            MultiLangEnumBridge multiLangEnumBridge;
            String taxname = null;
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
            QFilter skssqqFilter = new QFilter("startdate", "=", (Object)startDate);
            QFilter skssqzFilter = new QFilter("enddate", "=", (Object)endDate);
            if ("zys".equals(taxtype)) {
                taxtype = "tcrt";
            }
            if ("ccs".equals(taxtype)) {
                taxtype = "tcvvt";
            }
            if ("hbs".equals(taxtype)) {
                taxtype = "tcept";
            }
            if ("szys".equals(taxtype)) {
                taxtype = "tcwat";
            }
            if (null != (multiLangEnumBridge = DeclareTaxType.nssbMatchBaseName((String)taxtype))) {
                taxname = multiLangEnumBridge.loadKDString();
            }
            QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)taxname);
            DynamicObject[] sbb = BusinessDataServiceHelper.load((String)"tcret_ccxws_zb_hb", (String)"sm,ybse", (QFilter[])new QFilter[]{sbbidFilter, taxtypeFilter, skssqqFilter, skssqzFilter});
            for (int i = 0; i < sbb.length; ++i) {
                DynamicObject dynamicObject = entryentity.addNew();
                dynamicObject.set("taxitem", (Object)sbb[i].getString("sm"));
                BigDecimal yjjemx = sbb[i].getBigDecimal("ybse");
                dynamicObject.set("yjjemx", (Object)yjjemx);
                dynamicObject.set("sjjemx", (Object)BigDecimal.ZERO);
                dynamicObject.set("syqjjemx", (Object)yjjemx);
                dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
            }
        }
    }

    private void updateEntryEntity(List<DynamicObject> data, String orgIdKey) {
        IDataModel model = this.getModel();
        if (data.size() > 0) {
            BigDecimal yjjehj = BigDecimal.ZERO;
            Date dqjkqx = null;
            Date yhjkqx = null;
            model.beginInit();
            model.deleteEntryData("entryentity");
            model.batchCreateNewEntryRow("entryentity", data.size());
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject dyo = data.get(i);
                long orgId = dyo.getLong(orgIdKey);
                model.setValue("sbbid", dyo.get("sbbid"), i);
                model.setValue("sbbentryid", dyo.get("sbbentryid"), i);
                model.setValue("org", dyo.get("org"), i);
                String taxperiod = dyo.getString("taxperiod");
                model.setValue("taxperiod", (Object)taxperiod, i);
                String taxtype = dyo.getString("taxtype");
                model.setValue("taxtype", (Object)taxtype, i);
                model.setValue("type", dyo.get("type"), i);
                String taxlimit = dyo.getString("taxlimit");
                model.setValue("taxlimit", (Object)taxlimit, i);
                BigDecimal ybtse = dyo.getBigDecimal("ybtse");
                model.setValue("ybtse", (Object)ybtse, i);
                yjjehj = yjjehj.add(ybtse);
                String skssqzStr = taxperiod.contains("~") ? taxperiod.split("~")[1] : (taxperiod.contains("-") ? taxperiod.split("-")[1] : taxperiod);
                Date skssqz = DateUtils.stringToDate2((String)skssqzStr, (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
                if (dqjkqx == null) {
                    dqjkqx = CalenderUtils.getTaxCalenderDate((Long)orgId, (Date)skssqz, (String)taxtype, (String)taxlimit, (int)1);
                }
                if (yhjkqx != null) continue;
                yhjkqx = CalenderUtils.getTaxCalenderDate((Long)orgId, (Date)skssqz, (String)taxtype, (String)taxlimit, (int)4);
            }
            model.endInit();
            this.getView().updateView("entryentity");
            model.setValue("yjjehj", (Object)yjjehj);
            model.setValue("dqjkqx", dqjkqx);
            model.setValue("yhjkqx", yhjkqx);
        } else {
            model.deleteEntryData("entryentity");
        }
    }

    private Long doSetAccountOrg(Long taxOrg, Date startDate, Date endDate) {
        Long defaultAccountOrg = this.setDefaultAccountOrg(taxOrg, startDate, endDate).get(0);
        return defaultAccountOrg;
    }

    private List<Long> setDefaultAccountOrg(Long taxOrg, Date startDate, Date endDate) {
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
        return !CollectionUtils.isEmpty((Collection)orgRelations) ? orgRelations.stream().distinct().collect(Collectors.toList()) : Lists.newArrayList((Object[])new Long[]{0L});
    }

    private boolean tryLock(List<DLock> locks, Object id) {
        DLock lock = DLock.create((String)id.toString());
        if (lock.tryLock(30000L)) {
            locks.add(lock);
            return true;
        }
        return false;
    }
}

