/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeferPayRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(AbstractReportFormPlugin.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final List<String> TCVAT_TAXTYPE = Arrays.asList("zzs", "cswhjss", "jyffj", "dfjyfj");
    private static final List<String> TCCIT_TAXTYPE = Collections.singletonList("qysds");
    private static final Map<String, List<String>> taxTypeMap = new HashMap<String, List<String>>(){
        {
            this.put("tcvat", TCVAT_TAXTYPE);
            this.put("tccit", TCCIT_TAXTYPE);
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlistap = (ReportList)this.getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
                List orgList = hasPermOrgResult.getHasPermOrgs();
                QFilter idsFilter = new QFilter("id", "in", (Object)orgList);
                args.getCustomQFilters().add(idsFilter);
            }
        }
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String appId = this.getView().getFormShowParameter().getAppId();
        CommonFilterColumn cmmTaxtype = (CommonFilterColumn)contInitEvent.getFilterColumn("cmm_taxtype");
        if (appId != null && taxTypeMap.get(appId) != null) {
            List<String> taxTypes = taxTypeMap.get(appId);
            List comboItems = cmmTaxtype.getComboItems();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(comboItems.size());
            for (ComboItem comboItem : comboItems) {
                if (!taxTypes.contains(comboItem.getValue())) continue;
                items.add(comboItem);
            }
            cmmTaxtype.setComboItems(items);
        }
        CommonFilterColumn cmmOrg = (CommonFilterColumn)contInitEvent.getFilterColumn("cmm_org");
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List orgList = hasPermOrgResult.getHasPermOrgs();
            Set orgs = orgList.stream().map(Objects::toString).collect(Collectors.toSet());
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(orgList.size());
            List comboItems = cmmOrg.getComboItems();
            for (ComboItem comboItem : comboItems) {
                if (!orgs.contains(comboItem.getValue())) continue;
                items.add(comboItem);
            }
            cmmOrg.setComboItems(items);
        }
        SchemeFilterColumn scmTaxtype = (SchemeFilterColumn)contInitEvent.getFilterColumn("scm_taxtype");
        if (appId != null && taxTypeMap.get(appId) != null) {
            List<String> taxTypes = taxTypeMap.get(appId);
            List comboItems = scmTaxtype.getComboItems();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(comboItems.size());
            for (ComboItem comboItem : comboItems) {
                if (!taxTypes.contains(comboItem.getValue())) continue;
                items.add(comboItem);
            }
            scmTaxtype.setComboItems(items);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("apply".equals(operateKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bdtaxr_deferpay_dialog");
            showParameter.getOpenStyle().setShowType(ShowType.NonModal);
            showParameter.setShowTitle(false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "applypay");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else if ("unapply".equals(operateKey)) {
            List<DynamicObject> selectRows = this.getSelectRowDatas();
            if (selectRows.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"DeferPayRptPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            StringBuilder errMsg = new StringBuilder();
            StringBuilder message = new StringBuilder();
            for (DynamicObject selectRow : selectRows) {
                long sbbid = selectRow.getLong("sbbid");
                QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbid));
                boolean exists = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidFilter, new QFilter("paystatus", "=", (Object)"1")});
                String taxperiod = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"DeferPayRptPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), DateUtils.format((Date)selectRow.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE), DateUtils.format((Date)selectRow.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE));
                String type = selectRow.getString("type");
                String taxtypes = selectRow.getString("taxtypes");
                if (exists) {
                    errMsg.append(String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s%4$s\u5df2\u786e\u8ba4\u7f34\u6b3e\uff0c\u4e0d\u80fd\u53d6\u6d88\u7533\u8bf7", (String)"DeferPayRptPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append(SEPARATOR);
                    continue;
                }
                QFilter voucherFilter = new QFilter("isvoucher", "=", (Object)"1");
                boolean isvoucher = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidFilter, voucherFilter});
                if (isvoucher) {
                    errMsg.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u751f\u6210\u51ed\u8bc1\u7684\u6570\u636e\u53ef\u8fdb\u884c\u53d6\u6d88\u7533\u62a5\u64cd\u4f5c\uff1a%1$s%2$s%3$s%4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeferPayRptPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append(SEPARATOR);
                    continue;
                }
                message.append(String.format("%s%s%s%s", selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append('\n');
            }
            if (errMsg.length() == 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("unapply", (IFormPlugin)this);
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String title = ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88\u7f13\u7f34\u7533\u8bf7\uff1f", (String)"DeferPayRptPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                this.getView().showConfirm(title, message.substring(0, message.length() - 1), options, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.showMessage(errMsg);
            }
        } else if ("pay".equals(operateKey)) {
            List<DynamicObject> selectRows = this.getSelectRowDatas();
            if (selectRows.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"DeferPayRptPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            BigDecimal yjjehj = BigDecimal.ZERO;
            StringBuilder message = new StringBuilder();
            for (DynamicObject selectRow : selectRows) {
                String paystatus = selectRow.getString("paystatus");
                String taxperiod = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"DeferPayRptPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), DateUtils.format((Date)selectRow.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE), DateUtils.format((Date)selectRow.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE));
                String type = selectRow.getString("type");
                String taxtypes = selectRow.getString("taxtypes");
                if ("1".equals(paystatus)) {
                    message.append(String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s%4$s\u5df2\u786e\u8ba4\u7f34\u6b3e\uff0c\u65e0\u9700\u518d\u7f34\u6b3e", (String)"DeferPayRptPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append(SEPARATOR);
                    continue;
                }
                yjjehj = yjjehj.add(selectRow.getBigDecimal("yjje"));
            }
            if (message.length() == 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("pay", (IFormPlugin)this);
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%1$s\u6761\u5f85\u7f34\u6b3e\u8bb0\u5f55\uff0c\u5e94\u7f34\u91d1\u989d\u5408\u8ba1\u4e3a%2$s\u5143\uff0c\u662f\u5426\u786e\u8ba4\u7f34\u6b3e\uff1f", (String)"DeferPayRptPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRows.size(), yjjehj.setScale(2, RoundingMode.HALF_UP));
                this.getView().showConfirm(msg, options, confirmCallBacks);
            } else {
                this.showMessage(message);
            }
        } else if ("unpay".equals(operateKey)) {
            List<DynamicObject> selectRows = this.getSelectRowDatas();
            if (selectRows.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"DeferPayRptPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(selectRows.size());
            StringBuilder message = new StringBuilder();
            for (DynamicObject selectRow : selectRows) {
                String paystatus = selectRow.getString("paystatus");
                String taxperiod = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"DeferPayRptPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), DateUtils.format((Date)selectRow.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE), DateUtils.format((Date)selectRow.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE));
                String type = selectRow.getString("type");
                String taxtypes = selectRow.getString("taxtypes");
                if ("2".equals(paystatus)) {
                    message.append(String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s%4$s\u672a\u7f34\u6b3e\uff0c\u65e0\u9700\u53d6\u6d88\u7f34\u6b3e", (String)"DeferPayRptPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append(SEPARATOR);
                    continue;
                }
                DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)selectRow.get("id"), (String)"bdtaxr_pay_record");
                this.getPageCache().put(dyo.getString("sbbid"), dyo.getString("paydate"));
                dyo.set("paystatus", (Object)"2");
                dyo.set("sjje", (Object)BigDecimal.ZERO);
                dyo.set("syqjje", (Object)dyo.getBigDecimal("yjje").subtract(dyo.getBigDecimal("sjje")));
                dyo.set("payer", null);
                dyo.set("paydate", null);
                updateList.add(dyo);
            }
            if (message.length() == 0) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                this.updateSbbData(appId, selectRows, "unpay");
                this.calcElement(updateList, "cancelpay");
                this.getView().refresh();
            } else {
                this.showMessage(message);
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List list = TaxTypeUtils.getTemplateTypeList((String)appId, (String)((String)this.getView().getFormShowParameter().getCustomParam("taxtype")));
        List qFilters = queryParam.getFilter().getQFilters();
        qFilters.add(new QFilter("type", "in", (Object)list));
        HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (result != null && !result.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)result)) {
            List orgList = result.getHasPermOrgs();
            QFilter idsFilter = new QFilter("org", "in", (Object)orgList);
            qFilters.add(idsFilter);
        }
        queryParam.getCustomParam().put("appId", appId);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        ReportColumn columnDesc = (ReportColumn)e.getSource();
        String type = data.getString("type");
        if ("type".equals(columnDesc.getFieldKey())) {
            e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
        } else if ("sssq".equals(columnDesc.getFieldKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        } else if ("sjkbl".equals(columnDesc.getFieldKey())) {
            BigDecimal jkbl = data.getBigDecimal("jkbl");
            e.setFormatValue((Object)(jkbl.multiply(new BigDecimal("100")).setScale(0, RoundingMode.HALF_UP).toString() + "%"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (MessageBoxResult.Yes == result && "unapply".equals(callBackId)) {
            DynamicObject[] updateDatas;
            String amtKey;
            QFilter[] applyfilters;
            List hjsqIds;
            DynamicObjectCollection hjsqid;
            QFilter[] recordfilters;
            List<DynamicObject> selectRows = this.getSelectRowDatas();
            if ("tcvat".equals(appId)) {
                List sbbEntryIds = selectRows.stream().map(e -> e.get("sbbentryid")).collect(Collectors.toList());
                recordfilters = new QFilter[]{new QFilter("sbbentryid", "in", sbbEntryIds)};
                hjsqid = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"hjsqid", (QFilter[])recordfilters);
                hjsqIds = hjsqid.stream().map(e -> e.get("hjsqid")).collect(Collectors.toList());
                applyfilters = new QFilter[]{new QFilter("id", "in", hjsqIds)};
                amtKey = "bqdybtse";
                updateDatas = BusinessDataServiceHelper.load((Object[])sbbEntryIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_declare_entry"));
            } else {
                DynamicObject[] sbbIds = selectRows.stream().map(e -> e.getLong("sbbid")).collect(Collectors.toList());
                recordfilters = new QFilter[]{new QFilter("sbbid", "in", (Object)sbbIds.stream().map(String::valueOf).toArray())};
                hjsqid = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"hjsqid", (QFilter[])recordfilters);
                hjsqIds = hjsqid.stream().map(e -> e.get("hjsqid")).collect(Collectors.toList());
                applyfilters = new QFilter[]{new QFilter("id", "in", hjsqIds)};
                amtKey = "bqybtse";
                updateDatas = BusinessDataServiceHelper.load((Object[])sbbIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
            }
            for (DynamicObject updateData : updateDatas) {
                updateData.set("deferpayapply", (Object)Boolean.FALSE);
                updateData.set("sjje", (Object)BigDecimal.ZERO);
                updateData.set("qjje", updateData.get(amtKey));
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    DeleteServiceHelper.delete((String)"bdtaxr_pay_record", (QFilter[])recordfilters);
                    DeleteServiceHelper.delete((String)"bdtaxr_deferpay_apply", (QFilter[])applyfilters);
                    SaveServiceHelper.update((DynamicObject[])updateDatas);
                }
                catch (Exception e2) {
                    h.markRollback();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u7533\u8bf7\u5931\u8d25", (String)"DeferPayRptPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    logger.error("taxc-DeferPayRptPlugin unapply fail:", (Object)e2.getMessage());
                }
            }
            this.getView().refresh();
        } else if (MessageBoxResult.Yes == result && "pay".equals(callBackId)) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_paydate_confirm");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
            this.getPageCache().put("selectRows", SerializationUtils.toJsonString(this.getSelectRowDatas()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("applypay".endsWith(actionId)) {
            Object returnData = evt.getReturnData();
            if (returnData != null) {
                this.getView().showSuccessNotification((String)returnData);
            }
            this.getView().refresh();
        }
        if ("payDateConfirm".equals(actionId)) {
            String appId = this.getView().getFormShowParameter().getAppId();
            Date payDate = (Date)evt.getReturnData();
            if (payDate == null) {
                return;
            }
            List selectRows = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectRows"), List.class);
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(selectRows.size());
            for (Map row : selectRows) {
                String paystatus = (String)row.get("paystatus");
                if ("1".equals(paystatus)) continue;
                DynamicObject dyo = BusinessDataServiceHelper.loadSingle(row.get("id"), (String)"bdtaxr_pay_record");
                BigDecimal yjje = dyo.getBigDecimal("yjje");
                dyo.set("paystatus", (Object)"1");
                dyo.set("sjje", (Object)yjje);
                dyo.set("syqjje", (Object)dyo.getBigDecimal("yjje").subtract(dyo.getBigDecimal("sjje")));
                dyo.set("payer", (Object)RequestContext.get().getCurrUserId());
                dyo.set("paydate", (Object)payDate);
                updateList.add(dyo);
            }
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            this.updateSbbData(appId, updateList, "pay");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DeferPayRptPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.calcElement(updateList, "pay");
            this.getView().refresh();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject rowData = ((ReportList)evt.getSource()).getReportModel().getRowData(evt.getRowIndex());
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)rowData.get("sbbid"), (String)"tcvat_nsrxx");
        String type = object.getString("type");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("sbbid", object.getString("id"));
        customParams.put("orgid", object.getDynamicObject("org").getString("id"));
        customParams.put("orgname", object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        customParams.put("type", type);
        customParams.put("templatetype", type);
        customParams.put("taxPayerType", type);
        customParams.put("deadLine", "month".equals(object.getString("taxlimit")) ? "aysb" : "ajsb");
        customParams.put("tcrettype", object.getString("tcrettype"));
        customParams.put("apanage", object.getString("apanage"));
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("taxlimit", DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
        customParams.put("taxperiod", startDate.substring(0, 7));
        customParams.put("readonly", Boolean.TRUE);
        customParams.put("from", "history");
        customParams.put("modifytime", object.getDate("modifytime"));
        String declarestatus = object.getString("declarestatus");
        String dataType = object.getString("datatype");
        customParams.put("datatype", dataType);
        this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, declarestatus);
    }

    private void showMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(SEPARATOR);
            if (messages.length == 1) {
                this.getView().showErrorNotification(message.toString());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private void updateSbbAmt(DynamicObject sbbData, String sbbIdName, String ybtseName) {
        if (sbbData != null) {
            Object id = "sbbid".equals(sbbIdName) ? sbbData.getString("id") : Long.valueOf(sbbData.getLong("id"));
            DynamicObject sjjeSum = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"sum(sjje) as sjje", (QFilter[])new QFilter[]{new QFilter(sbbIdName, "=", id)});
            BigDecimal sjje = sjjeSum.getBigDecimal("sjje");
            BigDecimal ybtse = sbbData.getBigDecimal(ybtseName);
            sbbData.set("sjje", (Object)sjje);
            sbbData.set("qjje", (Object)ybtse.subtract(sjje));
        }
    }

    private void updateSbbData(String appId, List<DynamicObject> selectRows, String operateKey) {
        Map<Long, DynamicObject> sbbEntryMap = null;
        if ("tcvat".equals(appId)) {
            DynamicObject[] sbbEntry = BusinessDataServiceHelper.load((Object[])selectRows.stream().map(e -> e.get("sbbentryid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_declare_entry"));
            sbbEntryMap = Stream.of(sbbEntry).collect(Collectors.toMap(d -> d.getLong("id"), d -> d, (v1, v2) -> v1));
        }
        DynamicObject[] sbbDatas = BusinessDataServiceHelper.load((Object[])selectRows.stream().map(e -> e.getLong("sbbid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
        Map<Long, DynamicObject> sbbMap = Stream.of(sbbDatas).collect(Collectors.toMap(d -> d.getLong("id"), d -> d, (v1, v2) -> v1));
        if (selectRows != null && selectRows.size() > 0) {
            for (DynamicObject row : selectRows) {
                QFilter payStatusFilter;
                long sbbId = row.getLong("sbbid");
                DynamicObject sbbData = sbbMap.get(sbbId);
                if (sbbEntryMap != null) {
                    long sbbentryid = row.getLong("sbbentryid");
                    this.updateSbbAmt(sbbEntryMap.get(sbbentryid), "sbbentryid", "bqdybtse");
                } else {
                    this.updateSbbAmt(sbbData, "sbbid", "bqybtse");
                }
                if ("pay".equals(operateKey)) {
                    payStatusFilter = new QFilter("paystatus", "=", (Object)"2");
                    sbbData.set("payer", (Object)RequestContext.get().getCurrUserId());
                    sbbData.set("paydate", (Object)row.getDate("paydate"));
                } else {
                    payStatusFilter = new QFilter("paystatus", "=", (Object)"1");
                }
                DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bdtaxr_pay_record", (String)"id,sbbid,paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(sbbId)), payStatusFilter}, (String)"paydate desc");
                boolean exists = rows.hasNext();
                if (exists) {
                    sbbData.set("paystatus", (Object)"partpaid");
                    Date paydate = rows.next().getDate("paydate");
                    if (paydate == null) continue;
                    sbbData.set("paydate", (Object)paydate);
                    continue;
                }
                sbbData.set("paystatus", (Object)("pay".equals(operateKey) ? "paid" : "unpaid"));
                if (!"unpay".equals(operateKey)) continue;
                sbbData.set("payer", null);
                sbbData.set("paydate", null);
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject[])sbbMap.values().toArray(new DynamicObject[0]));
                if (sbbEntryMap != null) {
                    SaveServiceHelper.update((DynamicObject[])sbbEntryMap.values().toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e2) {
                h.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u7f34\u6b3e\u5931\u8d25", (String)"DeferPayRptPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                logger.error("taxc-DeferPayRptPlugin pay fail:", (Object)e2.getMessage());
            }
        }
    }

    private List<DynamicObject> getSelectRowDatas() {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        int[] rows = reportlist.getEntryState().getSelectedRows();
        if (rows.length > 0) {
            IReportListModel reportModel = reportlist.getReportModel();
            return Arrays.stream(rows).mapToObj(arg_0 -> ((IReportListModel)reportModel).getRowData(arg_0)).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>(0);
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus) {
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private void calcElement(List<DynamicObject> updateList, String act) {
        for (DynamicObject dyo : updateList) {
            Long sbbid = dyo.getLong("sbbid");
            Date paydate = "cancelpay".equals(act) ? DateUtils.stringToDate((String)this.getPageCache().get(sbbid.toString())) : dyo.getDate("paydate");
            Date skssqq = DateUtils.getFirstDateOfMonth((Date)paydate);
            Date skssqz = DateUtils.getLastDateOfMonth((Date)paydate);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
            DeclareMQSender.sendMQ((DynamicObject)dynamicObject, (Date)skssqq, (Date)skssqz, (String)DeclareMQType.PAY.name(), (String)act);
        }
    }
}

