/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FastFilter;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class DeferPayRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String payRecordFields = "id,billno,yjje,jkbl,paystatus,deadline,sjje,syqjje,payer,paydate,sbbid,hjsqid,sbbentryid,taxtype";
    private static final String declareMainFields = "id as bbid,org.name as orgname,type,skssqq,skssqz,org";
    private static final String declareMainEntryFields = "entryentity.id as entryid,entryentity.taxtypes as taxtypes,entryentity.bqdybtse as bqdybtse";
    private static final String deferPayApplyFields = "id as dpaid,applyno,operator,operatetime,sbbid as dpabbid";
    static final String PAY_RECORD_ENTITY = "bdtaxr_pay_record";
    static final String DEFERPAY_APPLY_ENTITY = "bdtaxr_deferpay_apply";
    private static final String DECLARE_MAIN = "tcvat_nsrxx";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return this.queryDataSet(reportQueryParam);
    }

    private DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map<String, List<QFilter>> filterMap = this.getFilter(reportQueryParam);
        String appId = (String)reportQueryParam.getCustomParam().get("appId");
        if (appId != null && "tcvat".equals(appId)) {
            DataSet payRecord = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)PAY_RECORD_ENTITY, (String)payRecordFields, (QFilter[])filterMap.computeIfAbsent(PAY_RECORD_ENTITY, s -> Collections.emptyList()).toArray(new QFilter[0]), null);
            DataSet deferPayApply = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)DEFERPAY_APPLY_ENTITY, (String)deferPayApplyFields, (QFilter[])filterMap.computeIfAbsent(DEFERPAY_APPLY_ENTITY, s -> Collections.emptyList()).toArray(new QFilter[0]), null);
            DataSet declareMain = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)DECLARE_MAIN, (String)declareMainFields, (QFilter[])filterMap.computeIfAbsent(DECLARE_MAIN, s -> Collections.emptyList()).toArray(new QFilter[0]), null);
            DataSet declareMainEntry = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)DECLARE_MAIN, (String)declareMainEntryFields, (QFilter[])filterMap.computeIfAbsent(DECLARE_MAIN, s -> Collections.emptyList()).toArray(new QFilter[0]), null);
            return deferPayApply.leftJoin(declareMain).on("dpabbid", "bbid").select(this.fieldsToSelectFields(deferPayApplyFields, declareMainFields).toArray(new String[0])).finish().leftJoin(payRecord).on("dpaid", "hjsqid").select(this.fieldsToSelectFields(payRecordFields, declareMainFields, deferPayApplyFields).toArray(new String[0])).finish().leftJoin(declareMainEntry).on("sbbentryid", "entryid").select(this.fieldsToSelectFields(payRecordFields, declareMainFields, deferPayApplyFields, declareMainEntryFields).toArray(new String[0])).finish().where("bbid != null and dpabbid != null and entryid != null and sbbentryid != null and sbbentryid != 0 and id != null").orderBy(new String[]{"org", "skssqq", "operatetime desc"});
        }
        DataSet payRecord = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)PAY_RECORD_ENTITY, (String)payRecordFields, (QFilter[])filterMap.computeIfAbsent(PAY_RECORD_ENTITY, s -> Collections.emptyList()).toArray(new QFilter[0]), null);
        DataSet deferPayApply = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)DEFERPAY_APPLY_ENTITY, (String)deferPayApplyFields, (QFilter[])filterMap.computeIfAbsent(DEFERPAY_APPLY_ENTITY, s -> Collections.emptyList()).toArray(new QFilter[0]), null);
        DataSet declareMain = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)DECLARE_MAIN, (String)declareMainFields, (QFilter[])filterMap.computeIfAbsent(DECLARE_MAIN, s -> Collections.emptyList()).toArray(new QFilter[0]), null);
        return deferPayApply.leftJoin(declareMain).on("dpabbid", "bbid").select(this.fieldsToSelectFields(deferPayApplyFields, declareMainFields).toArray(new String[0])).finish().leftJoin(payRecord).on("dpaid", "hjsqid").select(this.fieldsToSelectFields(payRecordFields, declareMainFields, deferPayApplyFields).toArray(new String[0])).finish().where("bbid != null and dpabbid != null and id != null").orderBy(new String[]{"org", "skssqq", "operatetime desc"});
    }

    private Map<String, List<QFilter>> getFilter(ReportQueryParam reportQueryParam) {
        List qFilterList;
        List qFilters;
        Object value;
        List fastFilters;
        HashMap<String, List<QFilter>> result = new HashMap<String, List<QFilter>>();
        FastFilter fastFilter = reportQueryParam.getFilter().getFastFilter();
        if (fastFilter != null && CollectionUtils.isNotEmpty((Collection)fastFilter.getQFilters()) && CollectionUtils.isNotEmpty((Collection)(fastFilters = fastFilter.getFastFilter()))) {
            for (Map fastMap : fastFilters) {
                List nameList = (List)fastMap.get("FieldName");
                List valueList = (List)fastMap.get("Value");
                value = valueList.get(0);
                QFilter qFilter = null;
                for (Object name : nameList) {
                    if (!StringUtils.equals((CharSequence)"fast_org", (CharSequence)((String)name))) continue;
                    name = "org.name";
                    if (qFilter == null) {
                        qFilter = new QFilter((String)name, "like", (Object)("%" + value + "%"));
                        continue;
                    }
                    qFilter = qFilter.or(new QFilter((String)name, "in", (Object)("%" + value + "%")));
                }
                qFilters = result.computeIfAbsent(DECLARE_MAIN, s -> new ArrayList(4));
                qFilters.add(qFilter);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(qFilterList = reportQueryParam.getFilter().getQFilters()))) {
            for (QFilter qFilter : qFilterList) {
                String name = qFilter.getProperty();
                if (name.contains("_")) {
                    name = name.substring(name.lastIndexOf(95) + 1);
                }
                String theName = name;
                if (name.contains(".")) {
                    theName = name.substring(0, name.indexOf(46));
                }
                value = qFilter.getValue();
                String cp = qFilter.getCP();
                qFilters = null;
                Pattern pattern = Pattern.compile("[, ]" + theName + ",?");
                if (pattern.matcher(payRecordFields).find()) {
                    qFilters = result.computeIfAbsent(PAY_RECORD_ENTITY, s -> new ArrayList(4));
                } else if (pattern.matcher(deferPayApplyFields).find()) {
                    qFilters = result.computeIfAbsent(DEFERPAY_APPLY_ENTITY, s -> new ArrayList(4));
                } else if (pattern.matcher(declareMainFields).find()) {
                    qFilters = result.computeIfAbsent(DECLARE_MAIN, s -> new ArrayList(4));
                }
                if (qFilters != null) {
                    if ("deadline".equals(theName) || "paydate".equals(theName) || "operatetime".equals(theName)) {
                        this.addDateFilter(qFilters, reportQueryParam, name, "scm_");
                    } else {
                        qFilters.add(new QFilter(name, cp, value));
                    }
                }
                if (!"taxperiod".equals(theName)) continue;
                qFilters = result.computeIfAbsent(DECLARE_MAIN, s -> new ArrayList(4));
                List taxperiod = reportQueryParam.getFilter().getFilterItems("cmm_taxperiod");
                for (FilterItemInfo filterItemInfo : taxperiod) {
                    String compareType = filterItemInfo.getCompareType();
                    Object value1 = filterItemInfo.getValue();
                    if (">=".equals(compareType)) {
                        qFilters.add(new QFilter("skssqq", compareType, value1));
                        continue;
                    }
                    qFilters.add(new QFilter("skssqz", compareType, value1));
                }
            }
        }
        return result;
    }

    private void addDateFilter(List<QFilter> qFilters, ReportQueryParam reportQueryParam, String name, String prefix) {
        List deadline = reportQueryParam.getFilter().getFilterItems(prefix + name);
        for (FilterItemInfo filterItemInfo : deadline) {
            String compareType = filterItemInfo.getCompareType();
            Object value1 = filterItemInfo.getValue();
            qFilters.add(new QFilter(name, compareType, value1));
        }
    }

    private List<String> fieldsToSelectFields(String ... fields) {
        if (fields == null) {
            return Collections.emptyList();
        }
        return Stream.of(fields).map(s -> s.split(",")).map(Stream::of).reduce(Stream::concat).orElseGet(Stream::empty).map(s -> {
            if (s.contains("as")) {
                return s.substring(s.lastIndexOf("as") + 3);
            }
            return s;
        }).collect(Collectors.toList());
    }
}

