/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class PayRecordFormPlugin
extends AbstractFormPlugin
implements UploadListener,
AttachmentMarkListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(PayRecordFormPlugin.class);
    private String ACCOUNTORG = "accountorg";
    private String ACCORG = "accorg";
    private String BIZDIMENSIONTYPE = "bizdimensiontype";
    private String BIZDIMENSIONNAME = "bizdimensionname";
    private String BIZDIMENSIONID = "bizdimensionid";
    private String PROJECTNUMBER = "projectnumber";
    private String PROJECTNAME = "projectname";

    private static String getName(int i) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, ResManager.loadKDString((String)"\u516c\u53f8\u7f16\u7801*", (String)"PayRecordFormPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(1, ResManager.loadKDString((String)"\u516c\u53f8\u540d\u79f0", (String)"PayRecordFormPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(2, ResManager.loadKDString((String)"\u516c\u53f8\u7a0e\u53f7", (String)"PayRecordFormPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(3, ResManager.loadKDString((String)"\u7533\u62a5\u8868\u540d\u79f0", (String)"PayRecordFormPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(4, ResManager.loadKDString((String)"\u5f81\u6536\u9879\u76ee*", (String)"PayRecordFormPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(5, ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee", (String)"PayRecordFormPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(6, ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u8d77*", (String)"PayRecordFormPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(7, ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u6b62*", (String)"PayRecordFormPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(8, ResManager.loadKDString((String)"\u7f34\u6b3e\u65e5\u671f", (String)"PayRecordFormPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(9, ResManager.loadKDString((String)"\u7f34\u6b3e\u671f\u9650", (String)"PayRecordFormPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(10, ResManager.loadKDString((String)"\u5e94\u7f34\u7a0e\u989d", (String)"PayRecordFormPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(11, ResManager.loadKDString((String)"\u5b9e\u7f34\u91d1\u989d", (String)"PayRecordFormPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(12, ResManager.loadKDString((String)"\u6ede\u7eb3\u91d1", (String)"PayRecordFormPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(13, ResManager.loadKDString((String)"\u7a0e\u6b3e\u72b6\u6001", (String)"PayRecordFormPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(14, ResManager.loadKDString((String)"\u7535\u5b50\u7a0e\u7968\u53f7\u7801", (String)"PayRecordFormPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        result.put(15, ResManager.loadKDString((String)"\u5e94\u7a0e\u51ed\u8bc1\u53f7", (String)"PayRecordFormPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        return (String)result.get(i);
    }

    public void afterBindData(EventObject e) {
        this.setDimensionField();
        this.setZnjValue();
        this.setZszm();
    }

    private void setZszm() {
        String taxtype = (String)this.getModel().getValue("taxtype");
        List<String> typeList = Arrays.asList("stbcbcf", "stbcbcf_jsqsr", "stbcbcf_kcqsr", "stbcbcf_qtsr");
        if (typeList.contains(taxtype)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"zszm"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"zszm"});
        }
    }

    private void setZnjValue() {
        Object paystatus = this.getModel().getValue("paystatus");
        this.getModel().setValue("gsznj", (Object)0.0);
        this.getModel().setValue("isdelay", (Object)"0");
        if (this.getModel().getValue("deadline") != null) {
            int dayDiff = -1;
            Object syqjje = null;
            if ("2".equals(paystatus)) {
                dayDiff = DateUtils.getDayDiff((Date)((Date)this.getModel().getValue("deadline")), (Date)new Date());
                syqjje = this.getModel().getValue("syqjje");
            } else if ("1".equals(paystatus) && this.getModel().getValue("paydate") != null) {
                dayDiff = DateUtils.getDayDiff((Date)((Date)this.getModel().getValue("deadline")), (Date)((Date)this.getModel().getValue("paydate")));
                syqjje = this.getModel().getValue("yjje");
            }
            if (dayDiff > 0) {
                this.getModel().setValue("delaynum", (Object)dayDiff);
                this.getModel().setValue("isdelay", (Object)"1");
                if (syqjje != null) {
                    BigDecimal gsznj = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)dayDiff, (Object)BigDecimalUtil.toBigDecimal((Object)syqjje), (int)2), (Object)"0.0005", (int)2);
                    this.getModel().setValue("gsznj", (Object)gsznj);
                }
            }
        }
    }

    private void setDimensionField() {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("org");
        String taxtype = (String)this.getModel().getValue("taxtype");
        if ("hbs".equals(taxtype)) {
            taxtype = "hjbhs";
        }
        Long baseTaxId = AccrualListEnum.getBaseTaxIdByCategory((String)taxtype);
        if (taxorg != null && baseTaxId != null) {
            TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(taxorg.getLong("id")), (Long)baseTaxId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz"));
            if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
                boolean isdimprovision = entry.getBoolean("ruleentity.rule.isdimprovision");
                String provisiondimension = entry.getString("ruleentity.rule.provisiondimension");
                this.getView().setVisible(Boolean.valueOf(isdimprovision), new String[]{this.PROJECTNUMBER, this.PROJECTNAME});
                boolean containsAccountOrg = isdimprovision && provisiondimension.contains("accountorg");
                this.getView().setVisible(Boolean.valueOf(containsAccountOrg), new String[]{this.ACCORG});
                this.getView().setVisible(Boolean.valueOf(!containsAccountOrg), new String[]{this.ACCOUNTORG});
                boolean containsBusinessdimension = isdimprovision && provisiondimension.contains("businessdimension");
                this.getView().setVisible(Boolean.valueOf(containsBusinessdimension), new String[]{this.BIZDIMENSIONTYPE, this.BIZDIMENSIONNAME});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.ACCORG, this.BIZDIMENSIONTYPE, this.BIZDIMENSIONNAME, this.BIZDIMENSIONID, this.PROJECTNUMBER, this.PROJECTNAME});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.ACCORG, this.BIZDIMENSIONTYPE, this.BIZDIMENSIONNAME, this.BIZDIMENSIONID, this.PROJECTNUMBER, this.PROJECTNAME});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long taxOrg = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(null);
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        customQFilters.add(new QFilter("id", "in", (Object)orgRelations));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("download")) {
            String fileName = ResManager.loadKDString((String)"\u7a0e\u5c40\u7533\u62a5\u6e05\u518c\u6a21\u677f.xlsx", (String)"PayRecordFormPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            String path = "/declare/" + fileName;
            this.downloadFile(path, fileName);
        }
    }

    private void downloadFile(String filePath, String fileName) {
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(filePath);){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, in, 5000);
            this.getView().openUrl(url);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }

    public void registerListener(EventObject e) {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        panel.addMarkListener((AttachmentMarkListener)this);
        panel.addUploadListener((UploadListener)this);
        BasedataEdit accountorgBase = (BasedataEdit)this.getView().getControl("accountorg");
        accountorgBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"download"});
    }

    public void upload(UploadEvent evt) {
        Map urls = (Map)evt.getUrls()[0];
        String url = (String)urls.get("url");
        try {
            boolean flag = this.uploadFile(url, evt);
            if (!flag) {
                evt.setCancel(true);
            }
        }
        catch (IOException e) {
            logger.error("upload fail", (Throwable)e);
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.getModel().setValue("electrictaxno", null);
        this.getModel().setValue("yspzno", null);
    }

    private boolean uploadFile(String fileUrl, UploadEvent evt) throws IOException {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(fileUrl).getQuery().split("&");
        HashMap<String, String> downloadFileParams = new HashMap<String, String>(16);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        InputStream inStream = content.getInputStream();
        Workbook sheets = WorkbookFactory.create((InputStream)inStream);
        Sheet sheetDetail = sheets.getSheetAt(0);
        int lastRowNum = sheetDetail.getLastRowNum();
        if (lastRowNum == 0) {
            evt.setCancelMsg(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u5df2\u586b\u5199\u6570\u636e\u7684\u6a21\u677f\u3002", (String)"PayRecordFormPlugin_20", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        if (lastRowNum > 0) {
            for (int i = 0; i < 16; ++i) {
                Row row = sheetDetail.getRow(0);
                if (null == row) {
                    evt.setCancelMsg(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6a21\u677f\u3002", (String)"PayRecordFormPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return false;
                }
                String value = String.valueOf(row.getCell(i));
                String trueValue = PayRecordFormPlugin.getName(i);
                if (trueValue.equals(value)) continue;
                evt.setCancelMsg(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u6a21\u677f\u3002", (String)"PayRecordFormPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return false;
            }
        }
        ArrayList<String> coNumberList = new ArrayList<String>();
        ArrayList<String> taxItemList = new ArrayList<String>();
        ArrayList<String> electrictaxnoList = new ArrayList<String>();
        ArrayList<String> yspznoList = new ArrayList<String>();
        String notNullMsg = ResManager.loadKDString((String)"\u5fc5\u5f55\u5b57\u6bb5\u4e0d\u5f97\u4e3a\u7a7a\u3002", (String)"PayRecordFormPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        String commonMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"PayRecordFormPlugin_22", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        for (int i = 1; i <= lastRowNum; ++i) {
            if (sheetDetail.getRow(i) == null) continue;
            Cell code = sheetDetail.getRow(i).getCell(0);
            if (null == code || code.getStringCellValue().equals("")) {
                evt.setCancelMsg(String.format(commonMsg, i, notNullMsg));
                return false;
            }
            this.addElement(code, coNumberList);
            Cell taxitem = sheetDetail.getRow(i).getCell(4);
            if (null == taxitem || taxitem.getStringCellValue().equals("")) {
                evt.setCancelMsg(String.format(commonMsg, i, notNullMsg));
                return false;
            }
            Cell qq = sheetDetail.getRow(i).getCell(6);
            Cell qz = sheetDetail.getRow(i).getCell(7);
            if (null != qq && null != qz) {
                try {
                    String skssqq = DateUtils.format((Date)qq.getDateCellValue());
                    String skssqz = DateUtils.format((Date)qz.getDateCellValue());
                    this.addElement(taxitem, taxItemList);
                    this.addOtherElement(sheetDetail.getRow(i).getCell(14), electrictaxnoList, taxitem, skssqq, skssqz);
                    this.addOtherElement(sheetDetail.getRow(i).getCell(15), yspznoList, taxitem, skssqq, skssqz);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u6e05\u518c\u4e2d\u65e5\u671f\u7c7b\u578b\u6709\u8bef\uff0cqq\uff1a{}\uff0cqz\uff1a{}", (Object)qq, (Object)qz);
                    evt.setCancelMsg(String.format(commonMsg, i, ResManager.loadKDString((String)"\u65e5\u671f\u7c7b\u578b\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PayRecordFormPlugin_21", (String)"taxc-bdtaxr", (Object[])new Object[0])));
                    return false;
                }
            }
            evt.setCancelMsg(String.format(commonMsg, i, notNullMsg));
            return false;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String orgNumber = org.getString("number");
        if (!orgNumber.equals(coNumberList.get(0))) {
            evt.setCancelMsg(ResManager.loadKDString((String)"\u5bfc\u5165\u516c\u53f8\u7f16\u7801\u4e0e\u5f53\u524d\u7f34\u7eb3\u5355\u516c\u53f8\u4e0d\u7b26\u3002", (String)"PayRecordFormPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        if (!electrictaxnoList.isEmpty()) {
            this.getModel().setValue("electrictaxno", electrictaxnoList.get(0));
        }
        if (!yspznoList.isEmpty()) {
            this.getModel().setValue("yspzno", yspznoList.get(0));
        }
        return true;
    }

    private void addElement(Cell cell, ArrayList<String> list) {
        String value = cell.getStringCellValue();
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            list.add(value);
        }
    }

    private void addOtherElement(Cell cell, ArrayList<String> list, Cell taxitem, String skssqq, String skssqz) {
        String taxtype = (String)this.getModel().getValue("taxtype");
        String startdate = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String enddate = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        String value = String.valueOf(cell);
        String item = String.valueOf(taxitem);
        if (list.size() == 0 && StringUtils.isNotBlank((CharSequence)value) && !"null".equals(value)) {
            String taxName;
            MultiLangEnumBridge type;
            if (taxtype.equals("zys")) {
                taxtype = "tcrt";
            }
            if (taxtype.equals("ccs")) {
                taxtype = "tcvvt";
            }
            if (taxtype.equals("hbs")) {
                taxtype = "tcept";
            }
            if (taxtype.equals("szys")) {
                taxtype = "tcwat";
            }
            if (null != (type = DeclareTaxType.nssbMatchBaseName((String)taxtype)) && item.equals(taxName = type.loadKDString()) && startdate.equals(skssqq) && enddate.equals(skssqz)) {
                list.add(value);
            }
        }
    }
}

