/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.pay.DeclarePayHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclarePageOpenHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.multidimension.MultiDiConstant;
import kd.taxc.bdtaxr.common.taxdeclare.enums.TaxDeclareMetaRouteEnum;
import kd.taxc.bdtaxr.common.taxdeclare.route.TaxDeclareRouteHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.PayRecordUtils;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class PayRecordQueryListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(PayRecordQueryListPlugin.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final List<String> TCVAT_TAXTYPE = Arrays.asList("zzs", "fjsf", "cswhjss", "jyffj", "dfjyfj");
    private static final List<String> TCCIT_TAXTYPE = Collections.singletonList("qysds");
    public static final List<String> TCRET_TAXTYPE = Arrays.asList("fcs", "cztdsys", "fcscztdsys", "yhs", "hbs", "szys", "ccs", "qs", "tvpt", "gdzys", "zys", "tdzzs", "yys");
    public static final List<String> TOTF_TAXTYPE = Arrays.asList("ghjf", "sljsjj", "ljclf", "whsyjsf", "qtsf_tysbb", "ghcbj", "dwfhf", "totf_cjrjybzj", "stbcbcf", "stbcbcf_jsqsr", "stbcbcf_kcqsr", "stbcbcf_qtsr");
    public static final List<String> TCNFEP_TAXTYPE = Arrays.asList("dkdj", "kjqysds");
    private static final String MENU = "menu";
    private static final String DEFER = "defer";
    private static final String PAY = "pay";
    private static final String DECLARE_TYPE = "declaretype";
    private static final String ISVOUCHER = "isvoucher";
    private static final String VOUCHERNO = "voucherno";
    private static final String OPERATETIME = "operatetime";
    private static final String YJJE = "yjje";
    private static final String JKBL = "jkbl";
    private static final String PAYSTATUS = "paystatus";
    private static final String SBBID = "sbbid";
    private static final String SBBENTRYID = "sbbentryid";
    private static final String TAXTYPE = "taxtype";
    private static final String HJSQID = "hjsqid";
    private static final String PAYED = "1";
    private static final Map<String, List<String>> TAXTYPE_MAP = new HashMap<String, List<String>>();

    public void initialize() {
        super.initialize();
        String menu = (String)this.getView().getFormShowParameter().getCustomParam(MENU);
        if (DEFER.equals(menu)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"genvoucher", "export"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"applypay", PAY});
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List collect;
        List listColumns;
        String menu = (String)this.getView().getFormShowParameter().getCustomParam(MENU);
        if (DEFER.equals(menu)) {
            listColumns = args.getListColumns();
            collect = listColumns.stream().filter(c -> !ISVOUCHER.equals(c.getListFieldKey()) && !VOUCHERNO.equals(c.getListFieldKey())).collect(Collectors.toList());
            args.setListColumns(collect);
        }
        if (PAY.equals(menu)) {
            listColumns = args.getListColumns();
            collect = listColumns.stream().filter(c -> !OPERATETIME.equals(c.getListFieldKey())).collect(Collectors.toList());
            args.setListColumns(collect);
        }
    }

    public void packageData(PackageDataEvent e) {
        Integer delayNum;
        String key = ((ColumnDesc)e.getSource()).getKey();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject rowData = e.getRowData();
        if ("isdelay".equals(key)) {
            delayNum = PayRecordUtils.getDelayNum((DynamicObject)rowData);
            String isdelay = "0";
            if (Objects.isNull(delayNum)) {
                return;
            }
            if (delayNum > 0) {
                isdelay = PAYED;
            }
            e.setFormatValue((Object)isdelay);
        } else if ("gsznj".equals(key)) {
            e.setFormatValue((Object)"0.00");
            delayNum = PayRecordUtils.getDelayNum((DynamicObject)rowData);
            if (Objects.nonNull(delayNum) && delayNum > 0) {
                BigDecimal delayMoney = PayRecordUtils.getDelayMoney((DynamicObject)rowData, (int)delayNum);
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMinimumFractionDigits(2);
                e.setFormatValue((Object)nf.format(delayMoney));
            }
        } else if ("skssqq".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)rowData.getDate("skssqq"), (Date)rowData.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
        String menu = (String)this.getView().getFormShowParameter().getCustomParam(MENU);
        if (PAY.equals(menu)) {
            e.setNoLinkKey(Collections.singletonList(YJJE));
            return;
        }
        if (DEFER.equals(menu)) {
            BigDecimal jkbl = rowData.getBigDecimal(JKBL);
            if (jkbl == null || jkbl.intValue() == 1) {
                e.setNoLinkKey(Collections.singletonList(YJJE));
                return;
            }
            String paystatus = rowData.getString(PAYSTATUS);
            if (paystatus.equals(PAYED)) {
                e.setNoLinkKey(Collections.singletonList(YJJE));
                return;
            }
            DynamicObject[] collect = this.getAnotherDeferPart(rowData, jkbl);
            if (collect.length == 0 || collect.length == 1 && collect[0].getString(PAYSTATUS).equals(PAYED)) {
                e.setNoLinkKey(Collections.singletonList(YJJE));
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] queryValues;
        for (DynamicObject rowData : queryValues = e.getQueryValues()) {
            Integer delayNum = PayRecordUtils.getDelayNum((DynamicObject)rowData);
            String isdelay = "0";
            rowData.set("gsznj", (Object)0);
            if (Objects.isNull(delayNum)) continue;
            if (delayNum > 0) {
                isdelay = PAYED;
                BigDecimal delayMoney = PayRecordUtils.getDelayMoney((DynamicObject)rowData, (int)delayNum);
                rowData.set("gsznj", (Object)delayMoney);
                rowData.set("delaynum", (Object)delayNum);
            }
            rowData.set("isdelay", (Object)isdelay);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (appId != null && TAXTYPE_MAP.get(appId) != null) {
            List<String> taxs = TAXTYPE_MAP.get(appId);
            List filterColumnList = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : filterColumnList) {
                String fieldName = filterColumn.getFieldName();
                if (!TAXTYPE.equals(fieldName)) continue;
                CommonFilterColumn column2 = (CommonFilterColumn)filterColumn;
                column2.setComboItems(column2.getComboItems().stream().filter(c -> taxs.contains(c.getValue())).collect(Collectors.toList()));
            }
            List schemeFilterColumns = args.getSchemeFilterColumns();
            for (FilterColumn filterColumn : schemeFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!TAXTYPE.equals(fieldName)) continue;
                SchemeFilterColumn column3 = (SchemeFilterColumn)filterColumn;
                column3.setComboItems(column3.getComboItems().stream().filter(c -> taxs.contains(c.getValue())).collect(Collectors.toList()));
            }
            if (appId.equals("tcnfep")) {
                filterColumnList.removeIf(column -> TAXTYPE.equals(column.getFieldName()));
                schemeFilterColumns.removeIf(column -> TAXTYPE.equals(column.getFieldName()));
                schemeFilterColumns.removeIf(column -> OPERATETIME.equals(column.getFieldName()));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String menu;
        String appId;
        super.setFilter(e);
        if (null == e) {
            return;
        }
        List qFilterList = e.getQFilters();
        if (!CollectionUtils.isEmpty((Collection)qFilterList)) {
            for (QFilter qFilter : qFilterList) {
                if (!TAXTYPE.equals(qFilter.getProperty()) || !"fcs".equals(qFilter.getValue())) continue;
                qFilter.__setCP("like");
                qFilter.__setValue((Object)"fcs%");
                break;
            }
        }
        if ((appId = this.getView().getFormShowParameter().getAppId()) != null && TAXTYPE_MAP.get(appId) != null) {
            qFilterList.add(new QFilter(TAXTYPE, "in", TAXTYPE_MAP.get(appId)));
            String declareType = (String)this.getView().getFormShowParameter().getCustomParam(DECLARE_TYPE);
            if (StringUtils.isNotBlank((CharSequence)declareType) && "tccit".equals(appId)) {
                qFilterList.add(new QFilter("nsrtype", "in", (Object)DeclareCateGory.valueOfCode((String)declareType).getTemplateType()));
            }
            if (StringUtils.isNotBlank((CharSequence)declareType) && "tcnfep".equals(appId)) {
                qFilterList.add(new QFilter("nsrtype", "=", (Object)declareType));
            }
        }
        if (DEFER.equals(menu = (String)this.getView().getFormShowParameter().getCustomParam(MENU))) {
            qFilterList.add(QFilter.isNotNull((String)OPERATETIME));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        String appId = this.getView().getFormShowParameter().getAppId();
        switch (operateKey = args.getOperateKey()) {
            case "apply": {
                this.doDeferBtn(appId);
                break;
            }
            case "unapply": {
                this.doCancelDeferBtn(appId);
                break;
            }
            case "pay": {
                this.doPayBtn(appId);
                break;
            }
            case "unpay": {
                this.doCancelPayBtn(appId);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("sbbno".equals(fieldName)) {
            args.setCancel(true);
            this.toDeclare(args);
        }
        if (YJJE.equals(fieldName)) {
            args.setCancel(true);
            this.toYjjeUpdate(args);
            this.getPageCache().put("selectPayRecordId", hyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue().toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.Yes != evt.getResult()) {
            return;
        }
        if ("unapply".equals(callBackId)) {
            this.doConfirmCancelDefer(this.getView().getFormShowParameter().getAppId());
            this.clearSelect();
        } else if (PAY.equals(callBackId)) {
            this.doConfirmPay();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("applypay".endsWith(actionId)) {
            this.doApplyPayCallBack(evt);
        }
        if ("payDateConfirm".equals(actionId)) {
            this.doPayDateConfirmCallBack(evt);
            this.clearSelect();
        }
        if ("yjjeUpdate".equals(actionId)) {
            this.doYjjeUpdateCallBack(evt);
        }
    }

    private void doYjjeUpdateCallBack(ClosedCallBackEvent evt) {
        BigDecimal postUpdate = (BigDecimal)evt.getReturnData();
        if (postUpdate == null) {
            return;
        }
        String selectPayRecordId = this.getPageCache().get("selectPayRecordId");
        DynamicObject updateObj = BusinessDataServiceHelper.loadSingle((Object)selectPayRecordId, (String)"bdtaxr_pay_record");
        BigDecimal updateNum = postUpdate.subtract(updateObj.getBigDecimal(YJJE));
        updateObj.set(YJJE, (Object)postUpdate);
        updateObj.set("syqjje", (Object)postUpdate);
        this.updatePayRecordEntryentity(updateObj);
        DynamicObject[] anotherDeferPartList = this.getAnotherDeferPart(updateObj, updateObj.getBigDecimal(JKBL));
        if (anotherDeferPartList.length == 0) {
            return;
        }
        DynamicObject anotherDeferPart = BusinessDataServiceHelper.loadSingle((Object)anotherDeferPartList[0].get("id"), (String)"bdtaxr_pay_record");
        anotherDeferPart.set(YJJE, (Object)anotherDeferPart.getBigDecimal(YJJE).subtract(updateNum));
        anotherDeferPart.set("syqjje", (Object)anotherDeferPart.getBigDecimal("syqjje").subtract(updateNum));
        this.updatePayRecordEntryentity(anotherDeferPart);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateObj, anotherDeferPart});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPayDateConfirmCallBack(ClosedCallBackEvent evt) {
        String appId = this.getView().getFormShowParameter().getAppId();
        Date payDate = (Date)evt.getReturnData();
        if (payDate == null) {
            return;
        }
        CopyOnWriteArrayList locks = new CopyOnWriteArrayList();
        List selectRows = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectRows"), List.class);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(selectRows.size());
        selectRows = selectRows.stream().filter(s -> this.tryLock(locks, s.get("id"))).collect(Collectors.toList());
        try {
            for (Map row : selectRows) {
                String paystatus = (String)row.get(PAYSTATUS);
                if (PAYED.equals(paystatus)) continue;
                DynamicObject dyo = BusinessDataServiceHelper.loadSingle(row.get("id"), (String)"bdtaxr_pay_record");
                BigDecimal yjje = dyo.getBigDecimal(YJJE);
                dyo.set(PAYSTATUS, (Object)PAYED);
                dyo.set("sjje", (Object)yjje);
                dyo.set("syqjje", (Object)dyo.getBigDecimal(YJJE).subtract(dyo.getBigDecimal("sjje")));
                dyo.set("payer", (Object)RequestContext.get().getCurrUserId());
                dyo.set("paydate", (Object)payDate);
                dyo.set("entrydate", (Object)payDate);
                this.updatePayRecordEntryentity(dyo);
                PayRecordUtils.setZnj((DynamicObject)dyo);
                updateList.add(dyo);
            }
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            this.updateSbbData(appId, updateList, PAY);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u7f34\u6b3e\u6210\u529f\u3002", (String)"PayRecordQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.calcElement(updateList, PAY);
        }
        finally {
            locks.forEach(lock -> Optional.ofNullable(lock).ifPresent(r -> r.unlock()));
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void doApplyPayCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData != null) {
            this.getView().showSuccessNotification((String)returnData);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void toDeclare(HyperLinkClickArgs args) {
        String appId = this.getView().getFormShowParameter().getAppId();
        String version = TaxDeclareRouteHelper.getDeclareRouteOfApp((String)appId);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject pay = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"bdtaxr_pay_record");
        if ("3.0".equals(version)) {
            block4: {
                try {
                    DynamicObject nxx = BusinessDataServiceHelper.loadSingle((Object)pay.getString(SBBID), (String)"tpo_declare_main_tsc");
                    this.setParams(nxx, customParams);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    DynamicObject nxx = BusinessDataServiceHelper.loadSingle((Object)pay.getString(SBBID), (String)"tcvat_nsrxx");
                    if (nxx == null) break block4;
                    this.getView().showTipNotification("need upgrade declare data from 2.0 to 3.0");
                }
            }
            return;
        }
        if (pay.getString("nsrtype").equals("totf_cjrjybzj")) {
            DynamicObject nxx = BusinessDataServiceHelper.loadSingle((Object)pay.getString(SBBID), (String)"tpo_declare_main_tsc");
            this.setParams(nxx, customParams);
            return;
        }
        DeclarePageOpenHelper.linkDeclarePageByPkId((IFormView)this.getView(), (Object)pay.get(SBBID));
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus) {
        String appId = this.getView().getFormShowParameter().getAppId();
        String version = TaxDeclareRouteHelper.getDeclareRouteOfApp((String)appId);
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("3.0".equals(version) && (templateEnum == TemplateEnum.KJQYSDS || templateEnum == TemplateEnum.DKDJ)) {
            if ("declared".equals(declarestatus)) {
                param.setFormId("multi_declare_show");
                param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            } else {
                String declarePage = templateEnum.getDeclarePage();
                TaxDeclareMetaRouteEnum metaRouteEnum = TaxDeclareMetaRouteEnum.getEnumByDeclarePage((String)declarePage);
                if (metaRouteEnum == null) {
                    param.setFormId(declarePage);
                } else {
                    param.setFormId(TaxDeclareRouteHelper.getCurrentShowMeta((String)metaRouteEnum.getName()));
                }
            }
        } else if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private List<DynamicObject> getSelectRowDatas() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        return Arrays.asList(BusinessDataServiceHelper.load((Object[])selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdtaxr_pay_record")));
    }

    private void showMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(SEPARATOR);
            if (messages.length == 1) {
                this.getView().showErrorNotification(message.toString());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private void updateSbbData(String appId, List<DynamicObject> selectRows, String operateKey) {
        Map<Long, DynamicObject> sbbEntryMap = null;
        if ("tcvat".equals(appId)) {
            DynamicObject[] sbbEntry = BusinessDataServiceHelper.load((Object[])selectRows.stream().map(e -> e.get(SBBENTRYID)).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_declare_entry"));
            sbbEntryMap = Stream.of(sbbEntry).collect(Collectors.toMap(d -> d.getLong("id"), d -> d, (v1, v2) -> v1));
        }
        DynamicObject[] sbbDatas = BusinessDataServiceHelper.load((Object[])selectRows.stream().map(e -> e.getLong(SBBID)).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
        Map<Long, DynamicObject> sbbMap = Stream.of(sbbDatas).collect(Collectors.toMap(d -> d.getLong("id"), d -> d, (v1, v2) -> v1));
        if (selectRows != null && selectRows.size() > 0) {
            for (DynamicObject row : selectRows) {
                QFilter payStatusFilter;
                long sbbId = row.getLong(SBBID);
                DynamicObject sbbData = sbbMap.get(sbbId);
                if (sbbEntryMap != null) {
                    long sbbentryid = row.getLong(SBBENTRYID);
                    this.updateSbbAmt(sbbEntryMap.get(sbbentryid), SBBENTRYID, "bqdybtse");
                } else {
                    this.updateSbbAmt(sbbData, SBBID, "bqybtse");
                }
                if (sbbData == null) continue;
                if (PAY.equals(operateKey)) {
                    payStatusFilter = new QFilter(PAYSTATUS, "=", (Object)"2");
                    sbbData.set("payer", (Object)RequestContext.get().getCurrUserId());
                    sbbData.set("paydate", (Object)row.getDate("paydate"));
                } else {
                    payStatusFilter = new QFilter(PAYSTATUS, "=", (Object)PAYED);
                }
                DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bdtaxr_pay_record", (String)"id,sbbid,paydate", (QFilter[])new QFilter[]{new QFilter(SBBID, "=", (Object)String.valueOf(sbbId)), payStatusFilter}, (String)"paydate desc");
                boolean exists = rows.hasNext();
                if (exists) {
                    sbbData.set(PAYSTATUS, (Object)"partpaid");
                    Date paydate = rows.next().getDate("paydate");
                    if (paydate == null) continue;
                    sbbData.set("paydate", (Object)paydate);
                    continue;
                }
                sbbData.set(PAYSTATUS, (Object)(PAY.equals(operateKey) ? "paid" : "unpaid"));
                if (!"unpay".equals(operateKey)) continue;
                sbbData.set("payer", null);
                sbbData.set("paydate", null);
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject[])sbbMap.values().toArray(new DynamicObject[0]));
                if (sbbEntryMap != null) {
                    SaveServiceHelper.update((DynamicObject[])sbbEntryMap.values().toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e2) {
                h.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u7f34\u6b3e\u5931\u8d25", (String)"PayRecordQueryListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                logger.error("taxc-DeferPayRptPlugin pay fail:", (Object)e2.getMessage());
            }
        }
    }

    private void updateSbbAmt(DynamicObject sbbData, String sbbIdName, String ybtseName) {
        if (sbbData != null) {
            Object id = SBBID.equals(sbbIdName) ? sbbData.getString("id") : Long.valueOf(sbbData.getLong("id"));
            DynamicObject sjjeSum = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"sum(sjje) as sjje", (QFilter[])new QFilter[]{new QFilter(sbbIdName, "=", id)});
            BigDecimal sjje = sjjeSum.getBigDecimal("sjje");
            BigDecimal ybtse = sbbData.getBigDecimal(ybtseName);
            sbbData.set("sjje", (Object)sjje);
            sbbData.set("qjje", (Object)ybtse.subtract(sjje));
        }
    }

    private void calcElement(List<DynamicObject> updateList, String act) {
        for (DynamicObject dyo : updateList) {
            Long sbbid = dyo.getLong(SBBID);
            BigDecimal sjje = dyo.getBigDecimal("sjje");
            String taxtype = dyo.getString(TAXTYPE);
            Date paydate = "cancelpay".equals(act) ? DateUtils.stringToDate((String)this.getPageCache().get(sbbid.toString())) : dyo.getDate("paydate");
            Date skssqq = DateUtils.getFirstDateOfMonth((Date)paydate);
            Date skssqz = DateUtils.getLastDateOfMonth((Date)paydate);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
            DeclareMQSender.sendMQ((DynamicObject)dynamicObject, (Date)skssqq, (Date)skssqz, (BigDecimal)sjje, (Date)paydate, (String)taxtype, (String)DeclareMQType.PAY.name(), (String)act);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancelPayBtn(String appId) {
        List<DynamicObject> selectRows = this.getSelectRowDatas();
        if (selectRows.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"PayRecordQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        CopyOnWriteArrayList locks = new CopyOnWriteArrayList();
        List ids = selectRows.stream().filter(s -> this.tryLock(locks, s.getLong("id"))).collect(Collectors.toList());
        try {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(selectRows.size());
            StringBuilder message = new StringBuilder();
            for (DynamicObject selectRow : selectRows) {
                String paystatus = selectRow.getString(PAYSTATUS);
                String taxperiod = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"PayRecordQueryListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), DateUtils.format((Date)selectRow.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE), DateUtils.format((Date)selectRow.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE));
                String type = selectRow.getString("nsrtype");
                String taxtypes = this.getEntryTaxType(selectRow);
                if ("2".equals(paystatus)) {
                    message.append(String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s%4$s\u672a\u7f34\u6b3e\uff0c\u65e0\u9700\u53d6\u6d88\u7f34\u6b3e", (String)"PayRecordQueryListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append(SEPARATOR);
                    continue;
                }
                String operateName = ResManager.loadKDString((String)"\u53d6\u6d88\u7f34\u6b3e", (String)"PayRecordQueryListPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u8bf7\u8868,\u53d6\u6d88\u7f34\u6b3e\u6210\u529f", (String)"PayRecordQueryListPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("billno"));
                OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"bdtaxr_deferpay_rpt", (String)operateName, (String)operateDescription);
                DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)selectRow.get("id"), (String)"bdtaxr_pay_record");
                this.getPageCache().put(dyo.getString(SBBID), dyo.getString("paydate"));
                dyo.set(PAYSTATUS, (Object)"2");
                dyo.set("sjje", (Object)BigDecimal.ZERO);
                dyo.set("syqjje", (Object)dyo.getBigDecimal(YJJE).subtract(dyo.getBigDecimal("sjje")));
                dyo.set("payer", null);
                dyo.set("paydate", null);
                dyo.set("entrydate", null);
                this.updatePayRecordEntryentity(dyo);
                PayRecordUtils.setZnj((DynamicObject)dyo);
                updateList.add(dyo);
            }
            if (message.length() == 0) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
                this.updateSbbData(appId, selectRows, "unpay");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u7f34\u6b3e\u6210\u529f\u3002", (String)"PayRecordQueryListPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                this.calcElement(updateList, "cancelpay");
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
            } else {
                this.showMessage(message);
            }
        }
        finally {
            locks.forEach(lock -> Optional.ofNullable(lock).ifPresent(r -> r.unlock()));
        }
        this.clearSelect();
    }

    private String getEntryTaxType(DynamicObject selectRow) {
        DynamicObject nsrEntry = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"entryentity.id as entryid,entryentity.taxtypes as taxtypes,entryentity.bqdybtse as bqdybtse", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", (Object)selectRow.getLong(SBBENTRYID))});
        return nsrEntry == null ? "" : nsrEntry.getString("taxtypes");
    }

    private void doPayBtn(String appId) {
        List<DynamicObject> selectRows = this.getSelectRowDatas();
        if (selectRows.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"PayRecordQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        BigDecimal yjjehj = BigDecimal.ZERO;
        StringBuilder message = new StringBuilder();
        for (DynamicObject selectRow : selectRows) {
            String paystatus = selectRow.getString(PAYSTATUS);
            String taxperiod = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"PayRecordQueryListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), DateUtils.format((Date)selectRow.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE), DateUtils.format((Date)selectRow.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE));
            String type = selectRow.getString("nsrtype");
            String taxtypes = this.getEntryTaxType(selectRow);
            if (PAYED.equals(paystatus)) {
                message.append(String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s%4$s\u5df2\u786e\u8ba4\u7f34\u6b3e\uff0c\u65e0\u9700\u518d\u7f34\u6b3e", (String)"PayRecordQueryListPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append(SEPARATOR);
                continue;
            }
            String operateName = ResManager.loadKDString((String)"\u786e\u8ba4\u7f34\u6b3e", (String)"PayRecordQueryListPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u8bf7\u8868,\u786e\u8ba4\u7f34\u6b3e\u6210\u529f", (String)"PayRecordQueryListPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("billno"));
            OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"bdtaxr_deferpay_rpt", (String)operateName, (String)operateDescription);
            yjjehj = yjjehj.add(selectRow.getBigDecimal(YJJE));
        }
        if (message.length() == 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(PAY, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%1$s\u6761\u5f85\u7f34\u6b3e\u8bb0\u5f55\uff0c\u5e94\u7f34\u91d1\u989d\u5408\u8ba1\u4e3a%2$s\u5143\uff0c\u662f\u5426\u786e\u8ba4\u7f34\u6b3e\uff1f", (String)"PayRecordQueryListPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRows.size(), yjjehj.setScale(2, RoundingMode.HALF_UP));
            this.getView().showConfirm(msg, options, confirmCallBacks);
        } else {
            this.showMessage(message);
        }
    }

    private void doCancelDeferBtn(String appId) {
        List<DynamicObject> selectRows = this.getSelectRowDatas();
        if (selectRows.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"PayRecordQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        StringBuilder message = new StringBuilder();
        for (DynamicObject selectRow : selectRows) {
            long sbbid = selectRow.getLong(SBBID);
            QFilter sbbidFilter = new QFilter(SBBID, "=", (Object)String.valueOf(sbbid));
            boolean exists = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidFilter, new QFilter(PAYSTATUS, "=", (Object)PAYED)});
            String taxperiod = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"PayRecordQueryListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), DateUtils.format((Date)selectRow.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE), DateUtils.format((Date)selectRow.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE));
            String type = selectRow.getString("nsrtype");
            String taxtypes = this.getEntryTaxType(selectRow);
            if (exists) {
                errMsg.append(String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s%4$s\u5df2\u786e\u8ba4\u7f34\u6b3e\uff0c\u4e0d\u80fd\u53d6\u6d88\u7533\u8bf7", (String)"PayRecordQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append(SEPARATOR);
                continue;
            }
            QFilter voucherFilter = new QFilter(ISVOUCHER, "=", (Object)PAYED);
            boolean isvoucher = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidFilter, voucherFilter});
            if (isvoucher) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u751f\u6210\u51ed\u8bc1\u7684\u6570\u636e\u53ef\u8fdb\u884c\u53d6\u6d88\u7533\u62a5\u64cd\u4f5c\uff1a%1$s%2$s%3$s%4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"PayRecordQueryListPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append(SEPARATOR);
                continue;
            }
            String operateName = ResManager.loadKDString((String)"\u53d6\u6d88\u7533\u8bf7", (String)"PayRecordQueryListPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u8bf7\u8868,\u53d6\u6d88\u7533\u8bf7\u6210\u529f", (String)"PayRecordQueryListPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectRow.getString("billno"));
            OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"bdtaxr_deferpay_rpt", (String)operateName, (String)operateDescription);
            message.append(String.format("%s%s%s%s", selectRow.getString("org.name"), taxperiod, TaxTypeUtils.getTaxTypeName((String)type, (String)taxtypes), TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""))).append('\n');
        }
        if (errMsg.length() == 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("unapply", (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String title = ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88\u7f13\u7f34\u7533\u8bf7\uff1f", (String)"PayRecordQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            this.getView().showConfirm(title, message.substring(0, message.length() - 1), options, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.showMessage(errMsg);
        }
    }

    private void clearSelect() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList != null) {
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void doDeferBtn(String appId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_deferpay_dialog");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setShowTitle(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "applypay");
        showParameter.setCloseCallBack(closeCallBack);
        String operateName = ResManager.loadKDString((String)"\u7533\u8bf7\u7f13\u7f34", (String)"PayRecordQueryListPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f13\u7f34\u7533\u8bf7\u9875\u9762\u6253\u5f00\u6210\u529f", (String)"PayRecordQueryListPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]), new Object[0]);
        OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"bdtaxr_deferpay_rpt", (String)operateName, (String)operateDescription);
        this.getView().showForm(showParameter);
    }

    private DynamicObject[] getAnotherDeferPart(DynamicObject rowData, BigDecimal jkbl) {
        QFilter sbbidFilter = new QFilter(SBBID, "=", (Object)rowData.getString(SBBID));
        QFilter sbbentryidFilter = new QFilter(SBBENTRYID, "=", (Object)rowData.getLong(SBBENTRYID));
        QFilter taxtypeFilter = new QFilter(TAXTYPE, "=", (Object)rowData.getString(TAXTYPE));
        QFilter jkblFilter = new QFilter(JKBL, "=", (Object)BigDecimal.ONE.subtract(jkbl));
        QFilter billnoFilter = new QFilter("billno", "!=", (Object)rowData.getString("billno"));
        return BusinessDataServiceHelper.load((String)"bdtaxr_pay_record", (String)"id,paystatus,yjje,syqjje", (QFilter[])new QFilter[]{sbbidFilter, sbbentryidFilter, taxtypeFilter, jkblFilter, billnoFilter});
    }

    private void toYjjeUpdate(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow row = list.getCurrentSelectedRowInfo();
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bdtaxr_pay_record");
        BigDecimal yjje = dyo.getBigDecimal(YJJE);
        HashMap<String, BigDecimal> customParams = new HashMap<String, BigDecimal>(16);
        DynamicObject[] anotherDeferPartList = this.getAnotherDeferPart(dyo, dyo.getBigDecimal(JKBL));
        if (anotherDeferPartList.length > 0) {
            customParams.put("otheryjje", anotherDeferPartList[0].getBigDecimal(YJJE));
        }
        customParams.put(YJJE, yjje);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bdtaxr_deferpay_yjje_edit");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "yjjeUpdate");
        param.setCloseCallBack(closeCallBack);
        param.setCaption(ResManager.loadKDString((String)"\u5c3e\u6570\u8c03\u6574", (String)"PayRecordQueryListPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.NonModal);
        this.getView().showForm(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConfirmCancelDefer(String appId) {
        List<DynamicObject> selectRows = this.getSelectRowDatas();
        CopyOnWriteArrayList locks = new CopyOnWriteArrayList();
        List<Long> sbbIds = selectRows.stream().map(e -> e.getLong(SBBID)).collect(Collectors.toList());
        List ids = selectRows.stream().filter(e -> this.tryLock(locks, e.getLong("id"))).collect(Collectors.toList());
        try {
            DynamicObject[] updateDatas;
            String amtKey;
            QFilter[] applyfilters;
            QFilter[] recordfilters;
            if ("tcvat".equals(appId)) {
                List sbbEntryIds = selectRows.stream().map(e -> e.get(SBBENTRYID)).collect(Collectors.toList());
                recordfilters = new QFilter[]{new QFilter(SBBENTRYID, "in", sbbEntryIds)};
                DynamicObjectCollection hjsqid = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)HJSQID, (QFilter[])recordfilters);
                List hjsqIds = hjsqid.stream().map(e -> e.get(HJSQID)).collect(Collectors.toList());
                applyfilters = new QFilter[]{new QFilter("id", "in", hjsqIds)};
                amtKey = "bqdybtse";
                updateDatas = BusinessDataServiceHelper.load((Object[])sbbEntryIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_declare_entry"));
            } else {
                recordfilters = new QFilter[]{new QFilter(SBBID, "in", (Object)sbbIds.stream().map(String::valueOf).toArray())};
                DynamicObject[] hjsqid = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)HJSQID, (QFilter[])recordfilters);
                List hjsqIds = hjsqid.stream().map(e -> e.get(HJSQID)).collect(Collectors.toList());
                applyfilters = new QFilter[]{new QFilter("id", "in", hjsqIds)};
                amtKey = "bqybtse";
                updateDatas = BusinessDataServiceHelper.load((Object[])sbbIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
            }
            for (DynamicObject updateData : updateDatas) {
                updateData.set("deferpayapply", (Object)Boolean.FALSE);
                updateData.set("sjje", (Object)BigDecimal.ZERO);
                updateData.set("qjje", updateData.get(amtKey));
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    DeleteServiceHelper.delete((String)"bdtaxr_pay_record", (QFilter[])recordfilters);
                    DeleteServiceHelper.delete((String)"bdtaxr_deferpay_apply", (QFilter[])applyfilters);
                    SaveServiceHelper.update((DynamicObject[])updateDatas);
                    DeclarePayHelper.manualDeclare(sbbIds);
                }
                catch (Exception e2) {
                    h.markRollback();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u7533\u8bf7\u5931\u8d25", (String)"PayRecordQueryListPlugin_20", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    logger.error("taxc-DeferPayRptPlugin unapply fail:", (Object)e2.getMessage());
                }
            }
        }
        finally {
            locks.forEach(lock -> Optional.ofNullable(lock).ifPresent(r -> r.unlock()));
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void doConfirmPay() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bdtaxr_paydate_confirm");
        param.getOpenStyle().setShowType(ShowType.NonModal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
        this.getPageCache().put("selectRows", SerializationUtils.toJsonString(this.getSelectRowDatas()));
    }

    private void updatePayRecordEntryentity(DynamicObject payRecord) {
        String payStatus = payRecord.getString(PAYSTATUS);
        DynamicObjectCollection entryentity = payRecord.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            for (DynamicObject dynamicObject : entryentity) {
                BigDecimal yjjemx;
                if (PAYED.equals(payStatus)) {
                    yjjemx = dynamicObject.getBigDecimal("yjjemx");
                    dynamicObject.set("sjjemx", (Object)yjjemx);
                    dynamicObject.set("syqjjemx", (Object)BigDecimal.ZERO);
                    continue;
                }
                yjjemx = dynamicObject.getBigDecimal("yjjemx");
                dynamicObject.set("syqjjemx", (Object)yjjemx);
                dynamicObject.set("sjjemx", (Object)BigDecimal.ZERO);
            }
        }
    }

    private void setParams(DynamicObject nxx, Map<String, Object> customParams) {
        customParams.put("billno", nxx.get("billno"));
        DynamicObject taxauthority = nxx.getDynamicObject("taxauthority");
        if (null != taxauthority) {
            customParams.put("taxauthority", taxauthority.get("id"));
        } else {
            customParams.put("taxauthority", 0L);
        }
        DynamicObject templatetype = (DynamicObject)nxx.get("templatetype");
        String type = templatetype.getString("number");
        customParams.put(SBBID, nxx.getString("id"));
        customParams.put("orgid", nxx.getDynamicObject("org").getString("id"));
        customParams.put("taxorg", nxx.getDynamicObject("org").getString("id"));
        customParams.put("orgname", nxx.getDynamicObject("org").getString("name"));
        Date skssqq = nxx.getDate("skssqq");
        Date skssqz = nxx.getDate("skssqz");
        customParams.put("type", type);
        customParams.put("templatetype", type);
        customParams.put("taxPayerType", type);
        customParams.put("tcrettype", nxx.getString("tcrettype"));
        customParams.put("apanage", nxx.getString("apanage"));
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("taxlimit", DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
        customParams.put("taxperiod", startDate.substring(0, 7));
        customParams.put("readonly", Boolean.TRUE);
        customParams.put("from", "history");
        customParams.put("modifytime", nxx.getDate("modifytime"));
        String declarestatus = nxx.getString("declarestatus");
        String dataType = nxx.getString("datatype");
        customParams.put("datatype", dataType);
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get("orgid"))));
        requestModel.setTemplateType(type);
        requestModel.setId(Long.valueOf(nxx.getLong("id")));
        requestModel.setSkssqq(DateUtils.format((Date)nxx.getDate("skssqq")));
        requestModel.setSkssqz(DateUtils.format((Date)nxx.getDate("skssqz")));
        requestModel.setModelId(MultiDiConstant.DEFAULT_MODEL);
        requestModel.setOperation("read");
        requestModel.setRefresh(Boolean.FALSE);
        requestModel.addBusinessValue("maindataid", requestModel.getId().toString());
        requestModel.addBusinessValue("declaremonth", (String)customParams.get("skssqq"));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, declarestatus);
    }

    private boolean tryLock(List<DLock> locks, Object id) {
        DLock lock = DLock.create((String)id.toString());
        if (lock.tryLock(30000L)) {
            locks.add(lock);
            return true;
        }
        return false;
    }

    static {
        TAXTYPE_MAP.put("tcvat", TCVAT_TAXTYPE);
        TAXTYPE_MAP.put("tccit", TCCIT_TAXTYPE);
        TAXTYPE_MAP.put("tcret", TCRET_TAXTYPE);
        TAXTYPE_MAP.put("totf", TOTF_TAXTYPE);
        TAXTYPE_MAP.put("tcnfep", TCNFEP_TAXTYPE);
    }
}

