/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.pay.DeclarePayHelper;
import kd.taxc.bdtaxr.common.enums.CalendarTaxType;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;

public class SelectSbbDialogPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btok"});
    }

    public void afterCreateNewData(EventObject evt) {
        DynamicObjectCollection query;
        QFilter isApplyDeferPayFilter;
        List allSbbEntryIds;
        List allSbbIds;
        FormShowParameter param = this.getView().getFormShowParameter();
        String appId = param.getAppId();
        List list = TaxTypeUtils.getTemplateTypeList((String)appId, (String)((String)param.getCustomParam("taxtype")));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter typeFilter = new QFilter("type", "in", (Object)list);
        filters.add(typeFilter);
        QFilter decareStatusFilter = new QFilter("declarestatus", "=", (Object)"declared");
        filters.add(decareStatusFilter);
        QFilter payStatusFilter = new QFilter("paystatus", "in", (Object)new String[]{"unpaid", "partpaid"});
        filters.add(payStatusFilter);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"bdtaxr", (String)"bdtaxr_pay_record", (String)"23PSLFCF0RXC");
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            List orgList = hasPermOrgResult.getHasPermOrgs();
            QFilter orgFilter = new QFilter("org", "in", (Object)orgList);
            filters.add(orgFilter);
        }
        if ((allSbbIds = (List)param.getCustomParam("allSbbIds")) != null && !allSbbIds.isEmpty()) {
            filters.add(new QFilter("id", "in", (Object)allSbbIds));
        }
        if ((allSbbEntryIds = (List)param.getCustomParam("allSbbEntryIds")) != null && !allSbbEntryIds.isEmpty()) {
            filters.add(new QFilter("entryentity.id", "in", (Object)allSbbEntryIds));
        }
        List<Object> data = new ArrayList(16);
        if ("tcvat".equals(appId)) {
            isApplyDeferPayFilter = new QFilter("entryentity.deferpayapply1", "=", (Object)Boolean.FALSE);
            filters.add(isApplyDeferPayFilter);
            query = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,org,skssqq,skssqz,type,taxlimit,bqybtse,entryentity.id as entryid,entryentity.taxtypes as taxtypes,entryentity.bqdybtse as bqdybtse,entryentity.deferpayapply1 as deferpayapply", (QFilter[])filters.toArray(new QFilter[0]), (String)"org,skssqq,entryentity.taxtypes");
            for (DynamicObject d2 : query) {
                String type = d2.getString("type");
                String taxtypes = d2.getString("taxtypes");
                String taxType = TaxTypeUtils.getTaxType((String)type, (String)taxtypes);
                if (CalendarTaxType.FJSF.getType().equals(taxType)) {
                    boolean deferpayapply = d2.getBoolean("deferpayapply");
                    for (String taxtype : TaxTypeUtils.FJSF_SPLIT) {
                        BigDecimal ybtse;
                        boolean exists;
                        long entryid = d2.getLong("entryid");
                        if (deferpayapply && (exists = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{new QFilter("sbbentryid", "=", (Object)entryid), new QFilter("taxtype", "=", (Object)taxtype), new QFilter("hjsqid", ">", (Object)0)})) || BigDecimal.ZERO.compareTo(ybtse = DeclarePayHelper.queryFjsfSubAmt(d2.getString("id"), taxtype, type)) >= 0) continue;
                        data.add(DeclarePayHelper.packDeferApplyShowData(d2, ybtse, entryid, taxtype));
                    }
                    continue;
                }
                BigDecimal bqdybtse = d2.getBigDecimal("bqdybtse");
                if (BigDecimal.ZERO.compareTo(bqdybtse) >= 0) continue;
                data.add(DeclarePayHelper.packDeferApplyShowData(d2, bqdybtse, d2.getLong("entryid"), taxType));
            }
        } else {
            isApplyDeferPayFilter = new QFilter("deferpayapply", "=", (Object)Boolean.FALSE);
            filters.add(isApplyDeferPayFilter);
            query = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,org,skssqq,skssqz,type,taxlimit,bqybtse", (QFilter[])filters.toArray(new QFilter[0]), (String)"skssqq");
            data = query.stream().map(d -> DeclarePayHelper.packDeferApplyShowData(d, d.getBigDecimal("bqybtse"), 0L, TaxTypeUtils.getTaxType((String)d.getString("type"), null))).collect(Collectors.toList());
        }
        IDataModel model = this.getModel();
        model.clearNoDataRow();
        if (data != null && data.size() > 0) {
            List sbbIds = (List)param.getCustomParam("sbbIds");
            List sbbEntryIds = (List)param.getCustomParam("sbbEntryIds");
            ArrayList<Integer> selectRows = null;
            if (sbbIds != null) {
                selectRows = new ArrayList<Integer>(sbbIds.size());
            } else if (sbbEntryIds != null) {
                selectRows = new ArrayList(sbbEntryIds.size());
            }
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", data.size());
            for (int i = 0; i < data.size(); ++i) {
                JSONObject dyo = (JSONObject)data.get(i);
                long sbbid = dyo.getLong("sbbid");
                long sbbEntryId = dyo.getLong("sbbentryid");
                if (selectRows != null) {
                    if ("tcvat".equals(appId)) {
                        if (sbbEntryIds != null && sbbEntryIds.contains(sbbEntryId)) {
                            selectRows.add(i);
                        }
                    } else if (sbbIds != null && sbbIds.contains(sbbid)) {
                        selectRows.add(i);
                    }
                }
                model.setValue("sbbid", (Object)sbbid, i);
                model.setValue("sbbentryid", (Object)sbbEntryId, i);
                model.setValue("org", dyo.get((Object)"org"), i);
                model.setValue("taxperiod", dyo.get((Object)"taxperiod"), i);
                model.setValue("taxtype", dyo.get((Object)"taxtype"), i);
                model.setValue("type", dyo.get((Object)"type"), i);
                model.setValue("taxlimit", dyo.get((Object)"taxlimit"), i);
                model.setValue("ybtse", dyo.get((Object)"ybtse"), i);
            }
            model.endInit();
            param.setCustomParam("selectRows", selectRows);
        }
        this.getView().updateView("entryentity");
    }

    public void afterBindData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        List selectRows = (List)param.getCustomParam("selectRows");
        if (selectRows != null) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int[] selected = selectRows.stream().mapToInt(Integer::intValue).toArray();
            if (selected.length > 0) {
                entryentity.selectRows(selected, selected[0]);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Button)evt.getSource()).getKey();
        if ("btok".equals(key)) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryentity.getSelectRows();
            if (selectRows.length > 0) {
                ArrayList<DynamicObject> returnData = new ArrayList<DynamicObject>(selectRows.length);
                String uniqueKey = null;
                for (int selectRow : selectRows) {
                    DynamicObject data = this.getModel().getEntryRowEntity("entryentity", selectRow);
                    String orgId = data.getString("org.id");
                    String taxperiod = data.getString("taxperiod");
                    if (uniqueKey == null) {
                        uniqueKey = orgId + taxperiod;
                    } else if (!uniqueKey.equals(orgId + taxperiod)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3001\u6240\u5c5e\u7a0e\u671f\u76f8\u540c\u7684\u7533\u62a5\u8bb0\u5f55", (String)"SelectSbbDialogPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        return;
                    }
                    returnData.add(data);
                }
                this.getView().returnDataToParent(returnData);
            }
            this.getView().close();
        }
    }
}

