/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.draft.drill;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchService;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceHandler;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.rulefetch.QueryRuleFetchParam;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.datadetails.DataDetailsOpenUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class RuleFetchDrillPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
RuleFetchConstant,
HyperLinkClickListener {
    private static final String CARD_ENTRY_ENTITY = "cardentryentity";
    private static final String DETAIL_ENTRY_ENTITY = "detailentryentity";
    private static final String EDIT_ENTRY_ENTITY = "editentryentity";
    private static final String[] CARD_EDIT_FIELDS = new String[]{"cardamount", "cardadjustamount", "cardtotalamount", "cardadjustexplain"};
    private static RuleFetchService ruleFetchService = new RuleFetchServiceImpl();

    public void initialize() {
        CardEntry cardEntry = (CardEntry)this.getControl(CARD_ENTRY_ENTITY);
        cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
        EntryGrid detailentry = (EntryGrid)this.getControl(DETAIL_ENTRY_ENTITY);
        detailentry.addHyperClickListener((HyperLinkClickListener)this);
        detailentry.addPackageDataListener(a -> this.packageData((PackageDataEvent)a));
    }

    private void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        String columnDescKey = columnDesc.getKey();
        if (columnDescKey.equals("fetchamount") && this.isNotLink()) {
            ArrayList<String> nolinks = new ArrayList<String>(4);
            nolinks.add("fetchamount");
            e.setNoLinkKey(nolinks);
        }
    }

    private boolean isNotLink() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return appId != null && NOT_LINK_LIST.contains(appId);
    }

    private void setVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"fetchtype"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String operation = (String)customParams.get("operation");
        String drillDetailReadOnlyStr = (String)customParams.get("locked");
        boolean drillDetailReadOnly = StringUtil.isEmpty((CharSequence)drillDetailReadOnlyStr) ? Boolean.TRUE : !Boolean.parseBoolean(drillDetailReadOnlyStr);
        switch (operation) {
            case "read": {
                this.enableCard(false);
                break;
            }
            case "edit": {
                this.enableCard(drillDetailReadOnly);
                break;
            }
            default: {
                this.enableCard(drillDetailReadOnly);
            }
        }
    }

    private void enableCard(boolean enable) {
        DynamicObjectCollection cards = this.getModel().getEntryEntity(CARD_ENTRY_ENTITY);
        if (!CollectionUtils.isEmpty((Collection)cards)) {
            for (int i = 0; i < cards.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(enable), i, CARD_EDIT_FIELDS);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject summaryObj = this.doQuerySummaryObj(this.getView().getFormShowParameter().getCustomParams());
        if (summaryObj == null) {
            this.doAddAndShowManualCard();
            this.setVisible();
            return;
        }
        this.doDrawLeftCard(summaryObj);
        if (!CollectionUtils.isEmpty((Collection)summaryObj.getDynamicObjectCollection(CARD_ENTRY_ENTITY))) {
            this.doDrawRightFetchDetail((DynamicObject)summaryObj.getDynamicObjectCollection(CARD_ENTRY_ENTITY).get(0));
        }
        this.doDrawSumAmount(summaryObj);
        this.doSetEditRecord(summaryObj);
        this.setVisible();
    }

    public void afterBindData(EventObject e) {
        CardEntry entryentitycard = (CardEntry)this.getControl(CARD_ENTRY_ENTITY);
        entryentitycard.selectCard(Integer.valueOf(0));
        entryentitycard.selectRowsChanged(Collections.singletonList(0), null);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List rows = evt.getNewRows();
        DynamicObjectCollection cardCollect = this.getModel().getEntryEntity(CARD_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)rows) || CollectionUtils.isEmpty((Collection)cardCollect)) {
            return;
        }
        if (cardCollect.size() - 1 == (Integer)rows.get(0)) {
            this.clearEntry(DETAIL_ENTRY_ENTITY);
            return;
        }
        this.clearEntry(DETAIL_ENTRY_ENTITY);
        DynamicObject summary = this.doQuerySummaryObj(this.getView().getFormShowParameter().getCustomParams());
        if (summary == null) {
            return;
        }
        Optional<DynamicObject> cardIdOp = summary.getDynamicObjectCollection(CARD_ENTRY_ENTITY).stream().filter(c -> c.getLong("id") == ((DynamicObject)cardCollect.get(((Integer)rows.get(0)).intValue())).getLong("cardid")).findFirst();
        if (cardIdOp.isPresent()) {
            this.doDrawRightFetchDetail(cardIdOp.get());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            if ("save".equals(operateKey)) {
                this.doSaveOperate();
            } else if ("export".equals(operateKey)) {
                this.doExportOperate();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("cardadjustamount".equals(name) || "cardtotalamount".equals(name)) {
            this.cardAmountChanged(name, changeData, rowIndex);
        } else if ("sumlastamount".equals(name)) {
            // empty if block
        }
    }

    public void showDetailDialog(String cellid, JSONObject params, IFormView view, IFormPlugin plugin) {
        String replaceCellId = cellid.replace("#", "_");
        IPageCache childPageCache = view.getPageCache();
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        if (!CollectionUtils.isEmpty((Map)updateMap) && updateMap.containsKey(replaceCellId)) {
            params.put("cellvalue", (Object)updateMap.get(replaceCellId).toString());
        }
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)32);
        Map viewParams = view.getFormShowParameter().getCustomParams();
        DeclareRequestModel declareModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)((String)viewParams.get("declareRequestData")), DeclareRequestModel.class);
        customParams.put("org", declareModel.getOrgId().toString());
        customParams.put("skssqq", declareModel.getSkssqq());
        customParams.put("skssqz", declareModel.getSkssqz());
        customParams.put("operation", params.getString("operation"));
        for (Map.Entry entry : params.entrySet()) {
            customParams.put(entry.getKey(), entry.getValue());
        }
        customParams.put("cellid", cellid);
        customParams.put("fromForm", "bdtaxr_rule_fetch_dialog");
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bdtaxr_rule_fetch_dialog");
        param.setCustomParams((Map)customParams);
        if (customParams.get("customCaption") != null) {
            param.setCaption((String)customParams.get("customCaption"));
        }
        param.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "cell_click_popup");
        param.setCloseCallBack(closeCallBack);
        view.showForm(param);
    }

    private DynamicObject doQuerySummaryObj(Map<String, Object> customParams) {
        return ruleFetchService.getFetchDetail(new QueryRuleFetchParam(RuleFetchServiceHandler.getRuleFetchMainId(new RuleFetchMainDto(customParams)), (String)customParams.get("cellid")));
    }

    private void doExportOperate() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("bdtaxr_rule_fetch_card");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "exportdata"));
        ListFilterParameter queryFliter = new ListFilterParameter();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("summaryid", "=", this.getModel().getValue("summaryid")));
        queryFliter.setQFilters(list);
        listShowParameter.setListFilterParameter(queryFliter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void doSaveOperate() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object cellId = customParams.get("cellid");
        this.cacheCardData(cellId);
        customParams.put("adjustsumamout", this.getModel().getValue("sumlastamount").toString());
        customParams.put("adjustamount", this.getModel().getValue("sumadjustamount").toString());
        this.getView().returnDataToParent((Object)customParams);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private Map<String, String> getUpdateCellMapFromCache(IPageCache parentCache, String key) {
        String updateCellListStr = parentCache.get(key);
        return StringUtils.isEmpty((CharSequence)updateCellListStr) ? new HashMap() : (Map)JsonUtil.fromJson((String)updateCellListStr, Map.class);
    }

    private RuleFetchCellSummaryDto getRuleFetchSummaryFromCacheMap() {
        IPageCache parentCache = this.getView().getParentView().getPageCache();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object cellId = customParams.get("cellid");
        Map<String, String> updateCellEntityMap = this.getUpdateCellMapFromCache(parentCache, "updateCellEntityMap");
        if (updateCellEntityMap == null || updateCellEntityMap.isEmpty()) {
            updateCellEntityMap = this.getUpdateCellMapFromCache(this.getView().getParentView().getParentView().getPageCache(), "updateCellEntityMap");
        }
        if (!updateCellEntityMap.containsKey(cellId.toString()) || updateCellEntityMap.get(cellId.toString()) == null) {
            return null;
        }
        RuleFetchCellSummaryDto ruleFetchCellSummaryDto = (RuleFetchCellSummaryDto)JsonUtil.fromJson((String)updateCellEntityMap.get(cellId.toString()), RuleFetchCellSummaryDto.class);
        return ruleFetchCellSummaryDto;
    }

    private void cardAmountChanged(String name, ChangeData changeData, int rowIndex) {
        BigDecimal amount;
        if ("cardadjustamount".equals(name)) {
            BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
            amount = (BigDecimal)this.getModel().getValue("cardamount", rowIndex);
            this.getModel().setValue("cardtotalamount", (Object)adjustamount.add(amount), rowIndex);
        }
        if ("cardtotalamount".equals(name)) {
            BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
            amount = (BigDecimal)this.getModel().getValue("cardamount", rowIndex);
            this.getModel().setValue("cardadjustamount", (Object)totalamount.subtract(amount), rowIndex);
        }
        this.refreshSumAmount();
    }

    private void lastAmountChanged(ChangeData changeData) {
        Boolean mustPositiveInteger = (Boolean)this.getView().getFormShowParameter().getCustomParam("mustPositiveInt");
        if (mustPositiveInteger != null && mustPositiveInteger.booleanValue()) {
            String notPositiveIntMsg = (String)this.getView().getFormShowParameter().getCustomParam("notPositiveIntMsg");
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else if (newValue.compareTo(BigDecimal.ZERO) < 0) {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", notPositiveIntMsg);
                this.getView().showFieldTip(tip);
                this.getView().showTipNotification(notPositiveIntMsg);
            } else {
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "adjustamount", "");
                tip.setSuccess(true);
                this.getView().showFieldTip(tip);
            }
        }
    }

    private void refreshSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(CARD_ENTRY_ENTITY);
        this.getModel().setValue("sumadjustamount", (Object)entryentitycard.stream().map(s -> s.getBigDecimal("cardadjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
        this.getModel().setValue("sumlastamount", (Object)entryentitycard.stream().map(s -> s.getBigDecimal("cardtotalamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    private void doSetEditRecord(DynamicObject summaryObj) {
        DynamicObjectCollection editEntry = summaryObj.getDynamicObjectCollection(EDIT_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)editEntry)) {
            return;
        }
        editEntry.forEach(e -> {
            int rowIndex = this.getModel().createNewEntryRow(EDIT_ENTRY_ENTITY);
            this.getModel().setValue("adjusttype", e.get("adjusttype"), rowIndex);
            this.getModel().setValue("rulename", e.get("rulename"), rowIndex);
            this.getModel().setValue("editfetchorg", e.get("editfetchorg"), rowIndex);
            this.getModel().setValue("preadjust", e.get("preadjust"), rowIndex);
            this.getModel().setValue("editadjustamount", e.get("editadjustamount"), rowIndex);
            this.getModel().setValue("postadjust", e.get("postadjust"), rowIndex);
            this.getModel().setValue("editadjustexplain", e.get("editadjustexplain"), rowIndex);
            this.getModel().setValue("creator", e.get("creator_id"), rowIndex);
            this.getModel().setValue("createtime", e.get("modifytime"), rowIndex);
        });
    }

    private void doDrawRightFetchDetail(DynamicObject selectedCard) {
        this.clearEntry(DETAIL_ENTRY_ENTITY);
        DynamicObjectCollection detailEntry = selectedCard.getDynamicObjectCollection(DETAIL_ENTRY_ENTITY);
        detailEntry.forEach(d -> {
            int rowIndex = this.getModel().createNewEntryRow(DETAIL_ENTRY_ENTITY);
            this.getModel().setValue("skssqq", (Object)d.getDate("startdate"), rowIndex);
            this.getModel().setValue("bizname", (Object)d.getString("bizname"), rowIndex);
            this.getModel().setValue("datasource", d.get("datasource"), rowIndex);
            this.getModel().setValue("filtercondition", d.get("filtercondition"), rowIndex);
            this.getModel().setValue("conditionjson", d.get("conditionjson"), rowIndex);
            this.getModel().setValue("advancedconfjson", d.get("advancedconfjson"), rowIndex);
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("filtercondition");
            String tagPropName = largeTextEdit.getTagFieldKey();
            String largeText = (String)d.get("filtercondition");
            if (StringUtil.isEmpty((CharSequence)largeText)) {
                largeText = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\uff01", (String)"RuleFetchDrillPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            }
            this.getModel().setValue(tagPropName, (Object)largeText, rowIndex);
            this.getModel().setValue("amounttype", d.get("amounttype"), rowIndex);
            this.getModel().setValue("amountfield", d.get("amountfield"), rowIndex);
            this.getModel().setValue("absolute", d.get("absolute"), rowIndex);
            this.getModel().setValue("fetchtype", d.get("fetchtype"), rowIndex);
            this.getModel().setValue("fetchdirection", d.get("fetchdirection"), rowIndex);
            this.getModel().setValue("fetchamount", d.get("detailfetchamount"), rowIndex);
            this.getModel().setValue("originamount", d.get("detailoriginamount"), rowIndex);
        });
    }

    private void doAddAndShowManualCard() {
        this.showCardData(this.addCellData());
    }

    private void showCardData(long mainId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.doDrawLeftCard(ruleFetchService.getFetchDetail(new QueryRuleFetchParam(Long.valueOf(mainId), (String)customParams.get("cellid"))));
        this.getModel().setValue("rulefetchmainid", (Object)mainId);
    }

    private long addCellData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        RuleFetchMainDto cellMain = new RuleFetchMainDto(customParams);
        cellMain.setRuleFetchCellSummaryList(this.doPackageCellSummary(customParams));
        return ruleFetchService.addCellData(cellMain);
    }

    private List<RuleFetchCellSummaryDto> doPackageCellSummary(Map<String, Object> customParams) {
        return Collections.singletonList(new RuleFetchCellSummaryDto((String)customParams.get("cellid")));
    }

    private void doDrawLeftCard(DynamicObject summaryObj) {
        if (summaryObj == null) {
            return;
        }
        DynamicObjectCollection cardEntry = summaryObj.getDynamicObjectCollection(CARD_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)cardEntry)) {
            return;
        }
        cardEntry.sort(Comparator.comparing(c -> c.getLong("id")));
        cardEntry.forEach(c -> {
            int rowIndex = this.getModel().createNewEntryRow(CARD_ENTRY_ENTITY);
            this.getModel().setValue("cardid", c.get("id"), rowIndex);
            this.getModel().setValue("summaryid", summaryObj.get("id"), rowIndex);
            this.getModel().setValue("cardname", c.get("cardname"), rowIndex);
            this.getModel().setValue("cardruleid", c.get("cardruleid"), rowIndex);
            this.getModel().setValue("cardrulename", c.get("cardrulename"), rowIndex);
            this.getModel().setValue("cardamount", c.get("cardamount"), rowIndex);
            this.getModel().setValue("fetchorg", c.get("fetchorg"), rowIndex);
            this.getModel().setValue("cardadjustamount", c.get("cardadjustamount"), rowIndex);
            this.getModel().setValue("cardtotalamount", c.get("cardtotalamount"), rowIndex);
            this.getModel().setValue("cardadjustexplain", c.get("adjustexplain"), rowIndex);
        });
        RuleFetchCellSummaryDto ruleFetchCellSummaryDto = this.getRuleFetchSummaryFromCacheMap();
        if (ruleFetchCellSummaryDto == null) {
            return;
        }
        List ruleFetchCardList = ruleFetchCellSummaryDto.getRuleFetchCardList();
        for (int i = 0; i < cardEntry.size(); ++i) {
            Long cardRuleId = (Long)this.getModel().getValue("cardruleid", i);
            Optional<RuleFetchCardDto> firstOp = ruleFetchCardList.stream().filter(r -> r.getRuleId().equals(cardRuleId.toString())).findFirst();
            if (!firstOp.isPresent()) continue;
            RuleFetchCardDto ruleFetchCardDto = firstOp.get();
            BigDecimal fetchAmount = (BigDecimal)this.getModel().getValue("cardamount", i);
            BigDecimal adjustAmount = ruleFetchCardDto.getAdjustAmount();
            this.getModel().setValue("cardadjustamount", (Object)adjustAmount, i);
            BigDecimal totalAmount = adjustAmount.add(fetchAmount);
            this.getModel().setValue("cardtotalamount", (Object)totalAmount, i);
            this.getModel().setValue("cardadjustexplain", (Object)ruleFetchCardDto.getAdjustExplain(), i);
        }
    }

    private void doDrawSumAmount(DynamicObject summaryObj) {
        BigDecimal originamount = (BigDecimal)summaryObj.get("originamount");
        this.getModel().setValue("sumoriginamount", (Object)originamount);
        this.getModel().setValue("sumadjustamount", summaryObj.get("adjustamount"));
        this.getModel().setValue("sumlastamount", summaryObj.get("lastamount"));
        this.getModel().setValue("rulefetchmainid", summaryObj.get("rulefetchmainid"));
        this.getModel().setValue("ruletable", summaryObj.get("ruletable"));
        this.getModel().setValue("ruleid", summaryObj.get("ruleid"));
        this.getModel().setValue("ruleitem", summaryObj.get("ruleitem"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CARD_ENTRY_ENTITY);
        BigDecimal cardadjustamount = entryEntity.stream().map(a -> a.getBigDecimal("cardadjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("sumadjustamount", (Object)cardadjustamount);
        this.getModel().setValue("sumlastamount", (Object)originamount.add(cardadjustamount));
    }

    private void cacheCardData(Object cellId) {
        IPageCache parentCache = this.getView().getParentView().getPageCache();
        Map<String, String> updateCellMap = this.getUpdateCellMapFromCache(parentCache, "updateCellMap");
        Map<String, String> updateCellEntityMap = this.getUpdateCellMapFromCache(parentCache, "updateCellEntityMap");
        if (this.getUpdateCellMapFromCache(this.getView().getParentView().getParentView().getPageCache(), "updateCellEntityMap") != null) {
            updateCellEntityMap.putAll(this.getUpdateCellMapFromCache(this.getView().getParentView().getParentView().getPageCache(), "updateCellEntityMap"));
        }
        DynamicObjectCollection cardEntry = this.getModel().getEntryEntity(CARD_ENTRY_ENTITY);
        ArrayList<RuleFetchCardDto> ruleFetchCardList = new ArrayList<RuleFetchCardDto>(cardEntry.size());
        for (int i = 0; i < cardEntry.size(); ++i) {
            ruleFetchCardList.add(this.doCreateCardDto(i));
        }
        RuleFetchCellSummaryDto ruleFetchCellSummaryDto = this.doCreateSummaryDto();
        ruleFetchCellSummaryDto.setRuleFetchCardList(ruleFetchCardList);
        updateCellMap.put(cellId.toString(), ruleFetchCellSummaryDto.getLastAmount().toString());
        updateCellEntityMap.put(cellId.toString(), JsonUtil.toJson((Object)ruleFetchCellSummaryDto));
        parentCache.put("updateCellMap", JsonUtil.toJson(updateCellMap));
        parentCache.put("updateCellEntityMap", JsonUtil.toJson(updateCellEntityMap));
    }

    private RuleFetchCellSummaryDto doCreateSummaryDto() {
        BigDecimal sumLastAmount = (BigDecimal)this.getModel().getValue("sumlastamount");
        BigDecimal sumAdjustAmount = (BigDecimal)this.getModel().getValue("sumadjustamount");
        Long rulefetchmainid = (Long)this.getModel().getValue("rulefetchmainid");
        String ruletable = (String)this.getModel().getValue("ruletable");
        String ruleid = (String)this.getModel().getValue("ruleid");
        String ruleitem = (String)this.getModel().getValue("ruleitem");
        String cellid = (String)this.getView().getFormShowParameter().getCustomParams().get("cellid");
        return new RuleFetchCellSummaryDto(rulefetchmainid, ruletable, ruleid, ruleitem, cellid, sumAdjustAmount, sumLastAmount);
    }

    private RuleFetchCardDto doCreateCardDto(int i) {
        String cardName = (String)this.getModel().getValue("cardname", i);
        Long ruleId = (Long)this.getModel().getValue("cardruleid", i);
        DynamicObject fetchOrg = (DynamicObject)this.getModel().getValue("fetchorg", i);
        String cardRuleName = (String)this.getModel().getValue("cardrulename", i);
        BigDecimal adjustAmount = (BigDecimal)this.getModel().getValue("cardadjustamount", i);
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("cardtotalamount", i);
        String adjustExplain = (String)this.getModel().getValue("cardadjustexplain", i);
        return new RuleFetchCardDto(cardName, ruleId.toString(), cardRuleName, Long.valueOf(fetchOrg == null ? 0L : fetchOrg.getLong("id")), adjustAmount, totalAmount, adjustExplain);
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("fetchamount".equals(evt.getFieldName())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            long orgid = Long.parseLong(String.valueOf(customParams.get("org")));
            Date skssqq = DateUtils.stringToDate2((String)String.valueOf(customParams.get("skssqq")));
            Date skssqz = DateUtils.stringToDate2((String)String.valueOf(customParams.get("skssqz")));
            int rowIndex = evt.getRowIndex();
            DynamicObject datasource = (DynamicObject)this.getModel().getValue("datasource", rowIndex);
            String amounttype = (String)this.getModel().getValue("amounttype", rowIndex);
            String amountname = "";
            if ("tctb_datasource_entry".equals(amounttype)) {
                DynamicObject amountField = (DynamicObject)this.getModel().getValue("amountfield", rowIndex);
                DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_datasource_entry", (String)"fieldname", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)amountField.getLong("id"))});
                if (object != null) {
                    amountname = object.getString("fieldname");
                }
            }
            String conditionJson = (String)this.getModel().getValue("conditionjson", rowIndex);
            String advancedconfjson = (String)this.getModel().getValue("advancedconfjson", rowIndex);
            Long baseTaxId = this.getBaseTaxId(customParams);
            Map businessParams = (Map)customParams.get("businessParams");
            DataDetailsOpenUtils.openDataDetailsPage((Long)baseTaxId, (Long)orgid, (Date)skssqq, (Date)skssqz, (Long)datasource.getLong("id"), (String)amountname, (String)conditionJson, (String)advancedconfjson, (IFormView)this.getView(), (Map)businessParams);
        }
    }

    private Long getBaseTaxId(Map<String, Object> customParams) {
        Object taxcategory;
        Object businessParams = customParams.get("businessParams");
        if (businessParams instanceof Map && EmptyCheckUtils.isNotEmpty(taxcategory = ((Map)businessParams).get("taxcategory"))) {
            return Long.parseLong(String.valueOf(taxcategory));
        }
        return null;
    }
}

