/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.draft.drill;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.business.taxcode.TaxCodeResultBussiness;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxcodeFetchDrillPlugin
extends AbstractFormPlugin {
    private static final String BDTAXR_RULE_FETCH_TAXCODE = "bdtaxr_rule_fetch_taxcode";
    private static final String ENTRY_ENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        Object[] taxdetailObjs = this.doQueryTaxInfoObj(this.getView().getFormShowParameter().getCustomParams());
        if (ObjectUtils.isEmpty((Object[])taxdetailObjs)) {
            return;
        }
        boolean flag = true;
        if (!ObjectUtils.isEmpty((Object[])taxdetailObjs)) {
            if ("1652818532024594432".equals(taxdetailObjs[0].getString("taxcodetype.id"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"taxrate"});
                flag = false;
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"minimumtax"});
            }
        }
        this.doDrawTaxFetchDetail((DynamicObject[])taxdetailObjs, flag);
    }

    private void doDrawTaxFetchDetail(DynamicObject[] taxdetailObjs, boolean flag) {
        this.getModel().deleteEntryData("detailentryentity");
        Arrays.asList(taxdetailObjs).forEach(d -> {
            int rowIndex = this.getModel().createNewEntryRow("detailentryentity");
            BigDecimal taxrate = d.get("taxrate") == null ? BigDecimal.ZERO : new BigDecimal(d.get("taxrate").toString()).divide(new BigDecimal("100"), 6, 4);
            this.getModel().setValue("range", d.get("range"), rowIndex);
            if (flag) {
                this.getModel().setValue("taxrate", (Object)taxrate, rowIndex);
            } else {
                BigDecimal minimumtax = d.get("taxrate") == null ? BigDecimal.ZERO : new BigDecimal(d.get("taxrate").toString());
                this.getModel().setValue("minimumtax", (Object)minimumtax, rowIndex);
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Object[] taxdetailObjs = this.doQueryTaxInfoObj(e.getFormShowParameter().getCustomParams());
        if (!ObjectUtils.isEmpty((Object[])taxdetailObjs)) {
            DynamicObject taxcodetype = taxdetailObjs[0].getDynamicObject("taxratetype");
            if ("1652818532024594432".equals(taxdetailObjs[0].getString("taxcodetype.id"))) {
                e.getFormShowParameter().setCaption(taxdetailObjs[0].getString("taxcodetype.name"));
                return;
            }
            if (!ObjectUtils.isEmpty((Object)taxcodetype)) {
                e.getFormShowParameter().setCaption(taxcodetype.getString("name"));
            }
        }
    }

    private DynamicObject[] doQueryTaxInfoObj(Map<String, Object> customParams) {
        return TaxCodeResultBussiness.getTaxDetails((Long)customParams.get("templateId"), Long.valueOf(customParams.get("org").toString()), DateUtils.stringToDate((String)customParams.get("skssqq").toString()), DateUtils.stringToDate((String)customParams.get("skssqz").toString()), customParams.get("taxationsys"), customParams.get("taxcategory"), customParams.get("taxareagroup"), customParams.get("cellid").toString(), customParams.get("draftpurpose"), customParams.get("operation").toString());
    }

    public void showDetailDialog(String cellid, JSONObject params, IFormView view, IFormPlugin plugin) {
        String replaceCellId = cellid.replace("#", "_");
        IPageCache childPageCache = view.getPageCache();
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        if (!CollectionUtils.isEmpty((Map)updateMap) && updateMap.containsKey(replaceCellId)) {
            params.put("cellvalue", (Object)updateMap.get(replaceCellId).toString());
        }
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)32);
        Map viewParams = view.getFormShowParameter().getCustomParams();
        DeclareRequestModel declareModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)((String)viewParams.get("declareRequestData")), DeclareRequestModel.class);
        if (declareModel == null || declareModel.getSkssqq() == null || declareModel.getSkssqz() == null || declareModel.getOrgId() == null) {
            return;
        }
        customParams.put("org", declareModel.getOrgId());
        customParams.put("skssqq", declareModel.getSkssqq());
        customParams.put("skssqz", declareModel.getSkssqz());
        if (!ObjectUtils.isEmpty((Object)declareModel.getBusinessMap())) {
            customParams.putAll(declareModel.getBusinessMap());
        }
        if (!ObjectUtils.isEmpty((Object)declareModel.getExtendParams())) {
            customParams.putAll(declareModel.getExtendParams());
        }
        customParams.put("operation", params.getString("operation"));
        for (Map.Entry entry : params.entrySet()) {
            customParams.put(entry.getKey(), entry.getValue());
        }
        customParams.put("cellid", cellid);
        customParams.put("fromForm", BDTAXR_RULE_FETCH_TAXCODE);
        FormShowParameter param = new FormShowParameter();
        param.setFormId(BDTAXR_RULE_FETCH_TAXCODE);
        param.setCustomParams((Map)customParams);
        if (customParams.get("customCaption") != null) {
            param.setCaption((String)customParams.get("customCaption"));
        }
        param.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "cell_click_popup");
        param.setCloseCallBack(closeCallBack);
        view.showForm(param);
    }
}

