/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.draft.drill;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.taxcode.TaxCodeResultBussiness;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TaxcodeResultDrillPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    private static final String BDTAXR_TAXCODEDETAIL_POP = "bdtaxr_taxcodedetail_pop";
    private static final String LISTBOX = "listboxap";
    private static final String BILLLISTAP = "billlistap";
    private static final String INTERVAL_DATE = "intervaldate";
    private static final String DATA = "data";
    private static final String ACTIVE_ITEM = "activeItem";

    public void registerListener(EventObject e) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addSetFilterListener(this::setFilter);
        billList.addCreateListColumnsListener(this::createListColumns);
        Listbox listbox = (Listbox)this.getControl(LISTBOX);
        listbox.addListboxClickListener((ListboxClickListener)this);
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, Map<String, String>> taxcodeDetails = TaxCodeResultBussiness.queryTaxcodeResult(this.getView().getFormShowParameter().getCustomParams());
        this.getPageCache().put(DATA, SerializationUtils.toJsonString(taxcodeDetails));
        if (ObjectUtils.isEmpty(taxcodeDetails)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            QFilter idQ = new QFilter("id", "=", (Object)0L);
            billList.setFilter(idQ);
            billList.refresh();
            return;
        }
        this.initUpMenu(taxcodeDetails);
        int i = 0;
        for (Map.Entry<String, Map<String, String>> entry : taxcodeDetails.entrySet()) {
            if (i != 0) break;
            String firstItem = entry.getKey();
            Listbox listbox = (Listbox)this.getControl(LISTBOX);
            listbox.listboxClick(firstItem);
            this.setIntervaldateValue(entry.getValue().get(INTERVAL_DATE));
            ++i;
        }
    }

    public void showDetailDialog(String cellid, JSONObject params, IFormView view, IFormPlugin plugin) {
        String replaceCellId = cellid.replace("#", "_");
        IPageCache childPageCache = view.getPageCache();
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        if (!CollectionUtils.isEmpty((Map)updateMap) && updateMap.containsKey(replaceCellId)) {
            params.put("cellvalue", (Object)updateMap.get(replaceCellId).toString());
        }
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)32);
        Map viewParams = view.getFormShowParameter().getCustomParams();
        DeclareRequestModel declareModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)((String)viewParams.get("declareRequestData")), DeclareRequestModel.class);
        if (declareModel == null || declareModel.getSkssqq() == null || declareModel.getSkssqz() == null || declareModel.getOrgId() == null) {
            return;
        }
        customParams.put("org", declareModel.getOrgId());
        customParams.put("skssqq", declareModel.getSkssqq());
        customParams.put("skssqz", declareModel.getSkssqz());
        if (ObjectUtils.isNotEmpty((Object)declareModel.getBusinessMap())) {
            customParams.putAll(declareModel.getBusinessMap());
        }
        if (ObjectUtils.isNotEmpty((Object)declareModel.getExtendParams())) {
            customParams.putAll(declareModel.getExtendParams());
        }
        customParams.put("operation", params.getString("operation"));
        for (Map.Entry entry : params.entrySet()) {
            customParams.put(entry.getKey(), entry.getValue());
        }
        customParams.put("cellid", cellid);
        customParams.put("fromForm", BDTAXR_TAXCODEDETAIL_POP);
        FormShowParameter param = new FormShowParameter();
        param.setFormId(BDTAXR_TAXCODEDETAIL_POP);
        param.setCustomParams((Map)customParams);
        if (customParams.get("customCaption") != null) {
            param.setCaption((String)customParams.get("customCaption"));
        }
        param.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "cell_click_popup");
        param.setCloseCallBack(closeCallBack);
        view.showForm(param);
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String key = listboxEvent.getItemId();
        this.getPageCache().put(ACTIVE_ITEM, key);
        QFilter idQ = new QFilter("id", "=", (Object)Long.valueOf(key));
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setFilter(idQ);
        billList.refresh();
        Map data = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(DATA), Map.class);
        this.setIntervaldateValue((String)((Map)data.get(key)).get(INTERVAL_DATE));
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        String item = this.getPageCache().get(ACTIVE_ITEM);
        QFilter idQ = new QFilter("id", "=", (Object)(StringUtil.isNotEmpty((CharSequence)item) ? Long.parseLong(item) : 0L));
        qFilters.add(idQ);
    }

    private void initUpMenu(Map<String, Map<String, String>> taxcodeDetails) {
        Listbox listbox = (Listbox)this.getControl(LISTBOX);
        ArrayList<ListboxItem> listboxItemList = new ArrayList<ListboxItem>(16);
        for (Map.Entry<String, Map<String, String>> entry : taxcodeDetails.entrySet()) {
            Map<String, String> rowMap = entry.getValue();
            String name = rowMap.get("resultname");
            listboxItemList.add(new ListboxItem(entry.getKey(), name));
        }
        listbox.addItems(listboxItemList);
        listbox.addListboxClickListener((ListboxClickListener)this);
    }

    private void setIntervaldateValue(String value) {
        Label labelap = (Label)this.getControl(INTERVAL_DATE);
        labelap.setText(value);
    }
}

