/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.exportsql;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.formplugin.exportsql.HttpConnectionUtil;
import kd.taxc.bdtaxr.formplugin.exportsql.ZipUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckXmlFilesExistsPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(CheckXmlFilesExistsPlugin.class);
    private static final String OK = "btnok";
    private static final String CANCEL = "btncancel";
    private static final String DESTPATH = "destpath";
    private static final String APPCLOUD = "appcloud";
    private static final String APPIDS = "appids";
    private static final String OUTPRINT = "outprint";
    String entitySql = "select a.fnumber,a.fid,a.fdata,d.ftablename,e.fname entityname,e.fnumber entityid,f.fbizunitid from t_meta_bizapp a, t_meta_bizcloud  b, t_meta_entitydesign c,t_meta_entityinfo d, t_meta_entitydesign_l e,t_meta_bizunitrelform f where a.fbizcloudid = b.fid  and b.fnumber = 'TAXC'  and a.fid = c.fbizappid  and e.flocaleid = 'zh_CN'  and c.fid = e.fid  and c.fid = d.fentityid  and d.fentityid=f.fformid and a.fnumber='%s' order by a.fnumber, f.fbizunitid, e.fnumber";
    String formSql = "select  a.fnumber, a.fid, a.fdata, d.fname entityname, d.fnumber entityid, e.fbizunitid from  t_meta_bizapp a, t_meta_bizcloud b, t_meta_formdesign c, t_meta_formdesign_l  d, t_meta_bizunitrelform e where a.fbizcloudid = b.fid and b.fnumber ='TAXC' and a.fid =c.fbizappid  and c.fid =d.fid  and d.flocaleid ='zh_CN' and e.fformid =c.fentityid and a.Fnumber='%s' order by a.fnumber, e.fbizunitid, d.fnumber";
    String appidSql = "select b.fnumber as code from t_meta_bizcloud a,t_meta_bizapp b where a.fid =b.fbizcloudid and a.fnumber ='TAXC'";
    private static final String SEPARATOR = File.separator;
    private static final String WORK = System.getProperty("java.io.tmpdir") + SEPARATOR;
    private static final String metaDataPath = SEPARATOR + "datamodel" + SEPARATOR + "1.5" + SEPARATOR + "main" + SEPARATOR + "%s" + SEPARATOR + "metadata";
    private static final String BRANCH = "branch";
    private static final String CODE_STORE = "aHR0cHM6Ly9mZWF0dXJlLmtpbmdkZWUuY29tOjEwMjYvY29zbWljLWNkLXNjbS9wYXRjaHNjbS90ZXN0L3ByZXBhcmUvcnVudGltZS9kYXRhbW9kZWwv";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{OK, CANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        List columnList = DBUtils.query((String)DBRoute.meta.getRouteKey(), (String)this.appidSql);
        this.getModel().setValue(APPCLOUD, (Object)"taxc");
        this.getModel().setValue(BRANCH, (Object)"patchscm");
        this.getModel().setValue(DESTPATH, (Object)CheckXmlFilesExistsPlugin.getDecode(CODE_STORE));
        ComboEdit comboEdit = (ComboEdit)this.getControl(APPIDS);
        List comboItems = columnList.stream().map(s -> new ComboItem(new LocaleString(s.get("CODE").toString()), s.get("CODE").toString())).collect(Collectors.toList());
        comboEdit.setComboItems(comboItems);
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.getModel().setValue(OUTPRINT, null);
        String appids = (String)this.getModel().getValue(APPIDS);
        StringBuilder builder = new StringBuilder();
        String key = ((Control)evt.getSource()).getKey();
        String uri = (String)this.getModel().getValue(DESTPATH);
        if (OK.equalsIgnoreCase(key)) {
            if (StringUtils.isEmpty((CharSequence)uri) || !uri.endsWith("datamodel/")) {
                this.getView().showErrorNotification("please input uri!");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)appids)) {
                this.getView().showErrorNotification("please select appid!");
                return;
            }
            List collects = Arrays.stream(appids.split(",")).filter(s -> StringUtils.isNotEmpty((CharSequence)s)).collect(Collectors.toList());
            for (String appid : collects) {
                String zipName = String.format("taxc-%s-dm-1.x.zip", appid);
                try {
                    String downloadUrl = uri + zipName;
                    LOGGER.info("downloadUrl---" + downloadUrl);
                    LOGGER.info("zipUrl---" + WORK + zipName);
                    HttpConnectionUtil.downloadFile(downloadUrl, WORK, zipName);
                    String destDir = zipName.replace(".x.zip", "");
                    String decompressUrl = WORK + destDir;
                    LOGGER.info("decompressUrl---" + decompressUrl);
                    ZipUtils.decompress(new File(FilenameUtils.normalize((String)(WORK + FilenameUtils.getName((String)zipName)))), decompressUrl);
                    List columnList = DBUtils.query((String)DBRoute.meta.getRouteKey(), (String)String.format(this.formSql, appid));
                    List entitys = columnList.stream().filter(s -> s.containsKey("ENTITYID")).map(a -> (String)a.get("ENTITYID")).collect(Collectors.toList());
                    for (String entity : entitys) {
                        String filePath = String.format(WORK + destDir + metaDataPath, appid);
                        String normalize = FilenameUtils.normalize((String)(filePath + SEPARATOR + FilenameUtils.getName((String)(entity + ".dym"))));
                        Path path = Paths.get(normalize, new String[0]);
                        if (Files.exists(path, new LinkOption[0])) continue;
                        builder.append("entity or form files of xml not exists in projects\uff1a");
                        builder.append(entity);
                        builder.append("\n");
                    }
                    ZipUtils.delDir(WORK, zipName);
                    ZipUtils.delDir(WORK, destDir);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }
            this.getModel().setValue(OUTPRINT, (Object)(StringUtils.isEmpty((CharSequence)builder) ? "no diff!!!" : builder.toString()));
        }
    }

    private static String getDecode(String str) {
        return new String(Base64.getDecoder().decode(str));
    }
}

