/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.exportsql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EntityIdCalculator {
    private Map<String, List<Object>> idInfos = new HashMap<String, List<Object>>(16);
    private MainEntityType entityType;
    private List<Object> targetObjIds;

    public EntityIdCalculator(MainEntityType entityType, List<Object> targetObjIds) {
        this.entityType = entityType;
        this.targetObjIds = targetObjIds;
    }

    public Map<String, List<Object>> handleIdInfo() {
        Map entities = this.entityType.getAllEntities();
        for (EntityType entryEntityType : entities.values()) {
            if (entryEntityType instanceof LinkEntryType || entryEntityType.getAlias() == null || !(entryEntityType instanceof EntryType)) continue;
            this.handle((EntryType)entryEntityType);
        }
        return this.idInfos;
    }

    private List<Object> handle(EntryType entryType) {
        String name = entryType.getName();
        ISimpleProperty entryPkProp = entryType.getPrimaryKey();
        List<Object> idList = this.idInfos.get(name);
        if (idList != null) {
            return idList;
        }
        String entryIdKey = null;
        entryIdKey = entryType instanceof SubEntryType ? entryType.getParent().getName() + "." + entryType.getName() + "." + entryPkProp.getName() : entryType.getName() + "." + entryPkProp.getName();
        DynamicObjectCollection ids = QueryServiceHelper.query((String)this.entityType.getName(), (String)entryIdKey, (QFilter[])new QFilter(this.entityType.getPrimaryKey().getName(), "in", this.targetObjIds).toArray());
        idList = new ArrayList<Object>(ids.size());
        for (DynamicObject idObj : ids) {
            idList.add(idObj.get(entryIdKey));
        }
        this.idInfos.put(name, idList);
        return idList;
    }
}

