/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;

public class FormulaCellTypePlugin
extends AbstractFormPlugin {
    private static final String CONTENT = "content";
    private static final String SELECT_BASIC = "selectbasic";
    private static final String CELL_TYPE = "celltype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok", SELECT_BASIC});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Map paramMap = e.getFormShowParameter().getCustomParams();
        String selectedCellKey = "";
        if (paramMap != null && paramMap.get("selectCellKey") != null) {
            selectedCellKey = (String)paramMap.get("selectCellKey");
        }
        e.getFormShowParameter().setCaption(String.format(ResManager.loadKDString((String)"%s\u5355\u5143\u683c\u7c7b\u578b\u914d\u7f6e", (String)"FormulaCellTypePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), selectedCellKey));
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_BASIC});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject cellStyleObj = (JSONObject)customParams.get("cellType");
        if (cellStyleObj != null) {
            FormulaVo cellStyleVo = (FormulaVo)cellStyleObj.toJavaObject(FormulaVo.class);
            this.getModel().setValue(CELL_TYPE, (Object)cellStyleVo.getCellType());
            this.getModel().setValue(CONTENT, (Object)cellStyleVo.getContent());
        }
    }

    public void click(EventObject evt) {
        ListShowParameter listShowParameter;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.setReturnData();
        } else if (SELECT_BASIC.equals(key) && (listShowParameter = ShowFormHelper.createShowListForm((String)"bos_formmeta", (boolean)false)) != null) {
            listShowParameter.setFormId("bos_devp_formtreelistf7");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u9009\u62e9", (String)"FormulaCellTypePlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            listShowParameter.setCustomParam("onlyvisible", (Object)Boolean.FALSE);
            listShowParameter.setCustomParam("onlydeployed", (Object)Boolean.FALSE);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("modeltype", "in", Collections.singletonList("BaseFormModel")));
            listShowParameter.getListFilterParameter().setQFilters(qFilters);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "formCallBack"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void setReturnData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String cellKey = (String)customParams.get("selectCellKey");
        String cellType = (String)this.getModel().getValue(CELL_TYPE);
        if (StringUtils.isNotBlank((CharSequence)cellType)) {
            String content = (String)this.getModel().getValue(CONTENT);
            HashMap<String, FormulaVo> returnData = new HashMap<String, FormulaVo>();
            FormulaVo cellStyleVo = new FormulaVo();
            cellStyleVo.setFormulaKey(cellKey);
            cellStyleVo.setCellType(cellType);
            cellStyleVo.setContent(content);
            cellStyleVo.setFormulaType("3");
            if ("5".equals(cellType)) {
                String string = (String)this.getModel().getValue(SELECT_BASIC);
            }
            returnData.put("cellType", cellStyleVo);
            this.getView().setReturnData(returnData);
            this.getView().returnDataToParent(returnData);
        }
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (CELL_TYPE.equals(e.getProperty().getName())) {
            String cellType = (String)this.getModel().getValue(CELL_TYPE);
            if ("5".equals(cellType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SELECT_BASIC});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_BASIC});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("formCallBack".equalsIgnoreCase(closedCallBackEvent.getActionId()) && null != closedCallBackEvent.getReturnData()) {
            ListSelectedRowCollection rt = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String itemNumber = rt.get(0).getNumber();
            this.getModel().setValue(SELECT_BASIC, (Object)itemNumber);
        }
    }
}

