/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class FormulaScanPlugin
extends AbstractFormPlugin {
    private static final String SPLIT_STAR_STR = "**************************************************************************************************************************************************";
    private static final String TEMPLATE_NUM = "templatenum";
    private static final String CAL_FORMULA_TYPE = "1";
    private static final String ALL_TEMPLATE = "all";
    private static final String SCAN = "scan";
    private static final String OUTPRINT = "outprint";
    private static final String NEW_LINE = "\t\n";
    private static final String DELIMITER = "    ";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{SCAN});
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(TEMPLATE_NUM);
        DynamicObjectCollection templates = TemplateUtils.getAllTemplate();
        ArrayList comboItemList = new ArrayList();
        HashMap map = new HashMap();
        templates.forEach(v -> {
            String templateNum = v.getString("number");
            String templateId = v.getString("id");
            if (!map.containsKey(templateNum)) {
                comboItemList.add(new ComboItem(new LocaleString(templateNum), templateNum));
            }
            map.put(templateNum, templateId);
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"templateList", (Object)map);
        });
        comboEdit.setComboItems(comboItemList);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (SCAN.equalsIgnoreCase(key)) {
            this.getView().showLoading(new LocaleString("scaning please wait......"));
            String template = (String)this.getModel().getValue(TEMPLATE_NUM);
            StringBuilder builder = this.scanCalFormula(template);
            this.getModel().setValue(OUTPRINT, (Object)builder.toString());
            this.getView().hideLoading();
        }
    }

    private StringBuilder scanCalFormula(String templateNum) {
        StringBuilder result = new StringBuilder();
        ArrayList<String> templates = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)templateNum) || ALL_TEMPLATE.equals(templateNum)) {
            Map map = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"templateList", Map.class);
            templates.addAll(map.keySet());
        } else {
            templates.add(templateNum);
        }
        Map<String, Map<String, String>> reportItems = this.getReportItems(templates);
        HashMap noFormulaCells = new HashMap(16);
        Map formulasMap = QueryFormulaService.queryDBFormulaListByTemplate((String)CAL_FORMULA_TYPE, templates);
        formulasMap.forEach((template, formulas) -> {
            StringBuilder temp = new StringBuilder();
            AtomicBoolean isExistRepeatFormula = new AtomicBoolean(false);
            Map formulaKeyMap = formulas.stream().collect(Collectors.groupingBy(FormulaVo::getFormulaKey, Collectors.toList()));
            temp.append(SPLIT_STAR_STR).append(NEW_LINE);
            temp.append((String)template).append(NEW_LINE);
            formulaKeyMap.forEach((key, v) -> {
                if (v.size() > 1) {
                    isExistRepeatFormula.set(true);
                    temp.append((String)key).append(DELIMITER);
                }
            });
            temp.append(NEW_LINE);
            if (isExistRepeatFormula.get()) {
                result.append((CharSequence)temp);
            }
            Map itemMap = (Map)reportItems.get(template);
            StringBuilder noFormulaMsg = new StringBuilder();
            for (String key2 : itemMap.keySet()) {
                if (formulaKeyMap.get(key2) != null) continue;
                noFormulaMsg.append(key2).append(DELIMITER);
            }
            if (StringUtils.isNotBlank((CharSequence)noFormulaMsg)) {
                noFormulaCells.put(template, noFormulaMsg);
            }
        });
        result.append(NEW_LINE).append(SPLIT_STAR_STR).append(SPLIT_STAR_STR).append(NEW_LINE).append(SPLIT_STAR_STR).append(SPLIT_STAR_STR).append(NEW_LINE).append(NEW_LINE);
        result.append("No Formula Cells:").append(NEW_LINE).append(SPLIT_STAR_STR).append(NEW_LINE);
        for (Map.Entry entry : noFormulaCells.entrySet()) {
            String template2 = (String)entry.getKey();
            StringBuilder itemMsg = (StringBuilder)entry.getValue();
            result.append(template2).append(NEW_LINE).append((CharSequence)itemMsg).append(NEW_LINE).append(SPLIT_STAR_STR).append(NEW_LINE);
        }
        return result;
    }

    private Map<String, Map<String, String>> getReportItems(List<String> templates) {
        if (templates == null || CollectionUtils.isEmpty(templates)) {
            return null;
        }
        QFilter qFilter1 = new QFilter("number", "in", templates);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"id,number,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1});
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>(templates.size());
        for (DynamicObject object : collection) {
            String templateContent = object.getString("content_tag");
            HashMap<String, String> items = new HashMap<String, String>();
            Map<String, Map<String, String>> sheetCellMap = this.getReportItemsByTemplate(templateContent);
            for (Map<String, String> value : sheetCellMap.values()) {
                items.putAll(value);
            }
            results.put(object.getString("number"), items);
        }
        return results;
    }

    public Map<String, Map<String, String>> getReportItemsByTemplate(String templateContent) {
        ArrayList sheets = new ArrayList();
        sheets.addAll(SpreadUtils.getSheets((String)templateContent, null));
        HashMap<String, Map<String, String>> sheetCellMap = new HashMap<String, Map<String, String>>(sheets.size());
        for (Sheet e : sheets) {
            HashMap<String, String> cellsMap = new HashMap<String, String>();
            List rowList = e.getRowList();
            for (int i = 0; i < rowList.size(); ++i) {
                List cellList = (List)rowList.get(i);
                for (Cell cell : cellList) {
                    String cellKey = cell.getCellKey();
                    if (cellKey == null || !cellKey.contains("#")) continue;
                    cellsMap.put(cellKey, cellKey);
                }
            }
            sheetCellMap.put(e.getId(), cellsMap);
        }
        return sheetCellMap;
    }
}

