/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import org.apache.commons.lang.StringUtils;

public class FormulaTempAddPlugin
extends AbstractFormPlugin {
    private static final String EWBLXH = "ewblxh";
    private static final String ENTITY_SELECT = "entity_select";
    private static final String ROW_TREE = "rowtree";
    private static final String COLUMN_TREE = "columntree";
    private static final String BUTTON_CHANGE = "button_change";
    private static final String TYPE = "type";
    private static final String J = "#";
    private static final String FORMULAR_NAME = "formularName";
    private static final String FORMULAR_COUNT = "formularCount";
    private static final String FORMULAR_NAME_FIELD = "largetextfield1";
    private static final String FORMULAR_FIELD = "largetextfield";
    private static final Set<String> BASE_FIELD_LAST = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("id");
            this.add(FormulaTempAddPlugin.EWBLXH);
            this.add("ewblname");
            this.add("sbbid");
        }
    };

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_CHANGE});
        this.addClickListeners(new String[]{"btn_cancel", "btn_submit", "add", "minu", "miv", "div", "khz", "khs", "wh", "mh", "formulaadd", "buttonap", "buttonap1", "buttonap2", "buttonap3", "buttonap4", "buttonap5", "buttonap6", "buttonap7", "buttonap8", "buttonap9", "formulaadd1"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"tablecontent", "tableid", "fieldid", "filterjson", "mainid", "ischild", "condition", "flexpanelap1"});
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        if (entityId != null) {
            this.getModel().setValue(ENTITY_SELECT, (Object)entityId);
        }
        String templateType = (String)this.getView().getFormShowParameter().getCustomParam("templateType");
        Map tableMap = TemplateUtils.queryEntityByTypeId((String)templateType);
        Iterator it = tableMap.entrySet().iterator();
        int index = 0;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(tableMap.size());
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ComboItem item = new ComboItem();
            item.setId((String)entry.getKey());
            item.setValue((String)entry.getKey());
            item.setCaption(new LocaleString((String)entry.getValue()));
            combos.add(item);
            if (index == 0) {
                this.getModel().setValue(ENTITY_SELECT, entry.getKey());
            }
            if (((String)entry.getKey()).equals(entityId)) {
                this.getModel().setValue(ENTITY_SELECT, (Object)entityId);
            }
            ++index;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(ENTITY_SELECT);
        comboEdit.setComboItems(combos);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)Boolean.TRUE);
        this.initTree(Boolean.TRUE);
        this.initFZTree();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String formula = (String)this.getView().getModel().getValue(TYPE);
        int index = FormulaEditHelper.getCursorIndex((IFormView)this.getView(), (String)key, (String)FORMULAR_FIELD);
        switch (key) {
            case "button_change": {
                this.changeClick();
                break;
            }
            case "btn_submit": {
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put(FORMULAR_FIELD, this.getView().getModel().getValue(FORMULAR_FIELD));
                returnData.put(FORMULAR_NAME_FIELD, this.getView().getModel().getValue(FORMULAR_NAME_FIELD));
                this.getView().setReturnData(returnData);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "add": {
                this.setValue("+", index);
                this.setValueName("+", index);
                break;
            }
            case "minu": {
                this.setValue("-", index);
                this.setValueName("-", index);
                break;
            }
            case "miv": {
                this.setValue("*", index);
                this.setValueName("*", index);
                break;
            }
            case "div": {
                this.setValue("/", index);
                this.setValueName("/", index);
                break;
            }
            case "khz": {
                this.setValue("(", index);
                this.setValueName("(", index);
                break;
            }
            case "khs": {
                this.setValue(")", index);
                this.setValueName(")", index);
                break;
            }
            case "wh": {
                this.setValue("if", index);
                this.setValueName("if", index);
                break;
            }
            case "mh": {
                this.setValue(",", index);
                this.setValueName(",", index);
                break;
            }
            case "buttonap": {
                this.setValue(">", index);
                this.setValueName(">", index);
                break;
            }
            case "buttonap1": {
                this.setValue(">=", index);
                this.setValueName(">=", index);
                break;
            }
            case "buttonap2": {
                this.setValue("<", index);
                this.setValueName("<", index);
                break;
            }
            case "buttonap3": {
                this.setValue("<=", index);
                this.setValueName("<=", index);
                break;
            }
            case "buttonap4": {
                this.setValue("=", index);
                this.setValueName("=", index);
                break;
            }
            case "buttonap5": {
                this.setValue("!=", index);
                this.setValueName("!=", index);
                break;
            }
            case "buttonap6": {
                this.setValue("||", index);
                this.setValueName("||", index);
                break;
            }
            case "buttonap7": {
                this.setValue("&&", index);
                this.setValueName("&&", index);
                break;
            }
            case "formulaadd": {
                if (!formula.contains("Q")) break;
                TreeView rowTreeView = (TreeView)this.getView().getControl(ROW_TREE);
                TreeView columnTreeView = (TreeView)this.getView().getControl(COLUMN_TREE);
                List rowListMap = rowTreeView.getTreeState().getSelectedNodes();
                List columnListMap = columnTreeView.getTreeState().getSelectedNodes();
                if (rowListMap.size() <= 0 || columnListMap.size() <= 0) break;
                String row = (String)((Map)rowListMap.get(0)).get("id");
                String column = (String)((Map)columnListMap.get(0)).get("id");
                String rowText = (String)((Map)rowListMap.get(0)).get("text");
                String columnText = (String)((Map)columnListMap.get(0)).get("text");
                this.setValue(formula.replace("values", row + J + column), index);
                this.setValueName(formula.replace("values", rowText + J + columnText), index);
                break;
            }
            case "formulaadd1": {
                TreeView rowTreeView = (TreeView)this.getView().getControl("rowtree1");
                List rowListMap = rowTreeView.getTreeState().getSelectedNodes();
                if (rowListMap.size() <= 0) break;
                String row = (String)((Map)rowListMap.get(0)).get("id");
                String rowText = (String)((Map)rowListMap.get(0)).get("text");
                this.setValue(formula.replace("values", row), index);
                this.setValueName(formula.replace("values", rowText), index);
                break;
            }
            case "buttonap8": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("tpo_table_show");
                HashMap customParams = new HashMap(4);
                parameter.setCustomParams(customParams);
                StyleCss sc = new StyleCss();
                sc.setHeight("580px");
                sc.setWidth("960px");
                parameter.getOpenStyle().setInlineStyleCss(sc);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "save"));
                this.getView().showForm(parameter);
                break;
            }
            case "buttonap9": {
                String sql = this.getWhere();
                this.setValue(formula.replace("values", sql), index);
                this.getModel().setValue("mainid", (Object)"");
                this.getModel().setValue("tableid", (Object)"");
                this.getModel().setValue("ischild", (Object)"");
                this.getModel().setValue("condition", (Object)"");
                this.getModel().setValue("fieldid", (Object)"");
                Label o = (Label)this.getControl("buttonap8");
                o.setText("");
                ArrayList combos = new ArrayList();
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl("combofield1");
                comboEdit.setComboItems(combos);
                this.getModel().getEntryEntity("entryentity").clear();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals("save")) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            this.setValue(map);
        }
    }

    private void setValue(Map<String, String> map) {
        if (null != map) {
            this.setColun(map);
            QFilter q1 = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(map.get("tableid"))));
            QFilter q2 = new QFilter("entryentity.wherestate", "=", (Object)"1");
            QFilter[] filters = new QFilter[]{q1, q2};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"id,bizname,name,subname,ischild,entryentity.id,entryentity.fieldname,entryentity.fieldsubname,entryentity.bizsubname", (QFilter[])filters);
            if (null != collection && collection.size() > 0) {
                this.setComboItem(collection);
            }
        }
    }

    private void setColun(Map<String, String> map) {
        QFilter q1 = new QFilter("entryentity.id", "=", (Object)Long.parseLong(String.valueOf(map.get("fieldid"))));
        QFilter[] filters = new QFilter[]{q1};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"id,bizname,name,subname,ischild,condition,entryentity.id,entryentity.fieldname,entryentity.bizsubname", (QFilter[])filters);
        if (null != collection && collection.size() > 0) {
            DynamicObject d = (DynamicObject)collection.get(0);
            String bizname = d.getString("bizname");
            String name = d.getString("name");
            String fieldname = d.getString("entryentity.fieldname");
            String entryentity_bizsubname = d.getString("entryentity.bizsubname");
            Label o = (Label)this.getControl("buttonap8");
            o.setText(bizname + "." + entryentity_bizsubname);
            String subname = d.getString("subname");
            String ischild = d.getString("ischild");
            String condition = d.getString("condition");
            this.getModel().setValue("mainid", (Object)name);
            this.getModel().setValue("tableid", (Object)subname);
            this.getModel().setValue("ischild", (Object)ischild);
            this.getModel().setValue("condition", (Object)condition);
            this.getModel().setValue("fieldid", (Object)fieldname);
        }
    }

    private void setComboItem(DynamicObjectCollection collection) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        for (DynamicObject c : collection) {
            ComboItem item = new ComboItem();
            item.setId(c.getString("entryentity.fieldname"));
            item.setValue(c.getString("entryentity.fieldname"));
            item.setCaption(new LocaleString(c.getString("entryentity.bizsubname")));
            combos.add(item);
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("combofield1");
        comboEdit.setComboItems(combos);
    }

    private String getWhere() {
        StringBuilder sb = new StringBuilder();
        String ischild = (String)this.getModel().getValue("ischild");
        MainEntityType mainEntityType = null;
        mainEntityType = ischild.equals("true") ? EntityMetadataCache.getDataEntityType((String)((String)this.getModel().getValue("mainid"))) : EntityMetadataCache.getDataEntityType((String)((String)this.getModel().getValue("tableid")));
        Map entityMap = mainEntityType.getAllEntities();
        String pk = "";
        String suPk = "";
        String fileName = (String)this.getModel().getValue("fieldid");
        String tableid = (String)this.getModel().getValue("tableid");
        String subTable = "";
        String fileNameStr = "";
        String mainTable = "";
        int EntryGrid2 = this.getModel().getEntryRowCount("entryentity");
        StringBuffer where = new StringBuffer();
        for (Map.Entry entry : entityMap.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            DataEntityPropertyCollection pros = entityType.getProperties();
            if (mainEntityType.getAlias().equals(entityType.getAlias())) {
                mainTable = entityType.getAlias();
                pk = entityType.getPrimaryKey().getAlias();
            } else if (tableid.equals(entityType.getName())) {
                subTable = entityType.getAlias();
                suPk = entityType.getPrimaryKey().getAlias();
            }
            for (IDataEntityProperty property : pros) {
                if (property.getDisplayName() == null || !StringUtils.isNotEmpty((String)property.getAlias())) continue;
                if (property.getName().equals(fileName)) {
                    fileNameStr = " " + entityType.getAlias() + "." + property.getAlias() + " ";
                }
                for (int i = 0; i < EntryGrid2; ++i) {
                    String zd = (String)this.getModel().getValue("combofield1", i);
                    if (!property.getName().equals(zd)) continue;
                    Object kh = this.getModel().getValue("combofield", i);
                    Object tj = this.getModel().getValue("combofield2", i);
                    Object z = this.getModel().getValue("textfield", i);
                    Object fk = this.getModel().getValue("combofield3", i);
                    Object lj = this.getModel().getValue("combofield4", i);
                    if (null != kh) {
                        where.append(kh);
                    }
                    where.append(entityType.getAlias()).append('.').append(property.getAlias());
                    if (null != tj) {
                        where.append(tj);
                    }
                    if (null != z) {
                        where.append(z);
                    }
                    if (null != fk) {
                        where.append(fk);
                    }
                    if (null != lj) {
                        where.append(lj);
                    }
                    where.append(' ');
                }
            }
        }
        if (ischild.equals("true")) {
            return sb.append("select ").append(fileNameStr).append(" from ").append(mainTable).append(" where ").append(mainTable).append('.').append(pk).append(" = ").append(subTable).append('.').append(suPk).append(" and ").append(where).toString();
        }
        return sb.append("select ").append(fileNameStr).append(" from ").append(mainTable).append(" where ").append(where).toString();
    }

    private void setValue(String values, int index) {
        String currentFormular = (String)this.getModel().getValue(FORMULAR_FIELD);
        StringBuilder sb = new StringBuilder();
        sb.append(currentFormular);
        sb.insert(index, values);
        this.getModel().setValue(FORMULAR_FIELD, (Object)sb.toString());
        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)FORMULAR_FIELD, (int)(index + values.length()));
    }

    private void setValueName(String name, int index) {
        String formularName = this.getPageCache().get(FORMULAR_NAME);
        ArrayList<String> names = new ArrayList<String>();
        if (null != formularName) {
            names.addAll(Arrays.asList(formularName.split(J)));
            if (!String.join((CharSequence)"", names).equals(this.getModel().getValue(FORMULAR_NAME_FIELD)) || index > names.size()) {
                return;
            }
        }
        names.add(index, name);
        this.getPageCache().put(FORMULAR_NAME, String.join((CharSequence)J, names));
        this.getModel().setValue(FORMULAR_NAME_FIELD, (Object)String.join((CharSequence)"", names));
        FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)FORMULAR_NAME_FIELD, (int)(index + name.length()));
    }

    private void initTree(Boolean showType) {
        TreeView columnTreeView;
        TreeView rowTreeView;
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)showType);
        String entityId = (String)this.getView().getModel().getValue(ENTITY_SELECT);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        ComboProp ewblxhProp = (ComboProp)mainPros.get((Object)EWBLXH);
        TreeNode rowRoot = new TreeNode();
        rowRoot.setId("ROOT");
        rowRoot.setText(ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"FormulaTempAddPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        rowRoot.setParentid("");
        ArrayList<TreeNode> ewblNodeList = new ArrayList<TreeNode>();
        if (ewblxhProp != null) {
            List listItem = ewblxhProp.getComboItems();
            for (Object item : listItem) {
                TreeNode node = new TreeNode();
                node.setParentid("");
                node.setId(entityId + J + item.getValue());
                node.setText(item.getName().getLocaleValue());
                ewblNodeList.add(node);
            }
        }
        rowRoot.addChildren(ewblNodeList);
        ArrayList<TreeNode> childListNode = new ArrayList<TreeNode>();
        TreeNode columnRoot = new TreeNode();
        columnRoot.setId("ROOT");
        columnRoot.setText(ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"FormulaTempAddPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        columnRoot.setParentid("");
        for (IDataEntityProperty property : mainPros) {
            if (BASE_FIELD_LAST.contains(property.getName()) || property.getDisplayName() == null) continue;
            TreeNode node = new TreeNode();
            node.setId(property.getName());
            node.setParentid("");
            node.setText(property.getDisplayName().getLocaleValue());
            childListNode.add(node);
        }
        columnRoot.addChildren(childListNode);
        if (showType.booleanValue()) {
            rowTreeView = (TreeView)this.getView().getControl(ROW_TREE);
            rowTreeView.deleteAllNodes();
            rowTreeView.addNode(rowRoot);
            columnTreeView = (TreeView)this.getView().getControl(COLUMN_TREE);
            columnTreeView.deleteAllNodes();
            columnTreeView.addNode(columnRoot);
            TreeUtils.expandAll((TreeView)rowTreeView, (TreeNode)rowRoot);
            TreeUtils.expandAll((TreeView)columnTreeView, (TreeNode)columnRoot);
        } else {
            rowTreeView = (TreeView)this.getView().getControl(COLUMN_TREE);
            rowTreeView.deleteAllNodes();
            rowTreeView.addNode(rowRoot);
            TreeUtils.expandAll((TreeView)rowTreeView, (TreeNode)rowRoot);
            columnTreeView = (TreeView)this.getView().getControl(ROW_TREE);
            columnTreeView.deleteAllNodes();
            columnTreeView.addNode(columnRoot);
            TreeUtils.expandAll((TreeView)columnTreeView, (TreeNode)columnRoot);
        }
    }

    private void changeClick() {
        Boolean showType = (Boolean)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, Boolean.class);
        if (null != showType) {
            this.initTree(showType == false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ENTITY_SELECT.equals(name)) {
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)Boolean.TRUE);
            this.initTree(Boolean.TRUE);
            String entityId = (String)this.getView().getModel().getValue(ENTITY_SELECT);
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)ENTITY_SELECT, (Object)entityId);
        } else if (TYPE.equals(name)) {
            String type = (String)this.getModel().getValue(TYPE);
            if ("{S[values]}".equals(type)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tablecontent"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "flexpanelap1"});
            } else if ("{Q[values]}".equals(type)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tablecontent", "flexpanelap1"});
            } else if ("{C[values]}".equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "tablecontent", "flexpanelap1"});
            } else if ("{P[values]}".equals(type)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "tablecontent"});
            }
        }
    }

    private void initFZTree() {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        String taxtype = (String)this.getView().getFormShowParameter().getCustomParam("templateType");
        String type = "0";
        if (null != taxtype) {
            if (taxtype.startsWith("zzs")) {
                type = "1";
            } else if (taxtype.startsWith("qysds")) {
                type = "2";
            } else if (taxtype.equals("yhs")) {
                type = "3";
            } else if (taxtype.equals("fjsf")) {
                type = "4";
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("taxtype", "=", (Object)type)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_tcvat_assist_trees", (String)"id,name", (QFilter[])filters);
        for (DynamicObject v : collection) {
            TreeNode node = new TreeNode();
            node.setId(v.getString("id"));
            node.setText(v.getString("name"));
            node.setParentid("0");
            nodeList.add(node);
        }
        DynamicObjectCollection assist = QueryServiceHelper.query((String)"tpo_tcvat_assist", (String)"number,name,group", (QFilter[])filters);
        if (assist != null && !assist.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl("rowtree1");
            treeView.deleteAllNodes();
            for (DynamicObject entry : assist) {
                String id = entry.getString("number");
                String name = entry.getString("name");
                String parentid = entry.getString("group");
                TreeNode node = new TreeNode();
                node.setId(id);
                node.setText(name);
                node.setParentid(parentid);
                nodeList.add(node);
            }
            TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)this.getPageCache(), (boolean)true);
            TreeUtils.checkFirstNode((IPageCache)this.getPageCache(), (TreeView)treeView);
        }
    }
}

