/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.refactor.formula.context.CalFormulaContext;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class FormulaViewPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String paramExp = "('#(\\w+)')";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        String formula = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        if (formula != null) {
            this.getModel().setValue("formula_tag", (Object)formula);
        }
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if (Objects.equals(BTNOK, source.getKey())) {
            String formula = (String)this.getModel().getValue("formula_tag");
            if (StringUtil.isEmpty((CharSequence)formula)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u516c\u5f0f\u3002", (String)"FormulaViewPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            Pattern r = Pattern.compile(paramExp);
            Matcher m = r.matcher(formula);
            ArrayList<String> parseParams = new ArrayList<String>(4);
            while (m.find()) {
                parseParams.add(m.group(2));
            }
            Map<String, String> paramMap = this.getModel().getEntryEntity("entryentity").stream().filter(v -> StringUtil.isNotEmpty((CharSequence)v.getString("keyfield")) && StringUtil.isNotEmpty((CharSequence)v.getString("valuefield"))).collect(Collectors.toMap(a -> a.getString("keyfield").trim(), b -> b.getString("valuefield"), (a, b) -> a));
            for (String parseParam : parseParams) {
                String paramValue = paramMap.get(parseParam);
                if (!StringUtil.isEmpty((CharSequence)paramValue)) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570%s\u672a\u8bbe\u7f6e", (String)"FormulaViewPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), parseParam));
                return;
            }
            CalFormulaContext formulaContext = new CalFormulaContext();
            paramMap.forEach((a, b) -> formulaContext.getParam().put(a, b));
            Map resultMap = formulaContext.previewFormula(formula);
            ArrayList<String> logList = new ArrayList<String>(32);
            Boolean success = (Boolean)resultMap.get("success");
            if (Boolean.FALSE.equals(success)) {
                logList.add(ResManager.loadKDString((String)"\u8fd0\u884c\u5931\u8d25\u3002", (String)"FormulaViewPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            } else {
                String data = (String)resultMap.get("data");
                if (StringUtil.isBlank((CharSequence)data)) {
                    data = ResManager.loadKDString((String)"\u7a7a\u4e32", (String)"FormulaViewPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                }
                logList.add(String.format(ResManager.loadKDString((String)"\u8fd0\u884c\u6210\u529f\u3002\u5f97\u5230\u7ed3\u679c: %s", (String)"FormulaViewPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), data));
            }
            logList.add(ResManager.loadKDString((String)"\u8fd0\u884c\u65e5\u5fd7\u5982\u4e0b\uff1a", (String)"FormulaViewPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            List logs = (List)resultMap.get("logs");
            logList.addAll(logs);
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeeditap");
            String text = logList.stream().collect(Collectors.joining("\n"));
            codeSQLshow.setText(text);
            this.getView().updateView();
        }
    }
}

