/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula.update;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.JdbcConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.taxc.bdtaxr.common.refactor.formula.utils.MsqlQueryUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.formula.update.FromVisitor;
import kd.taxc.bdtaxr.formplugin.formula.update.UpdateMetaVisitor;

public class ReplaceSqlUtil {
    private static List<Map<String, String>> tableList = new ArrayList<Map<String, String>>(256);
    private static List<String> noContainList = Arrays.asList("taxorg_id", "org_id", "orgid_id");
    private static List<String> EntityBlackList = Collections.singletonList("sim_invoice_test");

    public static List<Map<String, String>> getTableListByTableName(String tablename) {
        return tableList.stream().filter(a -> tablename.equals(a.get("tablename"))).collect(Collectors.toList());
    }

    public static void clearTableList() {
        tableList.clear();
        ReplaceSqlUtil.addTableMap("tctb_declare_main", "tctb_declare_main", "t_tctb_declare_main");
        ReplaceSqlUtil.addTableMap("tctb_declare_entry", "tctb_declare_entry", "t_tctb_declare_entry");
        ReplaceSqlUtil.addTableMap("items", "sim_vatinvoice", "t_sim_vatinvoice_item");
        ReplaceSqlUtil.addTableMap("sim_vatinvoice", "sim_vatinvoice", "t_sim_vatinvoice");
        ReplaceSqlUtil.addTableMap("orgrow", "tctb_org_group_latest", "t_tctb_org_group_detail");
        ReplaceSqlUtil.addTableMap("tctb_org_group_latest", "tctb_org_group_latest", "t_tctb_org_group");
    }

    public static String replaceSql(String sql) {
        if (StringUtil.isNotEmpty((CharSequence)sql)) {
            String lowerSql = MsqlQueryUtil.toLowerSql((String)sql).replace("\n", " ").replace("\t", "");
            SQLStatementParser mysql = SQLParserUtils.createSQLStatementParser((String)lowerSql, (DbType)JdbcConstants.MYSQL);
            SQLStatement sqlStatement = mysql.parseSelect();
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)sqlStatement;
            SQLSelectQueryBlock queryBlock = sqlSelectStatement.getSelect().getQueryBlock();
            SQLTableSource from = queryBlock.getFrom();
            HashMap<String, SQLTableSource> tableSourceHashMap = new HashMap<String, SQLTableSource>();
            from.accept((SQLASTVisitor)new FromVisitor(tableSourceHashMap));
            ReplaceSqlUtil.fillTableList(tableSourceHashMap);
            Map<String, String> aliasToTable = tableSourceHashMap.values().stream().filter(a -> a instanceof SQLExprTableSource).map(a -> (SQLExprTableSource)a).collect(Collectors.toMap(b -> StringUtil.isNotEmpty((CharSequence)b.getAlias()) ? b.getAlias() : SQLUtils.toMySqlString((SQLObject)b.getExpr()), c -> SQLUtils.toMySqlString((SQLObject)c.getExpr()), (m, n) -> n));
            Collection<String> values = aliasToTable.values();
            List<Map<String, String>> sqlTableList = tableList.stream().filter(a -> values.contains(a.get("tablename"))).collect(Collectors.toList());
            if (sqlTableList.size() == 0) {
                throw new KDBizException("Couldn't find the corresponding metadata id!");
            }
            UpdateMetaVisitor updateMetaVisitor = new UpdateMetaVisitor(aliasToTable, sqlTableList, lowerSql, UpdateMetaVisitor.MODEL_INSQL);
            queryBlock.accept((SQLASTVisitor)updateMetaVisitor);
            updateMetaVisitor = new UpdateMetaVisitor(aliasToTable, sqlTableList, updateMetaVisitor.getSql(), UpdateMetaVisitor.MODEL_FIELD);
            queryBlock.accept((SQLASTVisitor)updateMetaVisitor);
            return updateMetaVisitor.getSql();
        }
        return sql;
    }

    public static void fillTableList(Map<String, SQLTableSource> tableSourceHashMap) {
        List tables = tableSourceHashMap.values().stream().filter(a -> a instanceof SQLExprTableSource).map(a -> ((SQLExprTableSource)a).getExpr()).map(b -> SQLUtils.toMySqlString((SQLObject)b)).collect(Collectors.toList());
        if (tables.size() > 0) {
            for (String table : tables) {
                String entitykey;
                List<Map<String, String>> tableListByTableName = ReplaceSqlUtil.getTableListByTableName(table);
                if (tableListByTableName.size() != 0) continue;
                List list = DBUtils.query((String)"sys.meta", (String)"select fid as id,fentitykey as entitykey,ftablename as tablename from t_meta_entityinfo where ftablename = ?", (Object[])new Object[]{table});
                if (EmptyCheckUtils.isNotEmpty((Object)list)) {
                    for (Map objectMap : list) {
                        entitykey = String.valueOf(objectMap.get("ENTITYKEY"));
                        String id = String.valueOf(objectMap.get("ID"));
                        if (EntityBlackList.contains(entitykey) || EntityBlackList.contains(id)) continue;
                        String tablename = String.valueOf(objectMap.get("TABLENAME"));
                        ReplaceSqlUtil.addTableMap(entitykey, id, tablename);
                    }
                    continue;
                }
                List list2 = DBUtils.query((String)"sys.meta", (String)"select a.ftablename as tablename ,c.fnumber as ID from t_meta_tabledict a left join t_meta_tableref b on a.fid =b.fid left join t_meta_entitydesign c on b.fmainentityid =c.fid where a.ftablename =?", (Object[])new Object[]{table});
                if (!EmptyCheckUtils.isNotEmpty((Object)list2)) continue;
                String tablename = (String)((Map)list2.get(0)).get("TABLENAME");
                entitykey = (String)((Map)list2.get(0)).get("ID");
                if (EntityBlackList.contains(entitykey)) continue;
                ReplaceSqlUtil.addTableMap(entitykey, entitykey, tablename);
            }
        }
    }

    public static void addTableMap(String entitykey, String id, String tablename) {
        block4: {
            HashMap<String, String> tableMap = new HashMap<String, String>(16);
            tableMap.put("entitykey", entitykey);
            tableMap.put("entityid", id);
            tableMap.put("tablename", tablename);
            try {
                EntityInfo entityInfo = MetadataUtil.getEntityAllById2((String)id);
                if (Objects.equals(id, entitykey)) {
                    entityInfo.getFieldList().stream().filter(a -> !a.getFieldId().contains(".")).forEach(entityField -> {
                        String key = entityField.getFieldId().toLowerCase();
                        if (!noContainList.contains(key)) {
                            String value = entityField.getColumnName().toLowerCase();
                            tableMap.put(value, key);
                        }
                    });
                    System.out.println(1);
                } else {
                    entityInfo.getFieldList().stream().filter(a -> a.getFieldId().contains(entitykey + ".")).forEach(entityField -> {
                        String key = entityField.getFieldId().toLowerCase();
                        if (!noContainList.contains(key)) {
                            String value = entityField.getColumnName().toLowerCase();
                            tableMap.put(value, key);
                        }
                    });
                    tableMap.put("fid", "id");
                    tableMap.put("fseq", entitykey + ".seq");
                }
                tableList.add(tableMap);
            }
            catch (KDException e) {
                if (e.getMessage().contains(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ReplaceSqlUtil_0", (String)"taxc-bdtaxr", (Object[])new Object[0]))) break block4;
                throw new RuntimeException(e);
            }
        }
    }
}

