/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula.update;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.upload.UploadOption;
import org.apache.commons.io.FilenameUtils;

public class TransKSQLFilePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log LOGGER = LogFactory.getLog(TransKSQLFilePlugin.class);
    private static final String BT_TRANS = "bt_trans";
    private static final String BASE_PATH = System.getProperty("user.home") + File.separator + "template" + File.separator;
    private static final Map<String, String> sqlTypeMap = new HashMap(4){
        {
            this.put("6", "MYSQL");
            this.put("5", "POSTGRESSQL");
            this.put("8", "ORACLE");
            this.put("3", "SQLSERVER");
        }
    };

    public void registerListener(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnupload".equals(control.getKey())) {
            UploadOption opt = new UploadOption();
            opt.setMultiple(true);
            opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20KSQL\u811a\u672c\u6587\u4ef6", (String)"TransKSQLFilePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            opt.setSuffix(".sql");
            this.getView().showUpload(opt, "btnupload");
        } else if ("btndel".equals(control.getKey())) {
            IDataModel model = this.getModel();
            int i = model.getEntryCurrentRowIndex("upload_urls");
            String cacheUrls = this.getPageCache().get("_file_list_");
            List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
            String url = (String)model.getValue("url", i);
            filelist.removeIf(f -> f.get("url").equals(url));
            this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
            model.deleteEntryRow("upload_urls", i);
            if (filelist.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"urlsflex"});
            }
        } else if (BT_TRANS.equals(control.getKey())) {
            String file_list;
            boolean isCheck;
            IDataModel dataModel = this.getModel();
            Object radiogroupfield = dataModel.getValue("radiogroupfield");
            Boolean ischeckMySQL = Objects.equals("checkbox_mysql", radiogroupfield);
            Boolean ischeckPoSQL = Objects.equals("checkbox_postgressql", radiogroupfield);
            Boolean ischeckOracle = Objects.equals("checkbox_oracle", radiogroupfield);
            Boolean ischecksqlserver = Objects.equals("checkbox_sqlserver", radiogroupfield);
            boolean bl = isCheck = ischeckMySQL != false || ischeckPoSQL != false || ischeckOracle != false || ischecksqlserver != false;
            if (!isCheck) {
                this.getView().showErrorNotification("Please select the database type need to be translated!");
                return;
            }
            String sql_show = "";
            int sqlType = 0;
            if (ischeckMySQL.booleanValue()) {
                sqlType = 6;
            }
            if (ischeckPoSQL.booleanValue()) {
                sqlType = 5;
            }
            if (ischeckOracle.booleanValue()) {
                sqlType = 8;
            }
            if (ischecksqlserver.booleanValue()) {
                sqlType = 3;
            }
            if (StringUtils.isEmpty((CharSequence)(file_list = this.getPageCache().get("_file_list_")))) {
                this.getView().showErrorNotification("Please select upload file!");
                return;
            }
            List filelist = (List)SerializationUtils.deSerializeFromBase64((String)file_list);
            if (filelist.size() == 0) {
                this.getView().showErrorNotification("Please select upload file!");
                return;
            }
            if (filelist.size() > 3) {
                this.getView().showErrorNotification("Please select no more than three file upload!");
                return;
            }
            FileService service = FileServiceFactory.getAttachmentFileService();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(sql_show).append("\u00b7TO ").append(sqlTypeMap.get("" + sqlType)).append(":");
            for (int i = 0; i < filelist.size(); ++i) {
                Map fileMap = (Map)filelist.get(i);
                String file_url = (String)fileMap.get("url");
                String fileName = (String)fileMap.get("name");
                if (StringUtils.isBlank((CharSequence)file_url)) {
                    throw new KDBizException("Please upload the file!");
                }
                try (InputStream inputStream = service.getInputStream(file_url);){
                    this.handleInputStream(inputStream, sqlType, fileName);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    String error = e.getMessage();
                    stringBuilder.append("The import failed! Error message:").append(error).append("\n\t");
                }
            }
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
            codeSQLshow.setText(stringBuilder.toString());
        }
    }

    private void handleInputStream(InputStream inputStream, int sqlType, String fileName) {
        Throwable throwable;
        fileName = sqlTypeMap.get("" + sqlType) + "_" + fileName;
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)fileName))));
        file.getParentFile().mkdirs();
        try {
            throwable = null;
            try (FileOutputStream fout = new FileOutputStream(file);
                 BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream));
                 BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fout));){
                String buffString;
                while ((buffString = bufferedReader2.readLine()) != null) {
                    if (!StringUtils.isNotEmpty((CharSequence)buffString)) continue;
                    if (buffString.startsWith("--")) {
                        bufferedWriter.write(buffString + ";\r\n");
                        continue;
                    }
                    String s = this.execTransKSQL(buffString, sqlType);
                    bufferedWriter.write(s + ";\r\n");
                }
            }
            catch (Throwable bufferedReader2) {
                throwable = bufferedReader2;
                throw bufferedReader2;
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        try {
            throwable = null;
            try (FileInputStream in = new FileInputStream(file);){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
                this.getView().openUrl(urls);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }

    public String execTransKSQL(String ksql, int SQLType) {
        String retSql = null;
        try {
            retSql = TransUtil.translate((String)ksql, (int)SQLType, (FormatOptions)new FormatOptions());
            return retSql;
        }
        catch (SqlTranslateException e) {
            String msg = "Translation failed!" + e.getMessage();
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        catch (RuntimeException var6) {
            String msg = "Translation failed!" + var6.getMessage();
            throw new KDBizException((Throwable)var6, new ErrorCode("", msg), new Object[0]);
        }
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get("_file_list_");
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
    }

    public void upload(UploadEvent evt) {
        IDataModel model = this.getModel();
        this.getView().setVisible(Boolean.TRUE, new String[]{"urlsflex"});
        String cacheUrls = this.getPageCache().get("_file_list_");
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        Object[] urls = evt.getUrls();
        LOGGER.info("\u83b7\u5f97\u4e0a\u4f20\u6587\u4ef6urls\uff1a{}", (Object)Arrays.toString(urls));
        this.getModel().beginInit();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            String urlStr = (String)((Map)urls[i]).get("url");
            String name = (String)((Map)urls[i]).get("name");
            if (!StringUtils.isNotBlank((CharSequence)urlStr)) continue;
            filelist.add((Map)urls[i]);
            int index = model.createNewEntryRow("upload_urls");
            model.setValue("name", (Object)name, index);
            model.setValue("url", (Object)urlStr, index);
        }
        this.getModel().endInit();
        this.getView().updateView("upload_urls");
        this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
    }
}

