/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula.update;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.formula.update.ReplaceSqlUtil;

public class UpdateMetaVisitor
extends MySqlASTVisitorAdapter {
    private static final String BLANK_SPACE = " ";
    private static final String DONOT = ".";
    private static final String ACCENT = "`";
    private Map<String, String> aliasToTable;
    private List<Map<String, String>> tableList;
    private Map<String, String> allTableMap;
    private String sql;
    public static int MODEL_INSQL = 1;
    public static int MODEL_FIELD = 2;
    private int mode = 1;
    private static Set<String> KEYWORDS = new LinkedHashSet<String>(Arrays.asList("delete", "insert", "update", "update", "exists", "distinct", "union", "limit", "between", "like"));

    public UpdateMetaVisitor(Map<String, String> aliasToTable, List<Map<String, String>> tableList, String sql, int mode) {
        this.aliasToTable = aliasToTable;
        this.sql = sql;
        this.tableList = tableList;
        this.allTableMap = new HashMap<String, String>(16);
        tableList.forEach(a -> this.allTableMap.putAll((Map<String, String>)a));
        this.mode = mode;
    }

    private Map<String, String> getTableListByAlias(String alias) {
        String table = this.aliasToTable.get(alias);
        if (StringUtil.isNotEmpty((CharSequence)table)) {
            return this.tableList.stream().filter(a -> table.equals(a.get("tablename"))).findFirst().get();
        }
        return null;
    }

    public String getSql() {
        return this.sql;
    }

    public boolean visit(SQLExprTableSource sqlObject) {
        if (this.mode == MODEL_FIELD) {
            String alias = sqlObject.getAlias();
            String exprStr = SQLUtils.toMySqlString((SQLObject)sqlObject.getExpr());
            Map<String, String> tableListByAlias = null;
            if (StringUtil.isNotEmpty((CharSequence)alias)) {
                tableListByAlias = this.getTableListByAlias(alias);
            } else if (StringUtil.isNotEmpty((CharSequence)exprStr)) {
                tableListByAlias = this.getTableListByAlias(exprStr);
            }
            if (null != tableListByAlias) {
                String entityid = tableListByAlias.get("entityid");
                this.sql = this.sql.replace(BLANK_SPACE + exprStr + BLANK_SPACE, BLANK_SPACE + entityid + BLANK_SPACE);
            }
        }
        return true;
    }

    public boolean visit(SQLSelect sqlObject) {
        if (MODEL_INSQL == this.mode && (sqlObject.getParent() instanceof SQLInSubQueryExpr || sqlObject.getParent() instanceof SQLQueryExpr)) {
            String sqlString = SQLUtils.toMySqlString((SQLObject)sqlObject).replace('\n', ' ').replace("\t", "");
            String replace = ReplaceSqlUtil.replaceSql(sqlString);
            if (this.sql.indexOf(sqlString) > -1 && this.sql.indexOf(sqlString) != this.sql.lastIndexOf(sqlString)) {
                int index = this.sql.indexOf(sqlString);
                int splitIndex = index + sqlString.length() + 1;
                String substring1 = this.sql.substring(0, splitIndex);
                String substring2 = this.sql.substring(splitIndex);
                substring1 = substring1.replace(sqlString, replace);
                this.sql = substring1 + substring2;
            } else {
                this.sql = this.sql.replace(sqlString, replace);
            }
            return false;
        }
        return false;
    }

    public boolean visit(SQLJoinTableSource sqlObject) {
        return true;
    }

    public boolean visit(SQLPropertyExpr sqlObject) {
        if (MODEL_FIELD == this.mode) {
            String ownernName = sqlObject.getOwnernName();
            String name = sqlObject.getName();
            if (StringUtil.isNotEmpty((CharSequence)ownernName)) {
                this.replaceField(ownernName.toLowerCase(), name);
                return false;
            }
            if (this.aliasToTable.size() == 1) {
                String alias = (String)this.aliasToTable.keySet().stream().findFirst().get();
                this.replaceField(alias, name);
                return false;
            }
        }
        return true;
    }

    public boolean visit(SQLIdentifierExpr sqlObject) {
        if (MODEL_FIELD == this.mode) {
            String lowerName = sqlObject.getLowerName();
            if (!(sqlObject.getParent() instanceof SQLPropertyExpr || sqlObject.getParent() instanceof SQLQueryExpr || sqlObject.getParent() instanceof SQLTableSourceImpl)) {
                String alias = (String)this.aliasToTable.keySet().stream().findFirst().get();
                if (this.aliasToTable.size() == 1) {
                    this.replaceField(alias, lowerName);
                } else {
                    String fieldKey = this.allTableMap.get(lowerName);
                    if (StringUtil.isNotEmpty((CharSequence)fieldKey)) {
                        if (KEYWORDS.contains(fieldKey)) {
                            fieldKey = this.wrapFieldKey(fieldKey);
                        }
                        this.sql = this.sql.replace(lowerName, alias + DONOT + fieldKey);
                    }
                }
            }
        }
        return true;
    }

    private String wrapFieldKey(String fieldKey) {
        return ACCENT + fieldKey + ACCENT;
    }

    private void replaceField(String tableAlias, String name) {
        String fieldKey;
        Map<String, String> tableListByAlias = this.getTableListByAlias(tableAlias);
        if (null != tableListByAlias && StringUtil.isNotEmpty((CharSequence)(fieldKey = tableListByAlias.get(name)))) {
            if (KEYWORDS.contains(fieldKey)) {
                fieldKey = this.wrapFieldKey(fieldKey);
            }
            this.sql = this.sql.indexOf(tableAlias + DONOT + name) > 0 ? this.sql.replace(tableAlias + DONOT + name, tableAlias + DONOT + fieldKey) : this.sql.replace(name, fieldKey);
        }
    }
}

