/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.formula.update.twotothree;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.update.StandardDeclareDataUpdService;
import kd.taxc.bdtaxr.common.upgrade.UpdConstant;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class ManualDeclareDataUpdFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String TEMPLATENUM = "templatenum";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if (BTNOK.equals(source.getKey())) {
            String taxapp = (String)this.getModel().getValue("taxapp");
            if (StringUtil.isEmpty((CharSequence)taxapp)) {
                this.getView().showErrorNotification("Please enter the template numbers");
                return;
            }
            StandardDeclareDataUpdService updService = new StandardDeclareDataUpdService(taxapp);
            String result = updService.update();
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codeshow_sql");
            codeSQLshow.setText(String.join((CharSequence)"\n", result));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxapp".equalsIgnoreCase(name)) {
            List templateTypes;
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            if (StringUtil.isNotEmpty((CharSequence)newValue) && (templateTypes = UpdConstant.getTemplateTypeByApp((String)newValue)) != null) {
                DynamicObjectCollection templates = QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"id,number,type", (QFilter[])new QFilter[]{new QFilter("type", "in", (Object)templateTypes)});
                String templateTypeStr = templateTypes.stream().collect(Collectors.joining(","));
                String numbers = templates.stream().map(a -> a.getString("number")).collect(Collectors.joining(","));
                this.getModel().setValue("templatetype", (Object)templateTypeStr);
                this.getModel().setValue(TEMPLATENUM, (Object)numbers);
                return;
            }
            this.getModel().setValue("templatetype", null);
            this.getModel().setValue(TEMPLATENUM, null);
            this.getView().showTipNotification("[" + newValue + "] doesn't has the corresponding template");
        }
    }
}

