/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.param.SystemParamDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcparamapply.TaxcParamApplyDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.formplugin.init.OrgInitConfigItemEnum;
import kd.taxc.bdtaxr.formplugin.init.helper.BaseInitConfigSubmitHelper;

public class AbstractBaseInitConfigListPlugin
extends AbstractListPlugin {
    private BaseInitConfigSubmitHelper baseInitConfigSubmitHelper;

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime desc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().equals("billstatus")) continue;
            filterColumn.setDefaultValues(new Object[]{"A", "B"});
            break;
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        BillList list = (BillList)hyperEvt.getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        String entityId = list.getEntityId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)entityId);
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("org", obj.getLong("org_id"));
        customParams.put("id", currentSelectedRowInfo.getPrimaryKeyValue());
        param.setFormId("tam_base_init_guide");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        String operateKey = ((AbstractOperate)source).getOperateKey();
        List<Long> selectedOrgIds = this.getSelectedOrgIds();
        this.baseInitConfigSubmitHelper = new BaseInitConfigSubmitHelper();
        if ("submit".equals(operateKey)) {
            if (this.isBaseInitAuditParamEqualsOne()) {
                String msg = ResManager.loadKDString((String)"\u53c2\u6570\u201c\u57fa\u7840\u8d44\u6599\u5ba1\u6279\u65b9\u5f0f\u201d\u503c\u4e3a\u201c\u5355\u72ec\u5ba1\u6279\u201d\uff0c\u4e0d\u5141\u8bb8\u5728\u7a0e\u52a1\u5de5\u4f5c\u53f0\u6253\u5305\u63d0\u4ea4\u5ba1\u6279\uff0c\u53ef\u524d\u5f80\u201c\u7cfb\u7edf\u670d\u52a1\u4e91-\u914d\u7f6e\u5de5\u5177-\u53c2\u6570\u914d\u7f6e-\u7cfb\u7edf\u53c2\u6570\u201d\u786e\u8ba4\u3002", (String)"AbstractBaseInitConfigListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
            if (this.canSubmit(args)) {
                this.doSubmitSubBill(args, selectedOrgIds);
            }
        } else if ("unsubmit".equals(operateKey)) {
            if (this.isBaseInitAuditParamEqualsOne()) {
                String msg = ResManager.loadKDString((String)"\u53c2\u6570\u201c\u57fa\u7840\u8d44\u6599\u5ba1\u6279\u65b9\u5f0f\u201d\u503c\u4e3a\u201c\u5355\u72ec\u5ba1\u6279\u201d\uff0c\u4e0d\u5141\u8bb8\u5728\u7a0e\u52a1\u5de5\u4f5c\u53f0\u6253\u5305\u64a4\u9500\uff0c\u53ef\u524d\u5f80\u201c\u7cfb\u7edf\u670d\u52a1\u4e91-\u914d\u7f6e\u5de5\u5177-\u53c2\u6570\u914d\u7f6e-\u7cfb\u7edf\u53c2\u6570\u201d\u786e\u8ba4\u3002", (String)"AbstractBaseInitConfigListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
        } else if ("audit".equals(operateKey) && this.isBaseInitAuditParamEqualsOne()) {
            String msg = ResManager.loadKDString((String)"\u53c2\u6570\u201c\u57fa\u7840\u8d44\u6599\u5ba1\u6279\u65b9\u5f0f\u201d\u503c\u4e3a\u201c\u5355\u72ec\u5ba1\u6279\u201d\uff0c\u4e0d\u5141\u8bb8\u5728\u7a0e\u52a1\u5de5\u4f5c\u53f0\u6253\u5305\u5ba1\u6279\uff0c\u53ef\u524d\u5f80\u201c\u7cfb\u7edf\u670d\u52a1\u4e91-\u914d\u7f6e\u5de5\u5177-\u53c2\u6570\u914d\u7f6e-\u7cfb\u7edf\u53c2\u6570\u201d\u786e\u8ba4\u3002", (String)"AbstractBaseInitConfigListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
    }

    private boolean canSubmit(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])listSelectedData.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((ListView)this.getView()).getBillFormId()));
        if (objs.length == 0) {
            return false;
        }
        if (!this.doCheckSubBillFinishStatus(objs)) {
            args.setCancel(true);
            return false;
        }
        if (!this.doCheckSubBillStatus(objs)) {
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean doCheckSubBillStatus(DynamicObject[] objs) {
        for (DynamicObject obj : objs) {
            for (OrgInitConfigItemEnum itemEnum : OrgInitConfigItemEnum.queryNeedBillStatusItem()) {
                List<DynamicObject> subBills = this.getSubBills(itemEnum, obj.getLong("org.id"));
                if (CollectionUtils.isEmpty(subBills)) continue;
                for (DynamicObject subBill : subBills) {
                    String subBillStatus = itemEnum == OrgInitConfigItemEnum.ORG_MAPPING ? subBill.getString("status") : subBill.getString("billstatus");
                    if ("A".equals(subBillStatus)) continue;
                    String msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u3010%1$s\u3011-%2$s\u3010%3$s\u3011\u975e\u6682\u5b58\u72b6\u6001\uff0c\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"AbstractBaseInitConfigListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                    EntityInfo entity = MetadataUtil.getEntityById((String)itemEnum.getMeta());
                    if (entity == null) continue;
                    String number = itemEnum == OrgInitConfigItemEnum.TAX_MAIN ? obj.getString("org.number") : (itemEnum == OrgInitConfigItemEnum.ORG_PARAM ? obj.getString("billno") : subBill.getString("number"));
                    this.getView().showErrorNotification(String.format(msg, obj.getString("org.number"), entity.getEntityName(), number));
                    return false;
                }
            }
        }
        return true;
    }

    private List<DynamicObject> getSubBills(OrgInitConfigItemEnum itemEnum, Long org) {
        List<Object> data = new ArrayList<DynamicObject>();
        if (itemEnum == OrgInitConfigItemEnum.TAX_MAIN) {
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsWithNoStatus(Collections.singletonList(org), null);
            data = (List)result.getData();
        } else if (itemEnum == OrgInitConfigItemEnum.ORG_MAPPING) {
            TaxResult result = TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIds(Collections.singletonList(org));
            data = (List)result.getData();
        } else if (itemEnum == OrgInitConfigItemEnum.ORG_PARAM) {
            TaxResult result = TaxcParamApplyDataServiceHelper.getTaxcParamApplyByOrgIds(Collections.singletonList(org));
            data = (List)result.getData();
        }
        return data;
    }

    private boolean doCheckSubBillFinishStatus(DynamicObject[] objs) {
        for (DynamicObject obj : objs) {
            String msg = this.doCheckEachSubBillFinishStatus(obj);
            if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private String doCheckEachSubBillFinishStatus(DynamicObject obj) {
        String msg;
        StringBuilder sb = new StringBuilder();
        if ("0".equals(obj.getString("isorgcomplete"))) {
            msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011-\u521d\u59cb\u5316\u914d\u7f6e\u4efb\u52a1\u3010\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u3011\u672a\u5b8c\u6210\uff0c\u8bf7\u5b8c\u6210\u540e\u63d0\u4ea4\u5355\u636e\u3002", (String)"AbstractBaseInitConfigListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            sb.append(String.format(msg, obj.getString("org.number")));
            sb.append("\r\n");
        }
        if ("0".equals(obj.getString("istaxmaincomplete"))) {
            msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011-\u521d\u59cb\u5316\u914d\u7f6e\u4efb\u52a1\u3010\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3011\u672a\u5b8c\u6210\uff0c\u8bf7\u5b8c\u6210\u540e\u63d0\u4ea4\u5355\u636e\u3002", (String)"AbstractBaseInitConfigListPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            sb.append(String.format(msg, obj.getString("org.number")));
            sb.append("\r\n");
        }
        if ("0".equals(obj.getString("isorgmappingcomplete"))) {
            msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011-\u521d\u59cb\u5316\u914d\u7f6e\u4efb\u52a1\u3010\u7a0e\u52a1\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\u3011\u672a\u5b8c\u6210\uff0c\u8bf7\u5b8c\u6210\u540e\u63d0\u4ea4\u5355\u636e\u3002", (String)"AbstractBaseInitConfigListPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            sb.append(String.format(msg, obj.getString("org.number")));
            sb.append("\r\n");
        }
        if ("0".equals(obj.getString("isorggroupcomplete"))) {
            msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011-\u521d\u59cb\u5316\u914d\u7f6e\u4efb\u52a1\u3010\u6c47\u603b\u65b9\u6848\u3011\u672a\u5b8c\u6210\uff0c\u8bf7\u5b8c\u6210\u540e\u63d0\u4ea4\u5355\u636e\u3002", (String)"AbstractBaseInitConfigListPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            sb.append(String.format(msg, obj.getString("org.number")));
            sb.append("\r\n");
        }
        if ("0".equals(obj.getString("isorgparamcomplete"))) {
            msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011-\u521d\u59cb\u5316\u914d\u7f6e\u4efb\u52a1\u3010\u7a0e\u52a1\u53c2\u6570\u914d\u7f6e\u3011\u672a\u5b8c\u6210\uff0c\u8bf7\u5b8c\u6210\u540e\u63d0\u4ea4\u5355\u636e\u3002", (String)"AbstractBaseInitConfigListPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            sb.append(String.format(msg, obj.getString("org.number")));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private void doSubmitSubBill(BeforeDoOperationEventArgs args, List<Long> selectedOrgIds) {
        TaxResult<OperationResult> orgMappingSubmitResult;
        List<Long> taxMainIds = this.baseInitConfigSubmitHelper.queryTaxMainIdsByOrg(selectedOrgIds);
        TaxResult<OperationResult> taxMainSubmitResult = this.baseInitConfigSubmitHelper.submitTaxMain(taxMainIds);
        if (!taxMainSubmitResult.isSuccess()) {
            this.baseInitConfigSubmitHelper.unSubmitTaxMain(taxMainIds);
            EntityInfo entity = MetadataUtil.getEntityById((String)OrgInitConfigItemEnum.TAX_MAIN.getMeta());
            String entityName = entity != null ? entity.getEntityName() : "";
            this.getView().showErrorNotification(entityName.concat(taxMainSubmitResult.getMessage()));
            args.setCancel(true);
            return;
        }
        List<Long> orgMappingIds = this.baseInitConfigSubmitHelper.queryOrgMappingIdsByOrg(selectedOrgIds);
        if (!CollectionUtils.isEmpty(orgMappingIds) && !(orgMappingSubmitResult = this.baseInitConfigSubmitHelper.submitOrgMapping(orgMappingIds)).isSuccess()) {
            this.baseInitConfigSubmitHelper.unSubmitTaxMain(taxMainIds);
            this.baseInitConfigSubmitHelper.unSubmitOrgMapping(orgMappingIds);
            EntityInfo entity = MetadataUtil.getEntityById((String)OrgInitConfigItemEnum.ORG_MAPPING.getMeta());
            String entityName = entity != null ? entity.getEntityName() : "";
            this.getView().showErrorNotification(entityName.concat(orgMappingSubmitResult.getMessage()));
            args.setCancel(true);
            return;
        }
        List<Long> applyFormIds = this.baseInitConfigSubmitHelper.queryApplyFormIdsByOrg(selectedOrgIds);
        if (CollectionUtils.isEmpty(applyFormIds)) {
            return;
        }
        TaxResult<OperationResult> paramApplySubmitResult = this.baseInitConfigSubmitHelper.submitParamApply(applyFormIds);
        if (!paramApplySubmitResult.isSuccess()) {
            this.baseInitConfigSubmitHelper.unSubmitTaxMain(taxMainIds);
            this.baseInitConfigSubmitHelper.unSubmitOrgMapping(orgMappingIds);
            this.baseInitConfigSubmitHelper.unSubmitParamApply(applyFormIds);
            EntityInfo entity = MetadataUtil.getEntityById((String)OrgInitConfigItemEnum.ORG_PARAM.getMeta());
            String entityName = entity != null ? entity.getEntityName() : "";
            this.getView().showErrorNotification(entityName.concat(paramApplySubmitResult.getMessage()));
            args.setCancel(true);
        }
    }

    private List<Long> getSelectedOrgIds() {
        ListSelectedRowCollection listSelectedData = this.getSelectedRows();
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])listSelectedData.getPrimaryKeyValues(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((ListView)this.getView()).getBillFormId()));
        return Arrays.stream(objs).map(o -> o.getLong("org.id")).collect(Collectors.toList());
    }

    private boolean isBaseInitAuditParamEqualsOne() {
        Long rootOrgId = (Long)ViewDataServiceHelper.getRootOrgId().getData();
        boolean ispackaudit = false;
        if (!ObjectUtils.isEmpty((Object)rootOrgId)) {
            TaxResult result = SystemParamDataServiceHelper.getAppParameter((String)"tctb", (String)"bdaudittype", (Long)rootOrgId);
            ispackaudit = ((String)result.getData()).equalsIgnoreCase("2");
        }
        return !ispackaudit;
    }
}

