/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.monitor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.Donothing;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class BussinessDataCheckListPlugin
extends AbstractListPlugin {
    private static final String OPERATION_RESULT_ENTITY = "bos_operationresult";
    private static final String SELECTED_FIELDS = "period,operation,createtime,number,conditionjson,checkdata,range";
    private static final String OPERATE_NAME = "operateName";
    private static final String TITLE = "title";
    private static final String ERROR_MSG = "errorMsg";
    private static final String CANCEL = "cancel";
    private static final String REFRESH = "refresh";
    private static final String CUSTOM_FILTER = "customfilter";
    private static final String START = "start";
    private static final String END = "end";

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addSearchClickListener(event -> this.filterSearchClickEvent(event));
    }

    private void filterSearchClickEvent(SearchClickEvent searchClickEvent) {
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get(CUSTOM_FILTER);
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        QFilter endValue = null;
        for (QFilter filter : commonQFilterList) {
            if (!START.equals(filter.getProperty()) || filter.getNests(false).size() == 0) continue;
            QFilter current = ((QFilter.QFilterNest)filter.getNests(false).get(0)).getFilter();
            endValue = new QFilter(END, "<=", current.getValue());
            break;
        }
        BillList billlist = (BillList)this.getControl("billlistap");
        if (null != endValue) {
            billlist.setFilter(endValue);
        }
        billlist.clearSelection();
        billlist.refresh();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && ((Donothing)args.getSource()).getOperateKey().equals("process")) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u8bb0\u5f55", (String)"BussinessDataCheckListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> errors = new ArrayList<String>();
            this.getErrors(errors, selectedRows);
            if (errors.size() < selectedRows.size()) {
                this.openCallSettingPage("process");
            } else {
                this.showOperationResultMulti(selectedRows.size(), errors, null);
            }
        } else if (args.getSource() instanceof Donothing && ((Donothing)args.getSource()).getOperateKey().equals(CANCEL)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u8bb0\u5f55", (String)"BussinessDataCheckListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.batchProcessCancel(selectedRows);
        } else if (args.getSource() instanceof Donothing && ((Donothing)args.getSource()).getOperateKey().equals("processcer")) {
            this.openCallCheckPage("processcer");
            return;
        }
    }

    private void openCallCheckPage(String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_procescer_dialogue");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    private void getErrors(List<String> errors, ListSelectedRowCollection selectedRows) {
        DynamicObject[] items;
        Object[] pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        block7: for (DynamicObject itemObj : items = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bdtaxr_datachange_check"))) {
            String currentStatus;
            switch (currentStatus = itemObj.getString("processstatus")) {
                case "done": 
                case "no": {
                    errors.add(ResManager.loadKDString((String)"%s:\u6570\u636e\u5df2\u4e3a\u5df2\u5904\u7406\u6216\u65e0\u9700\u5904\u7406\u72b6\u6001", (String)"BussinessDataCheckListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[]{itemObj.getString("number")}));
                    continue block7;
                }
            }
        }
    }

    private void openCallSettingPage(String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_process_dialogue");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("processcer".equals(evt.getActionId())) {
            this.getView().updateView();
            return;
        }
        if (null == evt.getReturnData()) {
            return;
        }
        if ("process".equals(evt.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Map returnData = (Map)JsonUtil.fromJson((String)((String)evt.getReturnData()), Map.class);
            if (null == returnData || returnData.size() == 0) {
                return;
            }
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<DynamicObject> updateDyos = new ArrayList<DynamicObject>();
            this.getBatchProceesResult(errors, updateDyos, selectedRows, returnData);
            if (updateDyos.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])updateDyos.toArray(new DynamicObject[0]));
                this.getView().invokeOperation(REFRESH);
            }
            String successInfo = ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"BussinessDataCheckListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            this.showOperationResultMulti(selectedRows.size(), errors, successInfo);
        }
    }

    private void batchProcessCancel(ListSelectedRowCollection selectedRows) {
        DynamicObject[] items;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<DynamicObject> updateDyos = new ArrayList<DynamicObject>();
        Object[] pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        block9: for (DynamicObject itemObj : items = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bdtaxr_datachange_check"))) {
            String currentStatus;
            switch (currentStatus = itemObj.getString("processstatus")) {
                case "todo": {
                    errors.add(ResManager.loadKDString((String)"%s:\u6570\u636e\u5df2\u4e3a\u5f85\u5904\u7406\u72b6\u6001", (String)"BussinessDataCheckListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[]{itemObj.getString("number")}));
                    continue block9;
                }
                case "done": 
                case "no": {
                    updateDyos.add(this.clearValues(itemObj));
                    continue block9;
                }
            }
        }
        if (updateDyos.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])updateDyos.toArray(new DynamicObject[0]));
            this.getView().invokeOperation(REFRESH);
        }
        String successInfo = ResManager.loadKDString((String)"\u53d6\u6d88\u5904\u7406\u6210\u529f", (String)"BussinessDataCheckListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.showOperationResultMulti(selectedRows.size(), errors, successInfo);
    }

    private void getBatchProceesResult(List<String> errors, List<DynamicObject> updateDyos, ListSelectedRowCollection selectedRows, Map<String, Object> returnData) {
        if (returnData != null) {
            DynamicObject[] items;
            Object[] pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            block9: for (DynamicObject itemObj : items = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bdtaxr_datachange_check"))) {
                String currentStatus;
                switch (currentStatus = itemObj.getString("processstatus")) {
                    case "todo": {
                        updateDyos.add(this.updateValues(returnData, itemObj));
                        continue block9;
                    }
                    case "done": 
                    case "no": {
                        errors.add(ResManager.loadKDString((String)"%s:\u6570\u636e\u5df2\u4e3a\u5df2\u5904\u7406\u6216\u65e0\u9700\u5904\u7406\u72b6\u6001", (String)"BussinessDataCheckListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[]{itemObj.getString("number")}));
                        continue block9;
                    }
                }
            }
        }
    }

    private void showOperationResultMulti(int total, List<String> errorList, String successInfo) {
        if (ObjectUtils.isEmpty(errorList)) {
            this.getView().showSuccessNotification(successInfo);
        } else if (total == 1 && errorList.size() == 1) {
            this.getView().showErrorNotification(errorList.get(0));
        } else {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId(OPERATION_RESULT_ENTITY);
            parameters.setShowTitle(false);
            parameters.setCustomParam(OPERATE_NAME, (Object)"");
            String title = ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u5904\u7406\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20", (String)"BussinessDataCheckListPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[]{total, total - errorList.size(), errorList.size()});
            parameters.setCustomParam(TITLE, (Object)title);
            parameters.setCustomParam(ERROR_MSG, errorList);
            this.getView().showForm(parameters);
        }
    }

    private DynamicObject updateValues(Map<String, Object> returnData, DynamicObject itemObj) {
        itemObj.set("processstatus", returnData.get("status"));
        itemObj.set("processcer", (Object)RequestContext.get().getUserId());
        itemObj.set("processtime", (Object)new Date());
        itemObj.set("opinion", returnData.get("opinion"));
        return itemObj;
    }

    private DynamicObject clearValues(DynamicObject itemObj) {
        itemObj.set("processstatus", (Object)"todo");
        itemObj.set("processcer", null);
        itemObj.set("processtime", null);
        itemObj.set("opinion", null);
        return itemObj;
    }
}

