/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.monitor;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.monitor.timertask.BussinessDataCheckService;

public class BussinessDataCheckPlugin
extends AbstractListPlugin {
    private static final String SELECTED_FIELDS = "period,operation,createtime,number,conditionjson,checkdata,daterange,range";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && ((Donothing)args.getSource()).getOperateKey().equals("process")) {
            String currentStatus;
            switch (currentStatus = (String)this.getModel().getValue("processstatus")) {
                case "todo": {
                    this.openCallSettingPage("process");
                    return;
                }
                case "done": 
                case "no": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u5df2\u5904\u7406\u6216\u65e0\u9700\u5904\u7406\u72b6\u6001", (String)"BussinessDataCheckPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
            }
        }
        if (args.getSource() instanceof Donothing && ((Donothing)args.getSource()).getOperateKey().equals("processcer")) {
            this.openCallCkeckPage("processcer");
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void openCallCkeckPage(String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_procescer_dialogue");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    private void openCallSettingPage(String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_process_dialogue");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        String returnDataStr = (String)evt.getReturnData();
        if ("process".equals(evt.getActionId()) && !StringUtil.isEmpty((CharSequence)returnDataStr) && (returnData = (Map)JsonUtil.fromJson((String)returnDataStr, Map.class)) != null) {
            this.updateValues(returnData);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"BussinessDataCheckPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if ("processcer".equals(evt.getActionId()) && !StringUtil.isEmpty((CharSequence)returnDataStr)) {
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)"bdtaxr_data_checkset", (String)SELECTED_FIELDS, null);
            Date now = DateUtils.trunc((Date)new Date());
            ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
            BussinessDataCheckService service = new BussinessDataCheckService();
            service.dataCheck(dyo, now, result, true, null, null);
            SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        }
    }

    private void updateValues(Map<String, Object> returnData) {
        this.getModel().setValue("processstatus", returnData.get("status"));
        this.getModel().setValue("processcer", (Object)RequestContext.get().getUserId());
        this.getModel().setValue("processtime", (Object)new Date());
        this.getModel().setValue("opinion", returnData.get("opinion"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
    }
}

