/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.pdmscript;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.taxc.bdtaxr.common.plugin.AbstractTreePlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class PdmPlaugin
extends AbstractTreePlugin {
    private static Log logger = LogFactory.getLog(PdmPlaugin.class);
    private static final String TREE_ID = "treeviewap";
    private static final String OUT_PUT = "output";
    private static final String NEW_LINE = "\r\n";
    private final DBRoute dBRoute = DBRoute.of((String)"taxc");

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        super.addEnterListener(new String[]{TREE_ID});
    }

    public void afterCreateNewData(EventObject e) {
        List<TreeNode> nodeList = this.queryEntityList();
        super.bind(TREE_ID, nodeList);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("comment".equals(key)) {
            this.outPutComment();
        } else if ("constant".equals(key)) {
            this.outPutConstant();
        } else if ("run".equals(key)) {
            StringBuilder sb = new StringBuilder();
            String routeKey = (String)this.getModel().getValue(OUT_PUT);
            if (routeKey != null && routeKey.toLowerCase(Locale.ENGLISH).startsWith("routekey")) {
                routeKey = routeKey.substring(9);
                try {
                    Connection con = TX.getConnection((String)routeKey, (boolean)false);
                    DatabaseMetaData metadata = con.getMetaData();
                    sb.append("url").append(':').append(metadata.getURL());
                    sb.append(NEW_LINE);
                    sb.append("DriverName").append(':').append(metadata.getDriverName());
                    sb.append(NEW_LINE);
                    sb.append("UserName").append(':').append(metadata.getUserName());
                    sb.append(NEW_LINE);
                    if (con instanceof DelegateConnection) {
                        Class<?> conClass = con.getClass();
                        Field f = conClass.getDeclaredField("dbConfig");
                        AccessibleObject.setAccessible(new AccessibleObject[]{f}, true);
                        DBConfig dBConfig = (DBConfig)f.get(con);
                        if (dBConfig != null) {
                            Class<DBConfig> dBConfigClass = DBConfig.class;
                            AccessibleObject[] fields2 = dBConfigClass.getDeclaredFields();
                            AccessibleObject.setAccessible(fields2, true);
                            for (AccessibleObject field2 : fields2) {
                                sb.append(((Field)field2).getName()).append(':').append(((Field)field2).get(dBConfig));
                                sb.append(NEW_LINE);
                            }
                        }
                    }
                    this.getModel().setValue(OUT_PUT, (Object)sb.toString());
                }
                catch (Exception e) {
                    this.getModel().setValue(OUT_PUT, (Object)e.getMessage());
                }
            }
        }
    }

    private void outPutConstant() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ID);
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        this.getRoot(TREE_ID);
        String newLine = NEW_LINE;
        StringBuilder sb = new StringBuilder();
        for (String entityId : selectIds) {
            try {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                Map entityMap = mainEntityType.getAllEntities();
                for (Map.Entry entry : entityMap.entrySet()) {
                    EntityType entityType = (EntityType)entry.getValue();
                    DataEntityPropertyCollection pros = entityType.getProperties();
                    for (IDataEntityProperty property : pros) {
                        if (property.getDisplayName() == null || !StringUtils.isNotEmpty((CharSequence)property.getAlias())) continue;
                        sb.append("/***").append(property.getDisplayName().getLocaleValue()).append("***/").append(newLine);
                        sb.append("private static final String FIELD_").append(property.getName().toUpperCase()).append("=\"").append(property.getName()).append("\";").append(newLine);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        this.getModel().setValue(OUT_PUT, (Object)sb.toString());
    }

    private void outPutComment() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ID);
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        this.getRoot(TREE_ID);
        String newLine = NEW_LINE;
        StringBuilder sb = new StringBuilder();
        for (String entityId : selectIds) {
            try {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                sb.append("comment on table ").append(mainEntityType.getAlias()).append(" is '").append(mainEntityType.getDisplayName().getLocaleValue()).append("';").append(newLine);
                Map entityMap = mainEntityType.getAllEntities();
                for (Map.Entry entry : entityMap.entrySet()) {
                    EntityType entityType = (EntityType)entry.getValue();
                    DataEntityPropertyCollection pros = entityType.getProperties();
                    if (StringUtil.isBlank((CharSequence)entityType.getAlias())) continue;
                    if (!mainEntityType.getAlias().equals(entityType.getAlias())) {
                        sb.append("comment on table ").append(entityType.getAlias()).append(" is '").append(mainEntityType.getDisplayName().getLocaleValue()).append(entityType.getDisplayName().getLocaleValue()).append("';").append(newLine);
                    }
                    for (IDataEntityProperty property : pros) {
                        if (property instanceof MulBasedataProp || property.getDisplayName() == null || !StringUtils.isNotEmpty((CharSequence)property.getAlias())) continue;
                        sb.append("comment on column ").append(entityType.getAlias());
                        if (property instanceof MuliLangTextProp) {
                            sb.append("_l");
                        }
                        if (StringUtil.isNotBlank((CharSequence)property.getTableGroup())) {
                            sb.append("_").append(property.getTableGroup());
                        }
                        sb.append('.').append(property.getAlias()).append(" is '").append(property.getDisplayName().getLocaleValue()).append("';").append(newLine);
                    }
                }
                String tablel = mainEntityType.getAlias() + "_l";
                Class<?> name = Class.forName("kd.bos.db.DB");
                Method method = ReflectionUtils.findMethod(name, (String)"exitsTable", (Class[])new Class[]{DBRoute.class, String.class});
                Object result = method.invoke(name, this.dBRoute, tablel);
                if (!((Boolean)result).booleanValue()) continue;
                sb.append("comment on table ").append(tablel).append(" is '").append(mainEntityType.getDisplayName().getLocaleValue()).append(ResManager.loadKDString((String)"\u591a\u8bed\u8a00';", (String)"PdmPlaugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0])).append(newLine);
                sb.append("comment on column ").append(tablel).append(ResManager.loadKDString((String)".fpkid is '\u4e3b\u952e';", (String)"PdmPlaugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0])).append(newLine);
                sb.append("comment on column ").append(tablel).append(ResManager.loadKDString((String)".flocaleid is '\u8bed\u8a00\u7c7b\u578b';", (String)"PdmPlaugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0])).append(newLine);
                sb.append("comment on column ").append(tablel).append(ResManager.loadKDString((String)".fname is '\u540d\u79f0';", (String)"PdmPlaugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0])).append(newLine);
            }
            catch (Exception exception) {}
        }
        this.getModel().setValue(OUT_PUT, (Object)sb.toString());
    }

    public List<String> queryTableSchema(String tableName) {
        List list = DBUtils.query((String)("SELECT TABLE_SCHEMA,table_name,TABLE_COMMENT FROM INFORMATION_SCHEMA.TABLES a where TABLE_name='" + tableName + "'"));
        ArrayList<String> listName = new ArrayList<String>(list.size());
        for (Map map : list) {
            listName.add((String)map.get("TABLE_SCHEMA"));
        }
        return listName;
    }

    private List<TreeNode> queryEntityList() {
        ArrayList<TreeNode> listNode = new ArrayList<TreeNode>();
        String sql = "SELECT a.Fnumber,a.Fid,a.Fdata,d.Ftablename,e.Fname Entityname,e.Fnumber Entityid,f.fbizunitid FROM t_Meta_Bizapp         a,      t_Meta_Bizcloud       b,      t_Meta_Entitydesign   c,      t_Meta_Entityinfo     d,      t_Meta_Entitydesign_l e,      T_meta_bizunitrelform f WHERE a.Fbizcloudid = b.Fid  AND b.Fnumber = 'TAXC'  AND a.Fid = c.Fbizappid  AND e.Flocaleid = 'zh_CN'  AND c.Fid = e.Fid  AND c.Fid = d.Fentityid  and d.fentityid=f.fformid ORDER BY a.Fnumber, f.fbizunitid, e.Fnumber";
        List columnList = DBUtils.query((String)DBRoute.meta.getRouteKey(), (String)sql);
        ArrayList<String> bizList = new ArrayList<String>();
        for (Map map : columnList) {
            String bizid = map.get("FNUMBER").toString();
            String entityname = map.get("ENTITYNAME").toString();
            String entityid = map.get("ENTITYID").toString();
            Object fbizunitid = map.get("FBIZUNITID");
            String bizunitid = null;
            if (fbizunitid != null) {
                bizunitid = fbizunitid.toString();
            }
            if (!bizList.contains(bizid)) {
                TreeNode bizNode = new TreeNode();
                bizNode.setId(bizid);
                bizNode.setText(bizid);
                bizNode.setParentid("");
                listNode.add(bizNode);
                bizList.add(bizid);
                String fdata = map.get("FDATA").toString();
                try {
                    this.parseXml(fdata, bizList, listNode, bizid);
                }
                catch (Exception e) {
                    logger.error("queryEntityList exception:", (Object)e.getMessage());
                }
            }
            TreeNode node = new TreeNode();
            node.setId(entityid);
            node.setText(entityid + "_" + entityname);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", entityid);
            data.put("name", entityname);
            node.setData(data);
            if (bizList.contains(bizid + bizunitid)) {
                node.setParentid(bizid + bizunitid);
            } else {
                node.setParentid(bizid);
            }
            listNode.add(node);
        }
        return listNode;
    }

    private void parseXml(String xml, List<String> unitList, List<TreeNode> listNode, String parent) {
        String[] packItems;
        int start = xml.indexOf("<AppFunctionPackets>");
        int end = xml.indexOf("</AppFunctionPackets>");
        String pack = xml.substring(start, end);
        for (String item : packItems = pack.split("</AppFunctionPacketElement>")) {
            if (item.indexOf("<Id>") <= 0 || item.indexOf("<Name>") <= 0) continue;
            String name = item.substring(item.indexOf("<Name>") + 6, item.indexOf("</Name>"));
            String id = item.substring(item.indexOf("<Id>") + 4, item.indexOf("</Id>"));
            TreeNode bizNode = new TreeNode();
            bizNode.setId(parent + id);
            bizNode.setText(name);
            bizNode.setParentid(parent);
            listNode.add(bizNode);
            unitList.add(parent + id);
        }
    }
}

