/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.paramconfig.ParamConfigBusiness;
import kd.taxc.bdtaxr.business.service.taxdeclare.RiskDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.RiskDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.common.constant.TaxDeductionConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.paramconfig.ParamConfigKeyEnum;
import kd.taxc.bdtaxr.common.helper.tctrc.RiskResultHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.GZIPUtils;
import kd.taxc.bdtaxr.common.vo.CalcRangeVo;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.ApitudeService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.BorderCardVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.LoadDeclareDataVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.MultiTctrcwarningVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.TctrcwarningVo;

public class TaxDeclarePluginService {
    private static Log LOGGER = LogFactory.getLog(TaxDeclarePluginService.class);
    private static RiskDataService riskDataService = new RiskDataServiceImpl();
    private static List<String> excludingFilter = Arrays.asList("tpo_tcnfep_bizdef_entry", "bos_user", "bd_currency", "er_taxclasscode", "bastax_supervision", "bastax_taxorgan");
    private static String TAB_NUMBER = "A199998";
    private static String TAB_NUMBER_ORIGIN = "A199999";
    public static final String EWBLXH = "ewblxh";
    public static final String SPLIT_STRING = "#";
    private static final Set<String> BASE_FIELD_LAST = new HashSet<String>();

    public static void checkParams(DeclareRequestModel declareModel) {
        Long orgId = declareModel.getOrgId();
        if (null == orgId) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePluginService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String templateType = declareModel.getTemplateType();
        if (StringUtils.isEmpty((CharSequence)templateType)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6a21\u677f\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePluginService_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        String skssqq = declareModel.getSkssqq();
        if (StringUtils.isEmpty((CharSequence)skssqq)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePluginService_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            sdf.parse(skssqq);
        }
        catch (ParseException e1) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a[yyyy-MM-dd]", (String)"TaxDeclarePluginService_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), e1);
        }
        String skssqz = declareModel.getSkssqz();
        if (StringUtils.isEmpty((CharSequence)skssqz)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePluginService_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        try {
            sdf.parse(skssqz);
        }
        catch (ParseException e1) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a[yyyy-MM-dd]", (String)"TaxDeclarePluginService_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), e1);
        }
    }

    public static void checkResponse(DeclareRequestModel requestModel, DeclareResponseModel responseModel) {
        if (responseModel == null || requestModel.getTemplateId() == null) {
            if ("szys_a".equals(requestModel.getTemplateType()) || "szys_b".equals(requestModel.getTemplateType())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u6240\u5728\u5730\u533a\u6216\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5", (String)"TaxDeclarePluginService_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5", (String)"TaxDeclarePluginService_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    public static void loadPage(LoadDeclareDataVo loadDeclareDataVo) {
        Map<String, String> showData = loadDeclareDataVo.getShowData();
        List<Map<String, String>> checkFormulaList = loadDeclareDataVo.getCheckFormulaList();
        TctrcwarningVo riskResultMap = loadDeclareDataVo.getRiskResultMap();
        DeclareRequestModel requestModel = loadDeclareDataVo.getRequestModel();
        DeclareResponseModel responseModel = loadDeclareDataVo.getResponseModel();
        TemplateVo template = loadDeclareDataVo.getTemplate();
        if (template == null) {
            return;
        }
        CustomControl control = loadDeclareDataVo.getControl();
        Map<String, Object> treeData = loadDeclareDataVo.getTreeData();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (requestModel != null) {
            map.put("operation", requestModel.getOperation());
        }
        if (responseModel != null) {
            map.put("dynRowDataList", TaxDeclarePluginService.parseDynamicRow(responseModel.getDynRowList()));
            map.put("errorinfo", responseModel.getErrorInfo());
        }
        if (treeData != null) {
            map.put("treeData", treeData.get("treeData"));
            map.put("selected", treeData.get("selected"));
        }
        Map currentSheetCells = null;
        String currentSheetId = loadDeclareDataVo.getCurrentSheetId();
        if (StringUtil.isBlank((CharSequence)currentSheetId)) {
            currentSheetId = !CollectionUtils.isEmpty((Collection)template.getTemplate()) ? ((Sheet)template.getTemplate().get(0)).getId() : "0";
        }
        String currentSheet = currentSheetId;
        if (responseModel != null && showData != null) {
            template = DeclareReportHelpService.parseTemplateByData(requestModel, template, showData, responseModel.getDynRowList());
        }
        map.put("templateNumber", template.getTemplateNumber());
        map.put("templateName", template.getTemplateName());
        map.put("template", template.getTemplate() == null ? null : TaxDeclarePluginService.getCurrentSheetForShow(template.getTemplate(), currentSheet));
        map.put("dynamicRow", template.getDynamicRow());
        if (template.getSheetCellMap() != null) {
            currentSheetCells = (Map)template.getSheetCellMap().get(currentSheet);
        }
        if (checkFormulaList != null) {
            checkFormulaList.forEach(e -> {
                e.put("jump", e.get("jump"));
                e.put("items", e.get("items"));
            });
            map.put("riskwarning", checkFormulaList);
        }
        if (riskResultMap != null) {
            map.put("tctrcwarning", riskResultMap.getTctrcwarning());
            map.put("haslicense", riskResultMap.getHaslicense());
        }
        map.put("baseTypeMap", loadDeclareDataVo.getBaseTypeMap());
        map.put("data", currentSheetCells == null ? Collections.emptyMap() : TaxDeclarePluginService.getCurrentSheetDataForShow(currentSheetCells, loadDeclareDataVo.getParseDataForShow()));
        map.put("hisCells", loadDeclareDataVo.getHisCellList());
        map.put("timeMillis", System.currentTimeMillis());
        control.setData(map);
    }

    private static Map<String, Map<String, String>> getCurrentSheetDataForShow(Map<String, String> currentSheetCells, Map<String, Map<String, String>> allDataForShow) {
        if (CollectionUtils.isEmpty(currentSheetCells)) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, String>> getCurrentSheetDataForShow = new HashMap<String, Map<String, String>>(currentSheetCells.size() * 2);
        for (String key : currentSheetCells.keySet()) {
            getCurrentSheetDataForShow.put(key, allDataForShow.get(key));
            StringBuilder newKey = new StringBuilder(key).append("_text");
            Map<String, String> value = allDataForShow.get(newKey.toString());
            if (value == null) continue;
            getCurrentSheetDataForShow.put(newKey.toString(), value);
        }
        return getCurrentSheetDataForShow;
    }

    private static List<Sheet> getCurrentSheetForShow(List<Sheet> templateSheets, String currentSheetId) {
        ArrayList<Sheet> templateShow = new ArrayList<Sheet>();
        templateSheets.forEach(e -> {
            if (!e.getId().equals(currentSheetId)) {
                Sheet sheet = new Sheet();
                sheet.setId(e.getId());
                sheet.setRowNum(e.getRowNum());
                sheet.setColNum(e.getColNum());
                sheet.setFrozenColumnCount(e.getFrozenColumnCount());
                sheet.setFrozenRowCount(e.getFrozenRowCount());
                sheet.setColWidthList(e.getColWidthList());
                sheet.setRowList(new ArrayList(0));
                sheet.setName(e.getName());
                templateShow.add(sheet);
                return;
            }
            templateShow.add((Sheet)e);
        });
        return templateShow;
    }

    public static void parseTypeMap(Map<String, EntityField> typeMap, Map<String, String> newTypeMap, Map<String, String> baseTypeMap) {
        HashMap<String, String> baseTypeMapTemp = new HashMap<String, String>(50);
        int i = 1;
        for (Map.Entry<String, EntityField> entry : typeMap.entrySet()) {
            String fieldType;
            String fieldTypeUUID;
            Format format;
            EntityField field = entry.getValue();
            String formatter = field.getFormatStr();
            if (StringUtil.isBlank((CharSequence)formatter) && (format = field.getFormat()) != null) {
                formatter = ((SimpleDateFormat)format).toPattern();
            }
            if (!StringUtils.isBlank((CharSequence)(fieldTypeUUID = (String)baseTypeMapTemp.get(fieldType = field.isMustInput() + "|" + field.getFieldType() + "|" + field.getMaxLength() + "|" + formatter)))) {
                newTypeMap.put(entry.getKey(), fieldTypeUUID);
                continue;
            }
            fieldTypeUUID = i + "";
            baseTypeMapTemp.put(fieldType, fieldTypeUUID);
            newTypeMap.put(entry.getKey(), fieldTypeUUID);
            ++i;
        }
        for (Map.Entry<String, Object> entry : baseTypeMapTemp.entrySet()) {
            baseTypeMap.put(entry.getValue().toString(), entry.getKey().toString());
        }
    }

    public static Map<String, Object> parseDynamicRow(List<DynamicRowModel> dynRowList) {
        HashMap<String, Object> dynamicRow = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(dynRowList)) {
            return dynamicRow;
        }
        for (DynamicRowModel dynRowModel : dynRowList) {
            dynamicRow.put(dynRowModel.getDynRowNo(), CollectionUtils.isEmpty((Collection)dynRowModel.getRowList()) ? 0 : dynRowModel.getRowList().size());
        }
        return dynamicRow;
    }

    public static Map<String, Integer> parseDynamicRowFilterParam(List<DynamicRowModel> dynRowList) {
        HashMap<String, Integer> dynDataFilterParam = new HashMap<String, Integer>();
        if (CollectionUtils.isEmpty(dynRowList)) {
            return dynDataFilterParam;
        }
        for (DynamicRowModel dynRowModel : dynRowList) {
            if (!dynRowModel.getFilter()) continue;
            dynDataFilterParam.put(dynRowModel.getDynRowNo(), dynRowModel.getDynheader());
        }
        return dynDataFilterParam;
    }

    public static Map<String, Map<String, String>> parseShowData(Map<String, String> showData, Map<String, String> typeMap) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(showData.size());
        for (Map.Entry<String, String> entry : showData.entrySet()) {
            HashMap<String, String> m1 = new HashMap<String, String>(16);
            m1.put("v", entry.getValue());
            m1.put("t", typeMap.get(entry.getKey()));
            map.put(entry.getKey(), m1);
        }
        return map;
    }

    public static Map<String, String> showDataAddDefaultValueData(Map<String, String> showData, Map<String, EntityField> fieldTypeMap) {
        if (!CollectionUtils.isEmpty(showData) && !CollectionUtils.isEmpty(fieldTypeMap)) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            Sets.SetView differenceSets = Sets.difference(fieldTypeMap.keySet(), showData.keySet());
            for (String cellKey : differenceSets) {
                EntityField fieldType = fieldTypeMap.get(cellKey);
                if (fieldType == null || !"decimal".equalsIgnoreCase(fieldType.getFieldType()) && !"date".equalsIgnoreCase(fieldType.getFieldType()) && !"text".equalsIgnoreCase(fieldType.getFieldType())) continue;
                String value = DataFormatUtils.dataFormatByFieldType((Object)"", (EntityField)fieldType);
                map.put(cellKey, value);
            }
            if (!CollectionUtils.isEmpty(map)) {
                showData.putAll(map);
            }
        }
        return showData;
    }

    public static void loadPageMulti(LoadDeclareDataVo loadDeclareDataVo) {
        String currentSheetId;
        Map<String, String> showData = loadDeclareDataVo.getShowData();
        Map<String, EntityField> typeMap = loadDeclareDataVo.getTypeMap();
        showData = TaxDeclarePluginService.showDataAddDefaultValueData(showData, typeMap);
        List<Map<String, String>> checkFormulaList = loadDeclareDataVo.getCheckFormulaList();
        TctrcwarningVo riskResultMap = loadDeclareDataVo.getRiskResultMap();
        DeclareRequestModel requestModel = loadDeclareDataVo.getRequestModel();
        DeclareResponseModel responseModel = loadDeclareDataVo.getResponseModel();
        TemplateVo template = loadDeclareDataVo.getTemplate();
        if (template == null) {
            return;
        }
        CustomControl control = loadDeclareDataVo.getControl();
        Map<String, Object> treeData = loadDeclareDataVo.getTreeData();
        List<BorderCardVo> borderCardVoList = loadDeclareDataVo.getBorderCardVoList();
        List<MultiTctrcwarningVo> multiTctrcwarningVoList = loadDeclareDataVo.getMultiTctrcwarningVoList();
        String operation = requestModel.getOperation();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("templateType", requestModel.getTemplateType());
        map.put("operation", operation);
        map.put("dynRowDataList", TaxDeclarePluginService.parseDynamicRow(responseModel.getDynRowList()));
        map.put("dynRowDataFilterParam", TaxDeclarePluginService.parseDynamicRowFilterParam(responseModel.getDynRowList()));
        if (!CollectionUtils.isEmpty(borderCardVoList)) {
            map.put("borderCardVoList", borderCardVoList);
        }
        if (responseModel.getErrorInfo() != null) {
            map.put("errorinfo", responseModel.getErrorInfo());
        }
        if (treeData != null) {
            map.put("treeData", treeData.get("treeData"));
            map.put("selected", treeData.get("selected"));
        }
        if (StringUtil.isBlank((CharSequence)(currentSheetId = loadDeclareDataVo.getCurrentSheetId()))) {
            currentSheetId = !CollectionUtils.isEmpty((Collection)template.getTemplate()) ? ((Sheet)template.getTemplate().get(0)).getId() : "0";
        }
        ArrayList<Sheet> currentSheetForShow = new ArrayList<Sheet>(10);
        Map templateDynamicRowMap = template.getDynamicRow();
        currentSheetForShow = (template = DeclareReportHelpService.parseTemplateByData(requestModel, template, showData, responseModel.getDynRowList())).getTemplate() != null ? TaxDeclarePluginService.getCurrentSheetForShow(template.getTemplate(), currentSheetId) : null;
        map.put("template", currentSheetForShow);
        map.put("dynamicRow", templateDynamicRowMap);
        if (checkFormulaList != null) {
            map.put("riskwarning", checkFormulaList);
        }
        if (riskResultMap != null) {
            map.put("tctrcwarning", riskResultMap.getTctrcwarning());
            map.put("haslicense", riskResultMap.getHaslicense());
        }
        if ("read".equals(operation)) {
            List<String> hisCellList = TaxDeclarePluginService.queryHasHisCell(String.valueOf(requestModel.getId()));
            map.put("hisCells", hisCellList);
        }
        HashMap<String, String> newTypeMap = new HashMap<String, String>(typeMap.size());
        HashMap<String, String> baseTypeMap = new HashMap<String, String>(50);
        if (!CollectionUtils.isEmpty(typeMap)) {
            TaxDeclarePluginService.parseTypeMap(typeMap, newTypeMap, baseTypeMap);
            map.put("baseTypeMap", baseTypeMap);
        }
        Map<String, String> newShowData = TaxDeclarePluginService.getCurrentSheetDataForMulti(showData, currentSheetForShow, templateDynamicRowMap, currentSheetId);
        map.put("data", TaxDeclarePluginService.parseShowData(newShowData, newTypeMap));
        map.put("dataSource", responseModel.getDataSource());
        if (!CollectionUtils.isEmpty(multiTctrcwarningVoList)) {
            map.put("multiTctrcwarningVoList", multiTctrcwarningVoList);
        }
        map.put("timeMillis", System.currentTimeMillis());
        control.setData(map);
        String loadPageEncrypted = ParamConfigBusiness.getParamConfigByKey((String)ParamConfigKeyEnum.LOADPAGEENCRYPTED.getConfigType(), (String)ParamConfigKeyEnum.LOADPAGEENCRYPTED.getConfigKey());
        if ("1".equals(loadPageEncrypted)) {
            HashMap<String, String> result = new HashMap<String, String>();
            String jsonString = SerializationUtils.toJsonString(map);
            String zipData = new String(Base64.getEncoder().encode(GZIPUtils.compress((String)jsonString)));
            result.put("zipdata", zipData);
            control.setData(result);
        } else {
            control.setData(map);
        }
    }

    private static Map<String, String> getCurrentSheetDataForMulti(Map<String, String> showData, List<Sheet> currentSheetForShow, Map<String, List<List<Cell>>> templateDynamicRowMap, String currentSheetId) {
        if (CollectionUtils.isEmpty(showData) || CollectionUtils.isEmpty(currentSheetForShow) || currentSheetForShow == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> getCurrentSheetDataForShow = new HashMap<String, String>(100);
        currentSheetForShow.stream().flatMap(v -> v.getRowList().stream()).flatMap(Collection::stream).filter(cell -> currentSheetId.equals(cell.getSheetId())).forEach(cell -> {
            String key = cell.getCellKey();
            if (StringUtil.isNotEmpty((CharSequence)key)) {
                getCurrentSheetDataForShow.put(key, (String)showData.get(key));
                StringBuilder newKey = new StringBuilder(key).append("_text");
                String value = (String)showData.get(newKey.toString());
                if (value != null) {
                    getCurrentSheetDataForShow.put(newKey.toString(), value);
                }
            }
        });
        if (templateDynamicRowMap != null) {
            templateDynamicRowMap.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).filter(cell -> currentSheetId.equals(cell.getSheetId())).forEach(cell -> {
                String key = cell.getCellKey();
                if (StringUtil.isNotEmpty((CharSequence)key)) {
                    getCurrentSheetDataForShow.put(key, (String)showData.get(key));
                    StringBuilder newKey = new StringBuilder(key).append("_text");
                    String value = (String)showData.get(newKey.toString());
                    if (value != null) {
                        getCurrentSheetDataForShow.put(newKey.toString(), value);
                    }
                }
            });
        }
        return getCurrentSheetDataForShow;
    }

    public static Map<String, Object> getRiskResultMap(DeclareRequestModel requestModel) {
        HashMap<String, Object> riskResultMap = new HashMap<String, Object>(4);
        Long orgId = requestModel.getOrgId();
        boolean isnothaslicense = LicenseCheckServiceHelper.check((Object)orgId, null, (String)"tctrc");
        if (!isnothaslicense) {
            List<Map<String, String>> tctrcResultMapList = riskDataService.queryTctrcResult(requestModel);
            riskResultMap.put("tctrcwarning", tctrcResultMapList);
            riskResultMap.put("haslicense", "1");
        } else {
            riskResultMap.put("tctrcwarning", new ArrayList());
            riskResultMap.put("haslicense", "0");
        }
        return riskResultMap;
    }

    public static TctrcwarningVo getRiskResult(DeclareRequestModel requestModel) {
        List<Map<String, String>> tctrcResultMapList;
        TctrcwarningVo riskResult = new TctrcwarningVo();
        Long orgId = requestModel.getOrgId();
        boolean isnothaslicense = LicenseCheckServiceHelper.check((Object)orgId, null, (String)"tctrc");
        riskResult.setHaslicense(isnothaslicense ? "0" : "1");
        riskResult.setTctrcwarning(new ArrayList<Map<String, String>>(0));
        if (!isnothaslicense && (tctrcResultMapList = riskDataService.queryTctrcResult(requestModel)) != null) {
            riskResult.setTctrcwarning(tctrcResultMapList);
        }
        return riskResult;
    }

    public static List<MultiTctrcwarningVo> getMultiRiskResult(DeclareRequestModel requestModel) {
        if (LicenseCheckServiceHelper.check((Object)requestModel.getOrgId(), null, (String)"tctrc")) {
            LOGGER.info("No license found for tctrc.");
            return new ArrayList<MultiTctrcwarningVo>();
        }
        String draftPurpose = (String)requestModel.getExtendParams().get("draftpurpose");
        TaxResult result = RiskResultHelper.getRiskMetricsResult((String)requestModel.getTemplateType(), (String)requestModel.getSkssqq(), (String)requestModel.getSkssqz(), (Long)requestModel.getOrgId(), (String)draftPurpose, null);
        if (!result.isSuccess()) {
            TaxDeclarePluginService.logErrorDetails((TaxResult<List<Map<String, String>>>)result, requestModel);
            return new ArrayList<MultiTctrcwarningVo>();
        }
        List tctrcResultMapList = (List)result.getData();
        if (CollectionUtils.isEmpty((Collection)tctrcResultMapList)) {
            return new ArrayList<MultiTctrcwarningVo>();
        }
        LOGGER.info("tctrc-RiskService.getRiskMetricsResult-tctrcResultMapList : {}.", (Object)tctrcResultMapList);
        return MultiTctrcwarningVo.createMultiTctrcwarningVoList(tctrcResultMapList, true);
    }

    private static void logErrorDetails(TaxResult<List<Map<String, String>>> result, DeclareRequestModel requestModel) {
        StringBuilder details = new StringBuilder().append("templateType: ").append(requestModel.getTemplateType()).append(" skssqq: ").append(requestModel.getSkssqq()).append(" skssqz: ").append(requestModel.getSkssqz()).append(" orgId: ").append(requestModel.getOrgId()).append(" draftPurpose: null");
        LOGGER.info("taxc.tctrc.RiskService.getRiskMetricsResult error! [param:{}] code:{} message:{}", new Object[]{details.toString(), result.getCode(), result.getMessage()});
    }

    public static List<String> queryHasHisCell(String sbbid) {
        long t1 = System.currentTimeMillis();
        ArrayList<String> cellIdList = new ArrayList<String>();
        if (sbbid != null) {
            QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_declare_his", (String)"cellid", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject obj : collection) {
                String cellid = obj.getString("cellid");
                if (cellIdList.contains(cellid)) continue;
                cellIdList.add(cellid);
            }
        }
        long t2 = System.currentTimeMillis();
        LOGGER.info("\u67e5\u8be2\u5386\u53f2\u8bb0\u5f55\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
        return cellIdList;
    }

    public static List<String> queryReGetDataHisCell(String sbbid) {
        long t1 = System.currentTimeMillis();
        ArrayList<String> cellIdList = new ArrayList<String>();
        if (sbbid != null) {
            QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_declare_his", (String)"cellid,modifytype", (QFilter[])new QFilter[]{qFilter}, (String)"modifydatefield desc");
            for (DynamicObject obj : collection) {
                String cellid = obj.getString("cellid");
                String modifytype = obj.getString("modifytype");
                if (cellIdList.contains(cellid) || !"2".equals(modifytype)) continue;
                cellIdList.add(cellid);
            }
        }
        long t2 = System.currentTimeMillis();
        LOGGER.info("\u67e5\u8be2\u5386\u53f2\u8bb0\u5f55\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
        return cellIdList;
    }

    public static BillShowParameter setBaseDataDetail(String cellId, String entityId, Map<String, Object> customParams, CloseCallBack closeCallBack, String formulaName) {
        BaseShowParameter showParameter = new BaseShowParameter();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityId);
        LocaleString caption = formConfig.getCaption();
        showParameter.getOpenStyle().setShowType(formConfig.getViewShowType());
        if (formConfig.getViewShowType() != ShowType.Modal) {
            showParameter.getOpenStyle().setTargetKey("tabap");
        }
        showParameter.setCaption(caption.toString());
        showParameter.setCustomParam("PERM_IGNORE_CHECKAPP", (Object)true);
        showParameter.setFormId(entityId);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    public static ListShowParameter setBaseData(String cellId, String entityId, String minCompany, Map<String, Object> customParams, CloseCallBack closeCallBack, String formulaName) {
        JSONArray jsonArray;
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityId, (boolean)false, (int)2);
        showParameter.getCustomParams().put("cellId", cellId);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (showParameter.getBillFormId().equals("tpo_discount_tree") || showParameter.getBillFormId().equals("tpo_yearitems_tree")) {
            showParameter.setFormId("bos_treelistf7");
            if (showParameter.getBillFormId().equals("tpo_discount_tree")) {
                customParams.put("template", "qysdsyj");
                customParams.put("type", "yhxm");
            } else {
                customParams.put("template", "qysdsyj");
                customParams.put("type", "acce");
            }
            showParameter.setCustomParams(customParams);
            listFilterParameter = showParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            QFilter q = TaxDeclarePluginService.appendQfiler(cellId, minCompany, customParams);
            if (q != null) {
                qFilters.add(q);
            }
            TreeFilterParameter treeFilterParameter = showParameter.getTreeFilterParameter();
            treeFilterParameter.setQFilters(qFilters);
            listFilterParameter.getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
        } else if (!excludingFilter.contains(entityId) && StringUtil.isNotEmpty((CharSequence)formulaName) && (jsonArray = JSONArray.parseArray((String)formulaName)) != null && jsonArray.size() > 0) {
            JSONObject o = (JSONObject)jsonArray.get(0);
            QFilter treefilter = TaxDeclarePluginService.convertQfilter(o.getString("treefilter"));
            QFilter listfilter = TaxDeclarePluginService.convertQfilter(o.getString("listfilter"));
            boolean isDefaultFilter = !"false".equals(o.getString("defaultfilter"));
            boolean showtree = "true".equals(o.getString("showtree"));
            boolean multiSelect = "true".equals(o.getString("multiselect"));
            boolean quickAddNew = "true".equals(o.getString("quickaddnew"));
            if (multiSelect || quickAddNew) {
                showParameter.setMultiSelect(true);
            }
            TreeFilterParameter treeFilterParameter = showParameter.getTreeFilterParameter();
            if (showtree) {
                showParameter.setFormId("bos_treelistf7");
            }
            TaxDeclarePluginService.setFilter(cellId, entityId, listFilterParameter, treeFilterParameter, customParams, isDefaultFilter, treefilter, listfilter);
            showParameter.setTreeFilterParameter(treeFilterParameter);
        }
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    private static QFilter convertQfilter(String filterStr) {
        if (StringUtil.isNotEmpty((CharSequence)filterStr)) {
            try {
                return QFilter.of((String)filterStr, (Object[])new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("qfitler\u8f6c\u6362\u5f02\u5e38\uff1a" + filterStr, (Throwable)e);
            }
        }
        return null;
    }

    private static QFilter appendQfiler(String type, String minCompany, Map<String, Object> customParams) {
        QFilter q1 = null;
        Date skssqq = (Date)customParams.get("skssqq");
        Date skssqz = (Date)customParams.get("skssqz");
        if (skssqq == null || skssqz == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePluginService_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        QFilter dateFilter = new QFilter("start", "<=", (Object)skssqq).and(new QFilter("end", ">=", (Object)skssqz).or(new QFilter("end", "is null", null)));
        if (type.startsWith("tccit_qysds_ext_dyn#") && type.endsWith("#item")) {
            q1 = new QFilter("longnumber", "like", (Object)"%YJ-JJSR2021%").or(new QFilter("longnumber", "like", (Object)"%YJ-MSSR2021%")).or(new QFilter("longnumber", "like", (Object)"%YJ-JJKC2021%")).and(dateFilter).and(new QFilter("template", "=", (Object)"qysdsyj"));
        } else if (type.startsWith("tccit_qysds_ext_dyn2#") && type.endsWith("#item")) {
            q1 = new QFilter("number", "=", (Object)"YJ-SDJM2021").or(new QFilter("number", "like", (Object)"SD%")).and(dateFilter);
        } else if (type.startsWith("tccit_qysds_ext_dyn3#") && type.endsWith("#item")) {
            if ("0".equals(minCompany)) {
                q1 = new QFilter("longnumber", "like", (Object)"YJ-JMSE2021").or(new QFilter("longnumber", "like", (Object)"YJ-JMSE2021.%")).and(new QFilter("number", "not in", (Object)new String[]{"JMSE00306A", "JMSE00307A", "JMSE00604", "JMSE00100"})).and(dateFilter);
            } else if ("1".equals(minCompany)) {
                q1 = new QFilter("number", "=", (Object)"JMSE00100").and(dateFilter);
            } else {
                q1 = QFilter.of((String)"1!=1", (Object[])new Object[0]);
                customParams.put("needTips", "true");
            }
            String rjjcdlqyyhzc = (String)customParams.get("rjjcdlqyyhzc");
            if (StringUtil.isBlank((CharSequence)rjjcdlqyyhzc)) {
                q1.and(new QFilter("number", "not in", (Object)new String[]{"JMSE00301B", "JMSE00302B", "JMSE00303B", "JMSE00304B", "JMSE00305B", "JMSE00306B", "JMSE00307B", "JMSE00308B", "JMSE00309B", "JMSE00310B", "JMSE00301A", "JMSE00302A", "JMSE00303A", "JMSE00304A", "JMSE00305A", "JMSE00308A", "JMSE00309A"}));
            } else if ("1".equals(rjjcdlqyyhzc)) {
                q1.and(new QFilter("number", "not in", (Object)new String[]{"JMSE00301A", "JMSE00302A", "JMSE00303A", "JMSE00304A", "JMSE00305A", "JMSE00308A", "JMSE00309A"}));
            } else if ("2".equals(rjjcdlqyyhzc)) {
                q1.and(new QFilter("number", "not in", (Object)new String[]{"JMSE00301B", "JMSE00302B", "JMSE00303B", "JMSE00304B", "JMSE00305B", "JMSE00306B", "JMSE00307B", "JMSE00308B", "JMSE00309B", "JMSE00310B"}));
            }
        } else if (type.startsWith("tccit_qysds_a201020_dyn1")) {
            q1 = new QFilter("longnumber", "=", (Object)"acce").or(new QFilter("longnumber", "like", (Object)"%acce.10%"));
        } else if (type.startsWith("tccit_qysds_a201020_dyn2")) {
            q1 = new QFilter("longnumber", "=", (Object)"acce").or(new QFilter("longnumber", "like", (Object)"%acce.20%")).and(new QFilter("number", "!=", (Object)"JSZJ1020"));
        }
        return q1;
    }

    private static void setFilter(String cellId, String entityId, ListFilterParameter listFilterParameter, TreeFilterParameter treeFilterParameter, Map<String, Object> customParams, boolean isDefaultFilter, QFilter treefilter, QFilter listfilter) {
        DataEntityPropertyCollection properties;
        QFilter periodFilter;
        QFilter qFilter;
        QFilter dateFilter;
        String taxlimit;
        if (null == customParams) {
            throw new IllegalArgumentException("Illegal parameters!!!");
        }
        String declareRequest = (String)customParams.getOrDefault("declareRequest", "");
        if (StringUtil.isBlank((CharSequence)declareRequest)) {
            declareRequest = (String)customParams.getOrDefault("declareRequestData", "");
        }
        JSONObject obj = JSONObject.parseObject((String)declareRequest);
        String templatetype = obj.get((Object)"templateType").toString();
        String startDate = obj.get((Object)"skssqq").toString();
        String endDate = obj.get((Object)"skssqz").toString();
        String orgid = obj.get((Object)"orgId").toString();
        Date declaredate = Optional.ofNullable((JSONObject)obj.get((Object)"businessMap")).map(s -> s.getDate("declaredate")).orElseGet(() -> new Date());
        String string = taxlimit = customParams.get("taxlimit") == null ? "" : customParams.get("taxlimit").toString();
        if ("fjsf".equals(templatetype) || StringUtils.isNotEmpty((CharSequence)templatetype) && templatetype.contains("zzs")) {
            if ("tcvat_sb_fjsf_1_jmxzdm".equals(cellId) || "tcvat_sb_fjsf#1#jmxzdm".equals(cellId)) {
                templatetype = "cswhjss";
            }
            if ("tcvat_sb_fjsf_2_jmxzdm".equals(cellId) || "tcvat_sb_fjsf#2#jmxzdm".equals(cellId) || "tcvat_sb_fjsf#2#sdqyjmxzdm".equals(cellId)) {
                templatetype = "jyffj";
            }
            if ("tcvat_sb_fjsf_3_jmxzdm".equals(cellId) || "tcvat_sb_fjsf#3#jmxzdm".equals(cellId) || "tcvat_sb_fjsf#3#sdqyjmxzdm".equals(cellId)) {
                templatetype = "dfjyffj";
            }
        }
        if ("QTSF_FSSTYSBB".equalsIgnoreCase(templatetype) || "QTSF_TYSBB".equalsIgnoreCase(templatetype)) {
            Date lastDeclareMonth = DateUtils.addMonth((Date)declaredate, (int)-1);
            String currentZsxm = (String)customParams.get("currentZsxm");
            QFilter q1 = new QFilter("taxcategory.name", "in", (Object)currentZsxm);
            QFilter q2 = new QFilter("startdate", "<=", (Object)lastDeclareMonth).and(new QFilter("enddate", ">=", (Object)lastDeclareMonth).or(new QFilter("enddate", "is null", null)));
            listFilterParameter.getQFilters().add(q1);
            listFilterParameter.getQFilters().add(q2);
        }
        if ("tpo_taxdeduction".equals(entityId) && null != TaxDeductionConstant.getMap().get(templatetype)) {
            QFilter cateGoryFilter = new QFilter("taxcategory", "=", TaxDeductionConstant.getMap().get(templatetype));
            listFilterParameter.getQFilters().add(cateGoryFilter);
        }
        if ("tpo_taxdeduction".equals(entityId) && "xfsjfj".equals(templatetype)) {
            dateFilter = new QFilter("startdate", "<=", (Object)DateUtils.stringToDate2((String)startDate)).and(new QFilter("enddate", ">=", (Object)DateUtils.stringToDate2((String)endDate)).or(new QFilter("enddate", "is null", null)));
            listFilterParameter.getQFilters().add(dateFilter);
        }
        if ("tcnfep_fdyqkjhzxsbqk#1#xstddy".equals(cellId)) {
            qFilter = new QFilter("policycaluse", "like", (Object)ResManager.loadKDString((String)"%\u7a0e\u6536\u534f\u5b9a%", (String)"TaxDeclarePluginService_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            listFilterParameter.getQFilters().add(qFilter);
        }
        if ("tcnfep_fdyqkjhzxsbqk#1#xsgnssyh".equals(cellId)) {
            qFilter = new QFilter("taxcategory.number", "=", (Object)"003");
            listFilterParameter.getQFilters().add(qFilter);
        }
        if ("tpo_ictm_bizdef_entry".equals(entityId)) {
            qFilter = new QFilter("validfrom", "<=", (Object)new Date()).and(new QFilter("expired", ">=", (Object)new Date()).or(new QFilter("expired", "is null", null)));
            listFilterParameter.getQFilters().add(qFilter);
        }
        if ("tpo_tccit_bizdef_entry".equals(entityId)) {
            periodFilter = new QFilter("validfrom", "<=", (Object)DateUtils.stringToDate((String)startDate)).and(new QFilter("expired", ">=", (Object)DateUtils.stringToDate((String)endDate)).or("expired", "is null", null));
            listFilterParameter.getQFilters().add(periodFilter);
        }
        if ("ncpdg_import".equals(templatetype) && "tcvat_ncp_declare_name".equals(entityId)) {
            periodFilter = new QFilter("startdate", "<=", (Object)DateUtils.stringToDate((String)startDate)).and(new QFilter("enddate", ">=", (Object)DateUtils.stringToDate((String)endDate)).or("enddate", "is null", null));
            periodFilter.and("orgid", "=", (Object)(orgid != null ? Long.parseLong(orgid) : 0L)).and("enable", "=", (Object)"1");
            listFilterParameter.getQFilters().add(periodFilter);
        }
        if ("zzsxgmnsr".equals(templatetype)) {
            dateFilter = new QFilter("entryentity.startDate", "<=", (Object)DateUtils.stringToDate((String)startDate)).and(new QFilter("entryentity.endDate", ">=", (Object)DateUtils.stringToDate((String)endDate)).or("entryentity.endDate", "is null", null));
            QFilter taxPeriodFilter = new QFilter("taxperiod", "=", (Object)(startDate != null ? startDate.substring(0, 7) : ""));
            QFilter deadlineFilter = new QFilter("deadline", "=", (Object)("season".equals(taxlimit) ? "ajsb" : "aysb"));
            QFilter orgFilter = new QFilter("org", "=", (Object)(orgid != null ? Long.parseLong(orgid) : 0L));
            QFilter ewblxhFilter = new QFilter(EWBLXH, "=", (Object)"25");
            DynamicObject payment = QueryServiceHelper.queryOne((String)"tcvat_xgm_current_payment", (String)"salesexcludtax", (QFilter[])new QFilter[]{taxPeriodFilter, deadlineFilter, orgFilter, ewblxhFilter});
            BigDecimal salesexcludtax = payment != null ? payment.getBigDecimal("salesexcludtax") : BigDecimal.ZERO;
            DynamicObject assistid = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist", (String)"id", (QFilter[])new QFilter[]{dateFilter, new QFilter("number", "=", (Object)"Tax ThresholdQ-SS")});
            if (assistid != null) {
                DynamicObject assist = BusinessDataServiceHelper.loadSingleFromCache((Object)assistid.getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tpo_tcvat_assist"));
                String value = ((DynamicObject)assist.getDynamicObjectCollection("entryentity").get(0)).getString("fvalue1");
                int result = salesexcludtax.compareTo(new BigDecimal(value));
                if (result <= 0) {
                    listFilterParameter.getQFilters().add(new QFilter("number", "!=", (Object)"01045308"));
                }
            } else {
                listFilterParameter.getQFilters().add(new QFilter("number", "!=", (Object)"01045308"));
            }
        }
        if (isDefaultFilter && (properties = BusinessDataServiceHelper.newDynamicObject((String)entityId).getDynamicObjectType().getProperties()).containsKey((Object)"startDate") && properties.containsKey((Object)"endDate") && properties.containsKey((Object)"status")) {
            QFilter periodFilter2 = new QFilter("startDate", "<=", (Object)DateUtils.stringToDate((String)startDate)).and(new QFilter("endDate", ">=", (Object)DateUtils.stringToDate((String)endDate)).or("endDate", "is null", null));
            listFilterParameter.getQFilters().add(periodFilter2);
            listFilterParameter.getQFilters().add(new QFilter("status", "=", (Object)"C"));
        }
        if (listfilter != null) {
            listFilterParameter.getQFilters().add(listfilter);
        }
        if (treefilter != null && treeFilterParameter != null) {
            treeFilterParameter.getQFilters().add(treefilter);
        }
    }

    public static boolean StringValueExist(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return false;
        }
        try {
            BigDecimal value = new BigDecimal(str);
            if (value.compareTo(BigDecimal.ZERO) == 0) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("Number Format Error!");
        }
        return true;
    }

    public static FormShowParameter jumpToTctrcRiskParam(String tctrcResultId) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(tctrcResultId));
        DynamicObject result = QueryServiceHelper.queryOne((String)"tctrc_risk_run_result", (String)"risk.risktype", (QFilter[])new QFilter[]{qFilter});
        if (result == null) {
            return null;
        }
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Long> customParams = new HashMap<String, Long>(4);
        String risktype = result.getString("risk.risktype");
        if ("1".equals(risktype)) {
            param.setFormId("tctrc_risk_result_number");
        } else if ("2".equals(risktype)) {
            param.setFormId("tctrc_risk_result_sample");
        } else {
            param.setFormId("tctrc_risk_result_verify");
        }
        customParams.put("resultid", Long.parseLong(tctrcResultId));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return param;
    }

    public static Map<String, Object> loadTree(DeclareRequestModel requestModel, String selectNode, String sourceFrom) {
        QFilter qFilter = new QFilter("type", "=", (Object)"sbb");
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"tpo_qysds_types", (String)"id,name,title,number,parent", (QFilter[])new QFilter[]{qFilter}, (String)"order");
        if (dcs == null || dcs.isEmpty()) {
            return null;
        }
        String skssqq = requestModel.getSkssqq();
        String skssqz = requestModel.getSkssqz();
        Long orgId = requestModel.getOrgId();
        ArrayList<String> declareidList = new ArrayList<String>();
        DynamicObject draft = StatusUtils.queryOne((String)"draft_qysdsnb", (String)orgId.toString(), (String)skssqq, (String)skssqz, (String)"nssb");
        if (draft != null) {
            QFilter orgFilter = new QFilter("orgid", "=", (Object)orgId);
            QFilter startFilter = new QFilter("startdate", ">=", (Object)DateUtils.stringToDate((String)skssqq));
            QFilter endFilter = new QFilter("startdate", "<=", (Object)DateUtils.stringToDate((String)skssqz));
            DynamicObjectCollection policyList = QueryServiceHelper.query((String)"tccit_policy_confirm", (String)"id,status,entryentity.declareid as declareid", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
            for (DynamicObject obj : policyList) {
                declareidList.add(obj.getString("declareid"));
            }
        }
        DynamicObjectCollection apitudeEntryEntity = ApitudeService.getApitudeEntryEntity(orgId);
        Boolean showCard = ApitudeService.show(apitudeEntryEntity, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz));
        String selectNumber = ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u5e74\u5ea6\u7eb3\u7a0e\u7533\u62a5\u8868\u586b\u62a5\u8868", (String)"TaxDeclarePluginService_10", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (DynamicObject obj : dcs) {
            String name;
            String number;
            TreeNode leftRoot = new TreeNode();
            String id = obj.getString("id");
            if (!TaxDeclarePluginService.show(sourceFrom, declareidList, id, number = obj.getString("number"), showCard).booleanValue()) continue;
            if (selectNode != null && selectNode.equalsIgnoreCase(number)) {
                selectNumber = number;
            }
            if (StringUtils.isEmpty((CharSequence)(name = obj.getString("name")))) {
                name = obj.getString("title");
            }
            String parentid = obj.getString("parent");
            leftRoot.setId(id);
            leftRoot.setText(name);
            leftRoot.setType(number);
            leftRoot.setParentid(parentid);
            nodeList.add(leftRoot);
        }
        List treeNodes = TreeUtils.buildWithChildren(nodeList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("treeData", treeNodes);
        if (StringUtils.isNotEmpty((CharSequence)selectNode)) {
            data.put("selected", selectNumber);
        }
        return data;
    }

    static Boolean show(String sourceFrom, List<String> declareidList, String id, String number, Boolean showCard) {
        ArrayList whiteList = Lists.newArrayList((Object[])new String[]{TAB_NUMBER, TAB_NUMBER_ORIGIN});
        Boolean notSelect = StringUtils.equals((CharSequence)sourceFrom, (CharSequence)"2") || declareidList.size() == 0;
        if (showCard.booleanValue() && "A107041".equals(number)) {
            return Boolean.TRUE;
        }
        if (notSelect.booleanValue()) {
            return Boolean.TRUE;
        }
        if (declareidList.contains(id) || whiteList.contains(number)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Long getTemplateId(DeclareRequestModel requestModel) {
        Long templateId = null;
        try {
            DynamicObject template = TemplateUtils.getTemplateObjectByConfig((DeclareRequestModel)requestModel);
            if (template != null) {
                templateId = template.getLong("id");
            }
        }
        catch (Throwable e) {
            LOGGER.error("TemplateServiceImpl-getTemplateId-error", e);
            return templateId;
        }
        return templateId;
    }

    public static Long generateSBBId(String entityName) {
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            return DBServiceHelper.genLongIds((String)entityName, (int)1)[0];
        }
        return DBServiceHelper.genLongIds((String)"tpo_declare_main_tsd", (int)1)[0];
    }

    public static void calValues(Map<String, Map<String, String>> classformula, Map<String, FormulaVo> formulas, String key, Map<String, String> variableKeys) {
        Map<String, String> calFormula = classformula.get(key);
        if (null != calFormula && calFormula.get(key) != null) {
            calFormula.remove(key);
        }
        if (null != calFormula && calFormula.size() > 0) {
            for (String k : calFormula.keySet()) {
                FormulaVo f = formulas.get(k);
                if (null == f || variableKeys.containsKey(f.getFormulaKey())) continue;
                variableKeys.put(f.getFormulaKey(), f.getFormulaKey());
                TaxDeclarePluginService.calValues(classformula, formulas, f.getFormulaKey(), variableKeys);
            }
        }
    }

    public static Long getZeroTemplateId(String templateType, String orgId, Date startDate, Date endDate) {
        Long templateId = null;
        try {
            DynamicObject template = TemplateUtils.getZeroDeclareTemplate((String)templateType, (String)orgId, (Date)startDate, (Date)endDate);
            if (template != null) {
                templateId = template.getLong("id");
            }
        }
        catch (Throwable e) {
            LOGGER.error("TemplateServiceImpl-getTemplateId-error", e);
            return templateId;
        }
        return templateId;
    }

    public static TemplateVo getTemplateVo(DeclareRequestModel requestModel, Boolean isZeroDeclare) {
        TemplateVo templateVo = null;
        try {
            DynamicObject template;
            DynamicObject dynamicObject = template = isZeroDeclare == false ? TemplateUtils.getTemplateObjectByConfig((DeclareRequestModel)requestModel) : TemplateUtils.getZeroDeclareTemplate((String)requestModel.getTemplateType(), (String)String.valueOf(requestModel.getOrgId()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqq(), (String)"yyyy-MM-dd"), (Date)DateUtils.stringToDate((String)requestModel.getSkssqz(), (String)"yyyy-MM-dd"));
            if (template != null) {
                Long templateId = template.getLong("id");
                String templateNumber = template.getString("number");
                String templateContent = template.getString("content_tag");
                templateVo = new TemplateVo();
                templateVo.setTemplateId(templateId);
                templateVo.setTemplateNumber(templateNumber);
                List sheets = SpreadUtils.getSheets((String)templateContent, null);
                templateVo.setTemplate(sheets);
            }
        }
        catch (Throwable e) {
            LOGGER.error("TemplateServiceImpl-getTemplateId-error", e);
        }
        return templateVo;
    }

    public static TemplateVo getTemplateVo(Long templateId) {
        TemplateVo templateVo = null;
        try {
            DynamicObject template = TemplateUtils.getTemplateDynamicObjectById((Long)templateId);
            if (template != null) {
                String templateNumber = template.getString("number");
                String templateContent = template.getString("content_tag");
                templateVo = new TemplateVo();
                templateVo.setTemplateId(templateId);
                templateVo.setTemplateNumber(templateNumber);
                List sheets = SpreadUtils.getSheets((String)templateContent, null);
                templateVo.setTemplate(sheets);
            }
        }
        catch (Throwable e) {
            LOGGER.error("TemplateServiceImpl-getTemplateId-error", e);
        }
        return templateVo;
    }

    public static Map<String, EntityField> getAllFieldTypeToShow(Map<String, String> listTab) {
        if (CollectionUtils.isEmpty(listTab)) {
            return new HashMap<String, EntityField>(0);
        }
        long l = System.currentTimeMillis();
        HashMap<String, EntityField> map = new HashMap<String, EntityField>();
        for (Map.Entry<String, String> entry : listTab.entrySet()) {
            EntityInfo entityInfo = MetadataUtil.getEntityById((String)entry.getKey());
            List ewblxhItems = null;
            for (EntityField entityField : entityInfo.getFieldList()) {
                if (!EWBLXH.equals(entityField.getFieldId())) continue;
                ewblxhItems = entityField.getComboItems();
                break;
            }
            if (ewblxhItems == null) continue;
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + SPLIT_STRING + item.getValue() + SPLIT_STRING + entityField.getFieldId();
                    map.put(key, entityField);
                }
            }
        }
        long l1 = System.currentTimeMillis();
        LOGGER.info("getAllFieldTypeToShow cost:{}ms", (Object)(l1 - l));
        return map;
    }

    public static Map<String, EntityField> getFieldsTypeByDynRowMap(Map<String, String> listTab, List<DynamicRowModel> dynRowList) {
        Map<String, EntityField> metaTypeMap = TaxDeclarePluginService.getAllFieldTypeToShow(listTab);
        return TaxDeclarePluginService.expanFieldsTypeByDynRow(metaTypeMap, dynRowList);
    }

    public static Map<String, EntityField> expanFieldsTypeByDynRow(Map<String, EntityField> metaTypeMap, List<DynamicRowModel> dynRowList) {
        if (CollectionUtils.isEmpty(dynRowList)) {
            return metaTypeMap;
        }
        Integer totalSize = dynRowList.stream().filter(a -> a != null && a.getRowList() != null).map(a -> a.getRowList().size()).reduce(0, (a, b) -> a + b);
        long l = System.currentTimeMillis();
        HashMap<String, EntityField> addedMetaTypeMap = new HashMap<String, EntityField>(totalSize * 8 * 4 / 3);
        for (Map.Entry<String, EntityField> entry : metaTypeMap.entrySet()) {
            String key = entry.getKey().toString();
            DynamicRowModel dyn = DynamicRowService.matchDyn(dynRowList, (String)key);
            if (dyn == null || dyn.getRowList() == null || dyn.getRowList().size() <= 1) continue;
            for (int i = 1; i < dyn.getRowList().size(); ++i) {
                long rowIndex = dyn.getStartRow() + (long)i;
                String newKey = DynamicRowService.getNewKey((String)key, (long)rowIndex);
                addedMetaTypeMap.put(newKey, entry.getValue());
            }
        }
        if (!CollectionUtils.isEmpty(addedMetaTypeMap)) {
            metaTypeMap.putAll(addedMetaTypeMap);
        }
        long l1 = System.currentTimeMillis();
        LOGGER.info("expanFieldsTypeByDynRow cost:{}ms", (Object)(l1 - l));
        return metaTypeMap;
    }

    public static void removeInvalidKey(Map<String, String> metaMap, List<DynamicRowModel> dynRowList, DeclareService declareService, Map<String, String> calMap) {
        Iterator<String> it = calMap.keySet().iterator();
        while (it.hasNext()) {
            String t = it.next();
            if (!StringUtil.isEmpty((CharSequence)t) && t.contains(SPLIT_STRING) && declareService.checkTable(metaMap, t) && !declareService.isDelKey(dynRowList, t)) continue;
            it.remove();
        }
    }

    public static List<String> getCalcSheetIds(TemplateVo templateVo, CalcRangeVo calcRangeVo) {
        List calcSheetNames = calcRangeVo.getCalcSheetNames();
        if (CollectionUtils.isEmpty((Collection)calcSheetNames)) {
            return Collections.emptyList();
        }
        HashMap sheetNameIdsMap = new HashMap(10);
        for (Map.Entry entry : templateVo.getSheetIdNames().entrySet()) {
            sheetNameIdsMap.put(entry.getValue(), entry.getKey());
        }
        return calcSheetNames.stream().filter(sheetNameIdsMap::containsKey).map(v -> (String)sheetNameIdsMap.get(v)).collect(Collectors.toList());
    }

    public static void prepareDataByCalc(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> currentMap, TemplateVo templateVo, CalcRangeVo calcRangeVo, IPageCache pageCache) {
        Map ruleFetchData;
        List<String> calcSheetIds = TaxDeclarePluginService.getCalcSheetIds(templateVo, calcRangeVo);
        HashSet<String> ignoreDynRowNos = new HashSet<String>(100);
        HashSet ignoreCells = new HashSet(100);
        HashSet ignoreDynRowCells = new HashSet(100);
        if (!CollectionUtils.isEmpty(calcSheetIds) || !CollectionUtils.isEmpty((Collection)calcRangeVo.getCalcCells())) {
            if (templateVo.getTemplate() != null) {
                templateVo.getTemplate().stream().flatMap(v -> v.getRowList().stream()).flatMap(Collection::stream).forEach(cell -> {
                    String key = cell.getCellKey();
                    if (StringUtil.isNotEmpty((CharSequence)key) && !TaxDeclarePluginService.isCalcCell(cell, calcSheetIds, calcRangeVo.getCalcCells())) {
                        ignoreCells.add(key);
                    }
                });
            }
            if (templateVo.getDynamicRow() != null) {
                templateVo.getDynamicRow().values().stream().flatMap(Collection::stream).flatMap(Collection::stream).forEach(cell -> {
                    String key = cell.getCellKey();
                    if (StringUtil.isNotEmpty((CharSequence)key) && !TaxDeclarePluginService.isCalcCell(cell, calcSheetIds, calcRangeVo.getCalcCells())) {
                        ignoreDynRowNos.add(cell.getDynRowNo());
                        ignoreCells.add(key);
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty((Collection)calcRangeVo.getIgnoreDynRowNos()) && templateVo.getDynamicRow() != null) {
            templateVo.getDynamicRow().values().stream().flatMap(Collection::stream).flatMap(Collection::stream).forEach(cell -> {
                String key = cell.getCellKey();
                if (StringUtil.isNotEmpty((CharSequence)key) && calcRangeVo.getIgnoreDynRowNos().contains(cell.getDynRowNo())) {
                    ignoreDynRowCells.add(key);
                }
            });
            ignoreDynRowNos.addAll(calcRangeVo.getIgnoreDynRowNos());
        }
        if (!CollectionUtils.isEmpty((Collection)calcRangeVo.getIgnoreCells())) {
            ignoreCells.addAll(calcRangeVo.getIgnoreCells());
        }
        if (!CollectionUtils.isEmpty(ignoreDynRowCells)) {
            ignoreCells.addAll(ignoreDynRowCells);
        }
        HashMap<String, String> preData = new HashMap<String, String>(100);
        if (!ObjectUtils.isEmpty(ignoreCells)) {
            for (String key : ignoreCells) {
                String value = currentMap.get(key);
                if (value == null) continue;
                preData.put(key, value);
            }
            requestModel.setPreData(preData);
        }
        if (!ObjectUtils.isEmpty((Object)responseModel.getDynRowList())) {
            List<DynamicRowModel> dynRowList = TaxDeclarePluginService.getDynamicRowListByCalc(requestModel, currentMap, responseModel.getDynRowList(), ignoreDynRowNos);
            responseModel.setDynRowList(dynRowList);
        }
        if ((ruleFetchData = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"updateCellEntityMap", Map.class)) != null && !ObjectUtils.isEmpty(ignoreCells)) {
            HashMap ruleFetchDataNew = new HashMap(10);
            for (String key : ignoreCells) {
                String value = (String)ruleFetchData.get(key);
                if (value == null) continue;
                ruleFetchDataNew.put(key, ruleFetchData.get(key));
            }
            TreeUtils.putCache((IPageCache)pageCache, (String)"updateCellEntityMap", ruleFetchDataNew);
        } else {
            TreeUtils.removeCache((IPageCache)pageCache, (String)"updateCellEntityMap");
        }
    }

    private static boolean isCalcCell(Cell cell, List<String> calcSheetIds, List<String> calcCells) {
        return !CollectionUtils.isEmpty(calcSheetIds) && calcSheetIds.contains(cell.getSheetId()) || !CollectionUtils.isEmpty(calcCells) && calcCells.contains(cell.getCellKey());
    }

    private static List<DynamicRowModel> getDynamicRowListByCalc(DeclareRequestModel requestModel, Map<String, String> currentMap, List<DynamicRowModel> dynRowList, Set<String> ignoreDynRowNos) {
        TaxDeclareDataServiceImpl taxDeclareDataService = new TaxDeclareDataServiceImpl();
        List<Object> dynRowListNew = null;
        if (!CollectionUtils.isEmpty(ignoreDynRowNos)) {
            List<DynamicRowModel> dbDynRowList = taxDeclareDataService.getDynRowList(requestModel);
            Map<String, DynamicRowModel> dbDynRowMap = dbDynRowList.stream().collect(Collectors.toMap(k -> k.getDynRowNo(), v -> v));
            dynRowListNew = dynRowList.stream().map(v -> !ignoreDynRowNos.contains(v.getDynRowNo()) && dbDynRowMap.get(v.getDynRowNo()) != null ? (DynamicRowModel)dbDynRowMap.get(v.getDynRowNo()) : v).collect(Collectors.toList());
            dynRowListNew.stream().filter(v -> ignoreDynRowNos.contains(v.getDynRowNo())).filter(v -> v.getRowList() != null).flatMap(v -> v.getRowList().stream()).forEach(v -> {
                for (String key : v.keySet()) {
                    if (currentMap.get(key) == null) continue;
                    v.put(key, currentMap.get(key));
                }
            });
        } else {
            dynRowListNew = taxDeclareDataService.getDynRowList(requestModel);
        }
        return dynRowListNew;
    }

    static {
        BASE_FIELD_LAST.add("id");
        BASE_FIELD_LAST.add(EWBLXH);
        BASE_FIELD_LAST.add("ewblname");
        BASE_FIELD_LAST.add("sbbid");
    }
}

