/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.questionnaire;

import java.util.Collection;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.formplugin.questionnaire.QuestionnaireUtils;

public class QuestionnaireListPlugin
extends AbstractListPlugin {
    protected static final String PREVIEW = "preview";
    public static final String BDTAXR_QUESTIONNAIRE_SET = "bdtaxr_questionnaire_set";

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List filterColumnList = args.getCommonFilterColumns();
        String appname = (String)this.getView().getFormShowParameter().getCustomParam("appfid");
        for (FilterColumn filterColumn : filterColumnList) {
            if ("appname.name".equals(filterColumn.getFieldName())) {
                filterColumn.setDefaultValue(appname);
            }
            if (!"useorg.id".equals(filterColumn.getFieldName())) continue;
            List defaultValues = filterColumn.getDefaultValues();
            if (!CollectionUtils.isEmpty((Collection)defaultValues)) {
                this.getPageCache().put("currentorg", String.valueOf(filterColumn.getDefaultValues().get(0)));
                continue;
            }
            this.getPageCache().put("currentorg", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)PREVIEW, (CharSequence)operateKey)) {
            this.afterPreview(afterDoOperationEventArgs);
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    protected void afterPreview(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        IFormView view = this.getView();
        ListSelectedRowCollection selectRows = ((IListView)view).getSelectedRows();
        int size = selectRows.size();
        if (size < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"QuestionnaireListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        if (size > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9884\u89c8\u95ee\u5377\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"QuestionnaireListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Object primaryKeyValue = selectRows.get(0).getPrimaryKeyValue();
        String questionName = selectRows.get(0).getName();
        QuestionnaireUtils.showQuesnairePreview(Long.parseLong(primaryKeyValue.toString()), view, ShowType.Modal, BDTAXR_QUESTIONNAIRE_SET, questionName);
    }

    protected long getSelectMainOrgIdFirst() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (selectedMainOrgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u4e2a\u7f16\u5236\u7ec4\u7ec7\u3002", (String)"QuestionnaireListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return 0L;
        }
        return (Long)selectedMainOrgIds.get(0);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)this.getQuestionNaireFormId(), (CharSequence)actionId)) {
            this.questionNaireClosedCallBall(closedCallBackEvent);
        }
        super.closedCallBack(closedCallBackEvent);
    }

    protected String getQuestionNaireFormId() {
        return BDTAXR_QUESTIONNAIRE_SET;
    }

    protected void questionNaireClosedCallBall(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        long selectMainOrgId = this.getSelectMainOrgIdFirst();
        if (selectMainOrgId == 0L) {
            return;
        }
        ListSelectedRowCollection questionNaireColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (questionNaireColl.isEmpty()) {
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(this.getQuestionNaireFormId());
        billShowParameter.setCustomParam("selectMainOrgId", (Object)selectMainOrgId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

