/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.questionnaire;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class QuestionnairePreviewEditPlugin
extends AbstractFormPlugin {
    public static final String BDTAXR_QUESTIONNAIRE_SET = "bdtaxr_questionnaire_set";
    public static final String BDTAXR_QUESTIONANSWER = "bdtaxr_questionanswer";
    private static final String FIELDS = "id,setentry_quesclassif,setentry_problemdesc,setentry_problemtype,setentry_standardscore,setentry_optionset,setentry_answer,setentry_finalscore,setentry_metadataid,setentry_questionnaireid,setentry_sourcechoiceid,setentry_metadataname";
    public int totalScore = 0;
    protected static final String RETURNSCORE = "returnscore";
    protected static final String RESET = "reset";
    protected static final String BTNPREVIOUSPAGE = "btnpreviouspage";
    protected static final String BTNNEXTPAGE = "btnnextpage";
    protected static final String CONTENTPANEL = "contentpanel";
    protected static final String METADATANAME = "metadataname";
    protected static final String METADATAIDS = "metadataids";
    protected static final String QUESTIONNAIREID = "questionnaireid";
    protected static final String CLOSE = "close";
    protected static final String SAVE = "save";
    protected static final String PREFIX_CHOICEQUES = "choice_";
    protected static final String PREFIX_CHOICEITEM = "choiceitem_";
    protected static final String PREFIX_INPUTSCOREQUES = "inputscore_";
    protected static final String PREFIX_ESSAYQUEQUES = "essayque_";
    protected static final String PREFIX_ONETICKETVETOQUES = "oneticketveto_";
    protected static final String PREFIX_ONETICKETITEM = "oneticketitem_";
    protected static final String PREFIX_QUESNAME = "quesname_";
    protected static final String YES = "yes";
    protected static final String NO = "no";
    protected static final String CACHE_DYNAMICOBJECTITEM = "cache_dynamicObjectItem";
    protected static final String CACHE_DYNAMICFLEXKEY = "cache_dynamicflexkey";
    protected static final String CACHE_MAXQUESNUMBER = "cache_maxQuesNumber";
    protected static final String SPLITSTR = "@@@";
    protected static final String CACHE_TOPFLEXNUMBER = "cache_topFlexNumber";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!StringUtils.equalsIgnoreCase((CharSequence)((String)this.getView().getFormShowParameter().getCustomParams().get("billStatus")), (CharSequence)"A")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{RESET});
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        FlexPanelAp headAp = this.createDynamicFlex(formShowParameter);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", CONTENTPANEL);
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
        super.loadCustomControlMetas(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().startsWith(PREFIX_CHOICEQUES) || e.getKey().startsWith(PREFIX_ONETICKETVETOQUES)) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(e.getKey());
            comboEdit.setView(this.getView());
            e.setControl((Control)comboEdit);
        } else if (e.getKey().startsWith(PREFIX_INPUTSCOREQUES)) {
            IntegerEdit integerEdit = new IntegerEdit();
            integerEdit.setKey(e.getKey());
            integerEdit.setView(this.getView());
            e.setControl((Control)integerEdit);
        } else if (e.getKey().startsWith(PREFIX_ESSAYQUEQUES)) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(e.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
        super.onGetControl(e);
    }

    public void registerListener(EventObject e) {
        Button previousPage = (Button)this.getView().getControl(BTNPREVIOUSPAGE);
        previousPage.addClickListener((ClickListener)this);
        Button nextPage = (Button)this.getView().getControl(BTNNEXTPAGE);
        nextPage.addClickListener((ClickListener)this);
        Button close = (Button)this.getView().getControl(CLOSE);
        close.addClickListener((ClickListener)this);
        super.registerListener(e);
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BTNPREVIOUSPAGE, (CharSequence)source.getKey())) {
            this.beforeBtnPreviousPageClick(evt);
        } else if (StringUtils.equals((CharSequence)BTNNEXTPAGE, (CharSequence)source.getKey())) {
            this.beforeBtnNextPageClick(evt);
        } else if (StringUtils.equals((CharSequence)CLOSE, (CharSequence)source.getKey())) {
            this.beforeCloseClick(evt);
        }
        super.beforeClick(evt);
    }

    protected void beforeBtnNextPageClick(BeforeClickEvent evt) {
    }

    protected void beforeBtnPreviousPageClick(BeforeClickEvent evt) {
    }

    protected void beforeCloseClick(BeforeClickEvent evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String metadataname = (String)formShowParameter.getCustomParam(METADATANAME);
        if (!StringUtils.equals((CharSequence)BDTAXR_QUESTIONNAIRE_SET, (CharSequence)metadataname)) {
            String originAnswerList = this.getOldAnswerList();
            String currentAnswerList = null;
            boolean equals = Boolean.FALSE;
            this.updateParentData(CLOSE);
            currentAnswerList = "".equals(originAnswerList) && null != this.getPageCache().get("currentAnswerList") ? this.getPageCache().get("currentAnswerList").replace("null", "").replace("0", "") : this.getPageCache().get("currentAnswerList");
            if (null != originAnswerList && null != currentAnswerList) {
                equals = currentAnswerList.equals(originAnswerList);
            }
            if (null == originAnswerList && null == currentAnswerList) {
                equals = Boolean.TRUE;
            }
            if (!equals) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"QuestionnairePreviewEditPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"QuestionnairePreviewEditPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.YesNo;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"QuestionnairePreviewEditPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (CLOSE.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put("clickClose", "true");
            this.getView().close();
        }
        if (CLOSE.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Retry)) {
            this.deleteAndResetAnswer();
        }
    }

    private void deleteAndResetAnswer() {
        this.getPageCache().put("resetOpe", "true");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String questionnaireid = (String)formShowParameter.getCustomParam(QUESTIONNAIREID);
        List metadataids = (List)formShowParameter.getCustomParam(METADATAIDS);
        QFilter questionnaireidFilter = new QFilter("setentry_questionnaireid", "=", (Object)questionnaireid);
        QFilter metadataidFilter = new QFilter("setentry_metadataid", "in", (Object)metadataids);
        DeleteServiceHelper.delete((String)BDTAXR_QUESTIONANSWER, (QFilter[])new QFilter[]{questionnaireidFilter, metadataidFilter});
        this.totalScore = -1;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("totalScore", this.totalScore);
        this.getView().returnDataToParent((Object)customParams);
        this.getView().close();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BTNPREVIOUSPAGE, (CharSequence)source.getKey())) {
            this.btnPreviousPageClick(evt);
        } else if (StringUtils.equals((CharSequence)BTNNEXTPAGE, (CharSequence)source.getKey())) {
            this.btnNextPageClick(evt);
        }
        super.click(evt);
    }

    protected void btnNextPageClick(EventObject evt) {
        this.paging(true);
    }

    protected void btnPreviousPageClick(EventObject evt) {
        this.paging(false);
    }

    public void beforeBindData(EventObject e) {
        FlexPanelAp dynamicPanel = this.createDynamicFlex(this.getView().getFormShowParameter());
        Container contentPanel = (Container)this.getView().getControl(CONTENTPANEL);
        contentPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(contentPanel.getItems());
        this.initItemValue();
        this.paging(true);
        super.beforeBindData(e);
    }

    protected void initItemValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String metadataname = (String)formShowParameter.getCustomParam(METADATANAME);
        List metadataids = (List)formShowParameter.getCustomParam(METADATAIDS);
        String questionnaireid = (String)formShowParameter.getCustomParam(QUESTIONNAIREID);
        if (StringUtils.equals((CharSequence)BDTAXR_QUESTIONNAIRE_SET, (CharSequence)metadataname)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RESET});
            return;
        }
        if (metadataids.size() > 1) {
            return;
        }
        QFilter questionnaireidFilter = new QFilter("setentry_questionnaireid", "=", (Object)questionnaireid);
        QFilter metadatanaidFilter = new QFilter("setentry_metadataid", "in", (Object)metadataids);
        boolean exists = QueryServiceHelper.exists((String)BDTAXR_QUESTIONANSWER, (QFilter[])new QFilter[]{questionnaireidFilter, metadatanaidFilter});
        if (exists) {
            DynamicObject[] answerEntry = BusinessDataServiceHelper.load((String)BDTAXR_QUESTIONANSWER, (String)FIELDS, (QFilter[])new QFilter[]{questionnaireidFilter, metadatanaidFilter});
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String cacheDynamicObjectItem = this.getPageCache().get(CACHE_DYNAMICOBJECTITEM);
            if (cacheDynamicObjectItem == null) {
                return;
            }
            String[] itemArray = cacheDynamicObjectItem.split(SPLITSTR);
            String[] splitArray = null;
            String itemType = null;
            String itemId = null;
            String rowId = null;
            String problemType = null;
            Object itemValue = null;
            block0: for (String itemArrayOne : itemArray) {
                splitArray = itemArrayOne.split("_");
                itemType = splitArray[0];
                itemId = splitArray[1];
                for (DynamicObject answerEntryRow : answerEntry) {
                    rowId = answerEntryRow.getString("id");
                    problemType = answerEntryRow.getString("setentry_problemtype");
                    if (!StringUtils.equals((CharSequence)itemId, (CharSequence)rowId) || !StringUtils.equals((CharSequence)itemType, (CharSequence)problemType)) continue;
                    itemValue = this.getInitValueFormSetEntryRow(answerEntryRow, itemId);
                    dataEntity.set(itemArrayOne, itemValue);
                    continue block0;
                }
            }
        }
    }

    protected Object getInitValueFormSetEntryRow(DynamicObject setEntryRow, Object itemid) {
        String problemType = setEntryRow.getString("setentry_problemtype");
        Object initValue = null;
        switch (problemType) {
            case "choice": {
                initValue = this.getChoiceQuesItemInitValue(setEntryRow, itemid);
                break;
            }
            case "oneticketveto": {
                initValue = this.getOneTicketVetoItemInitValue(setEntryRow);
                break;
            }
            case "inputscore": {
                initValue = this.getInputScoreQuesItemInitValue(setEntryRow);
                break;
            }
            case "essayque": {
                initValue = this.getEssayQueQuesItemInitValue(setEntryRow);
                break;
            }
        }
        return initValue;
    }

    protected Object getEssayQueQuesItemInitValue(DynamicObject setEntryRow) {
        ILocaleString answer = setEntryRow.getLocaleString("setentry_answer");
        return answer == null ? null : answer.getLocaleValue();
    }

    protected Object getInputScoreQuesItemInitValue(DynamicObject setEntryRow) {
        return setEntryRow.getInt("setentry_finalscore");
    }

    protected Object getOneTicketVetoItemInitValue(DynamicObject setEntryRow) {
        ILocaleString answer = setEntryRow.getLocaleString("setentry_answer");
        if (answer == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)this.getYesAnswerValue(), (CharSequence)answer.getLocaleValue())) {
            return YES;
        }
        return NO;
    }

    protected Object getChoiceQuesItemInitValue(DynamicObject setEntryRow, Object itemid) {
        int finalScore = setEntryRow.getInt("setentry_finalscore");
        DynamicObject questionnaireObject = BusinessDataServiceHelper.loadSingle((String)BDTAXR_QUESTIONANSWER, (String)"subentry.subentry_option,subentry.subentry_standardscore", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(itemid.toString()))});
        DynamicObjectCollection subEntry = questionnaireObject.getDynamicObjectCollection("subentry");
        for (DynamicObject subEntryRow : subEntry) {
            if (finalScore != subEntryRow.getInt("subentry_standardscore")) continue;
            return finalScore + SPLITSTR + subEntryRow.getPkValue().toString();
        }
        return null;
    }

    protected void paging(boolean isNextPage) {
        int topFlexNumber;
        String dynamicFlexKey = this.getPageCache().get(CACHE_DYNAMICFLEXKEY);
        String topFlexNumberStr = this.getPageCache().get(CACHE_TOPFLEXNUMBER);
        String maxQuesNumberStr = this.getPageCache().get(CACHE_MAXQUESNUMBER);
        if (maxQuesNumberStr == null) {
            return;
        }
        int maxQuesNumber = Integer.parseInt(maxQuesNumberStr);
        int pagingNumber = this.getPagingNumber();
        int n = topFlexNumber = topFlexNumberStr == null ? 1 - pagingNumber : Integer.parseInt(topFlexNumberStr);
        if (isNextPage) {
            if (topFlexNumber + pagingNumber > maxQuesNumber) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u9875\u3002", (String)"QuestionnairePreviewEditPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
        } else if (topFlexNumber <= 0 || topFlexNumber == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u7b2c\u4e00\u9875\u3002", (String)"QuestionnairePreviewEditPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        int index = 0;
        String indexStr = null;
        String falseVisableFlexs = null;
        String trueVisableFlexs = null;
        PriorityQueue<Integer> queue = new PriorityQueue<Integer>();
        for (String flexKey : dynamicFlexKey.split(SPLITSTR)) {
            indexStr = flexKey.split("_")[1];
            index = Integer.parseInt(indexStr);
            if (isNextPage) {
                if (topFlexNumber + pagingNumber <= index && index < topFlexNumber + 2 * pagingNumber) {
                    trueVisableFlexs = trueVisableFlexs == null ? flexKey : trueVisableFlexs + SPLITSTR + flexKey;
                    queue.add(index);
                    continue;
                }
                if (falseVisableFlexs == null) {
                    falseVisableFlexs = flexKey;
                    continue;
                }
                falseVisableFlexs = falseVisableFlexs + SPLITSTR + flexKey;
                continue;
            }
            if (topFlexNumber - pagingNumber <= index && index < topFlexNumber) {
                trueVisableFlexs = trueVisableFlexs == null ? flexKey : trueVisableFlexs + SPLITSTR + flexKey;
                queue.add(index);
                continue;
            }
            falseVisableFlexs = falseVisableFlexs == null ? flexKey : falseVisableFlexs + SPLITSTR + flexKey;
        }
        if (falseVisableFlexs != null) {
            this.getView().setVisible(Boolean.FALSE, falseVisableFlexs.split(SPLITSTR));
        }
        if (trueVisableFlexs != null) {
            this.getView().setVisible(Boolean.TRUE, trueVisableFlexs.split(SPLITSTR));
        }
        this.getPageCache().put(CACHE_TOPFLEXNUMBER, String.valueOf(queue.poll()));
    }

    protected void registDynamicProps(MainEntityType newMainType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List metadataids = (List)formShowParameter.getCustomParam(METADATAIDS);
        String questionnaireid = (String)formShowParameter.getCustomParam(QUESTIONNAIREID);
        QFilter questionnaireidFilter = new QFilter("setentry_questionnaireid", "=", (Object)questionnaireid);
        QFilter metadatanaidFilter = new QFilter("setentry_metadataid", "in", (Object)metadataids);
        boolean exists = QueryServiceHelper.exists((String)BDTAXR_QUESTIONANSWER, (QFilter[])new QFilter[]{questionnaireidFilter, metadatanaidFilter});
        if (!exists) {
            if (questionnaireid == null) {
                return;
            }
            DynamicObject questionnaire = BusinessDataServiceHelper.loadSingle((Object)questionnaireid, (String)BDTAXR_QUESTIONNAIRE_SET, (String)String.join((CharSequence)",", "setentry", "setentry.seq", "setentry_optionset", "setentry_problemdesc", "setentry_problemtype", "setentry_standardscore", "subentry", "subentry.seq", "subentry_option", "subentry_standardscore"));
            DynamicObjectCollection setEntry = questionnaire.getDynamicObjectCollection("setentry");
            int index = 0;
            for (DynamicObject setEntryRow : setEntry) {
                this.registerQuestionItemBySetEntryRow(setEntryRow, index + 1, newMainType);
            }
        } else {
            DynamicObject[] setEntry = BusinessDataServiceHelper.load((String)BDTAXR_QUESTIONANSWER, (String)String.join((CharSequence)",", "setentry", "setentry.seq", "setentry_optionset", "setentry_problemdesc", "setentry_problemtype", "setentry_standardscore", "subentry", "subentry.seq", "subentry_option", "subentry_standardscore"), (QFilter[])new QFilter[]{new QFilter("setentry_metadataid", "in", (Object)metadataids)});
            int index = 0;
            for (DynamicObject setEntryRow : setEntry) {
                this.registerQuestionItemBySetEntryRow(setEntryRow, index + 1, newMainType);
            }
        }
    }

    protected void registerQuestionItemBySetEntryRow(DynamicObject setEntryRow, int i, MainEntityType newMainType) {
        String problemType;
        switch (problemType = setEntryRow.getString("setentry_problemtype")) {
            case "choice": {
                this.registerChoiceQuesItem(setEntryRow, newMainType);
                break;
            }
            case "oneticketveto": {
                this.registerOneTicketVetoItem(setEntryRow, newMainType);
                break;
            }
            case "inputscore": {
                this.registerInputScoreQuesItem(setEntryRow, newMainType);
                break;
            }
            case "essayque": {
                this.registerEssayQueQuesItem(setEntryRow, newMainType);
                break;
            }
        }
    }

    protected void registerEssayQueQuesItem(DynamicObject setEntryRow, MainEntityType newMainType) {
        TextProp textProp = new TextProp();
        textProp.setName(PREFIX_ESSAYQUEQUES + setEntryRow.getPkValue().toString());
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
    }

    protected void registerInputScoreQuesItem(DynamicObject setEntryRow, MainEntityType newMainType) {
        IntegerProp integerProp = new IntegerProp();
        integerProp.setName(PREFIX_INPUTSCOREQUES + setEntryRow.getPkValue().toString());
        integerProp.setDbIgnore(true);
        integerProp.setAlias("");
        newMainType.registerSimpleProperty((DynamicSimpleProperty)integerProp);
    }

    protected void registerOneTicketVetoItem(DynamicObject setEntryRow, MainEntityType newMainType) {
        String name = PREFIX_ONETICKETVETOQUES + setEntryRow.getPkValue().toString();
        this.registerComboProp(newMainType, name);
    }

    protected void registerChoiceQuesItem(DynamicObject setEntryRow, MainEntityType newMainType) {
        String name = PREFIX_CHOICEQUES + setEntryRow.getPkValue().toString();
        this.registerComboProp(newMainType, name);
    }

    protected void registerComboProp(MainEntityType newMainType, String name) {
        ComboProp comboProp = new ComboProp();
        comboProp.setName(name);
        comboProp.setDbIgnore(true);
        comboProp.setAlias("");
        newMainType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
    }

    protected FlexPanelAp createDynamicFlex(FormShowParameter formShowParameter) {
        FlexPanelAp flexPanelAp = this.createFlexPanelAp(CONTENTPANEL);
        List metadataids = (List)formShowParameter.getCustomParam(METADATAIDS);
        String questionnaireid = (String)formShowParameter.getCustomParam(QUESTIONNAIREID);
        QFilter questionnaireidFilter = new QFilter("setentry_questionnaireid", "=", (Object)questionnaireid);
        QFilter metadatanaidFilter = new QFilter("setentry_metadataid", "in", (Object)metadataids);
        boolean exists = QueryServiceHelper.exists((String)BDTAXR_QUESTIONANSWER, (QFilter[])new QFilter[]{questionnaireidFilter, metadatanaidFilter});
        if (!exists) {
            if (questionnaireid == null) {
                return flexPanelAp;
            }
            DynamicObject questionnaire = BusinessDataServiceHelper.loadSingle((Object)questionnaireid, (String)BDTAXR_QUESTIONNAIRE_SET, (String)String.join((CharSequence)",", "setentry", "setentry.seq", "setentry_optionset", "setentry_problemdesc", "setentry_problemtype", "setentry_standardscore", "subentry", "subentry.seq", "subentry_option", "subentry_standardscore"));
            DynamicObjectCollection setEntry = questionnaire.getDynamicObjectCollection("setentry");
            int index = 0;
            for (DynamicObject setEntryRow : setEntry) {
                FlexPanelAp questionItemFlex = this.createQuestionItemBySetEntryRow(setEntryRow, ++index);
                flexPanelAp.getItems().add(questionItemFlex);
            }
            if (this.getPageCache() != null) {
                this.getPageCache().put(CACHE_MAXQUESNUMBER, String.valueOf(setEntry.size()));
            }
            return flexPanelAp;
        }
        if (questionnaireid == null) {
            return flexPanelAp;
        }
        DynamicObject[] setEntry = BusinessDataServiceHelper.load((String)BDTAXR_QUESTIONANSWER, (String)String.join((CharSequence)",", "setentry", "setentry.seq", "setentry_optionset", "setentry_problemdesc", "setentry_problemtype", "setentry_standardscore", "subentry", "subentry.seq", "subentry_option", "subentry_standardscore"), (QFilter[])new QFilter[]{questionnaireidFilter, metadatanaidFilter});
        int index = 0;
        List collect = Arrays.stream(setEntry).sorted((a, b) -> a.getString("id").compareTo(b.getString("id"))).collect(Collectors.toList());
        for (DynamicObject setEntryRow : collect) {
            FlexPanelAp questionItemFlex = this.createQuestionItemBySetEntryRow(setEntryRow, ++index);
            flexPanelAp.getItems().add(questionItemFlex);
        }
        if (this.getPageCache() != null) {
            this.getPageCache().put(CACHE_MAXQUESNUMBER, String.valueOf(setEntry.length));
        }
        return flexPanelAp;
    }

    protected FlexPanelAp createQuestionItemBySetEntryRow(DynamicObject setEntryRow, int index) {
        String problemType = setEntryRow.getString("setentry_problemtype");
        String rowPkValue = setEntryRow.getPkValue().toString();
        String key = rowPkValue + "_" + index;
        FlexPanelAp flexPanelAp = this.createFlexPanelAp(key);
        String idAndKey = PREFIX_QUESNAME + setEntryRow.getPkValue();
        String name = null;
        switch (problemType) {
            case "choice": {
                name = index + "\u3001" + setEntryRow.getLocaleString("setentry_problemdesc").getLocaleValue();
                this.createLabelAp(name, flexPanelAp, idAndKey);
                this.createChoiceQuesItem(setEntryRow, flexPanelAp);
                break;
            }
            case "oneticketveto": {
                name = index + "\u3001" + setEntryRow.getLocaleString("setentry_problemdesc").getLocaleValue();
                this.createLabelAp(name, flexPanelAp, idAndKey);
                this.createOneTicketVetoItem(setEntryRow, flexPanelAp);
                break;
            }
            case "inputscore": {
                name = String.format(ResManager.loadKDString((String)"%1$s\u3001%2$s\uff08\u6ee1\u5206%3$s\u5206\uff09", (String)"QuestionnairePreviewEditPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), index, setEntryRow.getLocaleString("setentry_problemdesc").getLocaleValue(), setEntryRow.getInt("setentry_standardscore"));
                this.createLabelAp(name, flexPanelAp, idAndKey);
                this.createInputScoreQuesItem(setEntryRow, flexPanelAp);
                break;
            }
            case "essayque": {
                name = index + "\u3001" + setEntryRow.getLocaleString("setentry_problemdesc").getLocaleValue();
                this.createLabelAp(name, flexPanelAp, idAndKey);
                this.createEssayQueQuesItem(setEntryRow, flexPanelAp);
                break;
            }
        }
        this.putDynamicFlexKeyToCache(key);
        return flexPanelAp;
    }

    protected void createLabelAp(String name, FlexPanelAp flexPanelAp, String idAndKey) {
        LabelAp labelAp = new LabelAp();
        labelAp.setId(idAndKey);
        labelAp.setKey(idAndKey);
        labelAp.setName(new LocaleString(name));
        flexPanelAp.getItems().add(labelAp);
    }

    protected void createEssayQueQuesItem(DynamicObject setEntryRow, FlexPanelAp flexPanelAp) {
        String rowPkValue = setEntryRow.getPkValue().toString();
        String idAndKey = PREFIX_ESSAYQUEQUES + rowPkValue;
        String name = setEntryRow.getLocaleString("setentry_problemdesc").getLocaleValue();
        FieldAp textFieldAp = this.createFieldApTextFieldAp(idAndKey, name);
        flexPanelAp.getItems().add(textFieldAp);
        this.putDynamicFieldIdToCache(idAndKey);
    }

    protected void createInputScoreQuesItem(DynamicObject setEntryRow, FlexPanelAp flexPanelAp) {
        String rowPkValue = setEntryRow.getPkValue().toString();
        String idAndKey = PREFIX_INPUTSCOREQUES + rowPkValue;
        String name = setEntryRow.getLocaleString("setentry_problemdesc").getLocaleValue();
        FieldAp integerField = this.createFieldApIntegerFieldAp(idAndKey, name);
        flexPanelAp.getItems().add(integerField);
        this.putDynamicFieldIdToCache(idAndKey);
    }

    protected void createOneTicketVetoItem(DynamicObject setEntryRow, FlexPanelAp flexPanelAp) {
        String rowPkValue = setEntryRow.getPkValue().toString();
        String radioGroupFieldKey = PREFIX_ONETICKETVETOQUES + rowPkValue;
        String keyAndId = PREFIX_ONETICKETITEM + rowPkValue + YES;
        String name = this.getYesAnswerValue();
        this.craeteOneTicketItemFieldAp(radioGroupFieldKey, keyAndId, name, flexPanelAp, YES);
        keyAndId = PREFIX_ONETICKETITEM + rowPkValue + NO;
        name = this.getNoAnswerValue();
        this.craeteOneTicketItemFieldAp(radioGroupFieldKey, keyAndId, name, flexPanelAp, NO);
        RadioGroupField rgf = new RadioGroupField();
        rgf.setKey(radioGroupFieldKey);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(radioGroupFieldKey);
        fieldAp.setField((Field)rgf);
        flexPanelAp.getItems().add(fieldAp);
        this.putDynamicFieldIdToCache(radioGroupFieldKey);
    }

    protected void craeteOneTicketItemFieldAp(String radioGroupFieldKey, String keyAndId, String name, FlexPanelAp flexPanelAp, String item) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(keyAndId);
        fieldAp.setKey(keyAndId);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setHeight(new LocaleString("22px"));
        RadioField rf = new RadioField();
        rf.setId(keyAndId);
        rf.setKey(keyAndId);
        rf.setName(new LocaleString(name));
        rf.setItems(item);
        rf.setGroup(radioGroupFieldKey);
        fieldAp.setField((Field)rf);
        flexPanelAp.getItems().add(fieldAp);
    }

    protected void createChoiceQuesItem(DynamicObject setEntryRow, FlexPanelAp flexPanelAp) {
        this.createFieldApRadioGroupField(flexPanelAp, setEntryRow);
    }

    protected void createFieldApRadioGroupField(FlexPanelAp flexPanelAp, DynamicObject setEntryRow) {
        String radioGroupFieldKey = PREFIX_CHOICEQUES + setEntryRow.getPkValue();
        DynamicObjectCollection subEntry = setEntryRow.getDynamicObjectCollection("subentry");
        FieldAp radioFieldAp = null;
        for (DynamicObject subEntryRow : subEntry) {
            radioFieldAp = this.createFieldApRadioField(radioGroupFieldKey, subEntryRow);
            radioFieldAp.setWidth(new LocaleString("100%"));
            flexPanelAp.getItems().add(radioFieldAp);
        }
        RadioGroupField rf = new RadioGroupField();
        rf.setKey(radioGroupFieldKey);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(radioGroupFieldKey);
        fieldAp.setField((Field)rf);
        flexPanelAp.getItems().add(fieldAp);
        this.putDynamicFieldIdToCache(radioGroupFieldKey);
    }

    protected void putDynamicFlexKeyToCache(String key) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            return;
        }
        String cacheDynamicObjectItem = pageCache.get(CACHE_DYNAMICFLEXKEY);
        cacheDynamicObjectItem = cacheDynamicObjectItem == null ? key : cacheDynamicObjectItem + SPLITSTR + key;
        pageCache.put(CACHE_DYNAMICFLEXKEY, cacheDynamicObjectItem);
    }

    protected void putDynamicFieldIdToCache(String itemKey) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            return;
        }
        String cacheDynamicObjectItem = pageCache.get(CACHE_DYNAMICOBJECTITEM);
        cacheDynamicObjectItem = cacheDynamicObjectItem == null ? itemKey : cacheDynamicObjectItem + SPLITSTR + itemKey;
        pageCache.put(CACHE_DYNAMICOBJECTITEM, cacheDynamicObjectItem);
    }

    protected FieldAp createFieldApRadioField(String radioGroupFieldKey, DynamicObject subEntryRow) {
        String subEntryId = subEntryRow.getPkValue().toString();
        String keyAndId = PREFIX_CHOICEITEM + subEntryId;
        String name = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\u5206\uff09", (String)"QuestionnairePreviewEditPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), subEntryRow.getLocaleString("subentry_option").getLocaleValue(), subEntryRow.getInt("subentry_standardscore"));
        String item = subEntryRow.getString("subentry_standardscore") + SPLITSTR + subEntryId;
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(keyAndId);
        fieldAp.setKey(keyAndId);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setHeight(new LocaleString("22px"));
        RadioField rf = new RadioField();
        rf.setId(keyAndId);
        rf.setKey(keyAndId);
        rf.setName(new LocaleString(name));
        rf.setItems(item);
        rf.setGroup(radioGroupFieldKey);
        fieldAp.setField((Field)rf);
        return fieldAp;
    }

    protected FieldAp createFieldApIntegerFieldAp(String idAndKey, String name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(idAndKey);
        fieldAp.setKey(idAndKey);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setShowTitle(false);
        IntegerField integerField = new IntegerField();
        integerField.setId(idAndKey);
        integerField.setKey(idAndKey);
        integerField.setZeroShow(true);
        fieldAp.setField((Field)integerField);
        return fieldAp;
    }

    protected FieldAp createFieldApTextFieldAp(String idAndKey, String name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(idAndKey);
        fieldAp.setKey(idAndKey);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setShowTitle(false);
        TextField textField = new TextField();
        textField.setId(idAndKey);
        textField.setKey(idAndKey);
        fieldAp.setField((Field)textField);
        return fieldAp;
    }

    protected FlexPanelAp createFlexPanelAp(String key) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setGrow(1);
        flexPanelAp.setShrink(1);
        flexPanelAp.setKey(key);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("0px");
        margin.setRight("0px");
        margin.setTop("0px");
        margin.setBottom("10px");
        style.setMargin(margin);
        Border border = new Border();
        border.setBottom("0px_solid_#CED7DE");
        border.setLeft("0px_solid_#CED7DE");
        border.setRight("0px_solid_#CED7DE");
        border.setTop("0px_solid_#CED7DE");
        style.setBorder(border);
        flexPanelAp.setDirection("column");
        flexPanelAp.setWidth(new LocaleString("100%"));
        flexPanelAp.setStyle(style);
        return flexPanelAp;
    }

    protected int getPagingNumber() {
        return 10;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        FormShowParameter formShowParameter;
        String metadataname;
        super.beforeClosed(e);
        Boolean equals = Boolean.FALSE;
        if ("true".equals(this.getPageCache().get("reinput"))) {
            e.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u586b\u5199\u7684\u7b54\u6848\uff0c\u8bf7\u8fd4\u56de\u586b\u5199", (String)"QuestionnairePreviewEditPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            this.getPageCache().put("reinput", "false");
            return;
        }
        if ("true".equals(this.getPageCache().get("resetOpe")) || "true".equals(this.getPageCache().get("saveOpe"))) {
            return;
        }
        if (!"true".equals(this.getPageCache().get("clickClose")) && !StringUtils.equals((CharSequence)BDTAXR_QUESTIONNAIRE_SET, (CharSequence)(metadataname = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam(METADATANAME)))) {
            String originAnswerList = this.getOldAnswerList();
            String currentAnswerList = null;
            this.updateParentData(CLOSE);
            currentAnswerList = "".equals(originAnswerList) && null != this.getPageCache().get("currentAnswerList") ? this.getPageCache().get("currentAnswerList").replace("null", "").replace("0", "") : this.getPageCache().get("currentAnswerList");
            if (null != originAnswerList && null != currentAnswerList) {
                equals = currentAnswerList.equals(originAnswerList);
            }
            if (null == originAnswerList && null == currentAnswerList) {
                equals = Boolean.TRUE;
            }
            if (!equals.booleanValue()) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"QuestionnairePreviewEditPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"QuestionnairePreviewEditPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.YesNo;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"QuestionnairePreviewEditPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                e.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)RETURNSCORE, (CharSequence)operateKey)) {
            this.beforeReturnScore(args);
        }
        super.beforeDoOperation(args);
    }

    protected void beforeReturnScore(BeforeDoOperationEventArgs args) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((CharSequence)RETURNSCORE, (CharSequence)operateKey) && operationResult.isSuccess()) {
            this.getPageCache().put("saveOpe", "true");
            this.updateParentData(operateKey);
        } else if (StringUtils.equals((CharSequence)RESET, (CharSequence)operateKey) && operationResult.isSuccess()) {
            this.resetData();
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    protected void resetData() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"QuestionnairePreviewEditPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Retry.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4\u91cd\u7f6e", (String)"QuestionnairePreviewEditPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.RetryCancel;
        String msg = ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u6e05\u7a7a\u95ee\u5377\u7b54\u6848\uff0c\u5e76\u91cd\u65b0\u586b\u62a5\u6700\u65b0\u7684\u95ee\u5377\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u91cd\u7f6e\uff1f", (String)"QuestionnairePreviewEditPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    protected void updateParentData(String operateKey) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String questionnaireid = (String)formShowParameter.getCustomParam(QUESTIONNAIREID);
        String metadataname = (String)formShowParameter.getCustomParam(METADATANAME);
        List metadataids = (List)formShowParameter.getCustomParam(METADATAIDS);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isOneTickerVeto = this.getPageCache().get("isOneTickerVeto");
        if (metadataids.size() > 1) {
            for (String metadataid : metadataids) {
                this.copyQuestionnaire(questionnaireid, metadataname, metadataid, operateKey);
            }
            this.totalScore /= metadataids.size();
            if (RETURNSCORE.equals(operateKey)) {
                if ("true".equals(isOneTickerVeto)) {
                    customParams.put("totalScore", 0);
                } else {
                    customParams.put("totalScore", this.totalScore);
                }
                this.getView().returnDataToParent((Object)customParams);
            }
        } else {
            QFilter questionnaireidFilter = new QFilter("setentry_questionnaireid", "=", (Object)questionnaireid);
            QFilter metadataidFilter = new QFilter("setentry_metadataid", "in", (Object)metadataids);
            boolean exists = QueryServiceHelper.exists((String)BDTAXR_QUESTIONANSWER, (QFilter[])new QFilter[]{questionnaireidFilter, metadataidFilter});
            if (exists) {
                DynamicObject[] answerEntry = BusinessDataServiceHelper.load((String)BDTAXR_QUESTIONANSWER, (String)FIELDS, (QFilter[])new QFilter[]{questionnaireidFilter, metadataidFilter});
                this.insertAnswerArrary(answerEntry, operateKey);
            } else {
                this.copyQuestionnaire(questionnaireid, metadataname, (String)metadataids.get(0), operateKey);
            }
            if (RETURNSCORE.equals(operateKey)) {
                if ("true".equals(isOneTickerVeto)) {
                    customParams.put("totalScore", 0);
                } else {
                    customParams.put("totalScore", this.totalScore);
                }
                this.getView().returnDataToParent((Object)customParams);
            }
        }
    }

    private void copyQuestionnaire(String questionnaireid, String metadataname, String metadataid, String operateKey) {
        DynamicObject questionnaireObject = BusinessDataServiceHelper.loadSingle((String)BDTAXR_QUESTIONNAIRE_SET, (String)"setentry,setentry.setentry_problemtype,setentry.setentry_problemdesc,setentry.setentry_standardscore,setentry.setentry_optionset,setentry.setentry_userid,setentry.setentry_answer,setentry.setentry_finalscore,setentry.subentry,subentry.subentry_option,subentry.subentry_standardscore", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(questionnaireid))});
        DynamicObjectCollection setEntry = questionnaireObject.getDynamicObjectCollection("setentry");
        DynamicObjectCollection answerEntry = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : setEntry) {
            DynamicObject answerobject = BusinessDataServiceHelper.newDynamicObject((String)BDTAXR_QUESTIONANSWER);
            answerobject.set("setentry_problemdesc", dynamicObject.get("setentry_problemdesc"));
            answerobject.set("setentry_problemtype", dynamicObject.get("setentry_problemtype"));
            answerobject.set("setentry_standardscore", dynamicObject.get("setentry_standardscore"));
            answerobject.set("setentry_optionset", dynamicObject.get("setentry_optionset"));
            answerobject.set("setentry_answer", dynamicObject.get("setentry_answer"));
            answerobject.set("setentry_finalscore", dynamicObject.get("setentry_finalscore"));
            answerobject.set("setentry_metadataname", (Object)metadataname);
            answerobject.set("setentry_metadataid", (Object)metadataid);
            answerobject.set("setentry_questionnaireid", (Object)questionnaireid);
            answerobject.set("setentry_sourcechoiceid", dynamicObject.get("id"));
            DynamicObjectCollection subentry = dynamicObject.getDynamicObjectCollection("subentry");
            DynamicObjectCollection subentryCollection = answerobject.getDynamicObjectCollection("subentry");
            for (DynamicObject object : subentry) {
                DynamicObject subentryentity = subentryCollection.addNew();
                subentryentity.set("subentry_option", object.get("subentry_option"));
                object.get("subentry_standardscore");
                subentryentity.set("subentry_standardscore", object.get("subentry_standardscore"));
            }
            answerEntry.add((Object)answerobject);
        }
        this.insertAnswerCollection(answerEntry, operateKey);
    }

    private void insertAnswerArrary(DynamicObject[] answerEntry, String operateKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String cacheDynamicObjectItem = this.getPageCache().get(CACHE_DYNAMICOBJECTITEM);
        String[] dynamicItemArray = cacheDynamicObjectItem.split(SPLITSTR);
        StringBuilder currentAnswerList = new StringBuilder();
        Object itemValue = null;
        String itemType = null;
        String itemId = null;
        String[] splitArray = null;
        for (String dynamicItem : dynamicItemArray) {
            itemValue = dataEntity.get(dynamicItem);
            if (RETURNSCORE.equals(operateKey) && (itemValue == null || itemValue.equals(""))) {
                this.getPageCache().put("reinput", "true");
                return;
            }
            currentAnswerList.append(itemValue);
            this.getPageCache().put("currentAnswerList", currentAnswerList.toString());
            splitArray = dynamicItem.split("_");
            itemType = splitArray[0];
            itemId = splitArray[1];
            if (!RETURNSCORE.equals(operateKey)) continue;
            for (DynamicObject answerEntryRow : answerEntry) {
                this.updateFinalScoreToSetEntry(itemType, itemId, answerEntryRow, itemValue, false);
            }
        }
        if (RETURNSCORE.equals(operateKey)) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])answerEntry);
                    this.getPageCache().put("saved", "true");
                    this.getPageCache().put("reinput", "false");
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw new RuntimeException(t);
                }
            }
        }
    }

    private void insertAnswerCollection(DynamicObjectCollection answerEntry, String operateKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String cacheDynamicObjectItem = this.getPageCache().get(CACHE_DYNAMICOBJECTITEM);
        if (null != cacheDynamicObjectItem) {
            String[] dynamicItemArray = cacheDynamicObjectItem.split(SPLITSTR);
            StringBuilder currentAnswerList = new StringBuilder();
            Object itemValue = null;
            String itemType = null;
            String itemId = null;
            String[] splitArray = null;
            for (String dynamicItem : dynamicItemArray) {
                itemValue = dataEntity.get(dynamicItem);
                if (RETURNSCORE.equals(operateKey) && (itemValue == null || itemValue.equals(""))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u586b\u5199\u7684\u7b54\u6848\uff0c\u8bf7\u8fd4\u56de\u586b\u5199", (String)"QuestionnairePreviewEditPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    this.getPageCache().put("reinput", "true");
                    return;
                }
                itemValue = dataEntity.get(dynamicItem);
                currentAnswerList.append(itemValue);
                this.getPageCache().put("currentAnswerList", currentAnswerList.toString());
                splitArray = dynamicItem.split("_");
                itemType = splitArray[0];
                itemId = splitArray[1];
                if (!RETURNSCORE.equals(operateKey)) continue;
                for (DynamicObject answerEntryRow : answerEntry) {
                    this.updateFinalScoreToSetEntry(itemType, itemId, answerEntryRow, itemValue, true);
                }
            }
            if (RETURNSCORE.equals(operateKey)) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])answerEntry.toArray((Object[])new DynamicObject[0])));
                        this.getPageCache().put("saved", "true");
                        this.getPageCache().put("reinput", "false");
                    }
                    catch (Throwable t) {
                        h.markRollback();
                        throw new RuntimeException(t);
                    }
                }
            }
        }
    }

    private String getOldAnswerList() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List metadataids = (List)formShowParameter.getCustomParam(METADATAIDS);
        String questionnaireid = (String)formShowParameter.getCustomParam(QUESTIONNAIREID);
        if (metadataids.size() > 1) {
            this.getPageCache().put("originanswerlist", "");
            return null;
        }
        StringBuilder originAnswerList = new StringBuilder();
        QFilter questionnaireidFilter = new QFilter("setentry_questionnaireid", "=", (Object)questionnaireid);
        QFilter metadatanaidFilter = new QFilter("setentry_metadataid", "in", (Object)metadataids);
        boolean exists = QueryServiceHelper.exists((String)BDTAXR_QUESTIONANSWER, (QFilter[])new QFilter[]{questionnaireidFilter, metadatanaidFilter});
        if (exists) {
            DynamicObject[] answerEntry = BusinessDataServiceHelper.load((String)BDTAXR_QUESTIONANSWER, (String)FIELDS, (QFilter[])new QFilter[]{questionnaireidFilter, metadatanaidFilter});
            String cacheDynamicObjectItem = this.getPageCache().get(CACHE_DYNAMICOBJECTITEM);
            if (cacheDynamicObjectItem == null) {
                return null;
            }
            String[] itemArray = cacheDynamicObjectItem.split(SPLITSTR);
            String[] splitArray = null;
            String itemType = null;
            String itemId = null;
            String rowId = null;
            String problemType = null;
            Object itemValue = null;
            block0: for (String itemArrayOne : itemArray) {
                splitArray = itemArrayOne.split("_");
                itemType = splitArray[0];
                itemId = splitArray[1];
                for (DynamicObject answerEntryRow : answerEntry) {
                    rowId = answerEntryRow.getString("id");
                    problemType = answerEntryRow.getString("setentry_problemtype");
                    if (!StringUtils.equals((CharSequence)itemId, (CharSequence)rowId) || !StringUtils.equals((CharSequence)itemType, (CharSequence)problemType)) continue;
                    itemValue = this.getInitValueFormSetEntryRow(answerEntryRow, itemId);
                    originAnswerList.append(itemValue);
                    continue block0;
                }
            }
        }
        return originAnswerList.toString();
    }

    protected void updateFinalScoreToSetEntry(String itemType, String itemId, DynamicObject answerEntryRow, Object itemValue, Boolean isBlank) {
        String problemType = answerEntryRow.getString("setentry_problemtype");
        String rowId = null;
        rowId = isBlank != false ? answerEntryRow.getString("setentry_sourcechoiceid") : answerEntryRow.getString("id");
        if (StringUtils.equals((CharSequence)problemType, (CharSequence)itemType) && StringUtils.equals((CharSequence)itemId, (CharSequence)rowId)) {
            this.updateFinalScoreByPropertyType(problemType, answerEntryRow, itemValue, itemId, isBlank);
        }
    }

    protected void updateFinalScoreByPropertyType(String problemType, DynamicObject answerEntryRow, Object itemValue, Object itemid, Boolean isBlank) {
        switch (problemType) {
            case "choice": {
                this.updateChoiceRow(answerEntryRow, itemValue, itemid, isBlank);
                break;
            }
            case "essayque": {
                this.updateEssayQueRow(answerEntryRow, itemValue);
                break;
            }
            case "inputscore": {
                this.updateInputScoreRow(answerEntryRow, itemValue);
                break;
            }
            case "oneticketveto": {
                this.updateOneTickerVetoRow(answerEntryRow, itemValue);
                break;
            }
        }
    }

    protected void updateChoiceRow(DynamicObject answerEntryRow, Object itemValue, Object itemid, Boolean isBlank) {
        if (isBlank.booleanValue()) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String questionnaireid = (String)formShowParameter.getCustomParam(QUESTIONNAIREID);
            DynamicObject questionnaireObject = BusinessDataServiceHelper.loadSingle((String)BDTAXR_QUESTIONNAIRE_SET, (String)"setentry.subentry,subentry.subentry_option,subentry.subentry_standardscore", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(questionnaireid))});
            DynamicObjectCollection setentry = questionnaireObject.getDynamicObjectCollection("setentry");
            DynamicObjectCollection setEntry = setentry.stream().filter(s -> s.getString("id").equals(String.valueOf(itemid))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            DynamicObjectCollection subEntry = ((DynamicObject)setEntry.get(0)).getDynamicObjectCollection("subentry");
            String standardScore = null;
            for (DynamicObject subEntryRow : subEntry) {
                String itemValStr;
                standardScore = subEntryRow.getString("subentry_standardscore");
                if (!StringUtils.equals((CharSequence)standardScore, (CharSequence)(itemValStr = itemValue.toString()).split(SPLITSTR)[0])) continue;
                answerEntryRow.set("setentry_answer", subEntryRow.get("subentry_option"));
                answerEntryRow.set("setentry_finalscore", subEntryRow.get("subentry_standardscore"));
                this.totalScore += subEntryRow.getInt("subentry_standardscore");
                break;
            }
        } else {
            DynamicObject questionnaireObject = BusinessDataServiceHelper.loadSingle((String)BDTAXR_QUESTIONANSWER, (String)"subentry.subentry_option,subentry.subentry_standardscore", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(itemid.toString()))});
            DynamicObjectCollection subEntry = questionnaireObject.getDynamicObjectCollection("subentry");
            String standardScore = null;
            for (DynamicObject subEntryRow : subEntry) {
                String itemValStr;
                standardScore = subEntryRow.getString("subentry_standardscore");
                if (!StringUtils.equals((CharSequence)standardScore, (CharSequence)(itemValStr = itemValue.toString()).split(SPLITSTR)[0])) continue;
                answerEntryRow.set("setentry_answer", subEntryRow.get("subentry_option"));
                answerEntryRow.set("setentry_finalscore", subEntryRow.get("subentry_standardscore"));
                this.totalScore += subEntryRow.getInt("subentry_standardscore");
                break;
            }
        }
    }

    protected void updateEssayQueRow(DynamicObject setEntryRow, Object itemValue) {
        setEntryRow.set("setentry_answer", (Object)new LocaleString(itemValue.toString()));
    }

    protected void updateInputScoreRow(DynamicObject setEntryRow, Object itemValue) {
        if (QuestionnairePreviewEditPlugin.isNumeric(itemValue.toString())) {
            setEntryRow.set("setentry_finalscore", itemValue);
            setEntryRow.set("setentry_answer", (Object)new LocaleString(itemValue.toString()));
            this.totalScore += Integer.parseInt(String.valueOf(itemValue));
        } else {
            setEntryRow.set("setentry_finalscore", (Object)new LocaleString("-1"));
            setEntryRow.set("setentry_answer", (Object)new LocaleString("-1"));
        }
    }

    public static boolean isNumeric(String str) {
        Pattern patternInteger = Pattern.compile("[0-9][0-9]*");
        return patternInteger.matcher(str).matches();
    }

    protected void updateOneTickerVetoRow(DynamicObject setEntryRow, Object itemValue) {
        boolean result = StringUtils.equals((CharSequence)YES, (CharSequence)itemValue.toString());
        if (result) {
            setEntryRow.set("setentry_answer", (Object)new LocaleString(this.getYesAnswerValue()));
            this.getPageCache().put("isOneTickerVeto", "true");
        } else {
            setEntryRow.set("setentry_answer", (Object)new LocaleString(this.getNoAnswerValue()));
        }
    }

    protected String getNoAnswerValue() {
        return ResManager.loadKDString((String)"\u5426\uff08\u4e0d\u53c2\u4e0e\u8ba1\u5206\uff09", (String)"QuestionnairePreviewEditPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    }

    protected String getYesAnswerValue() {
        return ResManager.loadKDString((String)"\u662f\uff08\u95ee\u5377\u5f970\u5206\uff09", (String)"QuestionnairePreviewEditPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    }
}

