/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.rule;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.taxc.bdtaxr.common.enums.RuleExportEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class RuleExportImportPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    public void initialize() {
        Listbox listbox = (Listbox)this.getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String taxtype = StringUtil.isBlank((CharSequence)type) ? "tcvat" : type;
        this.getModel().setValue("taxtype", (Object)taxtype);
        this.initListBox(taxtype);
    }

    private void initListBox(String type) {
        RuleExportEnum ruleExportEnum = RuleExportEnum.getRuleExportEnum((String)type);
        if (ruleExportEnum != null) {
            Listbox listbox = (Listbox)this.getControl("listboxap");
            ArrayList<ListboxItem> items = new ArrayList<ListboxItem>(ruleExportEnum.getEntityList().size());
            for (String entity : ruleExportEnum.getEntityList()) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                ListboxItem listboxItem = new ListboxItem(entity, dataEntityType.getDisplayName().getLocaleValue());
                items.add(listboxItem);
            }
            listbox.addItems(items);
        }
    }

    public void afterBindData(EventObject e) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String taxtype = StringUtil.isBlank((CharSequence)type) ? "tcvat" : type;
        this.selectFirstItem(taxtype);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("taxtype".equals(e.getProperty().getName())) {
            String taxtype = (String)e.getChangeSet()[0].getNewValue();
            this.initListBox(taxtype);
            this.selectFirstItem(taxtype);
        }
    }

    private void selectFirstItem(String type) {
        Listbox listbox = (Listbox)this.getControl("listboxap");
        RuleExportEnum ruleExportEnum = RuleExportEnum.getRuleExportEnum((String)type);
        if (ruleExportEnum != null) {
            String itemId = (String)ruleExportEnum.getEntityList().get(0);
            listbox.listboxClick(itemId);
            listbox.activeItem(itemId);
        }
    }

    public void listboxClick(ListboxEvent event) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(event.getItemId());
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("flexpanelap");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("close".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
        }
    }
}

