/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.rule.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.CommonConstant;
import kd.taxc.bdtaxr.common.refactor.rule.rulecal.filter.FilterDto;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang.StringUtils;

public class SelfDefineFilterOperPlugin
extends AbstractFormPlugin
implements CellClickListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String FILTER_DESCRIPTION = "filterdescription";
    private static final String FILTER_VALUE = "filtervalue";
    private static final String JSON = "filterJson";
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";
    private static final String FIELD = "field";
    private static final String TABLE = "table";
    private static final String VALUE = "value";
    private static final String TRUE_VALUE = "truevalue";
    private static final String EQUAL_ID = "equalId";
    private static final String LOGIC = "logic";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String LEFT_BRACKET = "leftbracket";
    private static final String RIGHT_BRACKET = "rightbracket";
    private static final String TABLEID = "tableid";
    private static final String BIZ_NAME = "bizname";
    private static final String ENTITY_NAME = "entityname";
    private static final String BIZ_SUBNAME = "bizsubname";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_SUB_NAME = "fieldsubname";
    private static final String SETTING = "setting";
    private static final String INDEX = "index";
    private static final String SERIAL = "serial";
    private static final String SETTING_BASEDATA = "settingBasedata";
    private static final String SETTING_COMBO = "settingCombo";

    private String getOrCn() {
        return ResManager.loadKDString((String)"\u6216\u8005", (String)"SelfDefineFilterOperPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    }

    private String getAndCn() {
        return ResManager.loadKDString((String)"\u5e76\u4e14", (String)"SelfDefineFilterOperPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{OK, CANCEL});
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.addCellClickListener((CellClickListener)this);
        BasedataEdit amountfield = (BasedataEdit)this.getControl(FIELD);
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit conditionfield = (BasedataEdit)this.getControl("condition");
        conditionfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        conditionfield.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String json;
        Map tableId2Name = (Map)this.getView().getFormShowParameter().getCustomParams().get("entityId");
        if (tableId2Name != null && tableId2Name.size() != 0) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(TABLE);
            List collect = tableId2Name.keySet().stream().map(Long::valueOf).collect(Collectors.toList());
            basedataEdit.setQFilter(new QFilter("id", "in", collect));
            ArrayList list = new ArrayList();
            this.getModel().setValue(TABLE, tableId2Name.keySet().iterator().next(), 0);
        }
        if (StringUtil.isEmpty((CharSequence)(json = (String)this.getView().getFormShowParameter().getCustomParams().get(JSON)))) {
            return;
        }
        List dtos = JsonUtil.fromJsonList((String)json, FilterDto.class);
        this.getModel().beginInit();
        for (int i = 0; i < dtos.size(); ++i) {
            if (this.getModel().getEntryRowCount(ENTRY_ENTITY) <= i) {
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
            }
            FilterDto dto = (FilterDto)dtos.get(i);
            this.getModel().setValue(LEFT_BRACKET, (Object)dto.getLeftBracket(), i);
            this.getModel().setValue(TABLE, (Object)dto.getDataSource(), i);
            this.getModel().setValue(FIELD, (Object)dto.getField(), i);
            this.getModel().setValue("condition", (Object)dto.getConditon(), i);
            if ("is null".equals(dto.getConditonNumber()) || "is not null".equals(dto.getConditonNumber())) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{VALUE});
            }
            this.getModel().setValue(VALUE, (Object)dto.getValueCn(), i);
            this.getModel().setValue(TRUE_VALUE, (Object)String.join((CharSequence)(CommonConstant.COMMA + ""), dto.getValue()), i);
            this.getModel().setValue(RIGHT_BRACKET, (Object)dto.getRightBracket(), i);
            this.getModel().setValue(LOGIC, (Object)dto.getLogic(), i);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        if (cellClickEvent.getFieldKey().equals(VALUE)) {
            IDataEntityProperty current = this.getCurrentEntityProp(cellClickEvent.getRow());
            DynamicObject condition = (DynamicObject)this.getModel().getValue("condition");
            if (null == condition) {
                return;
            }
            String qCp = condition.getString("number");
            if ("is null".endsWith(qCp) || "is not null".endsWith(qCp)) {
                return;
            }
            boolean isMultiSelect = false;
            if ("in".equals(qCp) || "not in".equals(qCp)) {
                isMultiSelect = true;
            }
            int index = cellClickEvent.getRow();
            if ("subquery".equals(qCp)) {
                this.openSettingPage("settingBasedata#" + index, "bdtaxr_rule_set", isMultiSelect, null);
            } else if ("left join".equals(qCp) || "inner join".equals(qCp)) {
                Map tableId2Name = (Map)this.getView().getFormShowParameter().getCustomParams().get("entityId");
                if (tableId2Name == null) {
                    return;
                }
                DynamicObject dataSource = (DynamicObject)this.getModel().getValue(TABLE);
                if (null != dataSource) {
                    tableId2Name.remove(dataSource.getString("id"));
                }
                List tableids = tableId2Name.keySet().stream().map(Long::valueOf).collect(Collectors.toList());
                QFilter idFliter = new QFilter(TABLEID, "in", tableids);
                ListFilterParameter parameter = new ListFilterParameter(Arrays.asList(idFliter), null);
                this.openSettingPage("settingBasedata#" + index, "bdtaxr_datasource_entry", false, parameter);
            } else if (current instanceof BasedataProp) {
                this.openSettingPage("settingBasedata#" + index, ((BasedataProp)current).getBaseEntityId(), isMultiSelect, null);
            } else if (current instanceof ComboProp) {
                this.insertValue2AssistTable((ComboProp)current);
                this.openSettingPage("settingCombo#" + index, "bdtaxr_combo_assist", isMultiSelect, null);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (OK.equalsIgnoreCase(key)) {
            if (this.checkBeforeReturn()) {
                return;
            }
            Map<String, Object> ret = this.getConfig();
            this.getView().returnDataToParent(ret);
            this.getView().close();
        }
    }

    private Map<String, Object> getConfig() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<FilterDto> dto = this.buildFilterDto();
        if (dto == null || dto.size() == 0) {
            return data;
        }
        data.put(FILTER_VALUE, JsonUtil.toJson(dto));
        data.put(FILTER_DESCRIPTION, this.getFilterDesc(dto));
        return data;
    }

    private List<FilterDto> buildFilterDto() {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        ArrayList<FilterDto> filterDtos = new ArrayList<FilterDto>(10);
        for (int i = 0; i < rowCount; ++i) {
            FilterDto dto = new FilterDto();
            dto.setLeftBracket((String)this.getModel().getValue(LEFT_BRACKET, i));
            DynamicObject condition = (DynamicObject)this.getModel().getValue("condition", i);
            dto.setConditon(Long.valueOf(condition.getLong("id")));
            dto.setConditonCn(condition.getString("name"));
            dto.setConditonNumber(condition.getString("number"));
            DynamicObject dataSource = (DynamicObject)this.getModel().getValue(TABLE, i);
            dto.setDataSource(Long.valueOf(dataSource.getLong("id")));
            dto.setDataSourceCn(dataSource.getString(BIZ_NAME));
            dto.setDataSourceNumber(dataSource.getString(ENTITY_NAME));
            DynamicObject field = (DynamicObject)this.getModel().getValue(FIELD, i);
            if (StringUtils.equals((String)dataSource.getString(ENTITY_NAME), (String)field.getString(FIELD_SUB_NAME))) {
                dto.setFieldNumber(field.getString(FIELD_NAME));
            } else {
                dto.setFieldNumber(field.getString(FIELD_SUB_NAME) + "." + field.getString(FIELD_NAME));
            }
            dto.setField(Long.valueOf(field.getLong("id")));
            dto.setFieldCn(field.getString(BIZ_SUBNAME));
            dto.setRightBracket((String)this.getModel().getValue(RIGHT_BRACKET, i));
            dto.setLogic((String)this.getModel().getValue(LOGIC, i));
            String truevalue = (String)this.getModel().getValue(TRUE_VALUE, i);
            ArrayList<String> filterValues = new ArrayList<String>(Arrays.asList(truevalue.split(CommonConstant.COMMA + "")));
            if (filterValues.size() == 1 && StringUtil.isEmpty((CharSequence)((CharSequence)filterValues.get(0)))) {
                filterValues.add(0, (String)this.getModel().getValue(VALUE, i));
            }
            dto.setValue(filterValues);
            dto.setValueCn((String)this.getModel().getValue(VALUE, i));
            filterDtos.add(dto);
        }
        return filterDtos;
    }

    private String getFilterDesc(List<FilterDto> dtos) {
        StringBuilder sb = new StringBuilder();
        for (FilterDto dto : dtos) {
            sb.append(dto.toCnString()).append(" ");
        }
        String desc = sb.toString().trim();
        if (desc.endsWith(this.getAndCn()) || desc.endsWith(this.getOrCn())) {
            desc = desc.substring(0, desc.length() - 2);
        }
        return desc;
    }

    private IDataEntityProperty getCurrentEntityProp(int row) {
        DynamicObject table = (DynamicObject)this.getModel().getValue(TABLE);
        if (null == table) {
            this.getModel().setValue("condition", null, row);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"SelfDefineFilterOperPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)table.getString(ENTITY_NAME));
        Map entityTypeMap = entityType.getAllFields();
        DynamicObject field = (DynamicObject)this.getModel().getValue(FIELD);
        if (null == field) {
            return null;
        }
        String name = field.getString(FIELD_NAME);
        if (name.contains(".")) {
            name = name.split("\\.")[0];
        }
        return (IDataEntityProperty)entityTypeMap.get(name);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals(ENTRY_ENTITY)) {
            Map tableId2Name = (Map)this.getView().getFormShowParameter().getCustomParams().get("entityId");
            if (tableId2Name == null || tableId2Name.size() == 0) {
                return;
            }
            int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY) - 1;
            this.getModel().setValue(TABLE, tableId2Name.keySet().iterator().next(), rowCount);
        }
    }

    private void insertValue2AssistTable(ComboProp current) {
        DeleteServiceHelper.delete((String)"bdtaxr_combo_assist", null);
        ArrayList<DynamicObject> dyos = new ArrayList<DynamicObject>(10);
        for (ValueMapItem item : current.getComboItems()) {
            if (item.getName().isEmpty()) continue;
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_combo_assist");
            dyo.set("name", (Object)item.getName());
            dyo.set("number", (Object)item.getValue());
            dyos.add(dyo);
        }
        SaveServiceHelper.save((DynamicObject[])dyos.toArray(new DynamicObject[dyos.size()]));
    }

    private void openSettingPage(String actionId, String entityName, boolean isMultiSelect, ListFilterParameter listFilterParameter) {
        if (StringUtil.isEmpty((CharSequence)entityName)) {
            return;
        }
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)entityName, (boolean)isMultiSelect);
        parameter.setFormId("bos_listf7");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        parameter.setCloseCallBack(closeCallBack);
        parameter.setListFilterParameter(listFilterParameter);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        ListSelectedRowCollection collection = (ListSelectedRowCollection)evt.getReturnData();
        if (null == collection || collection.size() == 0) {
            return;
        }
        if (actionId.startsWith(SETTING)) {
            String[] subs = evt.getActionId().split("#");
            int index = Integer.parseInt(subs[1]);
            for (int i = 0; i < collection.size(); ++i) {
                String pkId = String.valueOf(collection.get(i).getPrimaryKeyValue());
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdtaxr_datasource_entry");
                if (obj == null) continue;
                String value = this.getIniteValue((DynamicObject)this.getModel().getValue("condition"), (DynamicObject)this.getModel().getValue(TABLE), obj.getLong(TABLEID));
                String trueValue = "";
                if (i != 0) {
                    value = this.getModel().getValue(VALUE, index) + CommonConstant.COMMA + "";
                    trueValue = this.getModel().getValue(TRUE_VALUE, index) + CommonConstant.COMMA + "";
                }
                this.getModel().setValue(VALUE, (Object)(value + collection.get(i).getName()), index);
                if (StringUtil.isEmpty((CharSequence)collection.get(i).getName())) {
                    this.getModel().setValue(VALUE, (Object)(value + pkId), index);
                }
                if (actionId.contains("Basedata")) {
                    this.getModel().setValue(TRUE_VALUE, (Object)(trueValue + pkId), index);
                    continue;
                }
                if (!actionId.contains("Combo")) continue;
                this.getModel().setValue(TRUE_VALUE, (Object)(trueValue + collection.get(i).getNumber()), index);
            }
        }
    }

    private String getIniteValue(DynamicObject condition, DynamicObject table, Long tableId) {
        String value = "";
        if (null == condition) {
            return value;
        }
        Map tableId2Name = (Map)this.getView().getFormShowParameter().getCustomParams().get("entityId");
        String qCp = condition.getString("number");
        return "left join".equals(qCp) || "inner join".equals(qCp) ? (String)tableId2Name.get(tableId) + "." : value;
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        this.cellClick(cellClickEvent);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals(FIELD)) {
            DynamicObject table = (DynamicObject)this.getModel().getValue(TABLE);
            if (table == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"SelfDefineFilterOperPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            QFilter tableid = new QFilter(TABLEID, "=", (Object)table.getLong("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(tableid);
        } else if (evt.getProperty().getName().equals("condition")) {
            QFilter conditionFilter = this.getConditionFilterByFieldType(evt.getRow());
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(conditionFilter);
            formShowParameter.getListFilterParameter().setOrderBy(SERIAL);
            this.getPageCache().put(INDEX, String.valueOf(evt.getRow()));
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        DynamicObject conditon = (DynamicObject)this.getModel().getValue("condition");
        if (null == conditon) {
            return;
        }
        String qcp = conditon.getString("number");
        if (StringUtil.isEmpty((CharSequence)this.getPageCache().get(INDEX))) {
            return;
        }
        int index = Integer.parseInt(this.getPageCache().get(INDEX));
        if ("is null".equals(qcp) || "is not null".equals(qcp)) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{VALUE});
        } else {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{VALUE});
        }
    }

    private QFilter getConditionFilterByFieldType(int row) {
        IDataEntityProperty current = this.getCurrentEntityProp(row);
        if (null == current) {
            DynamicObject field = (DynamicObject)this.getModel().getValue(FIELD, row);
            String name = field.getString(FIELD_NAME);
            if (StringUtils.equals((String)"id", (String)name)) {
                return new QFilter("number", "in", Arrays.asList("left join", "inner join", "subquery"));
            }
            return new QFilter("number", "in", null);
        }
        QFilter conditionFilter = null;
        if (current instanceof TextProp || current instanceof ComboProp) {
            conditionFilter = new QFilter("number", "in", Arrays.asList("=", "!=", "in", "not in", "is null", "is not null", "contain", "not contain", "start with", "end with", "subquery"));
        } else if (current instanceof DecimalProp || current instanceof DateTimeProp) {
            conditionFilter = new QFilter("number", "in", Arrays.asList("=", "!=", ">", ">=", "<", "<=", "in", "not in", "is null", "is not null", "subquery"));
        } else if (current instanceof BasedataProp) {
            conditionFilter = new QFilter("number", "in", Arrays.asList("=", "!=", "in", "not in", "is null", "is not null", "contain", "not contain", "subquery"));
        }
        Map tableId2Name = (Map)this.getView().getFormShowParameter().getCustomParams().get("entityId");
        if (null != tableId2Name && tableId2Name.size() > 1 && conditionFilter != null) {
            conditionFilter = conditionFilter.or(new QFilter("number", "in", Arrays.asList("left join", "inner join")));
        }
        return conditionFilter;
    }

    private boolean notJoinCondition(int row) {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject condition;
            if (i == row || null == (condition = (DynamicObject)this.getModel().getValue("condition", i)) || !"left join".equals(condition.getString("number")) && !"inner join".equals(condition.getString("number"))) continue;
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        if (FIELD.equals(propertyName)) {
            this.getModel().setValue("condition", (Object)this.getEqualId(), index);
            this.getView().setEnable(Boolean.TRUE, index, new String[]{VALUE});
            this.getModel().setValue(VALUE, null, index);
            this.getModel().setValue(TRUE_VALUE, null, index);
        } else if (TABLE.equals(propertyName)) {
            this.getModel().setValue(FIELD, null, index);
        } else if ("condition".equals(propertyName)) {
            this.getModel().setValue(VALUE, null, index);
            this.getModel().setValue(TRUE_VALUE, null, index);
        } else if (VALUE.equals(propertyName)) {
            this.getModel().setValue(TRUE_VALUE, e.getChangeSet()[0].getNewValue(), index);
        }
    }

    private Long getEqualId() {
        String id = this.getPageCache().get(EQUAL_ID);
        if (StringUtil.isEmpty((CharSequence)id)) {
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"bdtaxr_comparetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"=")});
            if (null != dyo) {
                this.getPageCache().put(EQUAL_ID, String.valueOf(dyo.getLong("id")));
                return dyo.getLong("id");
            }
            return null;
        }
        return Long.parseLong(id);
    }

    public boolean checkBeforeReturn() {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        for (int i = 0; i < rowCount; ++i) {
            if (null != this.getModel().getValue(TABLE, i) && null != this.getModel().getValue(FIELD, i) && null != this.getModel().getValue("condition", i) && !this.checkValue((DynamicObject)this.getModel().getValue("condition", i), (String)this.getModel().getValue(VALUE, i))) continue;
            int value = i + 1;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s", (String)"SelfDefineFilterOperPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), value));
            return true;
        }
        return false;
    }

    private boolean checkValue(DynamicObject condition, String value) {
        String qCp = condition.getString("number");
        if ("is null".equals(qCp) || "is not null".equals(qCp)) {
            return false;
        }
        return StringUtil.isEmpty((CharSequence)value);
    }
}

