/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.shareplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.taxc.bdtaxr.common.constant.SharePlanConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.user.UserDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSharePlanFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(AbstractSharePlanFormPlugin.class);
    protected Map<String, String> planFieldMap = new HashMap<String, String>();
    protected List<String> lockOperate = Arrays.asList("save", "plandel");

    public void initialize() {
        super.initialize();
        this.initData();
        CardEntry planentity = (CardEntry)this.getControl("planentity");
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
    }

    protected void initData() {
        this.planFieldMap.put("name", "carname");
        this.planFieldMap.put("number", "carnumber");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarMain = (Toolbar)this.getControl("toolbarap");
        toolbarMain.addItemClickListener((ItemClickListener)this);
        OrgEdit taxOrgEdit = (OrgEdit)this.getControl("org");
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ruleEdit = (BasedataEdit)this.getControl("rule");
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        search.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("init", "true");
        this.loadFormData();
        this.checkPermission();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSelectRow();
        this.setVisible();
    }

    protected void initSelectRow() {
        String afterSelectRow = this.getPageCache().get("afterSelectRow");
        if (ObjectUtils.isNotEmpty((Object)afterSelectRow)) {
            this.selectListRow(Integer.parseInt(afterSelectRow));
            this.getPageCache().put("afterSelectRow", null);
        } else {
            this.selectListRow(0);
        }
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get("currentSearch"), (CharSequence)searchText)) {
            this.selectListRowAndPutCache();
        } else {
            this.generateCardIndexs(searchText);
            this.selectListRowAndPutCache();
        }
    }

    private void generateCardIndexs(String searchText) {
        this.getPageCache().put("currentSearch", searchText);
        ArrayList<Integer> list = new ArrayList<Integer>();
        HashMap map = new HashMap();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter("name", "like", (Object)text);
        QFilter numberQ = new QFilter("number", "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet tempDataSet = dataSet.filter(nameQ.or(numberQ).toString());
        for (Row row : tempDataSet) {
            list.add(row.getInteger("index"));
        }
        tempDataSet.close();
        Collections.sort(list);
        Stream.iterate(0, i -> i + 1).limit(list.size()).forEach(i -> {
            Integer cfr_ignored_0 = (Integer)map.put(String.valueOf(i), list.get((int)i));
        });
        this.getPageCache().put("cardIndexs", SerializationUtils.toJsonString(map));
        if (!map.isEmpty()) {
            this.getPageCache().put("focusCardIndex", "-1");
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        this.generateCardIndexs(searchText);
        return this.filterDataSet(searchText);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int selectRow;
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (this.planFieldMap.containsKey(key) && (selectRow = this.getSelectRows()) >= 0) {
            if (newValue instanceof LocaleDynamicObjectCollection) {
                this.getModel().setValue(this.planFieldMap.get(key), (Object)this.getLangValue(newValue), selectRow);
            } else {
                this.getModel().setValue(this.planFieldMap.get(key), newValue, selectRow);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if (StringUtil.equalsIgnoreCase((CharSequence)event.getProperty().getName(), (CharSequence)"org")) {
            this.setOrgFilter(event);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)event.getProperty().getName(), (CharSequence)"rule")) {
            this.setRuleFilter(event);
        }
    }

    protected void setOrgFilter(BeforeF7SelectEvent event) {
    }

    protected void setRuleFilter(BeforeF7SelectEvent event) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        int rowIndex = this.getSelectRows();
        if (this.lockOperate.contains(operateKey) && !ObjectUtils.isEmpty((Object)(row = this.getSelectRowObj(rowIndex))) && this.checkLock(String.valueOf(row.getLong("id")))) {
            args.setCancel(true);
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"planadd") && this.checkChangeData(rowIndex)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u65b0\u589e\u5171\u4eab\u65b9\u6848\u3002", (String)"AbstractSharePlanFormPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"plandel")) {
            this.planDel(args);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"save") && !this.checkChangeData(rowIndex) && this.checkDBChangeData(rowIndex)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractSharePlanFormPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"planadd")) {
            this.planAdd(args);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"save")) {
            OperationResult result = args.getOperationResult();
            if (result.isSuccess()) {
                this.planSave(args);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"plandel")) {
            this.getView().invokeOperation("refresh");
        }
        this.setVisible();
    }

    protected void planAdd(AfterDoOperationEventArgs args) {
        int selectRow = this.getSelectRows();
        this.selectListRow(selectRow);
        this.createNewPlan(selectRow);
        this.getModel().setEntryCurrentRowIndex("planentity", selectRow);
        this.getModel().createNewEntryRow("ruleentity");
        this.getModel().createNewEntryRow("orgentity");
    }

    protected void createNewPlan(int selectRow) {
        String number = this.getCodeRuleNumber();
        this.getModel().setValue("number", (Object)number, selectRow);
        this.getModel().setValue(this.planFieldMap.get("number"), (Object)number, selectRow);
    }

    protected void planDel(BeforeDoOperationEventArgs args) {
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("planentity").get(this.getSelectRows());
        Long planId = row.getLong("id");
        DynamicObject plan = this.loadPlanData(planId);
        if (plan != null) {
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)this.getSharePlanEntityName(), (Object[])new Object[]{planId}, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                int i = row.getInt(1) - 1;
                int entryCount = this.getModel().getEntryRowCount("planentity");
                if (entryCount == 0 || row.getInt(1) + 1 > entryCount) {
                    i = 0;
                }
                this.getPageCache().put("afterSelectRow", String.valueOf(i));
            } else {
                this.getView().showOperationResult(result, ResManager.loadKDString((String)"\u5220\u9664", (String)"AbstractSharePlanFormPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
    }

    protected void planSave(AfterDoOperationEventArgs args) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("planentity");
        if (collection.isEmpty()) {
            return;
        }
        if (!this.beforeSavePlan()) {
            return;
        }
        ArrayList<DynamicObject> forSaveObjArr = new ArrayList<DynamicObject>(10);
        DynamicObject row = (DynamicObject)collection.get(this.getSelectRows());
        DynamicObject planObject = this.getPlanObject(row);
        planObject.set("name", this.getModel().getValue("name"));
        forSaveObjArr.add(planObject);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.getSharePlanEntityName(), (DynamicObject[])forSaveObjArr.toArray(new DynamicObject[forSaveObjArr.size()]), (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractSharePlanFormPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), Integer.valueOf(3000));
            this.getPageCache().put("afterSelectRowId", String.valueOf(result.getSuccessPkIds().get(0)));
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showOperationResult(result, ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractSharePlanFormPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    protected DynamicObject getPlanObject(DynamicObject row) {
        Long planId = row.getLong("id");
        DynamicObject planObject = BusinessDataServiceHelper.newDynamicObject((String)this.getSharePlanEntityName());
        if (!ObjectUtils.isEmpty((Object)planId) && planId > 0L) {
            planObject = this.loadPlanData(planId);
        } else {
            planObject.set("creator", row.get("creator"));
            planObject.set("createtime", row.get("createtime"));
        }
        this.setPlanField(planObject, row);
        planObject.set("modifier", row.get("modifier"));
        planObject.set("modifytime", row.get("modifytime"));
        planObject.set("status", (Object)"C");
        planObject.set("enable", (Object)1);
        DynamicObjectCollection ruleCol = row.getDynamicObjectCollection("ruleentity");
        DynamicObjectCollection ruleCollection = planObject.getDynamicObjectCollection("ruleentity");
        ruleCollection.clear();
        Stream.iterate(0, i -> i + 1).limit(ruleCol.size()).forEach(index -> {
            DynamicObject rule = (DynamicObject)ruleCol.get(index.intValue());
            DynamicObject ruleRow = ruleCollection.addNew();
            ruleRow.set("seq", index);
            ruleRow.set("id", rule.get("ruleentryid"));
            ruleRow.set("rule", rule.get("rule"));
        });
        DynamicObjectCollection orgCol = row.getDynamicObjectCollection("orgentity");
        DynamicObjectCollection orgCollection = planObject.getDynamicObjectCollection("orgentity");
        orgCollection.clear();
        Stream.iterate(0, i -> i + 1).limit(orgCol.size()).forEach(index -> {
            DynamicObject org = (DynamicObject)orgCol.get(index.intValue());
            DynamicObject orgRow = orgCollection.addNew();
            orgRow.set("seq", index);
            orgRow.set("id", org.get("orgentryid"));
            orgRow.set("org", org.get("org"));
        });
        return planObject;
    }

    protected void setPlanField(DynamicObject planObject, DynamicObject row) {
        for (Map.Entry<String, String> entry : this.planFieldMap.entrySet()) {
            planObject.set(entry.getKey(), row.get(entry.getValue()));
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        List oldRows = evt.getOldRows();
        if (newRows != null && newRows.size() > 0) {
            Integer oldRowIndex;
            Integer newRowIndex = (Integer)newRows.get(0);
            if (!newRowIndex.equals(oldRowIndex = (Integer)oldRows.get(0)) && this.checkChangeData((Integer)evt.getOldRows().get(0))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("cardSwitch", (IFormPlugin)this);
                this.showConfirm(confirmCallBacks);
                this.getPageCache().put("newRow", String.valueOf(newRowIndex));
                this.getPageCache().put("oldRow", String.valueOf(oldRowIndex));
                return;
            }
            this.getPageCache().put("newRow", String.valueOf(newRowIndex));
            this.getPageCache().put("oldRow", newRowIndex.equals(oldRowIndex) ? String.valueOf(this.getPageCache().get("oldRow")) : String.valueOf(oldRowIndex));
            this.resetPlanName(newRowIndex);
            this.afterRestPlanName(newRowIndex);
            this.requireLock(this.getSelectRowObj(newRowIndex));
            this.getPageCache().put("oldRow", String.valueOf(newRowIndex));
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseLock();
    }

    protected boolean checkLock(String objectId) {
        if (StringUtil.isEmpty((CharSequence)objectId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(objectId, "default_netctrl", this.getSharePlanEntityName());
        if (lockInfo != null && !((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            String username = "";
            TaxResult result = UserDataServiceHelper.queryUserNameByIds((Long)Long.valueOf((String)lockInfo.get("userid")));
            if (result != null && result.isSuccess()) {
                username = (String)result.getData();
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractSharePlanFormPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), username));
            return true;
        }
        return false;
    }

    protected void requireLock(DynamicObject object) {
        if (object == null) {
            return;
        }
        this.releaseLock();
        if (object.getLong("id") == 0L) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"flexdata"});
            return;
        }
        String objectId = String.valueOf(object.getLong("id"));
        boolean newMutexLocked = MutexHelper.require((String)this.getSharePlanEntityName(), (Object)objectId, (String)"modify", (boolean)Boolean.FALSE, (StringBuilder)new StringBuilder());
        if (!newMutexLocked) {
            if (this.checkLock(objectId)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"flexdata"});
            }
        } else {
            this.getPageCache().put("id_lock", objectId);
            this.getView().setEnable(Boolean.TRUE, new String[]{"flexdata"});
        }
    }

    protected void releaseLock() {
        DataMutexImpl dataMutex;
        Map lockInfo;
        String lockId = this.getPageCache().get("id_lock");
        if (StringUtil.isNotEmpty((CharSequence)lockId) && !"null".equalsIgnoreCase(lockId) && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(lockId, "default_netctrl", this.getSharePlanEntityName())) != null && ((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            MutexHelper.release((String)this.getSharePlanEntityName(), (String)"modify", (String)lockId);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        int rowIndex = this.getSelectRows();
        if ((StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"bar_close") || StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"refresh")) && this.checkChangeData(rowIndex)) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(evt.getItemKey(), (IFormPlugin)this);
            this.showConfirm(confirmCallBacks);
        }
    }

    protected void showConfirm(ConfirmCallBackListener confirmCallBacks) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractSharePlanFormPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AbstractSharePlanFormPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractSharePlanFormPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"refresh")) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"importdata")) {
            this.importData(this.getSharePlanEntityName(), this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"exportdata")) {
            this.showExportDataForm(this.getSharePlanEntityName());
        }
    }

    protected boolean checkChangeData(int row) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("planentity");
        if (collection.isEmpty()) {
            return false;
        }
        DynamicObject newRowObject = (DynamicObject)collection.get(row);
        String oldDataJson = newRowObject.getString("olddata");
        if (StringUtil.isEmpty((CharSequence)oldDataJson)) {
            return true;
        }
        Object[] oldDatas = DynamicObjectSerializeUtil.deserialize((String)oldDataJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSharePlanEntityName()));
        if (oldDatas == null || oldDatas.length == 0) {
            return false;
        }
        return this.isDataChange(newRowObject, (DynamicObject)oldDatas[0]);
    }

    protected boolean checkDBChangeData(int row) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("planentity");
        if (collection.isEmpty()) {
            return false;
        }
        DynamicObject newRowObject = (DynamicObject)collection.get(row);
        DynamicObject planRow = this.loadPlanData(newRowObject.getLong("id"));
        return this.isDataChange(newRowObject, planRow);
    }

    protected boolean isDataChange(DynamicObject newRowObject, DynamicObject planRow) {
        if (ObjectUtils.isNotEmpty((Object)planRow)) {
            List ruleEntityList = planRow.getDynamicObjectCollection("ruleentity").stream().map(o -> o.getString("rule.id")).collect(Collectors.toList());
            List orgEntityList = planRow.getDynamicObjectCollection("orgentity").stream().map(o -> o.getString("org.id")).collect(Collectors.toList());
            List<String> planEntity = Arrays.asList(planRow.getString("number"), planRow.getString("name"));
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = newRowObject.getDynamicObjectCollection("ruleentity");
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = newRowObject.getDynamicObjectCollection("orgentity");
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            List<String> plan = Arrays.asList(newRowObject.getString(this.planFieldMap.get("number")), newRowObject.getString(this.planFieldMap.get("name")));
            if (!(CollectionUtils.isEqualCollection(plan, planEntity) && CollectionUtils.isEqualCollection(ruleList, ruleEntityList) && CollectionUtils.isEqualCollection(orgList, orgEntityList))) {
                return true;
            }
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"bar_close")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().close();
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"refresh")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"cardSwitch")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                String oldRow = this.getPageCache().get("oldRow");
                DynamicObjectCollection collection = this.getModel().getEntryEntity("planentity");
                DynamicObject oldObject = (DynamicObject)collection.get(Integer.parseInt(oldRow));
                DynamicObject planRow = this.loadPlanData(oldObject.getLong("id"));
                if (null != planRow) {
                    List ruleList = planRow.getDynamicObjectCollection("ruleentity").stream().map(o -> o.getString("rule.id")).collect(Collectors.toList());
                    List orgList = planRow.getDynamicObjectCollection("orgentity").stream().map(o -> o.getString("org.id")).collect(Collectors.toList());
                    oldObject.set("olddata", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{planRow}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSharePlanEntityName())));
                    for (Map.Entry<String, String> entry : this.planFieldMap.entrySet()) {
                        oldObject.set(entry.getValue(), planRow.get(entry.getKey()));
                    }
                    this.getModel().setEntryCurrentRowIndex("planentity", Integer.parseInt(oldRow));
                    this.getModel().deleteEntryData("ruleentity");
                    ruleList.stream().forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow("ruleentity");
                        this.getModel().setValue("rule", (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getModel().deleteEntryData("orgentity");
                    orgList.stream().forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow("orgentity");
                        this.getModel().setValue("org", (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getView().updateView("planentity");
                } else {
                    this.getModel().deleteEntryRow("planentity", Integer.parseInt(oldRow));
                }
                this.selectListRow(Integer.parseInt(this.getPageCache().get("newRow")));
            } else {
                this.selectListRow(Integer.parseInt(this.getPageCache().get("oldRow")));
            }
        }
    }

    private void resetPlanName(Integer startRowIndex) {
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        DynamicObject[] planentities = this.getModel().getEntryEntity("planentity", startRowIndex.intValue(), startRowIndex + 1);
        boolean hasData = false;
        if (planentities != null && planentities.length > 0) {
            hasData = true;
        }
        for (Map.Entry<String, String> entry : this.planFieldMap.entrySet()) {
            if (hasData) {
                this.getModel().setValue(entry.getKey(), planentities[0].get(entry.getValue()));
                continue;
            }
            this.getModel().setValue(entry.getKey(), (Object)"");
        }
        for (Map.Entry<String, String> entry : this.planFieldMap.entrySet()) {
            this.getView().updateView(entry.getKey());
        }
    }

    protected int getSelectRows() {
        int rowIndex = 0;
        EntryGrid planEntry = (EntryGrid)this.getControl("planentity");
        int[] ids = planEntry.getSelectRows();
        if (!ObjectUtils.isEmpty((Object)ids)) {
            rowIndex = ids[0];
        }
        return rowIndex;
    }

    protected DynamicObject getSelectRowObj(int rowIndex) {
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity("planentity");
        if (rowIndex < 0 || rowIndex >= planEntity.size()) {
            return null;
        }
        DynamicObject row = (DynamicObject)planEntity.get(rowIndex);
        return row;
    }

    private String getLangValue(Object object) {
        String value = null;
        String lang = RequestContext.get().getLang().toString();
        if (object instanceof LocaleDynamicObjectCollection) {
            LocaleDynamicObjectCollection valueCol = (LocaleDynamicObjectCollection)object;
            for (DynamicObject langObj : valueCol) {
                String localeid = langObj.getString("localeid");
                String version = langObj.getString("name");
                if (lang == null || !lang.equals(localeid)) continue;
                value = version;
                break;
            }
        }
        return value;
    }

    protected void setVisible() {
        int row = this.getModel().getEntryRowCount("planentity");
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", "planentity"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", "planentity"});
        }
    }

    protected void selectListRow(int rowIndex) {
        CardEntry planCardEntry = (CardEntry)this.getControl("planentity");
        int entryCount = this.getModel().getEntryRowCount("planentity");
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        int nowRow = this.getSelectRows();
        planCardEntry.selectCard(Integer.valueOf(rowIndex));
        planCardEntry.selectRowsChanged(Collections.singletonList(rowIndex), Collections.singletonList(nowRow));
    }

    private String getCodeRuleNumber() {
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)this.getSharePlanEntityName());
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.readNumber(this.getSharePlanEntityName(), dataInfo, null);
    }

    private void loadFormData() {
        DynamicObject[] planRows = this.loadPlanDatas();
        if (planRows.length > 0) {
            this.getModel().deleteEntryData("planentity");
            HashMap<String, String> indexMap = new HashMap<String, String>(10);
            DynamicObject planRow = null;
            int size = planRows.length;
            for (int i = 0; i < size; ++i) {
                planRow = planRows[i];
                indexMap.put(String.valueOf(planRow.getLong("id")), String.valueOf(i));
                this.innerLoadData(planRow);
            }
            String afterSelectRowId = this.getPageCache().get("afterSelectRowId");
            if (ObjectUtils.isNotEmpty((Object)afterSelectRowId)) {
                this.getPageCache().put("afterSelectRow", (String)indexMap.get(afterSelectRowId));
                this.getPageCache().put("afterSelectRowId", null);
            }
        }
    }

    protected void innerLoadData(DynamicObject planRow) {
        int rowIndex = this.getModel().createNewEntryRow("planentity");
        this.getModel().setValue("id", planRow.get("id"), rowIndex);
        this.setCardViewField(planRow, rowIndex);
        this.getModel().setValue("creator", planRow.get("creator"), rowIndex);
        this.getModel().setValue("createtime", planRow.get("createtime"), rowIndex);
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId(), rowIndex);
        this.getModel().setValue("modifytime", (Object)new Date(), rowIndex);
        this.getModel().setValue("olddata", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{planRow}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSharePlanEntityName())), rowIndex);
        this.getModel().setEntryCurrentRowIndex("planentity", rowIndex);
        DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection("ruleentity");
        ruleCol.stream().forEach(ruleRow -> {
            int subRowIndex = this.getModel().createNewEntryRow("ruleentity");
            this.getModel().setValue("rule", ruleRow.get("rule"), subRowIndex);
            this.getModel().setValue("ruleentryid", ruleRow.get("id"), subRowIndex);
        });
        DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection("orgentity");
        orgCol.stream().forEach(orgRow -> {
            int subRowIndex = this.getModel().createNewEntryRow("orgentity");
            this.getModel().setValue("org", orgRow.get("org"), subRowIndex);
            this.getModel().setValue("orgentryid", orgRow.get("id"), subRowIndex);
        });
    }

    protected void setCardViewField(DynamicObject planRow, int rowIndex) {
        for (Map.Entry<String, String> entry : this.planFieldMap.entrySet()) {
            this.getModel().setValue(entry.getValue(), planRow.get(entry.getKey()), rowIndex);
        }
    }

    private void checkPermission() {
        if (!PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"47156aff000000ac")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"importdata"});
        }
    }

    private void importData(String entityId, String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)entityId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("Enabled", Boolean.TRUE);
        plugins.add(map);
        showParameter.setCustomParam("ListName", (Object)entityName);
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importdata"));
        this.getView().showForm(showParameter);
    }

    private void showExportDataForm(String entitynumber) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(entitynumber);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setMarginRight("500");
        styleCss.setMarginLeft("500");
        styleCss.setWidth("1150");
        styleCss.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "exportdata"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtil.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"importdata")) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void selectListRowAndPutCache() {
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("cardIndexs"), Map.class);
        if (!map.isEmpty()) {
            Integer focusCardIndex = Integer.valueOf(this.getPageCache().get("focusCardIndex"));
            if (map.size() - 1 > focusCardIndex) {
                String nextFocusCardIndex = String.valueOf(focusCardIndex + 1);
                this.selectListRow((Integer)map.get(nextFocusCardIndex));
                this.getPageCache().put("focusCardIndex", nextFocusCardIndex);
            } else if (map.size() - 1 == focusCardIndex) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u641c\u7d22\u5230\u6700\u540e\u4e00\u884c\u3002", (String)"AbstractSharePlanFormPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
    }

    private DataSet buildDataSet() {
        DataType[] dataTypes = new DataType[]{DataType.IntegerType, DataType.StringType, DataType.StringType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])SharePlanConstant.fieldNames, (DataType[])dataTypes);
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        int entryRowCount = this.getModel().getEntryRowCount("planentity");
        for (int i = 0; i < entryRowCount; ++i) {
            Object[] value = new Object[SharePlanConstant.fieldNames.length];
            DynamicObject planEntry = (DynamicObject)this.getModel().getEntryEntity("planentity").get(i);
            value[0] = i;
            value[1] = planEntry.getString(this.planFieldMap.get("number"));
            value[2] = planEntry.getString(this.planFieldMap.get("name"));
            coll.add(value);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet dataSet = Algo.create((String)this.getSharePlanEntityName()).createDataSet(new Input[]{inputs});
        return dataSet;
    }

    private List<String> filterDataSet(String searchText) {
        ArrayList<String> list = new ArrayList<String>();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter("name", "like", (Object)text);
        QFilter numberQ = new QFilter("number", "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet nameDataSet = dataSet.filter(nameQ.toString());
        DataSet numberDataSet = dataSet.filter(numberQ.toString());
        if (!nameDataSet.isEmpty()) {
            nameDataSet.forEach(o -> list.add(o.getString("name")));
        }
        if (!numberDataSet.isEmpty()) {
            numberDataSet.forEach(o -> list.add(o.getString("number")));
        }
        nameDataSet.close();
        numberDataSet.close();
        return list;
    }

    protected List<Long> getPermOrgs() {
        long userId;
        TaxResult result;
        List<Long> orgIds = new ArrayList<Long>(10);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        String entityid = this.getView().getEntityId();
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        if ((result = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)(userId = RequestContext.get().getCurrUserId()), (String)appid, (String)entityid, (String)"47150e89000000ac", (String)"40")) != null && result.isSuccess()) {
            orgIds = (List)result.getData();
        }
        return orgIds;
    }

    protected abstract DynamicObject[] loadPlanDatas();

    protected abstract DynamicObject loadPlanData(Long var1);

    protected abstract String getSharePlanEntityName();

    protected void afterRestPlanName(Integer startRowIndex) {
    }

    protected boolean beforeSavePlan() {
        return true;
    }

    protected void setEditEnable(boolean enbale) {
        this.getView().setEnable(Boolean.valueOf(enbale), new String[]{"name", "ruleadd", "ruledel", "advconap1", "advconap2"});
    }
}

