/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.tax.rules;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaxRulesImportPlugin
implements IImportPlugin {
    private static final String ENTYR_ENTITY = "entryentity";
    private static final String ENTRY_CLASS = "entryclass";
    private static final String VALUE_NAME = "valuename";
    private static final String VALUE_NUMBER = "valuenumber";
    private static final String VALUE_ID = "valueid";
    private static final String BASTAX_ADDRESSTYPE = "bastax_addresstype";
    private static final String BASTAX_PARTY_TYPE = "bastax_party_type";
    private static final String BASTAX_TAXPRODUCT = "bastax_taxproduct";
    private static final String BASTAX_PROCESS_TYPE = "bastax_process_type";

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONArray entryArr = (JSONArray)data.get(ENTYR_ENTITY);
        if (entryArr != null) {
            String formId = "";
            for (int i = 0; i < entryArr.size(); ++i) {
                Map itemEntry = (Map)entryArr.get(i);
                if (itemEntry != null && itemEntry.get(ENTRY_CLASS) != null) {
                    Object itemClass = itemEntry.get(ENTRY_CLASS);
                    switch (itemClass.toString()) {
                        case "bastax_addresstype": {
                            formId = "bastax_addressterms";
                            break;
                        }
                        case "bastax_party_type": {
                            formId = "bastax_party";
                            break;
                        }
                        case "bastax_process_type": {
                            formId = "bastax_process";
                            break;
                        }
                        case "bastax_taxproduct": {
                            formId = BASTAX_TAXPRODUCT;
                            break;
                        }
                    }
                    Object valuenumber = itemEntry.get(VALUE_NUMBER);
                    if (valuenumber == null) {
                        importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u503c\u3011\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxRulesImportPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0])));
                        return false;
                    }
                    try {
                        String numbers = valuenumber.toString();
                        String[] numberArr = numbers.split(",");
                        ArrayList<String> ids = new ArrayList<String>(numberArr.length);
                        ArrayList<String> names = new ArrayList<String>(numberArr.length);
                        for (String number : numberArr) {
                            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)formId, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                            ids.add(dynamicObject.getString("id"));
                            names.add(dynamicObject.getString("name"));
                        }
                        itemEntry.put(VALUE_ID, StringUtils.join((Object[])ids.toArray(), (String)","));
                        itemEntry.put(VALUE_NAME, StringUtils.join((Object[])names.toArray(), (String)","));
                        continue;
                    }
                    catch (Exception e) {
                        importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u3010\u503c\u3011\u7f16\u7801", (String)"TaxRulesImportPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0])));
                        return false;
                    }
                }
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u89c4\u5219\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxRulesImportPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0])));
                return false;
            }
            return true;
        }
        importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u7a0e\u8981\u7d20\u5927\u7c7b\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxRulesImportPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0])));
        return false;
    }
}

