/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.tax.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaxRulesListPlugin
extends AbstractListPlugin {
    private static final Map<String, String> classMap = new HashMap<String, String>();

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] objArray = e.getQueryValues();
        if (objArray != null && objArray.length > 0) {
            for (DynamicObject itemObj : objArray) {
                DynamicObjectCollection entryCol = (DynamicObjectCollection)itemObj.get("entryentity");
                if (entryCol == null || entryCol.size() <= 0) continue;
                for (DynamicObject entry : entryCol) {
                    String entryclass = entry.getString("entryclass");
                    Long id = entry.getLong("id");
                    String number = this.queryEntryNumber(entryclass, id);
                    entry.set("valuenumber", (Object)number);
                }
            }
        }
    }

    private String queryEntryNumber(String classType, Long id) {
        QFilter idFilter;
        QFilter filter = new QFilter("entryentity.id", "=", (Object)id);
        DynamicObject entry = QueryServiceHelper.queryOne((String)"bdtaxr_tax_rules", (String)"id,entryentity.valueid", (QFilter[])new QFilter[]{filter});
        String valueid = entry.getString("entryentity.valueid");
        if (valueid != null && valueid.contains(",")) {
            String[] ids = valueid.split(",");
            long[] idarr = Arrays.asList(ids).stream().mapToLong(Long::parseLong).toArray();
            idFilter = new QFilter("id", "in", (Object)idarr);
        } else {
            idFilter = new QFilter("id", "=", (Object)Long.parseLong(valueid));
        }
        String entityName = classMap.get(classType);
        DynamicObjectCollection d = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{idFilter});
        if (d != null && d.size() > 0) {
            ArrayList<String> numbers = new ArrayList<String>(d.size());
            for (DynamicObject item : d) {
                numbers.add(item.getString("number"));
            }
            return StringUtils.join((Object[])numbers.toArray(), (String)",");
        }
        return "";
    }

    static {
        classMap.put("bastax_addresstype", "bastax_addressterms");
        classMap.put("bastax_party_type", "bastax_party");
        classMap.put("bastax_process_type", "bastax_process");
        classMap.put("bastax_taxproduct", "bastax_taxproduct");
    }
}

