/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.tax.rules.op;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.StringUtils;

public class TaxRulesEditSaveOp
extends AbstractOperationServicePlugIn {
    private static final Map<String, String> entryclass2TableNumber = new HashMap<String, String>();
    private static final Map<String, String> entryclass2FieldNumber = new HashMap<String, String>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject[] colls;
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    long country = currentObj.getDynamicObject("country").getLong("id");
                    DynamicObjectCollection ruleConditions = currentObj.getDynamicObjectCollection("entryentity");
                    if (ruleConditions.size() == 0) {
                        return;
                    }
                    HashSet<String> currentBigItem = new HashSet<String>();
                    HashSet<String> currentSmallItem = new HashSet<String>();
                    Set existNumbers = null;
                    boolean needQuery = true;
                    for (DynamicObject dyo : ruleConditions) {
                        currentBigItem.add(dyo.getString("entryclass"));
                        if (null != dyo.getDynamicObject("entrytype")) {
                            currentSmallItem.add(dyo.getDynamicObject("entrytype").getString("id"));
                        }
                        if (!needQuery) continue;
                        Set numbers = TaxRulesEditSaveOp.this.getNumbersSameValues(dyo, currentObj.getString("number"));
                        if (null == existNumbers) {
                            existNumbers = numbers;
                        } else {
                            existNumbers.retainAll(numbers);
                        }
                        if (existNumbers.size() != 0) continue;
                        needQuery = false;
                    }
                    if (TaxRulesEditSaveOp.this.isExist(existNumbers, ruleConditions.size(), currentObj.get("id"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u89c4\u5219\u6761\u4ef6\u7684\u7a0e\u52a1\u89c4\u5219%s", (String)"TaxRulesEditSaveOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), StringUtils.join(existNumbers, (String)",")));
                    }
                    for (DynamicObject coll : colls = BusinessDataServiceHelper.load((String)"bdtaxr_billtax_configs", (String)"product_entity,address_entity.conditiontype,party_entity.partytype,element_entity.processtype", (QFilter[])new QFilter[]{new QFilter("country", "=", (Object)country)})) {
                        HashSet existBigItem = new HashSet();
                        HashSet<String> existSmallItem = new HashSet<String>();
                        for (Map.Entry entry : entryclass2TableNumber.entrySet()) {
                            DynamicObjectCollection subs = coll.getDynamicObjectCollection((String)entry.getValue());
                            if (subs.size() == 0) continue;
                            existBigItem.add(entry.getKey());
                            for (DynamicObject sub : subs) {
                                if (null == entryclass2FieldNumber.get(entry.getKey())) continue;
                                existSmallItem.add(sub.getDynamicObject((String)entryclass2FieldNumber.get(entry.getKey())).getString("id"));
                            }
                        }
                        if (!existBigItem.containsAll(currentBigItem) || !existSmallItem.containsAll(currentSmallItem)) continue;
                        return;
                    }
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u7ef4\u62a4\u8ba1\u7a0e\u914d\u7f6e\u7684\u89c4\u5219\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u8ba1\u7a0e\u914d\u7f6e", (String)"TaxRulesEditSaveOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            }
        });
    }

    private boolean isExist(Set<String> existNumbers, int size, Object id) {
        DynamicObject[] collection;
        if (null != existNumbers && existNumbers.size() > 0 && null != (collection = BusinessDataServiceHelper.load((String)"bdtaxr_tax_rules", (String)"entryentity", (QFilter[])new QFilter[]{new QFilter("number", "in", existNumbers).and("id", "!=", id)})) && collection.length > 0) {
            for (DynamicObject dynamicObject : collection) {
                if (dynamicObject.getDynamicObjectCollection("entryentity").size() != size) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getNumbersSameValues(DynamicObject dyo, String number) {
        HashSet<String> numbers = new HashSet<String>();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_tax_rules", (String)"number,id", (QFilter[])this.buildFilters(dyo, number));
        if (null != collection && collection.size() != 0) {
            for (DynamicObject dynamicObject : collection) {
                numbers.add(dynamicObject.getString("number"));
            }
        }
        return numbers;
    }

    private QFilter[] buildFilters(DynamicObject dyo, String number) {
        DynamicObject entryType = dyo.getDynamicObject("entrytype");
        return new QFilter[]{new QFilter("number", "!=", (Object)number), new QFilter("entryentity.entryclass", "=", dyo.get("entryclass")), new QFilter("entryentity.entrytype", "=", null == entryType ? Integer.valueOf(0) : entryType.get("id")), new QFilter("entryentity.condition", "=", dyo.get("condition")), new QFilter("entryentity.valuename", "=", dyo.get("valuename")), new QFilter("entryentity.link", "=", dyo.get("link"))};
    }

    static {
        entryclass2TableNumber.put("bastax_addresstype", "address_entity");
        entryclass2TableNumber.put("bastax_party_type", "party_entity");
        entryclass2TableNumber.put("bastax_taxproduct", "product_entity");
        entryclass2TableNumber.put("bastax_process_type", "element_entity");
        entryclass2FieldNumber.put("bastax_addresstype", "conditiontype");
        entryclass2FieldNumber.put("bastax_party_type", "partytype");
        entryclass2FieldNumber.put("bastax_process_type", "processtype");
    }
}

