/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceHandler;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.MutexMappingEnum;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.refactor.formula.utils.JsonUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.multideclarelist.MultiDeclareUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractDeclareReportMultiPlugin
extends AbstractFormPlugin {
    private static final String COMMA = ResManager.loadKDString((String)"\uff0c", (String)"AbstractDeclareReportPluginNew_39", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    private static Log logger = LogFactory.getLog(AbstractDeclareReportMultiPlugin.class);
    protected static final String ORGID_KEY = "orgid";
    protected static final String OLD_ORGID_KEY = "oldorgid";
    private static final String CONTENT_TAB = "tabcontent";
    protected static final String SBBID = "cache_sbbid";
    protected static final String BILLNO = "billno";
    protected static final String EDIT_KEY = "edit";
    protected static final String SAVE_KEY = "save";
    protected static final String CANCEL_KEY = "cancel";
    protected static final String SUBMIT_KEY = "submit";
    private static final String UNSUBMIT_KEY = "unsubmit";
    protected static final String RECALC_KEY = "recalc";
    private static final String VIEW_DRAFT_KEY = "viewdraft";
    protected static final String AUDIT_KEY = "audit";
    protected static final String UNAUDIT_KEY = "unaudit";
    protected static final String REGETDATA_KEY = "regetdata";
    private static final String CLOSE_KEY = "close";
    private static final String ONE_KEY_GENERATE = "onekeygenerate";
    private static final String LINK_TO_DRAFT_LIST = "linktodraftlist";
    private static final String CREATESBB = "createsbb";
    protected static final String ORG_SEL = "org";
    private static final String DECLARE_PAGE_ENTITY = "bdtaxr_declare_multi";
    protected static final String BILL_STATUS = "cache_billstatus";
    private static final String CALLBACKID_MOD = "modifyOrDelete";
    private static final String CALLBACKID_MODIFY = "callback_modify";
    private static final String TEMPLATE_TYPE = "templatetype";
    private static final String TAXPAYER_TYPE_KEY = "taxPayerType";
    private static final String EDIT = "edit";
    private static final String VIEW = "read";
    protected static final String DEFAULT_MODEL_NUMBER = "TSC001";
    private static final String TOOL_BAR_DECLARE = "toolbarapdeclare";
    protected DynamicObject declareMainObj;
    private DeclareReportService declareReportService;
    protected static final String ZERODECLARE = "zerodeclare";

    public void registerListener(EventObject e) {
        String BAR_KEY = "toolbarap";
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit", SUBMIT_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("checkisopenbyworkflow") != null && this.getModel().getProperty("checkisopenbyworkflow") != null) {
            this.getModel().setValue("checkisopenbyworkflow", (Object)true);
        }
        if (customParams.get(ORGID_KEY) != null && customParams.get("skssqq") != null && customParams.get("skssqz") != null) {
            if (customParams.get(CREATESBB) != null) {
                this.loadFromOtherPage(customParams);
            } else {
                this.beforeLoadFromHyperLinkClick(customParams);
                this.loadFromHyperLinkClick(customParams);
            }
        } else {
            this.loadFromDeclareMenu();
        }
    }

    protected void beforeLoadFromHyperLinkClick(Map<String, Object> customParams) {
    }

    private void loadFromDeclareMenu() {
        Map customParams;
        String paramOrg = (String)(customParams = this.getView().getFormShowParameter().getCustomParams()).get(ORGID_KEY);
        long org = StringUtil.isNotBlank((CharSequence)paramOrg) ? Long.parseLong(paramOrg) : RequestContext.get().getOrgId();
        Long orgid = this.setDefaultOrg(customParams, org);
        if (this.checkNcpOrgConfig(orgid)) {
            return;
        }
        if (orgid == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"AbstractDeclareReportMultiPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ORGID_KEY, String.valueOf(orgid));
        this.getPageCache().put(OLD_ORGID_KEY, String.valueOf(orgid));
        this.initPeriod(this.getModel(), this.getPageCache(), String.valueOf(orgid), customParams);
        this.beforeOpenInnerPage(String.valueOf(orgid));
        this.init();
    }

    protected boolean checkNcpOrgConfig(Long orgid) {
        return false;
    }

    public Long setDefaultOrg(Map<String, Object> customParams, long org) {
        long currUserId = RequestContext.get().getCurrUserId();
        return this.isDefaultOrg() ? OrgCheckUtil.setDefaultOrg((Long)org, (Long)currUserId, (IFormView)this.getView()) : this.getCustomOrg(customParams);
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        return true;
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        return 0L;
    }

    protected boolean isDefaultOrg() {
        return true;
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        String orgid = ObjectUtils.isNotEmpty((Object)customParams.get(ORGID_KEY)) ? customParams.get(ORGID_KEY).toString() : "0";
        String sbbId = (String)(Objects.nonNull(customParams.get("entryid")) ? customParams.get("entryid") : customParams.get("sbbid"));
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
        boolean checkResult = false;
        if (this.isNeedZeroDeclareCheck()) {
            DynamicObject declareMain = this.getDeclareMain(orgid, (String)customParams.get("skssqq"), (String)customParams.get("skssqz"));
            checkResult = declareMain != null && declareMain.containsProperty(ZERODECLARE) && declareMain.getBoolean(ZERODECLARE) ? this.zeroCheckResult(orgid, appid, licenseTaxEnum) : OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)categoryType);
        } else if (!"tcct".equals(appid)) {
            checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)categoryType);
        }
        if (!checkResult) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, orgid);
            String skssqqstr = (String)customParams.get("skssqq");
            Date skssqq = DateUtils.stringToDate((String)skssqqstr);
            if (this.getModel().getDataEntity().containsProperty("skssqq")) {
                this.getModel().setValue("skssqq", (Object)skssqq);
            }
            this.getPageCache().put("skssqq", skssqqstr);
            String skssqzstr = (String)customParams.get("skssqz");
            Date skssqz = DateUtils.stringToDate((String)skssqzstr);
            if (this.getModel().getDataEntity().containsProperty("skssqq")) {
                this.getModel().setValue("skssqz", (Object)skssqz);
            }
            this.getPageCache().put("skssqz", skssqzstr);
            this.paraCustomParams(customParams);
            customParams.get("refresh");
            String startDate = this.getPageCache().get("skssqq");
            String endDate = this.getPageCache().get("skssqz");
            this.getPageCache().put(TAXPAYER_TYPE_KEY, (String)customParams.get(TEMPLATE_TYPE));
            this.getPageCache().put(TEMPLATE_TYPE + orgid + this.getPageCache().get(TAXPAYER_TYPE_KEY) + startDate + endDate, (String)customParams.get(TAXPAYER_TYPE_KEY));
            this.doInLoadFromHyperLinkClick(sbbId);
            this.openDeclarePage(orgid, skssqqstr, skssqzstr, "true".equals(String.valueOf(customParams.get("refresh"))), "query");
            this.init();
        }
    }

    public boolean isNeedZeroDeclareCheck() {
        return false;
    }

    protected void doInLoadFromHyperLinkClick(String sbbid) {
    }

    private void beforeOpenInnerPage(String orgid) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        TaxAppEnum taxAppEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        if (taxAppEnum == null) {
            this.getView().showErrorNotification("no such configration in TaxAppEnum!");
            return;
        }
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appid, (String)ZERODECLARE, (long)Long.parseLong(orgid));
        boolean checkResult = false;
        if (!"tcct".equals(appid)) {
            checkResult = zerodeclare ? this.zeroCheckResult(orgid, appid, taxAppEnum) : OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)taxAppEnum.getCategoryCode());
        }
        if (!checkResult) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, orgid);
            if (this.checkArgsBeforeOpenInnerPage()) {
                this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), false, "query");
            }
        } else {
            this.getPageCache().put(ORGID_KEY, null);
        }
    }

    public boolean zeroCheckResult(String orgid, String appid, TaxAppEnum taxAppEnum) {
        boolean checkResult = OrgCheckUtil.zeroDeclareCheck((IFormView)this.getView(), (String)orgid, (String)appid, (String)taxAppEnum.getCategoryCode());
        if (checkResult) {
            return true;
        }
        this.getPageCache().put(ZERODECLARE, String.valueOf(true));
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)orgid));
        String orgname = CollectionUtils.isEmpty((Collection)org) ? "" : ((DynamicObject)org.get(0)).getString("name");
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u7533\u62a5\u8868\u91d1\u989d\u9ed8\u8ba4\u4e3a0", (String)"AbstractDeclareReportMultiPlugin_39", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname));
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean needMsg;
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        if (e.getProperty().getName().equals(ORG_SEL)) {
            Object object = changeData[0].getNewValue();
            if (StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue()) {
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
            String orgid = org.getString("id");
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appid, (String)ZERODECLARE, (long)Long.parseLong(orgid));
            boolean checkResult = zerodeclare ? this.zeroCheckResult(orgid, appid, TaxAppEnum.getEnumInstanceByAppid((String)appid)) : OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (checkResult) {
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
            } else {
                this.getPageCache().put(ORGID_KEY, orgid);
                DynamicObject oldValueObj = (DynamicObject)changeData[0].getOldValue();
                this.getPageCache().put(OLD_ORGID_KEY, null == oldValueObj ? null : oldValueObj.getString("id"));
                this.initStartAndEndDate(true);
                if (this.checkArgsBeforeOpenInnerPage()) {
                    this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), Boolean.FALSE, Boolean.FALSE);
                }
            }
        }
        if (e.getProperty().getName().equals("skssqq")) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportMultiPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            this.loadData((Date)changeData[0].getNewValue(), (Date)this.getModel().getValue("skssqz"), needMsg, Boolean.FALSE);
        }
        if (e.getProperty().getName().equals("skssqz")) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportMultiPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)changeData[0].getNewValue(), needMsg, Boolean.FALSE);
        }
        this.getPageCache().remove("needMsg");
        this.init();
    }

    @Deprecated
    public void loadData(Date startDate, Date endDate, Boolean needMsg, boolean refresh) {
        Boolean flag = this.isValidDates(startDate, endDate, needMsg);
        if (flag.booleanValue()) {
            this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
            this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
            this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), refresh, "load");
        }
    }

    public void loadData(Long orgId, Date startDate, Date endDate, Boolean needMsg, boolean refresh) {
        Boolean flag = this.isValidDates(startDate, endDate, needMsg);
        if (flag.booleanValue()) {
            String orgIdStr = String.valueOf(orgId);
            String skssqq = DateUtils.format((Date)startDate);
            String skssqz = DateUtils.format((Date)endDate);
            this.getPageCache().put(ORGID_KEY, orgIdStr);
            this.getPageCache().put("skssqq", skssqq);
            this.getPageCache().put("skssqz", skssqz);
            this.openDeclarePage(orgIdStr, skssqq, skssqz, refresh, "load");
        }
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        String[] taxLimits;
        boolean isvalid = Boolean.FALSE;
        for (String taxLimit : taxLimits = this.getTaxLimits()) {
            boolean temp = DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)endDate);
            isvalid |= temp;
        }
        if (!isvalid) {
            if (needMsg.booleanValue()) {
                String errMsg = this.buildErrorMsg(taxLimits);
                this.getView().showTipNotification(errMsg);
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a%s\u3002", (String)"AbstractDeclareReportMultiPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        ArrayList nameList = new ArrayList(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map dataMap = JsonUtils.strToMap((String)this.getPageCache().get("resultData"));
        this.clientCallBackMethod(dataMap, e.getName());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String sbbid = this.getPageCache().get(SBBID);
        if ("edit".equals(key)) {
            boolean success = this.requestMutexLock(sbbid);
            if (!success) {
                evt.setCancel(true);
            }
        } else if (Sets.newHashSet((Object[])new String[]{ONE_KEY_GENERATE, SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY}).contains(key)) {
            DynamicObject dynamicObject = MutexServiceImpl.getMutexData(new QFilter("objectid", "=", (Object)sbbid));
            if (dynamicObject != null && !dynamicObject.get("user.id").equals(RequestContext.get().getCurrUserId())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractDeclareReportMultiPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), dynamicObject.get("user.name")));
                evt.setCancel(true);
            }
        } else if (SAVE_KEY.equals(key) || CANCEL_KEY.equals(key)) {
            MutexServiceImpl.releaseMutexLock(sbbid, "edit", RequestContext.get().getCurrUserId());
        }
    }

    private boolean requestMutexLock(String sbbid) {
        if (StringUtil.isBlank((CharSequence)sbbid) || "0".equals(sbbid)) {
            return true;
        }
        String entityname = this.getModel().getDataEntityType().getName();
        String entity = MutexMappingEnum.getEntity((String)entityname);
        if (StringUtils.isNotBlank((CharSequence)entity)) {
            try {
                DynamicObject dynamicObject;
                HashMap<String, String> customparam = new HashMap<String, String>();
                MutexServiceImpl mutexService = new MutexServiceImpl();
                customparam.put("dataObjId", sbbid);
                customparam.put("entityKey", entity);
                customparam.put("operationKey", "edit");
                customparam.put("groupId", "declare_edit");
                mutexService.setMutexLockInfo(customparam);
                boolean isSuccessLock = mutexService.setMutexLock();
                logger.info("DynamicEntity:{},Entity:{} lock : {}", new Object[]{entityname, entity, isSuccessLock});
                if (!isSuccessLock && (dynamicObject = MutexServiceImpl.getMutexData(new QFilter("objectid", "=", (Object)sbbid))) != null) {
                    String user = dynamicObject.getString("user.name");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractDeclareReportMultiPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), user));
                    return false;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "cancel": {
                this.cancel(key);
                break;
            }
        }
    }

    private boolean isDataChanged() {
        IPageCache childPageCache;
        IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
        if (childPage != null && (childPageCache = childPage.getPageCache()) != null) {
            Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
            return updateMap != null && updateMap.size() > 0;
        }
        return false;
    }

    protected IPageCache getChildPageCache() {
        IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
        if (childPage != null) {
            return childPage.getPageCache();
        }
        return null;
    }

    private void cancel(String customEvent) {
        if (this.isDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CANCEL_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractDeclareReportMultiPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"AbstractDeclareReportMultiPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"AbstractDeclareReportMultiPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            String orgId = this.getPageCache().get(ORGID_KEY);
            String startDate = this.getPageCache().get("skssqq");
            String endDate = this.getPageCache().get("skssqz");
            String templateType = this.getTemplateType();
            QFilter extendQfilter = this.getDeclareMainQueryParams();
            DynamicObject dyo = YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (long)Long.parseLong(null == orgId ? "0" : orgId), (String)templateType, (String)startDate, (String)endDate, (QFilter)extendQfilter);
            TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap");
            TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent");
            TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"remark_data");
            if (dyo == null) {
                this.closeView();
            } else {
                this.enableSubmitBtn();
                this.operationSbb(VIEW, Boolean.FALSE, customEvent);
            }
        }
    }

    protected void closeView() {
        this.getPageCache().put("code_close", "true");
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        if (this.getModel().getValue(ORG_SEL) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportMultiPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                boolean isOpen = this.beforeClickCheckStatus(key);
                if (!isOpen) break;
                this.edit(key);
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(key);
                break;
            }
            case "recalc": {
                if (!this.beforeClickCheckStatus(key)) break;
                this.recalc();
                break;
            }
            case "viewdraft": {
                this.viewDraft();
                break;
            }
            case "onekeygenerate": {
                this.onekeygenerate();
                break;
            }
            case "print": {
                this.print();
                break;
            }
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDeclareReportMultiPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
                this.save();
                break;
            }
            case "regetdata": {
                if (!this.beforeClickCheckStatus(key)) break;
                this.reGetDataConform();
                break;
            }
        }
    }

    protected void print() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        params.put("templateId", this.getPageCache().get("templateId"));
        params.put("templateType", this.getTemplateType());
        params.put("modelid", this.getModelId());
        params.put("sbbid", this.getPageCache().get(SBBID));
        showParameter.setFormId("bdtaxr_declare_print");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
        String billno = this.getPageCache().get(BILLNO);
        String orgId = this.getPageCache().get(ORGID_KEY);
        long orgid = 0L;
        if (EmptyCheckUtils.isNotEmpty((Object)orgId)) {
            orgid = Long.parseLong(orgId);
        }
        String operate = OperateCodeEnum.getByCode((String)"print");
        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s%2$s\u6210\u529f", (String)"AbstractDeclareReportMultiPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno, operate);
        OperatorDialogUtils.operateDialog((String)this.getTemplateType(), (String)this.getView().getFormShowParameter().getFormId(), (String)operate, (String)operateDescription, (Long)orgid);
    }

    protected boolean beforeClickCheckStatus(String operateKey) {
        DynamicObject declare;
        if (this.getModel().getDataEntity().containsProperty("skssqq") && this.getModel().getDataEntity().containsProperty("skssqz")) {
            Date endDate;
            Date startDate = (Date)this.getModel().getValue("skssqq");
            Boolean flag = this.isValidDates(startDate, endDate = (Date)this.getModel().getValue("skssqz"), Boolean.TRUE);
            if (!flag.booleanValue()) {
                String sbbid;
                if ("edit".equals(operateKey) && StringUtils.isNotBlank((CharSequence)(sbbid = this.getPageCache().get(SBBID)))) {
                    MutexServiceImpl.releaseMutexLock(sbbid, "edit", RequestContext.get().getCurrUserId());
                }
                return false;
            }
            this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
            this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
        }
        if ((declare = this.queryNsrxx(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"))) != null) {
            String billstatus = declare.getString("billstatus");
            if (!"A".equalsIgnoreCase(billstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u7f16\u8f91", (String)"AbstractDeclareReportMultiPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return false;
            }
        } else if ("edit".equals(operateKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"AbstractDeclareReportMultiPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean beforeCilckCheck() {
        String billstatus;
        DynamicObject declare = this.queryNsrxx(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        if (declare != null && !"A".equalsIgnoreCase(billstatus = declare.getString("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u7f16\u8f91", (String)"AbstractDeclareReportMultiPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void viewDraft() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        if (StringUtil.isEmpty((CharSequence)orgid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportMultiPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)endDate));
        String templateType = this.getTemplateType();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
        QFilter templateFilter = new QFilter(TEMPLATE_TYPE, "=", (Object)templateEnum.getDraftType());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"type", (QFilter[])new QFilter[]{orgFilter, templateFilter, startFilter, endFilter});
        if (dynamicObject == null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(VIEW_DRAFT_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportMultiPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportMultiPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
            String orgName = org != null ? org.getString("name") : "";
            String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5c1a\u672a\u7f16\u5236\u8ba1\u7a0e\u5e95\u7a3f\uff0c\u662f\u5426\u524d\u5f80\u7f16\u5236\uff1f", (String)"AbstractDeclareReportMultiPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgName);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put(ORGID_KEY, orgid);
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", endDate);
            customParams.put("type", dynamicObject.getString("type"));
            customParams.put(TEMPLATE_TYPE, templateEnum.getDraftType());
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void operationSbb(String operationType, boolean isRefresh, String customEvent) {
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sheetId = childPageCache.get("sheetid");
        String sheetname = childPageCache.get("sheetname");
        Map customParams = childView.getFormShowParameter().getCustomParams();
        FormShowParameter param = new FormShowParameter();
        customParams.put("operation", operationType);
        customParams.put("sheetid", sheetId);
        customParams.put("refresh", "false");
        if (StringUtils.isNotBlank((CharSequence)sheetname)) {
            customParams.put("sheetname", sheetname);
        }
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"declareRequest", DeclareRequestModel.class);
        requestModel.setCustomEvent(customEvent);
        requestModel.setOperation(operationType);
        requestModel.setRefresh(Boolean.valueOf(isRefresh));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(this.getDeclareFormId());
        if ("edit".equals(customEvent)) {
            RuleFetchMainDto fetchMainDto = new RuleFetchMainDto(requestModel.getOrgId(), kd.taxc.bdtaxr.common.utils.date.DateUtils.stringToDate((String)requestModel.getSkssqq()), kd.taxc.bdtaxr.common.utils.date.DateUtils.stringToDate((String)requestModel.getSkssqz()), requestModel.getTemplateId(), (String)requestModel.getBusinessMap().get("draftpurpose"), "0");
            String taxsystem = requestModel.getBusinessValue("taxsystem");
            String taxareagroup = requestModel.getBusinessValue("taxareagroup");
            RuleFetchServiceHandler.setInfo(fetchMainDto, taxsystem, taxareagroup);
            RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
            ruleFetchService.delRuleFetchData(fetchMainDto);
        }
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        if ("edit".equals(operationType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, RECALC_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE, REGETDATA_KEY});
            if (StringUtils.equals((CharSequence)"2", (CharSequence)this.getPageCache().get("datatype"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{RECALC_KEY, REGETDATA_KEY});
            }
            this.setExtendControllsStatus(operationType);
            String templateType = (String)customParams.get(TEMPLATE_TYPE);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u6b63\u5728\u7f16\u8f91\u4e2d", (String)"AbstractDeclareReportMultiPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
            DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)this.getModelId());
            if (declareTable != null && declareTable.isDraftModel()) {
                operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e95\u7a3f\u6b63\u5728\u7f16\u8f91\u4e2d", (String)"AbstractDeclareReportMultiPlugin_42", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
            }
            OperatorDialogUtils.operateDialog((String)templateType, (String)this.getEntity(templateType), (String)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"AbstractDeclareReportMultiPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)operateDescription);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{AUDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, ONE_KEY_GENERATE, REGETDATA_KEY});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{SUBMIT_KEY});
            this.setExtendControllsStatus(operationType);
        }
    }

    protected String getEntity(String templateType) {
        return TemplateEnum.getEnumByDeclareType((String)templateType).getDeclarePage();
    }

    protected void setExtendControllsStatus(String operationType) {
    }

    protected Map<String, String> getBizParams() {
        return new HashMap<String, String>(4);
    }

    public Map<String, String> getUpdateNsrxxMap() {
        return new HashMap<String, String>(4);
    }

    public void save() {
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("DeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                DeclareRequestModel declareRequestModel = new DeclareRequestModel();
                String orgId = this.getPageCache().get(ORGID_KEY);
                String startDate = this.getPageCache().get("skssqq");
                String endDate = this.getPageCache().get("skssqz");
                DynamicObject declareMain = this.getDeclareMain(orgId, startDate, endDate);
                if (declareMain != null && !"A".equals(declareMain.getString("billstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u7ecf\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838,\u4e0d\u5141\u8bb8\u4fee\u6539\u4fdd\u5b58\uff01", (String)"AbstractDeclareReportMultiPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                String templateType = this.getTemplateType();
                declareRequestModel.setCustomEvent(SAVE_KEY);
                declareRequestModel.setModelId(this.getModelId());
                declareRequestModel.setId(this.getSbbid(null, orgId, startDate, endDate));
                declareRequestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
                declareRequestModel.setTemplateType(templateType);
                declareRequestModel.setRefresh(Boolean.valueOf(true));
                declareRequestModel.setOperation("edit");
                declareRequestModel.setSkssqq(startDate);
                declareRequestModel.setSkssqz(endDate);
                declareRequestModel.getBusinessMap().putAll(this.getBizParams());
                declareRequestModel.getUpdateNsrxxMap().putAll(this.getUpdateNsrxxMap());
                BaseResult resultMap = (BaseResult)saveClick.invoke(taxDeclarePlugin, childPageCache, declareRequestModel);
                if (500 == resultMap.getCode()) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u539f\u56e0\uff1a%s", (String)"AbstractDeclareReportMultiPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]), resultMap.getMessage()));
                    return;
                }
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u4fdd\u5b58\u6210\u529f", (String)"AbstractDeclareReportMultiPlugin_20", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
                DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)this.getModelId());
                if (declareTable != null && declareTable.isDraftModel()) {
                    operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e95\u7a3f\u4fdd\u5b58\u6210\u529f", (String)"AbstractDeclareReportMultiPlugin_40", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                OperatorDialogUtils.operateDialog((String)templateType, (String)this.getEntity(templateType), (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractDeclareReportMultiPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)operateDescription);
                this.doAfterSuccessSave();
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap");
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent");
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"remark_data");
                String sbbid = String.valueOf(this.getSbbid(null, orgId, startDate, endDate));
                this.getPageCache().put(SBBID, sbbid);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"AbstractDeclareReportMultiPlugin_21", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDBizException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    this.getView().showErrorNotification(msg + COMMA + targetException.getMessage());
                } else {
                    this.getView().showErrorNotification(msg);
                }
                return;
            }
            this.operationSbb(VIEW, Boolean.FALSE, SAVE_KEY);
        }
        this.enableSubmitBtn();
    }

    protected void doAfterSuccessSave() {
    }

    public void enableSubmitBtn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY});
    }

    public void submit(String key) {
        String sbbid = null;
        DynamicObject declare = this.queryNsrxx(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        if (declare != null) {
            sbbid = declare.getString("id");
        }
        if (!StringUtils.isEmpty(sbbid)) {
            ArrayList<String> pklist = new ArrayList<String>();
            pklist.add(sbbid);
            boolean flag = MultiDeclareUtils.submit((IFormView)this.getView(), pklist, (String)key, (String)this.getSubmitMainTable(), (boolean)false);
            if (flag) {
                String orgId = this.getPageCache().get(ORGID_KEY);
                String startDate = this.getPageCache().get("skssqq");
                String endDate = this.getPageCache().get("skssqz");
                this.setBtnStatus(orgId, startDate, endDate, VIEW);
                this.customEvent(orgId, startDate, endDate, key);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"AbstractDeclareReportMultiPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    protected void customEvent(String orgId, String startDate, String endDate, String operationKey) {
    }

    public String getSubmitMainTable() {
        return MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable();
    }

    private DynamicObject queryNsrxx(String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        String templateType = this.getTemplateType();
        QFilter extendQfilter = this.getDeclareMainQueryParams();
        return YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (long)Long.parseLong(orgId), (String)templateType, (String)startdate, (String)enddate, (QFilter)extendQfilter);
    }

    public void edit(String key) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, AUDIT_KEY, CLOSE_KEY});
        this.operationSbb("edit", Boolean.FALSE, key);
    }

    private void recalc() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportMultiPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportMultiPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u7f6e\u62a5\u8868\u5c06\u5bfc\u81f4\u539f\u6709\u6570\u636e\uff08\u5305\u62ec\u624b\u5de5\u8c03\u6574\u7684\u6570\u636e\uff09\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportMultiPlugin_22", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void reGetDataConform() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REGETDATA_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPluginNew_25", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPluginNew_26", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u4f1a\u4fdd\u7559\u5355\u5143\u683c\u7684\u624b\u5de5\u8c03\u6574\u503c\uff0c\u5355\u5143\u683c\u7684\u53d6\u6570\u516c\u5f0f\u4e0e\u5355\u5143\u683c\u95f4\u7684\u8ba1\u7b97\u516c\u5f0f\u5c06\u4f1a\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPluginNew_49", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void onekeygenerate() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        if (LicenseCheckServiceHelper.check((Object)orgid, (IFormView)this.getView(), (String)"tcdrs")) {
            return;
        }
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)this.getTemplateType());
        String draftType = templateEnum.getDraftType();
        DynamicObject draft = StatusUtils.queryOne((String)draftType, (String)orgid, (String)skssqq, (String)skssqz, (String)draftpurpose);
        if (draft != null) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(orgid), (String)"bos_org");
            String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u5df2\u5b58\u5728\u5e95\u7a3f\u6570\u636e\uff0c\u91cd\u65b0\u751f\u6210\u5c06\u5bfc\u81f4\u539f\u6709\u7684\u5e95\u7a3f\u548c\u7533\u62a5\u8868\u6570\u636e\u88ab\u6e05\u9664\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportMultiPlugin_23", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgObj.getString("name"), skssqq, skssqz);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ONE_KEY_GENERATE, (IFormPlugin)this);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks, null, SerializationUtils.toJsonString((Object)draft));
        } else {
            this.executeEngineHandler(orgid, skssqq, skssqz, this.getTemplateType());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        Date skssqqDate = DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM-dd");
        Date skssqzDate = DateUtils.stringToDate((String)skssqz, (String)"yyyy-MM-dd");
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        String templateType = this.getTemplateType();
        switch (callBackId) {
            case "recalc": {
                if (!this.isValidDates(skssqqDate, skssqzDate, Boolean.TRUE).booleanValue()) {
                    return;
                }
                if (e.getResult() != MessageBoxResult.Yes) break;
                if (orgId == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportMultiPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                this.openDeclarePage(orgId, skssqq, skssqz, true, callBackId);
                String templatetype = this.getTemplateType();
                if ("kjqysds".equals(templateType) || "dkdj".equals(templateType)) {
                    return;
                }
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap");
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent");
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"remark_data");
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"AbstractDeclareReportMultiPlugin_25", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
                DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)this.getModelId());
                if (declareTable != null && declareTable.isDraftModel()) {
                    operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e95\u7a3f\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"AbstractDeclareReportMultiPlugin_41", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
                }
                OperatorDialogUtils.operateDialog((String)templatetype, (String)this.getEntity(templatetype), (String)ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97", (String)"AbstractDeclareReportMultiPlugin_24", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)operateDescription);
                break;
            }
            case "viewdraft": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put("skssqq", skssqq);
                customParams.put("skssqz", skssqz);
                TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
                customParams.put(TEMPLATE_TYPE, templateEnum.getDraftType());
                PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "callback_modify": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    this.showInnerPage(orgId, skssqq, skssqz, false, VIEW, callBackId);
                    break;
                }
                this.closeView();
                break;
            }
            case "modifyOrDelete": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    TemplateUtils.deleteReport((Long)Long.parseLong(orgId), (String)templateType, (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz), null);
                    TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
                    StatusUtils.delete((String)templateEnum.getDraftType(), (String)orgId, (String)skssqq, (String)skssqz, (String)draftpurpose);
                    HashMap<String, String> customParams = new HashMap<String, String>();
                    customParams.put(ORGID_KEY, orgId);
                    customParams.put("skssqq", skssqq);
                    customParams.put("skssqz", skssqz);
                    if (StringUtil.isEmpty((CharSequence)templateEnum.getDraftPage())) {
                        this.getView().showErrorNotification("No Draft Page!");
                        return;
                    }
                    PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
                    this.closeView();
                    break;
                }
                if (e.getResult() == MessageBoxResult.No) {
                    Long sbbid = this.getSbbid(null, orgId, skssqq, skssqz);
                    boolean success = this.requestMutexLock(sbbid + "");
                    if (success) {
                        this.showInnerPage(orgId, skssqq, skssqz, false, "edit", callBackId);
                        this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY, REGETDATA_KEY});
                        break;
                    }
                    this.showInnerPage(orgId, skssqq, skssqz, false, VIEW, callBackId);
                    this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY, REGETDATA_KEY});
                    break;
                }
                this.closeView();
                break;
            }
            case "onekeygenerate": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String customVaule = e.getCustomVaule();
                JSONObject object = JSONObject.parseObject((String)customVaule);
                if (!"A".equals(object.getString("billstatus"))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u662f\u5426\u9700\u8981\u524d\u5f80\u5e95\u7a3f\u67e5\u8be2\u754c\u9762\u4fee\u6539\uff1f", (String)"AbstractDeclareReportMultiPlugin_26", (String)"taxc-bdtaxr", (Object[])new Object[0]), object.getString(BILLNO));
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(LINK_TO_DRAFT_LIST, (IFormPlugin)this);
                    this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, object.getString(BILLNO));
                    break;
                }
                this.executeEngineHandler(orgId, skssqq, skssqz, templateType);
                break;
            }
            case "linktodraftlist": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String draftQueryPage = TemplateEnum.getEnumByDeclareType((String)this.getTemplateType()).getDraftQueryPage();
                HashMap<String, Comparable<Long>> customParams = new HashMap<String, Comparable<Long>>();
                customParams.put(ORGID_KEY, Long.valueOf(Long.parseLong(orgId)));
                customParams.put("startdate", DateUtils.stringToDate((String)skssqq));
                customParams.put("enddate", DateUtils.stringToDate((String)skssqz));
                PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)draftQueryPage, (IFormView)this.getView(), customParams);
                break;
            }
            case "handle_onekey_generate_exception": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String declareType = this.getTemplateType();
                String draftPage = TemplateEnum.getEnumByDeclareType((String)declareType).getDraftPage();
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put("skssqq", skssqq);
                customParams.put("skssqz", skssqz);
                PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)draftPage, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "cancel": {
                QFilter extendQfilter = this.getDeclareMainQueryParams();
                DynamicObject dyo = YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (long)Long.parseLong(null == orgId ? "0" : orgId), (String)templateType, (String)skssqq, (String)skssqz, (QFilter)extendQfilter);
                if (e.getResult() == MessageBoxResult.Yes) {
                    TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent");
                    TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap");
                    TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"remark_data");
                    if (dyo == null) {
                        this.closeView();
                    } else {
                        this.enableSubmitBtn();
                        this.operationSbb(VIEW, Boolean.FALSE, CANCEL_KEY);
                        break;
                    }
                }
            }
            case "close": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.closeView();
                break;
            }
            case "regetdata": {
                if (!this.isValidDates(skssqqDate, skssqzDate, Boolean.TRUE).booleanValue()) {
                    return;
                }
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.reGetData();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String code_close = this.getPageCache().get("code_close");
        if (this.isDataChanged() && !"true".equals(code_close)) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractDeclareReportMultiPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"AbstractDeclareReportMultiPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"AbstractDeclareReportMultiPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    private void executeEngineHandler(String orgId, String skssqq, String skssqz, String templateType) {
        EngineHandler handler = EngineHandlerFactory.createHandler((String)templateType);
        EngineModel engineModel = this.buildEngineModel(orgId, skssqq, skssqz, templateType, this.getPageCache());
        try {
            handler.validate(engineModel);
            handler.execute(engineModel);
        }
        catch (KDBizException exception) {
            handler.handleException(exception, this.getView(), (IFormPlugin)this);
            return;
        }
        this.openDeclarePage(orgId, skssqq, skssqz, true, ONE_KEY_GENERATE);
    }

    protected void reGetData() {
        Map remarkDataMapCache;
        Map<String, String> bussinessUpdateMap;
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        if (childView == null) {
            return;
        }
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        if (childPageCache == null) {
            return;
        }
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareRequest", DeclareRequestModel.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareData", DeclareResponseModel.class);
        Map currentMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid_save", Map.class);
        String updateCellEntityMap = childPageCache.get("updateCellEntityMap");
        if (updateCellEntityMap == null) {
            updateCellEntityMap = this.getPageCache().get("updateCellEntityMap");
        }
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap", (Object)updateCellEntityMap);
        if (currentMap == null || currentMap.isEmpty()) {
            currentMap = responseModel.getData();
        }
        Map updateMapCache = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        List<String> reGetDataHisCells = TaxDeclarePluginService.queryReGetDataHisCell(String.valueOf(requestModel.getId()));
        HashMap updateMap = new HashMap(reGetDataHisCells.size());
        for (String cellKey : reGetDataHisCells) {
            if (!StringUtil.isNotBlank((CharSequence)cellKey) || !StringUtil.isNotBlank((CharSequence)((CharSequence)currentMap.get(cellKey)))) continue;
            updateMap.put(cellKey, currentMap.get(cellKey));
        }
        if (updateMapCache != null && !updateMapCache.isEmpty()) {
            updateMap.putAll(updateMapCache);
        }
        if ((bussinessUpdateMap = this.bussinessUpdateMap(currentMap)) != null && !bussinessUpdateMap.isEmpty()) {
            updateMap.putAll(bussinessUpdateMap);
        }
        if ((remarkDataMapCache = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"remark_data", Map.class)) != null) {
            HashMap remarkDataMap = new HashMap();
            updateMap.forEach((k, v) -> {
                if (remarkDataMapCache.containsKey(k)) {
                    remarkDataMap.put(k, (String)remarkDataMapCache.get(k));
                }
            });
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"remark_data", remarkDataMap);
        }
        requestModel.setCustomEvent(REGETDATA_KEY);
        requestModel.setPreData(updateMap);
        requestModel.setRefresh(Boolean.valueOf(true));
        requestModel.setOperation("edit");
        try {
            HashMap<String, String> ruleFetchData = StringUtil.isEmpty((CharSequence)updateCellEntityMap) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)updateCellEntityMap, Map.class);
            RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
            ruleFetchService.saveTempRuleFetchAdjustData(ruleFetchData, requestModel);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u94bb\u4e34\u65f6\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01", (String)"AbstractDeclareReportMultiPlugin_43", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.setRequestModel(requestModel);
        TreeUtils.putCache((IPageCache)childPageCache, (String)"declareRequest", (Object)SerializationUtils.toJsonString((Object)requestModel));
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent", (Object)updateMapCache);
        TreeUtils.putCache((IPageCache)childPageCache, (String)"updata_cellid_save", (Object)currentMap);
        this.getPageCache().put("updateCellEntityMap", updateCellEntityMap);
        Map customParams = childView.getFormShowParameter().getCustomParams();
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        FormShowParameter param = new FormShowParameter();
        param.setFormId(this.getDeclareFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        this.getPageCache().put("declarepageid", param.getPageId());
        param.setCustomParams(customParams);
        this.getView().showForm(param);
    }

    protected Map<String, String> bussinessUpdateMap(Map<String, String> currentMap) {
        return new HashMap<String, String>(0);
    }

    private boolean isDeclared(String rootPageId, String orgId, String startdate, String enddate) {
        DynamicObject declare = this.queryNsrxx(orgId, startdate, enddate);
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put(BILL_STATUS, "A");
        this.getPageCache().remove("templateid");
        if (declare != null) {
            if (StringUtil.isNotEmpty((CharSequence)declare.getString("templateid"))) {
                this.getPageCache().put("templateid", declare.getString("templateid"));
                this.getPageCache().put("templateId", declare.getDynamicObject("templateid").getString("id"));
            }
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            rootCache.put(BILL_STATUS, billstatus);
            rootCache.put(SBBID, id);
            rootCache.put(BILLNO, declare.getString(BILLNO));
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG_SEL);
                String orgName = null != org ? org.getString("name") : "";
                String taxlimitStr = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)startdate), (Date)DateUtils.stringToDate((String)enddate));
                if (!taxlimitStr.equals("")) {
                    this.getView().sendFormAction(rootView);
                }
                return true;
            }
        }
        return false;
    }

    private String getStatusLocaleName(String status, String billstatus) {
        String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279", (String)"AbstractDeclareReportMultiPlugin_27", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        if ("C".equals(billstatus)) {
            statusName = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"AbstractDeclareReportMultiPlugin_28", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        if ("declared".equals(status)) {
            statusName = ResManager.loadKDString((String)"\u7533\u62a5", (String)"AbstractDeclareReportMultiPlugin_29", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        return statusName;
    }

    protected String[] getTaxLimits() {
        return new String[]{"month"};
    }

    protected void initStartAndEndDate(boolean orgChange) {
        Date skssqz;
        Date skssqq;
        String taxLimit;
        switch (taxLimit = this.getTaxLimits()[0]) {
            case "year": {
                skssqq = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
                skssqz = DateUtils.getLastDateOfYear((Date)skssqq);
                break;
            }
            case "halfyear": {
                skssqq = DateUtils.getFirstDateOfHalfYear((Date)DateUtils.addMonth((Date)new Date(), (int)-6));
                skssqz = DateUtils.getLastDateOfHalfYear((Date)skssqq);
                break;
            }
            case "season": {
                skssqq = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)new Date(), (int)-3));
                skssqz = DateUtils.getLastDateOfSeason((Date)skssqq);
                break;
            }
            default: {
                skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
                skssqz = DateUtils.getLastDateOfMonth((Date)skssqq);
            }
        }
        this.getPageCache().put("needMsg", "false");
        this.getModel().setValue("skssqq", (Object)skssqq);
        this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
        this.getModel().setValue("skssqz", (Object)skssqz);
        this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
    }

    private void openDeclarePage(String orgid, String skssqq, String skssqz, boolean refresh, String customEvent) {
        Boolean isopenbyworkflow;
        if (!this.checkOrgTaxConfig(orgid, skssqq, skssqz)) {
            return;
        }
        String templateType = this.getTemplateType();
        QFilter extendQfilter = this.getDeclareMainQueryParams();
        DynamicObject dyo = YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (long)Long.parseLong(orgid), (String)templateType, (String)skssqq, (String)skssqz, (QFilter)extendQfilter);
        if (dyo == null) {
            logger.info("openDeclarePage add");
            customEvent = "add";
            this.showInnerPage(orgid, skssqq, skssqz, true, "edit", customEvent);
            return;
        }
        if (this.getModel().getDataEntity().containsProperty("checkisopenbyworkflow") && (isopenbyworkflow = (Boolean)this.getModel().getValue("checkisopenbyworkflow")) != null && isopenbyworkflow.booleanValue()) {
            this.showInnerPage(orgid, skssqq, skssqz, false, VIEW, customEvent);
            return;
        }
        this.getPageCache().put("datatype", dyo.getString("datatype"));
        if (StringUtils.equals((CharSequence)"2", (CharSequence)dyo.getString("datatype"))) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)dyo.getString("billstatus")) && this.viewDialog()) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                String taxLimitTips = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
                String orgname = this.getModel().getValue(ORG_SEL) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"AbstractDeclareReportMultiPlugin_30", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if ("yhs".equals(templateType)) {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportMultiPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportMultiPlugin_32", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e", (String)"AbstractDeclareReportMultiPlugin_33", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener(CALLBACKID_MODIFY, (IFormPlugin)this), btnNameMaps);
                } else {
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportMultiPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportMultiPlugin_32", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7a0e", (String)"AbstractDeclareReportMultiPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\n\u91cd\u65b0\u8ba1\u7a0e\uff1a\u6e05\u7a7a\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u5e76\u4f7f\u7528\u81ea\u52a8\u8ba1\u7a0e", (String)"AbstractDeclareReportMultiPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_MOD, (IFormPlugin)this), btnNameMaps);
                }
            } else {
                this.showInnerPage(orgid, skssqq, skssqz, refresh, VIEW, customEvent);
            }
        } else if ("A".equals(dyo.getString("billstatus"))) {
            this.showInnerPage(orgid, skssqq, skssqz, refresh, refresh ? "edit" : VIEW, customEvent);
        } else {
            this.showInnerPage(orgid, skssqq, skssqz, false, VIEW, customEvent);
        }
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        return true;
    }

    private void showInnerPage(String orgid, String startDate, String endDate, boolean refresh, String operationStatus, String customEvent) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("rootPageId", this.getView().getPageId());
        String taxLimit = DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        customParams.put("taxlimit", taxLimit);
        customParams.put(TEMPLATE_TYPE, this.getTemplateType());
        customParams.put("ParentCache", "true");
        if ("zzsybnsr_ybfz".equals(customParams.get(TEMPLATE_TYPE))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u6c47\u603b\u7ec4\u7ec7\u65e0\u987b\u7533\u62a5", (String)"AbstractDeclareReportMultiPlugin_36", (String)"taxc-bdtaxr", (Object[])new Object[0]), null);
            return;
        }
        if ("zzsybnsr_fzjg".equals(customParams.get(TEMPLATE_TYPE)) || "zzsybnsr_zjg".equals(customParams.get(TEMPLATE_TYPE))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6c47\u603b\u822a\u7a7a\u6682\u4e0d\u652f\u6301\u7eb3\u7a0e\u7533\u62a5", (String)"AbstractDeclareReportMultiPlugin_37", (String)"taxc-bdtaxr", (Object[])new Object[0]), null);
            return;
        }
        boolean readonly = false;
        boolean isDeclare = this.isDeclared(this.getView().getPageId(), orgid, startDate, endDate);
        if (isDeclare) {
            readonly = true;
        }
        customParams.put("readonly", readonly);
        customParams.put("templateid", this.getPageCache().get("templateid"));
        Map<String, String> businessParams = this.getBizParams();
        String templateType = (String)customParams.get(TEMPLATE_TYPE);
        this.declareReportService = DeclareReportFactory.createHandler((String)templateType);
        String billNo = this.getPageCache().get(BILLNO);
        if (StringUtil.isBlank((CharSequence)billNo)) {
            billNo = this.declareReportService.getBillNumber(DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), orgid, businessParams);
        }
        this.getPageCache().put(BILLNO, billNo);
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.getBusinessMap().putAll(businessParams);
        requestModel.setModelId(this.getModelId());
        requestModel.setId(this.getSbbid(null, orgid, startDate, endDate));
        requestModel.setBillNo(billNo);
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgid)));
        requestModel.setTemplateType(templateType);
        requestModel.setOperation(operationStatus);
        requestModel.setCustomEvent(customEvent);
        requestModel.setSkssqq(startDate);
        requestModel.setSkssqz(endDate);
        requestModel.setRefresh(Boolean.valueOf(refresh));
        requestModel.setUniKey(this.getUniKey());
        this.setRequestModel(requestModel);
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        FormShowParameter param = new FormShowParameter();
        param.setFormId(this.getDeclareFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        this.getView().updateView(CONTENT_TAB);
        this.setBtnStatus(orgid, startDate, endDate, operationStatus);
    }

    protected void rangeCalc() {
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("DeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                String orgId = this.getPageCache().get(ORGID_KEY);
                String startDate = this.getPageCache().get("skssqq");
                String endDate = this.getPageCache().get("skssqz");
                Map<String, String> businessParams = this.getBizParams();
                String templateType = this.getTemplateType();
                this.declareReportService = DeclareReportFactory.createHandler((String)templateType);
                String billNo = this.getPageCache().get(BILLNO);
                if (StringUtil.isBlank((CharSequence)billNo)) {
                    billNo = this.declareReportService.getBillNumber(DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), orgId, businessParams);
                }
                DeclareRequestModel requestModel = new DeclareRequestModel();
                requestModel.getBusinessMap().putAll(businessParams);
                requestModel.setModelId(this.getModelId());
                requestModel.setId(this.getSbbid(null, orgId, startDate, endDate));
                requestModel.setBillNo(billNo);
                requestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
                requestModel.setTemplateType(this.getTemplateType());
                requestModel.setOperation("edit");
                requestModel.setCustomEvent(RECALC_KEY);
                requestModel.setSkssqq(startDate);
                requestModel.setSkssqz(endDate);
                requestModel.setRefresh(Boolean.valueOf(true));
                requestModel.setUniKey(this.getUniKey());
                this.setRequestModel(requestModel);
                Method rangeCalc = pluginClass.getMethod("rangeCalc", IPageCache.class, DeclareRequestModel.class);
                rangeCalc.invoke(taxDeclarePlugin, childPageCache, requestModel);
            }
            catch (Exception e) {
                logger.error("\u91cd\u65b0\u8ba1\u7b97\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5931\u8d25", (String)"AbstractDeclareReportMultiPlugin_38", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDBizException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    this.getView().showErrorNotification(msg + COMMA + targetException.getMessage());
                }
                this.getView().showErrorNotification(msg);
            }
        }
    }

    public String getDeclareFormId() {
        return DECLARE_PAGE_ENTITY;
    }

    private void setBtnStatus(String orgid, String startDate, String endDate, String operationStatus) {
        String templateType = this.getTemplateType();
        QFilter extendQfilter = this.getDeclareMainQueryParams();
        DynamicObject dyo = YbnsrService.queryMultiDeclareMain((String)this.getMainTable(), (long)Long.parseLong(orgid), (String)templateType, (String)startDate, (String)endDate, (QFilter)extendQfilter);
        if (dyo != null && VIEW.equals(operationStatus)) {
            Object checkisopenbyworkflow;
            String billstatus = dyo.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{AUDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{SUBMIT_KEY});
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{SUBMIT_KEY});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{AUDIT_KEY});
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, SUBMIT_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{AUDIT_KEY});
            }
            if (Objects.equals(checkisopenbyworkflow = this.getView().getFormShowParameter().getCustomParam("checkisopenbyworkflow"), true) || Objects.equals(checkisopenbyworkflow, "true") || Objects.equals(checkisopenbyworkflow, Boolean.TRUE)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TOOL_BAR_DECLARE});
            }
            this.setExtendsControlsByBillstatus(billstatus);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, RECALC_KEY, REGETDATA_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
            if (dyo != null && StringUtils.equals((CharSequence)"2", (CharSequence)this.getPageCache().get("datatype"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{RECALC_KEY, REGETDATA_KEY});
            }
            this.setExtendsControlsByBillstatus("new");
        }
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
    }

    protected Long getSbbid(OperationStatus operationStatus, String orgid, String startDate, String endDate) {
        DynamicObject declareMain = this.getDeclareMain(orgid, startDate, endDate);
        if (declareMain != null) {
            return declareMain.getLong("id");
        }
        return null;
    }

    protected String getMainTable() {
        return MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable();
    }

    protected DynamicObject getDeclareMain(String orgid, String skssqq, String skssqz) {
        DynamicObject dyo;
        if (this.declareMainObj != null) {
            return this.declareMainObj;
        }
        String templateType = this.getTemplateType();
        QFilter extendQfilter = this.getDeclareMainQueryParams();
        this.declareMainObj = dyo = YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (long)Long.parseLong(orgid), (String)templateType, (String)skssqq, (String)skssqz, (QFilter)extendQfilter);
        return dyo;
    }

    protected EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String templateType, IPageCache pageCache) {
        return new EngineModel(orgId, skssqq, skssqz, templateType, pageCache);
    }

    public abstract void init();

    public abstract String getTaxType();

    public abstract String getTemplateType();

    public abstract void clientCallBackMethod(Map<String, String> var1, String var2);

    public abstract void initPeriod(IDataModel var1, IPageCache var2, String var3, Map<String, Object> var4);

    protected Long getModelId() {
        QFilter qFilter;
        DynamicObject d;
        String modelNumber = this.getModelNumber();
        if (StringUtil.isEmpty((CharSequence)modelNumber)) {
            modelNumber = DEFAULT_MODEL_NUMBER;
        }
        if ((d = BusinessDataServiceHelper.loadSingleFromCache((String)"tpo_model", (String)"id", (QFilter[])(qFilter = new QFilter("number", "=", (Object)modelNumber)).toArray())) == null) {
            throw new IllegalArgumentException("No Such Model!");
        }
        return d.getLong("id");
    }

    protected abstract String getModelNumber();

    protected abstract DeclareRequestModel setRequestModel(DeclareRequestModel var1);

    protected abstract Map<String, Object> paraCustomParams(Map<String, Object> var1);

    protected abstract QFilter getDeclareMainQueryParams();

    @Deprecated
    protected String getUniKey() {
        return "";
    }

    public void pageRelease(EventObject e) {
        String sbbid = this.getPageCache().get(SBBID);
        if (StringUtils.isNotBlank((CharSequence)sbbid)) {
            MutexServiceImpl.releaseMutexLock(sbbid, "edit", RequestContext.get().getCurrUserId());
        }
    }

    protected boolean viewDialog() {
        return Boolean.TRUE;
    }

    protected void loadFromOtherPage(Map<String, Object> customParams) {
    }

    public boolean checkIsDynCell(String cellKey) {
        String[] splits = cellKey.split("#");
        if (splits.length == 3) {
            try {
                Integer.parseInt(splits[1]);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

