/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.multidideclare.ExportService;
import kd.taxc.bdtaxr.business.multidideclare.MultiDeclareBizBusiness;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.taxdeclare.enums.TaxDeclareMetaRouteEnum;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.CommonInfoUtil;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.JobUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.file.FileUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractDeclareReportMultiQueryListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(AbstractDeclareReportMultiQueryListPlugin.class);
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    private static final String ITEM_KEY = "itemKey";
    private static final String BILL_LIST = "billlistap";
    private static final String DIRECT_DECLARE = "directdeclare";
    private static final String DIRECT_PAY = "fastpay";
    private static final String VIEWLOG_KEY = "viewlog";
    private static final String DEFER_PAY_KEY = "applydeferpay";
    private static final String APPLY = "apply";
    private static final String NEW = "new";
    private static final String VIEWHISTORYSBB = "viewhistorysbb";
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    private static final String CANCELAPPLY = "cancelapply";
    private static final String PAY = "pay";
    private static final String CANCELPAY = "cancelpay";
    private static final String SUBMIT = "submit";
    private static final String UNSUBMIT = "unsubmit";
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String VIEWLOG = "viewlog";
    private static final String DELETE = "delete";
    private static final String INVALID = "invalid";
    protected static final String RECTIFY = "rectify";
    private static final String SEPARATOR = System.getProperty("line.separator");
    public static final String BASE_PATH = System.getProperty("user.home") + File.separator + "template" + File.separator;
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORG = "org";
    private static final String TYPE = "type";
    private static final String TAXLIMIT = "taxlimit";
    private static final String ORG_ID = "org.id";
    protected static final String DEFAULT_MODEL_NUMBER = "TSC001";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public Map<String, String> getBizParams() {
        return new HashMap<String, String>(4);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if (ORG_ID.equalsIgnoreCase(args.getFieldName())) {
            List<Long> taxpayers = DeclareReportHelpService.queryTaxcOrgIdByIsTaxpayerWithPerm();
            QFilter orgFilter = new QFilter("id", "in", taxpayers);
            args.getQfilters().add(orgFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List filterColumnList = contInitEvent.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            Object org;
            if ("org.name".equals(column.getFieldName())) {
                String appid = this.getView().getFormShowParameter().getAppId();
                String entityid = this.getView().getEntityId();
                if (this.getView() instanceof ListView) {
                    entityid = ((ListView)this.getView()).getBillFormId();
                }
                List<Long> idList = DeclareReportHelpService.queryTaxcOrgIdByIsTaxpayerWithPerm(appid, entityid, "47150e89000000ac");
                long orgId = RequestContext.get().getOrgId();
                List<DynamicObject> orgCol = DeclareReportHelpService.queryTaxcOrgByOrgIds(idList);
                List comboItems = orgCol.stream().map(dyo -> {
                    ComboItem item = new ComboItem();
                    item.setValue(dyo.getString("id"));
                    item.setCaption(new LocaleString(dyo.getString("org.name")));
                    return item;
                }).collect(Collectors.toList());
                CommonFilterColumn typeColumn = (CommonFilterColumn)column;
                typeColumn.setComboItems(comboItems);
                if (idList.contains(orgId)) {
                    typeColumn.setDefaultValue(String.valueOf(orgId));
                } else if (!CollectionUtils.isEmpty(idList)) {
                    typeColumn.setDefaultValue(String.valueOf(idList.get(0)));
                }
            }
            if ((org = customParams.get(ORGID_KEY)) != null && column.getFieldName().equals("org.name") && column instanceof CommonFilterColumn) {
                column.setDefaultValue(org.toString());
                continue;
            }
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
            if (null == skssqq || null == skssqz || !column.getFieldName().equals(SKSSQQ)) continue;
            column.setDefaultValues(new Object[]{DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz)});
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (null != customList && customList.size() > 0) {
            for (Map map : customList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf(SKSSQQ);
                if (index == -1) continue;
                List valueList = (List)map.get("Value");
                this.getPageCache().put(SKSSQQ, SerializationUtils.toJsonString((Object)valueList));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String customFilter;
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        List<String> list = this.getTemplateTypeList();
        if (!CollectionUtils.isEmpty(list)) {
            resultFilter.add(new QFilter("templatetype", "in", list));
        }
        if (StringUtils.isNotEmpty((CharSequence)(customFilter = (String)this.getView().getFormShowParameter().getCustomParam("customFilter")))) {
            QFilter customQFilter = QFilter.fromSerializedString((String)customFilter);
            resultFilter.add(customQFilter);
        }
        e.setCustomQFilters(resultFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (args.getSource() instanceof Donothing && (SUBMIT.equals(operateKey = ((Donothing)args.getSource()).getOperateKey()) || UNSUBMIT.equals(operateKey) || AUDIT.equals(operateKey) || UNAUDIT.equals(operateKey) || PAY.equals(operateKey) || APPLY.equals(operateKey) || CANCELAPPLY.equals(operateKey) || CANCELPAY.equals(operateKey) || INVALID.equals(operateKey) || RECTIFY.equals(operateKey) || VIEWHISTORYSBB.equals(operateKey))) {
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (INVALID.equals(operateKey) || RECTIFY.equals(operateKey)) {
                String keyStr;
                Object source = args.getSource();
                String opreateType = "";
                FormOperate operate = (FormOperate)source;
                if (operate.getOption().containsVariable(TYPE)) {
                    opreateType = operate.getOption().getVariableValue(TYPE);
                }
                if ("msgInput".equals(opreateType)) {
                    return;
                }
                Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                String string = keyStr = INVALID.equals(operateKey) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"AbstractDeclareReportMultiQueryListPlugin_37", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"AbstractDeclareReportMultiQueryListPlugin_38", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if (collect.size() != 1) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e%s\u7533\u62a5\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_39", (String)"taxc-bdtaxr", (Object[])new Object[0]), keyStr));
                    args.setCancel(true);
                    return;
                }
                String msg = null;
                Object pkValue = list.get(0).getPrimaryKeyValue();
                msg = INVALID.equals(operateKey) ? MultiDeclareBizBusiness.checkBeforeInvalid(ObjectUtils.toLong((Object)pkValue)) : MultiDeclareBizBusiness.checkBeforeRectify(ObjectUtils.toLong((Object)pkValue));
                if (msg != null) {
                    this.getView().showErrorNotification(msg);
                    args.setCancel(true);
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u786e\u8ba4\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5f55\u5165\u539f\u56e0\u8bf4\u660e\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_40", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
            if (VIEWHISTORYSBB.equals(operateKey)) {
                args.setCancel(true);
                Set collect = list.stream().map(a -> a.getPrimaryKeyValue()).collect(Collectors.toSet());
                if (collect.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4efd\u5386\u53f2\u7248\u672c\uff0c\u8bf7\u4ec5\u52fe\u9009\u4e00\u6761\u7533\u62a5\u8868\u6570\u636e\u518d\u8fdb\u884c\u67e5\u770b\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                Object sbbid = list.get(0).getPrimaryKeyValue();
                if (!QueryServiceHelper.exists((String)"tpo_history_sbb", (QFilter[])new QFilter[]{new QFilter("declareid", "=", sbbid)})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u7533\u62a5\u8868\u65e0\u5386\u53f2\u7248\u672c\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                customParams.put("sbbid", sbbid);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tpo_history_sbb_view", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                return;
            }
        }
        if (args.getSource() instanceof Delete || SUBMIT.equals(((FormOperate)args.getSource()).getOperateKey()) || UNSUBMIT.equals(((FormOperate)args.getSource()).getOperateKey()) || AUDIT.equals(((FormOperate)args.getSource()).getOperateKey()) || UNAUDIT.equals(((FormOperate)args.getSource()).getOperateKey())) {
            Set strCollect = list.stream().map(a -> String.valueOf(a.getPrimaryKeyValue())).collect(Collectors.toSet());
            DynamicObjectCollection mutexCollection = QueryServiceHelper.query((String)"bos_datalock", (String)"objectid,objectname,entitykey,user.id,user.name", (QFilter[])new QFilter[]{new QFilter("objectid", "in", strCollect)});
            if (mutexCollection == null) {
                return;
            }
            Map<Long, String> mutexMap = mutexCollection.stream().collect(Collectors.toMap(e -> Long.valueOf(e.getString("objectid")), e -> e.getString("user.name"), (k, v) -> k));
            String templateSystem = this.getModelNumber();
            MultiTableEnum tableEnum = this.getMultiTable();
            if (tableEnum == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4f53\u7cfb\u7f16\u7801\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection nsrxxCollection = QueryServiceHelper.query((String)tableEnum.getDeclareMainTable(), (String)MetadataUtil.getAllFieldToQuery((String)tableEnum.getDeclareMainTable()), (QFilter[])new QFilter[]{new QFilter("id", "in", mutexMap.keySet())});
            ArrayList errList = new ArrayList();
            StringBuilder stringBuilder = new StringBuilder();
            nsrxxCollection.stream().forEach(e -> {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91%2$s\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\r\n", (String)"AbstractDeclareReportMultiQueryListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), mutexMap.get(e.getLong("id")), e.getString("billno"));
                errList.add(msg);
                stringBuilder.append(msg);
            });
            if (errList.size() > 0) {
                args.setCancel(true);
                if (errList.size() == 1) {
                    this.getView().showTipNotification((String)errList.get(0));
                } else {
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportMultiQueryListPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OK;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), stringBuilder.toString(), options, ConfirmTypes.Save, null, btnNameMaps);
                }
                return;
            }
        }
    }

    private boolean isEnableWfProcess() {
        MultiTableEnum tableEnum = this.getMultiTable();
        String billEntity = tableEnum.getDeclareMainTable();
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)billEntity);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        return processdefinition != null;
    }

    /*
     * WARNING - void declaration
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        block83: {
            ListSelectedRowCollection list;
            BillList billlist;
            String appId;
            String operateKey;
            OperationResult opResult;
            block84: {
                block82: {
                    boolean isCheck;
                    opResult = evt.getOperationResult();
                    operateKey = evt.getOperateKey();
                    appId = this.getView().getFormShowParameter().getAppId();
                    if (opResult == null) {
                        return;
                    }
                    if (!opResult.isSuccess() && (SUBMIT.equals(operateKey) || UNSUBMIT.equals(operateKey) || AUDIT.equals(operateKey) || UNAUDIT.equals(operateKey) || PAY.equals(operateKey) || APPLY.equals(operateKey) || CANCELAPPLY.equals(operateKey) || CANCELPAY.equals(operateKey) || INVALID.equals(operateKey) || RECTIFY.equals(operateKey)) && !(isCheck = this.setCustomCheckInfo(evt))) {
                        return;
                    }
                    billlist = (BillList)this.getControl(BILL_LIST);
                    list = billlist.getSelectedRows();
                    String querytype = this.getQuerytype(evt.getOperateKey());
                    if (!NEW.equals(operateKey) && !"newfss".equals(evt.getOperateKey())) break block82;
                    HashMap<String, Object> custom = new HashMap<String, Object>(16);
                    custom.put(TYPE, querytype);
                    this.showDeclarePage(querytype, custom, null, null);
                    break block83;
                }
                if (!EXPORT.equals(operateKey)) break block84;
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
                if (collect.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                String pk = list.get(0).getPrimaryKeyValue().toString();
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getMultiTable().getDeclareMainTable());
                DynamicObject org = obj.getDynamicObject(ORG);
                DynamicObject dynamicObject = obj.getDynamicObject("templateid");
                long templateId = dynamicObject.getLong("id");
                String templatetype = obj.getDynamicObject("templatetype").getString("number");
                String billno = obj.getString("billno");
                String draftpurpose = "";
                if (obj.containsProperty("draftpurpose")) {
                    draftpurpose = obj.getString("draftpurpose");
                }
                String taxsystem = "";
                if (obj.containsProperty("taxsystem")) {
                    taxsystem = obj.getString("taxsystem.id");
                }
                String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(templatetype, templatetype) + "_";
                if (org != null) {
                    fileName = fileName + org.getString("name");
                }
                Date startDate = (Date)obj.get(SKSSQQ);
                Date endDate = (Date)obj.get(SKSSQZ);
                DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"tpo_template");
                if (template == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                fileName = fileName + DateUtils.format((Date)startDate, (String)"yyyy-MM");
                String operateName = ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"AbstractDeclareReportMultiQueryListPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u62a5\u8868\uff0c\u5bfc\u51fa\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno);
                String taxName = TaxNameUtil.getTaxName((String)appId);
                if ("other".equals(taxName)) {
                    taxName = templatetype;
                }
                OperatorDialogUtils.operateDialog((String)taxName, (String)((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId(), (String)operateName, (String)operateDescription);
                DeclareRequestModel declareModel = new DeclareRequestModel();
                declareModel.setModelId(this.getModelId());
                declareModel.setId(Long.valueOf(Long.parseLong(pk)));
                declareModel.setTemplateId(Long.valueOf(templateId));
                declareModel.setTemplateType(templatetype);
                declareModel.setTemplateNumber(template.getString("number"));
                if (org != null) {
                    declareModel.setOrgId(Long.valueOf(org.getLong("id")));
                }
                declareModel.setSkssqq(obj.getString(SKSSQQ));
                declareModel.setSkssqz(obj.getString(SKSSQZ));
                declareModel.getBusinessMap().put("taxationsys", taxsystem);
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("draftpurpose", draftpurpose);
                declareModel.setExtendParams(map);
                declareModel.getBusinessMap().putAll(this.getBizParams());
                DeclareResponseModel responseModel = (DeclareResponseModel)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_DECLARE_DATA, (Object[])new Object[]{declareModel});
                Map valMap = responseModel.getData();
                Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{templateId, responseModel.getDynRowList()});
                Map fieldMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_ALL_FIELDS_TYPE_SHOW, (Object[])new Object[]{this.getModelId()});
                GetTemplateVo getTemplateVo = DeclareReportHelpService.getTemplateVo(declareModel, responseModel);
                LOGGER.info(ResManager.loadKDString((String)"\u5f15\u51fafieldTypes: {}", (String)"AbstractDeclareReportMultiQueryListPlugin_41", (String)"taxc-bdtaxr", (Object[])new Object[0]), fieldMap == null ? "" : JSONObject.toJSON((Object)fieldMap));
                String tempFileName = UUID.randomUUID().toString() + ".xlsx";
                File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)tempFileName))));
                file.getParentFile().mkdirs();
                String jsonString = template.getString("content_tag");
                List dynRowList = DynamicRowService.getDynRowNoList((Long)templateId);
                ExportService.buildExcel("RESULT", templateId, jsonString, getTemplateVo, fieldMap, file, cellTypeFormulas, valMap, dynRowList, declareModel.getBusinessMap());
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)in, 5000);
                    String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
                    String entityNum = ((IListView)this.getView()).getBillFormId();
                    PermissionUtils.putTempFilePermissionCache((String)urls, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
                    this.getView().openUrl(urls);
                }
                catch (Exception e2) {
                    try {
                        throw new KDBizException((Throwable)e2, new ErrorCode("", e2.toString()), new Object[0]);
                    }
                    catch (Throwable throwable) {
                        FileUtils.safeClose(in);
                        throw throwable;
                    }
                }
                FileUtils.safeClose((InputStream)in);
                break block83;
            }
            if (APPLY.equals(operateKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                billlist.refresh();
            } else if (CANCELAPPLY.equals(operateKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                billlist.refresh();
            } else if (PAY.equals(operateKey)) {
                FormShowParameter param = new FormShowParameter();
                param.setFormId("bdtaxr_paydate_confirm");
                param.getOpenStyle().setShowType(ShowType.NonModal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
                param.setCloseCallBack(closeCallBack);
                this.getView().showForm(param);
            } else if (RECTIFY.equals(operateKey)) {
                this.getView().showOperationResult(opResult);
                billlist.refresh();
            } else if (CANCELPAY.equals(operateKey) || INVALID.equals(operateKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                billlist.refresh();
            } else if (IMPORT.equals(operateKey)) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                String dialog = this.getOpenImportDialog();
                parameter.setFormId(dialog);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT));
                parameter.setCustomParam("source", (Object)"declare");
                parameter.setCustomParam("businessMap", this.getBizParams());
                List<String> templateTypeList = this.getTemplateTypeList();
                parameter.setCustomParam("templatetypelist", templateTypeList);
                String operateName = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"AbstractDeclareReportMultiQueryListPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                String string = String.format(ResManager.loadKDString((String)"\u6253\u5f00\u5bfc\u5165\u7533\u62a5\u8868\u6570\u636e\u5f39\u7a97\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]), new Object[0]);
                String taxName = TaxNameUtil.getTaxName((String)appId);
                if ("other".equals(taxName) && templateTypeList.size() > 0) {
                    taxName = templateTypeList.get(0);
                }
                OperatorDialogUtils.operateDialog((String)taxName, (String)((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId(), (String)operateName, (String)string);
                this.getView().showForm(parameter);
            } else if (SUBMIT.equals(operateKey) || UNSUBMIT.equals(operateKey) || AUDIT.equals(operateKey) || UNAUDIT.equals(operateKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                billlist.refresh();
            } else if (VIEWFLOWCHART.equals(operateKey)) {
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
                if (collect.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                try {
                    Object pkId = list.get(0).getPrimaryKeyValue();
                    DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)this.getModelId());
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)declareTable.getMainTable());
                    if (dynamicObject != null) {
                        String billno = dynamicObject.getString("billno");
                        String type = dynamicObject.getString("templatetype.id");
                        String operateName = ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe", (String)"AbstractDeclareReportMultiQueryListPlugin_44", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u6d41\u7a0b\u56fe\u6210\u529f", (String)"AbstractDeclareReportMultiQueryListPlugin_45", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno);
                        OperatorDialogUtils.operateDialog((String)type, (String)((String)this.getView().getFormShowParameter().getCustomParams().get("billFormId")), (String)operateName, (String)operateDescription);
                    }
                    WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)list.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
                }
                catch (Exception e3) {
                    LOGGER.error(ThrowableHelper.toString((Exception)e3));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            } else if ("viewlog".equals(operateKey)) {
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
                if (collect.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u65e5\u5fd7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                Object pkId = list.get(0).getPrimaryKeyValue();
                DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tcvat_nsrxx");
                if (declare != null) {
                    HashMap<String, Object> customerParams = new HashMap<String, Object>();
                    String string = declare.getDynamicObject(ORG).getString("id");
                    String type = declare.getString(TYPE);
                    ArrayList<String> skssq = new ArrayList<String>();
                    skssq.add(DateUtils.format((Date)declare.getDate(SKSSQQ), (String)"yyyy-MM-dd"));
                    skssq.add(DateUtils.format((Date)declare.getDate(SKSSQZ), (String)"yyyy-MM-dd"));
                    customerParams.put(ORG, string);
                    customerParams.put("types", type);
                    customerParams.put(SKSSQQ, skssq);
                    OpenStyle openStyle = new OpenStyle();
                    openStyle.setShowType(ShowType.MainNewTabPage);
                    ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"tsate_declare_record", (boolean)false, (int)0, (boolean)false);
                    showParameter.setOpenStyle(openStyle);
                    showParameter.setCustomParams(customerParams);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            } else if (DIRECT_DECLARE.equals(operateKey)) {
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                JSONArray jsonArray = new JSONArray();
                Object[] declarePkIds = list.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).toArray();
                DynamicObject[] declareData = BusinessDataServiceHelper.load((Object[])declarePkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"));
                StringBuilder message = new StringBuilder();
                for (DynamicObject declare : declareData) {
                    DynamicObject org = declare.getDynamicObject(ORG);
                    String type = declare.getString(TYPE);
                    String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                    String skssqq = DateUtils.format((Date)declare.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE);
                    String skssqz = DateUtils.format((Date)declare.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
                    String billStatus = declare.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u672a\u7533\u62a5\u6216\u7533\u62a5\u5931\u8d25\u72b6\u6001\u53ef\u53d1\u9001\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_20", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"zzsybnsr".equals(type)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_21", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    JSONObject customMap = new JSONObject();
                    customMap.put("sbbid", (Object)declare.getString("id"));
                    customMap.put(TYPE, (Object)declare.getString(TYPE));
                    customMap.put("nsrsbh", (Object)declare.getString("nsrsbh"));
                    customMap.put(ORGID_KEY, (Object)org.getString("id"));
                    Date skssqqDate = declare.getDate(SKSSQQ);
                    customMap.put(SKSSQQ, (Object)DateUtils.format((Date)skssqqDate, (String)"yyyy-MM-dd"));
                    Date skssqzDate = declare.getDate(SKSSQZ);
                    customMap.put(SKSSQZ, (Object)DateUtils.format((Date)skssqzDate, (String)"yyyy-MM-dd"));
                    customMap.put("address", (Object)declare.getString("scjydz"));
                    customMap.put(ITEM_KEY, (Object)DIRECT_DECLARE);
                    jsonArray.add((Object)customMap);
                }
                if (!jsonArray.isEmpty()) {
                    this.directDeclareConfirmTips(jsonArray, operateKey, ResManager.loadKDString((String)"\u53d1\u9001\u7533\u62a5\u540e\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u7533\u62a5\u5417\uff1f", (String)"AbstractDeclareReportMultiQueryListPlugin_22", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                    String[] stringArray = message.toString().split(System.getProperty("line.separator"));
                    if (stringArray.length == 1) {
                        this.getView().showErrorNotification(message.toString());
                    } else {
                        this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                        OperationResult operationResult = new OperationResult();
                        operationResult.setSuccess(false);
                        operationResult.setMessage(message.toString());
                        this.getView().showOperationResult(operationResult);
                    }
                }
            } else if (DIRECT_PAY.equals(operateKey)) {
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                JSONArray jsonArray = new JSONArray();
                Object[] declarePkIds = list.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).toArray();
                DynamicObject[] declareData = BusinessDataServiceHelper.load((Object[])declarePkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"));
                StringBuilder message = new StringBuilder();
                for (DynamicObject declare : declareData) {
                    DynamicObject org = declare.getDynamicObject(ORG);
                    String type = declare.getString(TYPE);
                    String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                    String skssqq = DateUtils.format((Date)declare.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE);
                    String skssqz = DateUtils.format((Date)declare.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
                    String billStatus = declare.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_23", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"declared".equals(declare.getString("declarestatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u53ef\u53d1\u9001\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_24", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"unpaid".equals(declare.getString("paystatus")) && !"payfailed".equals(declare.getString("paystatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u6216\u7f34\u6b3e\u5931\u8d25\u53ef\u53d1\u9001\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_25", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"zzsybnsr".equals(type)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\u7533\u62a5,%1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_26", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    JSONObject customMap = new JSONObject();
                    customMap.put("sbbid", (Object)declare.getString("id"));
                    customMap.put(TYPE, (Object)declare.getString(TYPE));
                    customMap.put("nsrsbh", (Object)declare.getString("nsrsbh"));
                    customMap.put(ORGID_KEY, (Object)org.getString("id"));
                    Date skssqqDate = declare.getDate(SKSSQQ);
                    customMap.put(SKSSQQ, (Object)DateUtils.format((Date)skssqqDate, (String)"yyyy-MM-dd"));
                    Date skssqzDate = declare.getDate(SKSSQZ);
                    customMap.put(SKSSQZ, (Object)DateUtils.format((Date)skssqzDate, (String)"yyyy-MM-dd"));
                    customMap.put("address", (Object)declare.getString("scjydz"));
                    customMap.put(ITEM_KEY, (Object)DIRECT_PAY);
                    jsonArray.add((Object)customMap);
                }
                if (!jsonArray.isEmpty()) {
                    this.directDeclareConfirmTips(jsonArray, operateKey, ResManager.loadKDString((String)"\u53d1\u9001\u7f34\u6b3e\u540e\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u7f34\u6b3e\u5417\uff1f", (String)"AbstractDeclareReportMultiQueryListPlugin_27", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                    String[] stringArray = message.toString().split(System.getProperty("line.separator"));
                    if (stringArray.length == 1) {
                        this.getView().showErrorNotification(message.toString());
                    } else {
                        this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                        OperationResult operationResult = new OperationResult();
                        operationResult.setSuccess(false);
                        operationResult.setMessage(message.toString());
                        this.getView().showOperationResult(operationResult);
                    }
                }
            } else if (DEFER_PAY_KEY.equals(operateKey)) {
                OperationResult operationResult1 = evt.getOperationResult();
                if (operationResult1 != null && (!operationResult1.isSuccess() || operationResult1.getSuccessPkIds().isEmpty())) {
                    operationResult1.setSuccessPkIds(Collections.emptyList());
                    return;
                }
                FormShowParameter parameter = new FormShowParameter();
                if (list != null && !list.isEmpty()) {
                    void var12_50;
                    List pkIds = Arrays.stream(list.getPrimaryKeyValues()).distinct().collect(Collectors.toList());
                    if ("tcvat".equals(appId)) {
                        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id as sbbid,billno,org,org.name as orgname,skssqq,skssqz,type,declarestatus,paystatus,entryentity.id,entryentity.deferpayapply1", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                    } else {
                        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id as sbbid,billno,org,org.name as orgname,skssqq,skssqz,type,declarestatus,paystatus,deferpayapply", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                    }
                    String uniqueKey = null;
                    JSONArray jsonArray = new JSONArray();
                    StringBuilder message = new StringBuilder();
                    StringBuilder fzybhzMessage = new StringBuilder();
                    List<Object> sbbid = new ArrayList();
                    for (void declare : var12_50) {
                        String orgId = declare.getDynamicObject(ORG).getString("id");
                        String skssqq = declare.getString(SKSSQQ);
                        String skssqz = declare.getString(SKSSQZ);
                        String payStatus = declare.getString("paystatus");
                        String type = declare.getString(TYPE);
                        String orgname = declare.getDynamicObject(ORG).getString("name");
                        String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                        OrgUtils.getfzybqyMessage((String)type, (String)orgId, (String)DateUtils.format((Date)declare.getDate(SKSSQQ)), (String)DateUtils.format((Date)declare.getDate(SKSSQZ)), (StringBuilder)fzybhzMessage);
                        if (!"declared".equals(declare.getString("declarestatus"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u7684\u6570\u636e\u53ef\u7533\u8bf7\u7f13\u7f34: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_28", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname, skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        if (!"unpaid".equals(payStatus) && !StringUtils.isBlank((CharSequence)declare.getString("paystatus"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u7684\u6570\u636e\u53ef\u7533\u8bf7\u7f13\u7f34: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"AbstractDeclareReportMultiQueryListPlugin_29", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname, skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        if (uniqueKey == null) {
                            uniqueKey = orgId + skssqq + skssqz;
                        } else if (!uniqueKey.equals(orgId + skssqq + skssqz)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3001\u6240\u5c5e\u7a0e\u671f\u76f8\u540c\u7684\u7533\u62a5\u8bb0\u5f55", (String)"AbstractDeclareReportMultiQueryListPlugin_30", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                            return;
                        }
                        String billno = declare.getString("billno");
                        String nsrtype = declare.getString(TYPE);
                        if (StringUtils.trimToEmpty((String)nsrtype).startsWith("zzs")) {
                            OperatorDialogUtils.operateDialog((String)"zzs", (String)TemplateEnum.getEnumByDeclareType((String)nsrtype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u7533\u8bf7\u7f13\u7f34", (String)"AbstractDeclareReportMultiQueryListPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7f34\u6b3e\u8868\u7533\u8bf7\u7f13\u7f34", (String)"AbstractDeclareReportMultiQueryListPlugin_32", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                            continue;
                        }
                        if (!StringUtils.trimToEmpty((String)nsrtype).startsWith("qysds")) continue;
                        OperatorDialogUtils.operateDialog((String)"qysds", (String)TemplateEnum.getEnumByDeclareType((String)nsrtype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u7533\u8bf7\u7f13\u7f34", (String)"AbstractDeclareReportMultiQueryListPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7f34\u6b3e\u8868\u7533\u8bf7\u7f13\u7f34", (String)"AbstractDeclareReportMultiQueryListPlugin_32", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                    }
                    if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                        String[] messages = message.toString().split(System.getProperty("line.separator"));
                        if (messages.length == 1) {
                            this.getView().showErrorNotification(message.toString());
                        } else {
                            this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                            OperationResult operationResult = new OperationResult();
                            operationResult.setSuccess(false);
                            operationResult.setMessage(message.toString());
                            this.getView().showOperationResult(operationResult);
                        }
                        return;
                    }
                    if ("tcvat".equals(appId)) {
                        parameter.setCustomParam("sbbEntryIds", sbbid);
                    } else {
                        sbbid = Arrays.stream(var12_50).map(e -> e.getLong("id")).collect(Collectors.toList());
                        parameter.setCustomParam("sbbIds", sbbid);
                    }
                    if (StringUtils.isNotBlank((CharSequence)fzybhzMessage.toString())) {
                        JSONObject customMap = new JSONObject();
                        customMap.put("sbbIds", sbbid);
                        jsonArray.add((Object)customMap);
                        this.directDeclareConfirmTips(jsonArray, operateKey, fzybhzMessage.toString());
                        return;
                    }
                }
                parameter.setFormId("bdtaxr_deferpay_dialog");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DEFER_PAY_KEY);
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(parameter);
            }
        }
    }

    protected boolean setCustomCheckInfo(AfterDoOperationEventArgs evt) {
        OperationResult opResult = evt.getOperationResult();
        String msg = opResult.getMessage();
        this.getView().invokeOperation("refresh");
        if (msg != null) {
            String[] messages = msg.split(SEPARATOR);
            if (messages.length == 1) {
                this.getView().showErrorNotification(msg);
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(msg);
                this.getView().showOperationResult(operationResult);
            }
            return false;
        }
        return true;
    }

    protected String getOpenImportDialog() {
        return "bdtaxr_import_dialog_mult";
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            return;
        }
        if ("riskcontent".equals(args.getFieldName())) {
            DeclareUtils.showRiskDialog((String)currentSelectedRowInfo.getPrimaryKeyValue().toString(), (IFormView)this.getView());
        } else {
            MultiTableEnum tableEnum = this.getMultiTable();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)tableEnum.getDeclareMainTable());
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("entryid", object.getString("id"));
            customParams.put("billno", object.getString("billno"));
            customParams.put(ORGID_KEY, object.getDynamicObject(ORG).getString("id"));
            customParams.put(ORGNAME_KEY, object.getDynamicObject(ORG).getString("name"));
            Date skssqq = object.getDate(SKSSQQ);
            Date skssqz = object.getDate(SKSSQZ);
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put(SKSSQQ, startDate);
            customParams.put(SKSSQZ, DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", object.getDate("modifytime"));
            String dataType = object.getString("datatype");
            customParams.put("datatype", dataType);
            this.setExtendCustomParams(customParams, object);
            String type = object.getString("templatetype.number");
            String declarestatus = MultiTableEnum.TSCOO1 == tableEnum ? object.getString("declarestatus") : null;
            this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, declarestatus, object);
        }
    }

    protected abstract void setExtendCustomParams(Map<String, Object> var1, DynamicObject var2);

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (SKSSQQ.equals(columnDesc.getKey())) {
            String dataFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
            String skssqq = DateUtils.format((Date)data.getDate(SKSSQQ), (String)dataFormat);
            String skssqz = DateUtils.format((Date)data.getDate(SKSSQZ), (String)dataFormat);
            e.setFormatValue((Object)(skssqq + "~" + skssqz));
        } else if ("riskcontent".equals(columnDesc.getKey()) && "normal".equals(e.getFormatValue())) {
            e.getNoLinkKey().add("riskcontent");
        }
    }

    public abstract String getModelNumber();

    public String getQuerytype(String operateKey) {
        return (String)this.getView().getFormShowParameter().getCustomParam("querytype");
    }

    protected abstract List<String> getTemplateTypeList();

    protected void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, DynamicObject object) {
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus)) {
            param.setFormId("multi_declare_show");
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            if (object != null) {
                DeclareRequestModel requestModel = new DeclareRequestModel();
                requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get(ORGID_KEY))));
                requestModel.setTemplateType(type);
                requestModel.setId(Long.valueOf(object.getLong("id")));
                requestModel.setSkssqq(DateUtils.format((Date)object.getDate(SKSSQQ)));
                requestModel.setSkssqz(DateUtils.format((Date)object.getDate(SKSSQZ)));
                requestModel.setOperation("read");
                requestModel.setRefresh(Boolean.FALSE);
                requestModel.setModelId(this.getModelId());
                customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
            }
        } else {
            String declarePage = templateEnum.getDeclarePage();
            TaxDeclareMetaRouteEnum metaRouteEnum = TaxDeclareMetaRouteEnum.getEnumByDeclarePage((String)declarePage);
            if (metaRouteEnum == null) {
                param.setFormId(declarePage);
            } else {
                param.setFormId(metaRouteEnum.getThreeMetaEntity());
            }
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private void directDeclareConfirmTips(JSONArray jSONArray, String key, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportMultiQueryListPlugin_33", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportMultiQueryListPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, JSONArray.toJSONString((Object)jSONArray));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(IMPORT) || DEFER_PAY_KEY.equals(actionId)) {
            Object returnData;
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            billList.refresh();
            if (DEFER_PAY_KEY.equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
                this.getView().showSuccessNotification((String)returnData);
            }
        } else if (actionId.equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            ListSelectedRowCollection list = billList.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            DynamicObject[] declares = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_declare_main_tsc"));
            this.pay(billList, declares, payDate);
        }
    }

    private void pay(BillList billlist, DynamicObject[] declares, Date payDate) {
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
            String appId = this.getView().getFormShowParameter().getAppId();
            for (DynamicObject declare : declares) {
                declare.set("paystatus", (Object)"paid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"0");
                declare.set("paydate", (Object)payDate);
                declare.set("payer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                DynamicObject[] saveObjects = modifyDynamicObjects.toArray(new DynamicObject[0]);
                SaveServiceHelper.save((DynamicObject[])saveObjects);
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"manualPay", (Object[])new Object[]{sbbIds});
                MultiDeclareMQSender.sendMQ((DynamicObject[])saveObjects, (String)PAY);
                DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)PAY));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                billlist.refresh();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        JSONArray customMaps;
        String customVaule;
        BillList billlist;
        ListSelectedRowCollection list;
        Object[] pkIds;
        DynamicObject[] declares;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (PAY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_paydate_confirm");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
        if (APPLY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes && (declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(pkIds = (list = (billlist = (BillList)this.getControl(BILL_LIST)).getSelectedRows()).getPrimaryKeyValues()))})) != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
            for (DynamicObject declare : declares) {
                BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
                    declare.set("paystatus", (Object)"nopay");
                }
                declare.set("declarestatus", (Object)"declared");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("declaretype", (Object)"0");
                declare.set("sbrq", (Object)new Date());
                declare.set("declarer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"manualDeclare", (Object[])new Object[]{sbbIds});
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AbstractDeclareReportMultiQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                billlist.refresh();
            }
        }
        if (DEFER_PAY_KEY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            customVaule = event.getCustomVaule();
            JSONArray.parseArray((String)customVaule);
            customMaps = JSONArray.parseArray((String)customVaule);
            JSONObject customMap = (JSONObject)customMaps.get(0);
            List sbbid = (List)customMap.get((Object)"sbbIds");
            FormShowParameter parameter = new FormShowParameter();
            if ("tcvat".equals(appId)) {
                parameter.setCustomParam("sbbEntryIds", (Object)sbbid);
            } else {
                parameter.setCustomParam("sbbIds", (Object)sbbid);
            }
            parameter.setFormId("bdtaxr_deferpay_dialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DEFER_PAY_KEY);
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
        if ((DIRECT_DECLARE.equals(event.getCallBackId()) || DIRECT_PAY.equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            customVaule = event.getCustomVaule();
            JSONArray.parseArray((String)customVaule);
            customMaps = JSONArray.parseArray((String)customVaule);
            for (Object obj : customMaps) {
                JSONObject customMap = (JSONObject)obj;
                String sbbid = customMap.getString("sbbid");
                String type = customMap.getString(TYPE);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
                paramMap.put("transrc", DIRECT_DECLARE);
                paramMap.put("businessId", sbbid);
                paramMap.put(TYPE, type);
                String skssqq = customMap.getString(SKSSQQ);
                String skssqz = customMap.getString(SKSSQZ);
                paramMap.put(SKSSQQ, skssqq);
                paramMap.put(SKSSQZ, skssqz);
                paramMap.put("nsrsbh", customMap.getString("nsrsbh"));
                if (DIRECT_DECLARE.equals(event.getCallBackId())) {
                    paramMap.put("operationType", "declare");
                } else if (DIRECT_PAY.equals(event.getCallBackId())) {
                    paramMap.put("operationType", DIRECT_PAY);
                }
                String dqdm = CommonInfoUtil.getAreaInfo((String)paramMap.get("nsrsbh").toString(), (String)"number");
                if (StringUtils.isNotBlank((CharSequence)dqdm)) {
                    paramMap.put("sbdq", dqdm);
                }
                try {
                    DynamicObject recordObj;
                    DynamicObject[] recordLog;
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)"tcvat_nsrxx");
                    if (DIRECT_DECLARE.equals(event.getCallBackId())) {
                        declare.set("declarestatus", (Object)"declaring");
                        recordLog = AbstractDeclareReportMultiQueryListPlugin.assembleDeclareRecord(customMap.getLong(ORGID_KEY), type, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), "1");
                        recordObj = recordLog[0];
                        paramMap.put("id", recordObj.getLong("id"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
                        paramMap.put("key", event.getCallBackId());
                        JobUtils.submitJob(paramMap);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u7533\u62a5\uff01", (String)"AbstractDeclareReportMultiQueryListPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    } else if (DIRECT_PAY.equals(event.getCallBackId())) {
                        declare.set("paystatus", (Object)"paying");
                        recordLog = AbstractDeclareReportMultiQueryListPlugin.assembleDeclareRecord(customMap.getLong(ORGID_KEY), type, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), "2");
                        recordObj = recordLog[0];
                        paramMap.put("id", recordObj.getLong("id"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
                        paramMap.put("key", event.getCallBackId());
                        JobUtils.submitJob(paramMap);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u7f34\u6b3e\uff01", (String)"AbstractDeclareReportMultiQueryListPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        DeclareMQSender.sendMQ((DynamicObject)declare, (Date)AbstractDeclareReportMultiQueryListPlugin.getPayDate(declare), (String)DeclareMQType.PAY.name(), (String)DIRECT_PAY);
                    }
                    BillList billlist2 = (BillList)this.getControl(BILL_LIST);
                    billlist2.refresh();
                }
                catch (Exception e) {
                    LOGGER.error("invokeBizSerivce error:" + e);
                }
            }
        }
        if ((INVALID.equals(event.getCallBackId()) || RECTIFY.equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            String keyStr = INVALID.equals(event.getCallBackId()) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"AbstractDeclareReportMultiQueryListPlugin_37", (String)"taxc-bdtaxr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"AbstractDeclareReportMultiQueryListPlugin_38", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            customParams.put("customCaption", String.format(ResManager.loadKDString((String)"%s\u7533\u62a5", (String)"AbstractDeclareReportMultiQueryListPlugin_42", (String)"taxc-bdtaxr", (Object[])new Object[0]), keyStr));
            customParams.put("inputType", event.getCallBackId());
            BillList billlist3 = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list2 = billlist3.getSelectedRows();
            Object[] pkIds2 = list2.getPrimaryKeyValues();
            customParams.put("pkid", pkIds2[0]);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tpo_declare_msg_input", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    protected static DynamicObject[] assembleDeclareRecord(Long orgId, String type, Date skssqq, Date skssqz, String executeType2) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        dynamicObject.set(ORG, (Object)orgId);
        dynamicObject.set(SKSSQQ, (Object)skssqq);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set(SKSSQZ, (Object)skssqz);
        dynamicObject.set(TYPE, (Object)type);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("executetype", (Object)executeType2);
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        String number = codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }

    private Long getModelId() {
        QFilter qFilter;
        DynamicObject d;
        String modelNumber = this.getModelNumber();
        if (StringUtil.isEmpty((CharSequence)modelNumber)) {
            modelNumber = DEFAULT_MODEL_NUMBER;
        }
        if ((d = BusinessDataServiceHelper.loadSingleFromCache((String)"tpo_model", (String)"id", (QFilter[])(qFilter = new QFilter("number", "=", (Object)modelNumber)).toArray())) == null) {
            throw new IllegalArgumentException("No Such Model!");
        }
        return d.getLong("id");
    }

    private static List<Long> filterByIsTaxpayer(Boolean istaxpayer) {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)istaxpayer)});
        return CollectionUtils.isEmpty((Collection)taxOrgs) ? new ArrayList<Long>() : taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    private MultiTableEnum getMultiTable() {
        MultiTableEnum tableEnum = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber());
        if (tableEnum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4f53\u7cfb\u914d\u7f6e\u6570\u636e\u8868\uff01", (String)"AbstractDeclareReportMultiQueryListPlugin_36", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        return tableEnum;
    }
}

